/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.CostItemFactory;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateUtils;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.ncm.ActivityInfo;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.AbstractDataBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.ncm.common.BillBaseStatusEnum;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.order.common.utils.OrderCMUtils;
import com.kingdee.eas.ncm.order.fact.bill.InitOrderActivityCollection;
import com.kingdee.eas.ncm.order.fact.bill.InitOrderActivityEntryCollection;
import com.kingdee.eas.ncm.order.fact.bill.InitOrderActivityEntryInfo;
import com.kingdee.eas.ncm.order.fact.bill.InitOrderActivityInfo;
import com.kingdee.eas.ncm.order.fact.bill.InitOrderException;
import com.kingdee.eas.ncm.order.fact.bill.InitOrderFactory;
import com.kingdee.eas.ncm.order.fact.bill.InitOrderInfo;
import com.kingdee.eas.ncm.order.fact.bill.InitOrderMaterialCollection;
import com.kingdee.eas.ncm.order.fact.bill.InitOrderMaterialEntryCollection;
import com.kingdee.eas.ncm.order.fact.bill.InitOrderMaterialEntryInfo;
import com.kingdee.eas.ncm.order.fact.bill.InitOrderMaterialInfo;
import com.kingdee.eas.ncm.order.fact.bill.client.AbstractInitOrderEditUI;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class InitOrderEditUI
extends AbstractInitOrderEditUI {
    private static final Logger logger = CoreUIObject.getLogger(InitOrderEditUI.class);
    private CompanyOrgUnitInfo currentCompany = SysContext.getSysContext().getCurrentFIUnit();
    private String companyID = this.currentCompany.getId().toString();
    private PeriodInfo _period = OrderCMUtils.getCurrentPeriod(this.companyID);
    CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.currentCompany.getBaseCurrency().getId()));
    private int amountPresision = 0;
    int tabPane = -1;
    private int currentMaterialRowIndex = -1;
    private int currentActivityRowIndex = -1;

    public InitOrderEditUI() throws Exception {
        if (this._period == null) {
            MsgBox.showInfo((String)"\u8bf7\u5148\u521d\u59cb\u5316\u6838\u7b97\u671f\u95f4\u3002");
            SysUtil.abort();
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.setCostCenter4Activity();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
        if ("ADDNEW".equals(this.getOprtState())) {
            this.setUITitle("\u671f\u521d\u5728\u5236\u8ba2\u5355\u6210\u672c\u5f55\u5165-\u65b0\u589e");
        } else if ("EDIT".equals(this.getOprtState())) {
            this.setUITitle("\u671f\u521d\u5728\u5236\u8ba2\u5355\u6210\u672c\u5f55\u5165-\u4fee\u6539");
        } else if ("VIEW".equals(this.getOprtState())) {
            this.setUITitle("\u671f\u521d\u5728\u5236\u8ba2\u5355\u6210\u672c\u5f55\u5165-\u67e5\u770b");
        }
    }

    public void onLoad() throws Exception {
        this.actionAddLine.setVisible(false);
        this.actionInsertLine.setVisible(false);
        this.actionRemoveLine.setVisible(false);
        this.kdtMaterial.checkParsed();
        this.kdtActivity.checkParsed();
        this.kdtMatDetail.checkParsed();
        this.kdtActDetail.checkParsed();
        this.kdtMaterial.getSelectManager().setSelectMode(2);
        this.kdtActivity.getSelectManager().setSelectMode(2);
        super.onLoad();
        this.setBtnStatus();
        this.amountPresision = this.currency.getPrecision();
        this.txtBopWIPQty.setPrecision(2);
        this.txtBopWIPQty.setNegatived(false);
        this.txtFinishedQty.setPrecision(2);
        this.txtFinishedQty.setNegatived(false);
        this.filterMO();
        this.tabPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    InitOrderEditUI.this.tabPane1_stateChanged(e);
                }
                catch (Exception exc) {
                    InitOrderEditUI.this.handUIException(exc);
                }
            }
        });
        this.tabPane2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    InitOrderEditUI.this.tabPane2_stateChanged(e);
                }
                catch (Exception exc) {
                    InitOrderEditUI.this.handUIException(exc);
                }
            }
        });
        this.btnTab1AddLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KDTable tableMain = null;
                tableMain = InitOrderEditUI.this.tabPane1.getSelectedIndex() == 0 ? InitOrderEditUI.this.kdtMaterial : InitOrderEditUI.this.kdtActivity;
                InitOrderEditUI.this.addLine(tableMain);
            }
        });
        this.btnTab1InsertLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KDTable tableMain = null;
                tableMain = InitOrderEditUI.this.tabPane1.getSelectedIndex() == 0 ? InitOrderEditUI.this.kdtMaterial : InitOrderEditUI.this.kdtActivity;
                InitOrderEditUI.this.insertLine(tableMain);
            }
        });
        this.btnTab1RemoveLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KDTable tableMain = null;
                tableMain = InitOrderEditUI.this.tabPane1.getSelectedIndex() == 0 ? InitOrderEditUI.this.kdtMaterial : InitOrderEditUI.this.kdtActivity;
                InitOrderEditUI.this.removeLine(tableMain);
            }
        });
        this.btnTab2AddLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KDTable tableMain = null;
                if (InitOrderEditUI.this.tabPane2.getSelectedIndex() == 0) {
                    IRow materialRow = InitOrderEditUI.this.kdtMaterial.getRow(InitOrderEditUI.this.currentMaterialRowIndex);
                    if (materialRow == null) {
                        MsgBox.showInfo((String)"\u8bf7\u5148\u5f55\u5165\u6750\u6599\u5728\u5236\u3002");
                        SysUtil.abort();
                    }
                    tableMain = InitOrderEditUI.this.kdtMatDetail;
                } else {
                    IRow activityRow = InitOrderEditUI.this.kdtActivity.getRow(InitOrderEditUI.this.currentActivityRowIndex);
                    if (activityRow == null) {
                        MsgBox.showInfo((String)"\u8bf7\u5148\u5f55\u5165\u4f5c\u4e1a\u5728\u5236\u3002");
                        SysUtil.abort();
                    }
                    tableMain = InitOrderEditUI.this.kdtActDetail;
                }
                InitOrderEditUI.this.addLine(tableMain);
            }
        });
        this.btnTab2InsertLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KDTable tableMain = null;
                if (InitOrderEditUI.this.tabPane2.getSelectedIndex() == 0) {
                    IRow materialRow = InitOrderEditUI.this.kdtMaterial.getRow(InitOrderEditUI.this.currentMaterialRowIndex);
                    if (materialRow == null) {
                        MsgBox.showInfo((String)"\u8bf7\u5148\u5f55\u5165\u6750\u6599\u5728\u5236\u3002");
                        SysUtil.abort();
                    }
                    tableMain = InitOrderEditUI.this.kdtMatDetail;
                } else {
                    IRow activityRow = InitOrderEditUI.this.kdtActivity.getRow(InitOrderEditUI.this.currentActivityRowIndex);
                    if (activityRow == null) {
                        MsgBox.showInfo((String)"\u8bf7\u5148\u5f55\u5165\u4f5c\u4e1a\u5728\u5236\u3002");
                        SysUtil.abort();
                    }
                    tableMain = InitOrderEditUI.this.kdtActDetail;
                }
                InitOrderEditUI.this.insertLine(tableMain);
            }
        });
        this.btnTab2RemoveLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KDTable tableMain = null;
                tableMain = InitOrderEditUI.this.tabPane2.getSelectedIndex() == 0 ? InitOrderEditUI.this.kdtMatDetail : InitOrderEditUI.this.kdtActDetail;
                InitOrderEditUI.this.removeLine(tableMain);
            }
        });
        this.initMaterial();
        this.initMatDetail();
        this.initActivity();
        this.initActDetail();
        this.btnUnaudit.setToolTipText("\u53cd\u5ba1\u6838");
        this.btnAudit.setToolTipText("\u5ba1\u6838");
    }

    private void setCostCenter4Activity() {
        if (this.editData == null || this.editData.size() <= 0) {
            return;
        }
        IRow row = null;
        HashMap<String, CostCenterOrgUnitInfo> map = new HashMap<String, CostCenterOrgUnitInfo>();
        InitOrderActivityCollection activityColl = this.editData.getActivity();
        InitOrderActivityInfo initOrderActivity = null;
        ActivityInfo activityInfo = null;
        String activityNumber = null;
        CostCenterOrgUnitInfo costCenter = null;
        int len = activityColl.size();
        for (int j = 0; j < len; ++j) {
            initOrderActivity = activityColl.get(j);
            if (initOrderActivity == null || initOrderActivity.getActivity() == null) continue;
            map.put(initOrderActivity.getActivity().getNumber().toString(), initOrderActivity.getActivity().getCostCenter());
        }
        len = this.kdtActivity.getRowCount();
        for (int i = 0; i < len; ++i) {
            row = this.kdtActivity.getRow(i);
            if (row == null || row.getCell("activity.number").getValue() == null || (costCenter = (CostCenterOrgUnitInfo)map.get(activityNumber = (activityInfo = (ActivityInfo)row.getCell("activity.number").getValue()).getNumber())) == null) continue;
            row.getCell("costCenter.number").setValue((Object)costCenter.getNumber());
            row.getCell("costCenter.name").setValue((Object)costCenter.getName());
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("activity.activity.costCenter.id"));
        sic.add(new SelectorItemInfo("activity.activity.costCenter.number"));
        sic.add(new SelectorItemInfo("activity.activity.costCenter.name"));
        return sic;
    }

    private void setBtnStatus() {
        if (this.oprtState.equals(OprtState.ADDNEW) || this.oprtState.equals(OprtState.EDIT)) {
            this.btnTab1AddLine.setEnabled(true);
            this.btnTab1InsertLine.setEnabled(true);
            this.btnTab1RemoveLine.setEnabled(true);
            this.btnTab2AddLine.setEnabled(true);
            this.btnTab2InsertLine.setEnabled(true);
            this.btnTab2RemoveLine.setEnabled(true);
        } else {
            this.btnTab1AddLine.setEnabled(false);
            this.btnTab1InsertLine.setEnabled(false);
            this.btnTab1RemoveLine.setEnabled(false);
            this.btnTab2AddLine.setEnabled(false);
            this.btnTab2InsertLine.setEnabled(false);
            this.btnTab2RemoveLine.setEnabled(false);
        }
    }

    private void addLine(int index, KDTable kdtEntrys) throws EASBizException, BOSException {
        if (index != -1) {
            kdtEntrys.addRow(index);
        } else {
            kdtEntrys.addRow();
        }
    }

    protected void filterMO() throws Exception {
        this.prmtOrder.setQueryInfo("com.kingdee.eas.mm.mo.app.F7ManufactureOrderQuery");
        this.prmtOrder.setVisible(true);
        this.prmtOrder.setEditable(true);
        this.prmtOrder.setDisplayFormat("$number$");
        this.prmtOrder.setEditFormat("$number$");
        this.prmtOrder.setCommitFormat("$number$");
        EntityViewInfo eviMO = new EntityViewInfo();
        eviMO.setFilter(this.getMOFilter());
        this.prmtOrder.setEntityViewInfo(eviMO);
        this.prmtOrder.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    InitOrderEditUI.this.prmtOrder_dataChanged(e);
                }
                catch (Exception exc) {
                    InitOrderEditUI.this.handUIException(exc);
                }
            }
        });
    }

    protected FilterInfo getMOFilter() throws Exception {
        FilterInfo filter = new FilterInfo();
        HashSet<Integer> statusSet = new HashSet<Integer>();
        statusSet.add(new Integer(5));
        statusSet.add(new Integer(8));
        statusSet.add(new Integer(7));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", statusSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("actureBeginDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)this._period.getEndDate()), CompareType.LESS_EQUALS));
        filter.mergeFilter(this.getStorageFilterFromFI(), "and");
        return filter;
    }

    protected FilterInfo getStorageFilterFromFI() throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        IOrgUnitRelation iOUR = OrgUnitRelationFactory.getRemoteInstance();
        OrgUnitCollection ccColl = iOUR.getFromUnit(this.companyID, 1, 4);
        int ccSize = ccColl.size();
        HashSet<String> ccIDSet = new HashSet<String>(ccSize);
        for (int i = 0; i < ccSize; ++i) {
            ccIDSet.add(ccColl.get(i).getId().toString());
        }
        filter.getFilterItems().add(new FilterItemInfo("STORAGEORGUNIT.ID", ccIDSet, CompareType.INCLUDE));
        return filter;
    }

    protected void initMaterial() throws Exception {
        this.kdtMaterial.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                int[] rows = KDTableUtil.getSelectedRows((KDTable)InitOrderEditUI.this.kdtMaterial);
                if (rows != null && rows.length > 0) {
                    InitOrderEditUI.this.currentMaterialRowIndex = rows[0];
                } else {
                    InitOrderEditUI.this.currentMaterialRowIndex = -1;
                }
            }
        });
        this.kdtMaterial.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                try {
                    InitOrderEditUI.this.kdtMaterial_editStarting(e);
                }
                catch (Exception exc) {
                    InitOrderEditUI.this.handUIException(exc);
                }
            }

            public void editStopped(KDTEditEvent e) {
                try {
                    InitOrderEditUI.this.kdtMaterial_editStopped(e);
                }
                catch (Exception exc) {
                    InitOrderEditUI.this.handUIException(exc);
                }
            }
        });
        KDBizPromptBox prmtCostCenter = new KDBizPromptBox();
        prmtCostCenter.setQueryInfo("com.kingdee.eas.basedata.org.app.CostCenterItemQuery");
        prmtCostCenter.setVisible(true);
        prmtCostCenter.setEditable(true);
        prmtCostCenter.setDisplayFormat("$number$");
        prmtCostCenter.setEditFormat("$number$");
        prmtCostCenter.setCommitFormat("$number$");
        EntityViewInfo eviCostCenter = new EntityViewInfo();
        eviCostCenter.setFilter(this.getCostCenterBaseFilter());
        prmtCostCenter.setEntityViewInfo(eviCostCenter);
        prmtCostCenter.setRequired(true);
        ObjectValueRender avCostCenter = new ObjectValueRender();
        avCostCenter.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtMaterial.getColumn("costCenter.number").setRenderer((IBasicRender)avCostCenter);
        this.kdtMaterial.getColumn("costCenter.number").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtCostCenter));
        this.kdtMaterial.getColumn("costCenter.name").getStyleAttributes().setLocked(true);
        this.kdtMaterial.getColumn("costCenter.number").setRequired(true);
        KDBizPromptBox prmtCostItem = new KDBizPromptBox();
        prmtCostItem.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostItemTreeListQuery");
        prmtCostItem.setVisible(true);
        prmtCostItem.setEditable(true);
        prmtCostItem.setDisplayFormat("$number$");
        prmtCostItem.setEditFormat("$number$");
        prmtCostItem.setCommitFormat("$number$");
        EntityViewInfo eviCostItem = new EntityViewInfo();
        eviCostItem.setFilter(this.getCostItemMatFilter());
        prmtCostItem.setEntityViewInfo(eviCostItem);
        prmtCostItem.setRequired(true);
        ObjectValueRender avCostItem = new ObjectValueRender();
        avCostItem.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtMaterial.getColumn("costItem.number").setRenderer((IBasicRender)avCostItem);
        this.kdtMaterial.getColumn("costItem.number").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtCostItem));
        this.kdtMaterial.getColumn("costItem.name").getStyleAttributes().setLocked(true);
        this.kdtMaterial.getColumn("costItem.number").setRequired(true);
        KDFormattedTextField txtBopAmount = new KDFormattedTextField();
        txtBopAmount.setDataType(1);
        txtBopAmount.setPrecision(this.amountPresision);
        txtBopAmount.setHorizontalAlignment(4);
        this.kdtMaterial.getColumn("bopAmount").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtBopAmount));
        this.kdtMaterial.getColumn("bopAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtMaterial.getColumn("bopAmount").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)this.amountPresision));
        this.kdtMaterial.getColumn("bopAmount").getStyleAttributes().setLocked(true);
        this.kdtMaterial.getColumn("bopAmount").setRequired(true);
        KDFormattedTextField txtInputAmount = new KDFormattedTextField();
        txtInputAmount.setDataType(1);
        txtInputAmount.setPrecision(this.amountPresision);
        txtInputAmount.setHorizontalAlignment(4);
        this.kdtMaterial.getColumn("inputAmount").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtInputAmount));
        this.kdtMaterial.getColumn("inputAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtMaterial.getColumn("inputAmount").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)this.amountPresision));
        this.kdtMaterial.getColumn("inputAmount").getStyleAttributes().setLocked(true);
        this.kdtMaterial.getColumn("inputAmount").setWidth(120);
    }

    protected void initMatDetail() throws Exception {
        this.kdtMatDetail.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                try {
                    int rowIndex = e.getRowIndex();
                    int colIndex = e.getColIndex();
                    if (InitOrderEditUI.this.kdtMatDetail.getColumn("material.batchNo").getColumnIndex() == colIndex) {
                        EntityViewInfo view = new EntityViewInfo();
                        FilterInfo filter = new FilterInfo();
                        MaterialInfo materialInfo = null;
                        if (InitOrderEditUI.this.kdtMatDetail.getCell(rowIndex, "material.number").getValue() instanceof MaterialInfo) {
                            materialInfo = (MaterialInfo)InitOrderEditUI.this.kdtMatDetail.getCell(rowIndex, "material.number").getValue();
                        }
                        if (materialInfo == null) {
                            e.setCancel(true);
                            InitOrderEditUI.this.kdtMatDetail.getCell(rowIndex, "material.batchNo").getStyleAttributes().setLocked(true);
                            return;
                        }
                        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialInfo.getId().toString(), CompareType.EQUALS));
                        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)BDCMUtils.getStorageOrgUnitIdsOfCompany((String)InitOrderEditUI.this.companyID), CompareType.INCLUDE));
                        view.setFilter(filter);
                        MaterialInventoryCollection coll = MaterialInventoryFactory.getRemoteInstance().getMaterialInventoryCollection(view);
                        boolean batchNoFlag = false;
                        if (coll != null && coll.size() > 0) {
                            MaterialInventoryInfo info = null;
                            for (int i = 0; i < coll.size(); ++i) {
                                info = coll.get(i);
                                if (info == null || !info.isIsLotNumber()) continue;
                                batchNoFlag = true;
                                break;
                            }
                        }
                        if (batchNoFlag) {
                            InitOrderEditUI.this.kdtMatDetail.getCell(rowIndex, "material.batchNo").getStyleAttributes().setLocked(false);
                        } else {
                            e.setCancel(true);
                            InitOrderEditUI.this.kdtMatDetail.getCell(rowIndex, "material.batchNo").getStyleAttributes().setLocked(true);
                        }
                    }
                }
                catch (Exception exc) {
                    InitOrderEditUI.this.handUIException(exc);
                }
            }

            public void editStopped(KDTEditEvent e) {
                try {
                    InitOrderEditUI.this.kdtMatDetail_editStopped(e);
                }
                catch (Exception exc) {
                    InitOrderEditUI.this.handUIException(exc);
                }
            }
        });
        KDBizPromptBox prmtMat = new KDBizPromptBox();
        prmtMat.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7MaterialCostObjectQuery");
        prmtMat.setVisible(true);
        prmtMat.setEditable(true);
        prmtMat.setDisplayFormat("$number$");
        prmtMat.setEditFormat("$number$");
        prmtMat.setCommitFormat("$number$");
        EntityViewInfo eviMat = new EntityViewInfo();
        eviMat.setFilter(this.getMaterialFilter());
        prmtMat.setEntityViewInfo(eviMat);
        prmtMat.setRequired(true);
        ObjectValueRender avMat = new ObjectValueRender();
        avMat.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtMatDetail.getColumn("material.number").setRenderer((IBasicRender)avMat);
        this.kdtMatDetail.getColumn("material.number").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtMat));
        this.kdtMatDetail.getColumn("material.number").setRequired(true);
        this.kdtMatDetail.getColumn("material.name").getStyleAttributes().setLocked(true);
        this.kdtMatDetail.getColumn("material.model").getStyleAttributes().setLocked(true);
        this.kdtMatDetail.getColumn("material.baseUnit").getStyleAttributes().setLocked(true);
        KDFormattedTextField txtQty = new KDFormattedTextField();
        txtQty.setDataType(1);
        txtQty.setHorizontalAlignment(4);
        txtQty.setNegatived(false);
        this.kdtMatDetail.getColumn("qty").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtQty));
        this.kdtMatDetail.getColumn("qty").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtMatDetail.getColumn("qty").setRequired(true);
        KDFormattedTextField txtPrice = new KDFormattedTextField();
        txtPrice.setDataType(1);
        txtPrice.setHorizontalAlignment(4);
        txtPrice.setNegatived(false);
        this.kdtMatDetail.getColumn("price").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtPrice));
        this.kdtMatDetail.getColumn("price").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtMatDetail.getColumn("price").setRequired(true);
        KDFormattedTextField txtAmount = new KDFormattedTextField();
        txtAmount.setDataType(1);
        txtAmount.setPrecision(this.amountPresision);
        txtAmount.setHorizontalAlignment(4);
        txtAmount.setNegatived(false);
        this.kdtMatDetail.getColumn("amount").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtAmount));
        this.kdtMatDetail.getColumn("amount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtMatDetail.getColumn("amount").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)this.amountPresision));
        this.kdtMatDetail.getColumn("amount").setRequired(true);
        KDFormattedTextField txtInputMatQty = new KDFormattedTextField();
        txtInputMatQty.setDataType(1);
        txtInputMatQty.setPrecision(8);
        txtInputMatQty.setHorizontalAlignment(4);
        txtInputMatQty.setNegatived(false);
        this.kdtMatDetail.getColumn("inputMatQty").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtInputMatQty));
        this.kdtMatDetail.getColumn("inputMatQty").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtMatDetail.getColumn("inputMatQty").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)8));
        KDFormattedTextField txtInputMatAmount = new KDFormattedTextField();
        txtInputMatAmount.setDataType(1);
        txtInputMatAmount.setPrecision(this.amountPresision);
        txtInputMatAmount.setHorizontalAlignment(4);
        txtInputMatAmount.setNegatived(false);
        this.kdtMatDetail.getColumn("inputMatAmount").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtInputMatAmount));
        this.kdtMatDetail.getColumn("inputMatAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtMatDetail.getColumn("inputMatAmount").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)this.amountPresision));
        this.kdtMatDetail.getColumn("inputMatAmount").setWidth(120);
        if (!"ADDNEW".equals(this.getOprtState()) || this.kdtMatDetail.getRowCount() < 1) {
            // empty if block
        }
    }

    protected void initActivity() throws Exception {
        this.kdtActivity.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                int[] rows = KDTableUtil.getSelectedRows((KDTable)InitOrderEditUI.this.kdtActivity);
                if (rows != null && rows.length > 0) {
                    InitOrderEditUI.this.currentActivityRowIndex = rows[0];
                } else {
                    InitOrderEditUI.this.currentActivityRowIndex = -1;
                }
            }
        });
        this.kdtActivity.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                try {
                    InitOrderEditUI.this.kdtActivity_editStarting(e);
                }
                catch (Exception exc) {
                    InitOrderEditUI.this.handUIException(exc);
                }
            }

            public void editStopped(KDTEditEvent e) {
                try {
                    InitOrderEditUI.this.kdtActivity_editStopped(e);
                }
                catch (Exception exc) {
                    InitOrderEditUI.this.handUIException(exc);
                }
            }
        });
        KDBizPromptBox prmtActivity = new KDBizPromptBox();
        prmtActivity.setQueryInfo("com.kingdee.eas.basedata.ncm.app.ActivityQuery");
        prmtActivity.setVisible(true);
        prmtActivity.setEditable(true);
        prmtActivity.setDisplayFormat("$number$");
        prmtActivity.setEditFormat("$number$");
        prmtActivity.setCommitFormat("$number$");
        EntityViewInfo eviActivity = new EntityViewInfo();
        eviActivity.setFilter(this.getActivityFilter());
        prmtActivity.setEntityViewInfo(eviActivity);
        ObjectValueRender avActivity = new ObjectValueRender();
        avActivity.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtActivity.getColumn("activity.number").setRenderer((IBasicRender)avActivity);
        this.kdtActivity.getColumn("activity.number").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtActivity));
        this.kdtActivity.getColumn("activity.name").getStyleAttributes().setLocked(true);
        this.kdtActivity.getColumn("activity.baseUnit").getStyleAttributes().setLocked(true);
        this.kdtActivity.getColumn("activity.number").setRequired(true);
        KDFormattedTextField txtBopQty = new KDFormattedTextField();
        txtBopQty.setDataType(1);
        txtBopQty.setPrecision(8);
        txtBopQty.setHorizontalAlignment(4);
        txtBopQty.setNegatived(false);
        this.kdtActivity.getColumn("bopQty").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtBopQty));
        this.kdtActivity.getColumn("bopQty").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtActivity.getColumn("bopQty").setWidth(120);
        KDFormattedTextField txtBopAmount = new KDFormattedTextField();
        txtBopAmount.setDataType(1);
        txtBopAmount.setPrecision(this.amountPresision);
        txtBopAmount.setHorizontalAlignment(4);
        this.kdtActivity.getColumn("bopAmount").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtBopAmount));
        this.kdtActivity.getColumn("bopAmount").getStyleAttributes().setLocked(true);
        this.kdtActivity.getColumn("bopAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtActivity.getColumn("bopAmount").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)this.amountPresision));
        this.kdtActivity.getColumn("bopAmount").setRequired(true);
        KDFormattedTextField txtInputAmount = new KDFormattedTextField();
        txtInputAmount.setDataType(1);
        txtInputAmount.setPrecision(this.amountPresision);
        txtInputAmount.setHorizontalAlignment(4);
        this.kdtActivity.getColumn("inputAmount").getStyleAttributes().setLocked(true);
        this.kdtActivity.getColumn("inputAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtActivity.getColumn("inputAmount").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)this.amountPresision));
        this.kdtActivity.getColumn("inputAmount").setWidth(120);
        if ("ADDNEW".equals(this.getOprtState()) && this.kdtActivity.getRowCount() < 1) {
            this.addLine(this.kdtActivity);
        }
        this.kdtActivity.getColumn("bcToUnewhQty").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        txtBopAmount.setHorizontalAlignment(4);
        this.kdtActivity.getColumn("bcToUnewhQty").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)4));
        this.kdtActivity.getColumn("bUntoQty").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtActivity.getColumn("bUntoQty").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)4));
    }

    protected void initActDetail() throws Exception {
        this.kdtActDetail.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    InitOrderEditUI.this.kdtActDetail_editStopped(e);
                }
                catch (Exception exc) {
                    InitOrderEditUI.this.handUIException(exc);
                }
            }
        });
        KDBizPromptBox prmtCostItem = new KDBizPromptBox();
        prmtCostItem.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostItemTreeListQuery");
        prmtCostItem.setVisible(true);
        prmtCostItem.setEditable(true);
        prmtCostItem.setDisplayFormat("$number$");
        prmtCostItem.setEditFormat("$number$");
        prmtCostItem.setCommitFormat("$number$");
        EntityViewInfo eviCostItem = new EntityViewInfo();
        eviCostItem.setFilter(this.getCostItemNotMatFilter());
        prmtCostItem.setEntityViewInfo(eviCostItem);
        prmtCostItem.setRequired(true);
        ObjectValueRender avCostItem = new ObjectValueRender();
        avCostItem.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtActDetail.getColumn("costItem.number").setRenderer((IBasicRender)avCostItem);
        this.kdtActDetail.getColumn("costItem.number").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtCostItem));
        this.kdtActDetail.getColumn("costItem.name").getStyleAttributes().setLocked(true);
        this.kdtActDetail.getColumn("costItem.number").setRequired(true);
        KDFormattedTextField txtBopQty = new KDFormattedTextField();
        txtBopQty.setDataType(1);
        txtBopQty.setPrecision(8);
        txtBopQty.setHorizontalAlignment(4);
        txtBopQty.setNegatived(false);
        this.kdtActDetail.getColumn("bopQty").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtActDetail.getColumn("bopQty").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)8));
        this.kdtActDetail.getColumn("bopQty").setWidth(120);
        this.kdtActDetail.getColumn("bopAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtActDetail.getColumn("bopAmount").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)this.amountPresision));
        this.kdtActDetail.getColumn("bopAmount").setWidth(120);
        this.kdtActDetail.getColumn("bopAmount").setRequired(true);
        this.kdtActDetail.getColumn("inputQty").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtActDetail.getColumn("inputQty").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)8));
        this.kdtActDetail.getColumn("inputQty").setWidth(120);
        this.kdtActDetail.getColumn("inputAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtActDetail.getColumn("inputAmount").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)this.amountPresision));
        this.kdtActDetail.getColumn("inputAmount").setWidth(120);
        if (!"ADDNEW".equals(this.getOprtState()) || this.kdtActDetail.getRowCount() < 1) {
            // empty if block
        }
    }

    protected void prmtOrder_dataChanged(DataChangeEvent e) throws Exception {
        ManufactureOrderInfo moInfo = (ManufactureOrderInfo)e.getNewValue();
        if (moInfo != null) {
            StorageOrgUnitInfo storage = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(moInfo.getStorageOrgUnit().getId()));
            this.prmtStorage.setData((Object)storage);
            MaterialInfo materialInfo = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(moInfo.getMaterial().getId()));
            this.prmtMoMaterialNumber.setData((Object)materialInfo);
            this.txtMoMaterialName.setText(materialInfo.getName());
            MeasureUnitInfo unit = MeasureUnitFactory.getRemoteInstance().getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(materialInfo.getBaseUnit().getId()));
            this.prmtBaseUnti.setData((Object)unit);
            this.txtBaseQty.setText(moInfo.getBaseQty().toString());
            this.txtBopWIPQty.setPrecision(unit.getQtyPrecision());
            this.txtFinishedQty.setPrecision(unit.getQtyPrecision());
        }
    }

    public void kdtMaterial_editStarting(KDTEditEvent e) throws Exception {
        this.currentMaterialRowIndex = e.getRowIndex();
    }

    public void kdtMaterial_editStopped(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (this.kdtMaterial.getColumn("costCenter.number").getColumnIndex() == colIndex && e.getValue() instanceof CostCenterOrgUnitInfo) {
            CostCenterOrgUnitInfo cc = (CostCenterOrgUnitInfo)e.getValue();
            this.kdtMaterial.getCell(rowIndex, "costCenter.name").setValue((Object)cc.getName());
        }
        if (this.kdtMaterial.getColumn("costItem.number").getColumnIndex() == colIndex && e.getValue() instanceof CostItemInfo) {
            CostItemInfo ci = (CostItemInfo)e.getValue();
            this.kdtMaterial.getCell(rowIndex, "costItem.name").setValue((Object)ci.getName());
        }
    }

    public void kdtMatDetail_editStopped(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (this.kdtMatDetail.getColumn("material.number").getColumnIndex() == colIndex && e.getValue() instanceof MaterialInfo) {
            MaterialInfo materialInfo = (MaterialInfo)e.getValue();
            if (materialInfo == null || materialInfo.getId() == null) {
                return;
            }
            this.kdtMatDetail.getCell(rowIndex, "material.name").setValue((Object)materialInfo.getName());
            this.kdtMatDetail.getCell(rowIndex, "material.model").setValue((Object)materialInfo.getModel());
            MeasureUnitInfo unit = MeasureUnitFactory.getRemoteInstance().getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(materialInfo.getBaseUnit().getId()));
            this.kdtMatDetail.getCell(rowIndex, "material.baseUnit").setValue((Object)unit.getName());
            NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)this.kdtMatDetail.getRow(rowIndex).getCell("qty"), (int)unit.getQtyPrecision());
            this.kdtMatDetail.getCell(rowIndex, "material.batchNo").setValue(null);
            this.kdtMatDetail.getCell(rowIndex, "material.batchNo").getStyleAttributes().setLocked(false);
            NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)this.kdtMatDetail.getCell(rowIndex, "price"), (int)materialInfo.getPricePrecision());
        }
        BigDecimal qty = SysConstant.BIGZERO;
        BigDecimal price = SysConstant.BIGZERO;
        BigDecimal amount = SysConstant.BIGZERO;
        if (this.kdtMatDetail.getColumn("qty").getColumnIndex() == colIndex || this.kdtMatDetail.getColumn("price").getColumnIndex() == colIndex) {
            qty = BDCMClientUtils.castToBigDecimal((KDTable)this.kdtMatDetail, (int)rowIndex, (String)"qty");
            price = BDCMClientUtils.castToBigDecimal((KDTable)this.kdtMatDetail, (int)rowIndex, (String)"price");
            amount = qty.multiply(price);
            this.kdtMatDetail.getCell(rowIndex, "amount").setValue((Object)amount);
        } else if (this.kdtMatDetail.getColumn("amount").getColumnIndex() == colIndex) {
            MaterialInfo materialInfo = null;
            if (this.kdtMatDetail.getCell(rowIndex, "material.number").getValue() instanceof MaterialInfo) {
                materialInfo = (MaterialInfo)this.kdtMatDetail.getCell(rowIndex, "material.number").getValue();
            }
            if (BDCMUtils.equalsZero((BigDecimal)(qty = BDCMClientUtils.castToBigDecimal((KDTable)this.kdtMatDetail, (int)rowIndex, (String)"qty")))) {
                return;
            }
            amount = BDCMClientUtils.castToBigDecimal((KDTable)this.kdtMatDetail, (int)rowIndex, (String)"amount");
            price = materialInfo != null ? amount.divide(qty, materialInfo.getPricePrecision(), 4) : amount.divide(qty, 4);
            this.kdtMatDetail.getCell(rowIndex, "price").setValue((Object)price);
        }
        BigDecimal amountRow = SysConstant.BIGZERO;
        BigDecimal amountTotal = SysConstant.BIGZERO;
        for (int i = 0; i < this.kdtMatDetail.getRowCount(); ++i) {
            IRow row = this.kdtMatDetail.getRow(i);
            amountRow = BDCMClientUtils.castToBigDecimal((KDTable)this.kdtMatDetail, (int)row.getRowIndex(), (String)"amount");
            amountTotal = amountTotal.add(amountRow);
        }
        if (this.currentMaterialRowIndex < 0) {
            return;
        }
        IRow materialRow = this.kdtMaterial.getRow(this.currentMaterialRowIndex);
        materialRow.getCell("bopAmount").setValue((Object)amountTotal);
        BigDecimal amountMatRow = SysConstant.BIGZERO;
        BigDecimal amountMatTotal = SysConstant.BIGZERO;
        for (int i = 0; i < this.kdtMatDetail.getRowCount(); ++i) {
            IRow row = this.kdtMatDetail.getRow(i);
            amountMatRow = BDCMClientUtils.castToBigDecimal((KDTable)this.kdtMatDetail, (int)row.getRowIndex(), (String)"inputMatAmount");
            amountMatTotal = amountMatTotal.add(amountMatRow);
        }
        materialRow.getCell("inputAmount").setValue((Object)amountMatTotal);
    }

    public void kdtActivity_editStarting(KDTEditEvent e) throws Exception {
    }

    public void kdtActivity_editStopped(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (this.kdtActivity.getColumn("activity.number").getColumnIndex() == colIndex && e.getValue() instanceof ActivityInfo) {
            ActivityInfo activityInfo = (ActivityInfo)e.getValue();
            this.kdtActivity.getCell(rowIndex, "activity.name").setValue((Object)activityInfo.getName());
            this.kdtActivity.getCell(rowIndex, "activity.baseUnit").setValue((Object)activityInfo.getTimeUnit());
            CostCenterOrgUnitInfo costCenterInfo = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(activityInfo.getCostCenter().getId()));
            this.kdtActivity.getCell(rowIndex, "costCenter.number").setValue((Object)costCenterInfo.getNumber());
            this.kdtActivity.getCell(rowIndex, "costCenter.name").setValue((Object)costCenterInfo.getName());
        }
    }

    public void kdtActDetail_editStopped(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (this.kdtActDetail.getColumn("costItem.number").getColumnIndex() == colIndex && e.getValue() instanceof CostItemInfo) {
            CostItemInfo ci = (CostItemInfo)e.getValue();
            this.kdtActDetail.getCell(rowIndex, "costItem.name").setValue((Object)ci.getName());
        }
        if (this.currentActivityRowIndex < 0) {
            return;
        }
        BigDecimal amountRow = SysConstant.BIGZERO;
        BigDecimal amountTotal = SysConstant.BIGZERO;
        for (int i = 0; i < this.kdtActDetail.getRowCount(); ++i) {
            IRow row = this.kdtActDetail.getRow(i);
            amountRow = BDCMClientUtils.castToBigDecimal((KDTable)this.kdtActDetail, (int)row.getRowIndex(), (String)"bopAmount");
            amountTotal = amountTotal.add(amountRow);
        }
        IRow activityRow = this.kdtActivity.getRow(this.currentActivityRowIndex);
        activityRow.getCell("bopAmount").setValue((Object)amountTotal);
        BigDecimal amountInputRow = SysConstant.BIGZERO;
        BigDecimal amountInputTotal = SysConstant.BIGZERO;
        for (int i = 0; i < this.kdtActDetail.getRowCount(); ++i) {
            IRow row = this.kdtActDetail.getRow(i);
            amountInputRow = BDCMClientUtils.castToBigDecimal((KDTable)this.kdtActDetail, (int)row.getRowIndex(), (String)"inputAmount");
            amountInputTotal = amountInputTotal.add(amountInputRow);
        }
        activityRow.getCell("inputAmount").setValue((Object)amountInputTotal);
    }

    protected void tabPane1_stateChanged(ChangeEvent e) throws Exception {
        int t1 = this.tabPane1.getSelectedIndex();
        if (t1 == 0) {
            this.tabPane = 1;
            this.tabPane2.setSelectedIndex(0);
        } else {
            this.tabPane = 2;
            this.tabPane2.setSelectedIndex(1);
        }
    }

    protected void tabPane2_stateChanged(ChangeEvent e) throws Exception {
        int t2 = this.tabPane2.getSelectedIndex();
        if (t2 == 0) {
            this.tabPane = 3;
            this.tabPane1.setSelectedIndex(0);
        } else {
            this.tabPane = 4;
            this.tabPane1.setSelectedIndex(1);
        }
    }

    private FilterInfo getActivityFilter() throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1), CompareType.EQUALS));
        return filter;
    }

    private FilterInfo getMaterialFilter() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("materialCompany.status", (Object)new Integer(1), CompareType.EQUALS));
        return filter;
    }

    private FilterInfo getCostCenterBaseFilter() throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        Set ccIDSet = BDCMClientUtils.getCostCenterSet((String)this.companyID);
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)Boolean.TRUE, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ccIDSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("costCenterType", (Object)new Integer(0), CompareType.EQUALS));
        return filter;
    }

    private FilterInfo getCostItemMatFilter() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("itemType", (Object)"1"));
        return filter;
    }

    private FilterInfo getCostItemNotMatFilter() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("itemType", (Object)"1", CompareType.NOTEQUALS));
        return filter;
    }

    protected FilterInfo getCostItemFilter() throws Exception {
        return CostItemFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), this.getKeyFieldName(), this.getAdminCUFieldName());
    }

    protected IObjectPK getBizCUPK() {
        Object object = this.getUIContext().get(this.getMainBizOrgType());
        CtrlUnitInfo currentBizOrg = object == null ? SysContext.getSysContext().getCurrentCtrlUnit() : (OrgUnitInfo)object;
        return new ObjectUuidPK(currentBizOrg.getCU().getId());
    }

    protected boolean confirmRemove(String msg) {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)msg));
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getAdminCUFieldName() {
        return "adminCU.id";
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        this.currentMaterialRowIndex = -1;
        this.currentActivityRowIndex = -1;
    }

    private String getNameByColumnKey(IRow row, String columnKey) {
        String name = "";
        if (row == null) {
            return name;
        }
        ICell cell = row.getCell(columnKey);
        if (cell == null) {
            return name;
        }
        if (cell.getValue() instanceof AbstractDataBaseInfo) {
            AbstractDataBaseInfo baseInfo = (AbstractDataBaseInfo)cell.getValue();
            if (baseInfo != null) {
                name = baseInfo.getName();
            }
        } else if (cell.getValue() instanceof String) {
            name = (String)cell.getValue();
        }
        return name;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        int rowNum2;
        int rowNum1 = this.checkRowRepeat(this.kdtMaterial, "kdtMaterial");
        if (rowNum1 != -1) {
            IRow row = this.kdtMaterial.getRow(rowNum1);
            String costCenter = this.getNameByColumnKey(row, "costCenter.number");
            String costItem = this.getNameByColumnKey(row, "costItem.number");
            MsgBox.showInfo((String)("\u6210\u672c\u4e2d\u5fc3" + costCenter + "+\u6210\u672c\u9879\u76ee" + costItem + "\u91cd\u590d\uff0c\u4e0d\u80fd\u63d0\u4ea4\u3002"));
            SysUtil.abort();
        }
        if ((rowNum2 = this.checkRowRepeat(this.kdtMatDetail, "kdtMatDetail")) != -1) {
            IRow row = this.kdtMatDetail.getRow(rowNum2);
            String material = this.getNameByColumnKey(row, "material.number");
            String batchNo = this.getNameByColumnKey(row, "material.batchNo");
            MsgBox.showInfo((String)("\u7269\u6599" + material + "+\u6279\u6b21" + batchNo + "\u91cd\u590d\uff0c\u4e0d\u80fd\u63d0\u4ea4\u3002"));
            SysUtil.abort();
        }
        if (this.kdtMaterial.getRowCount() > 0) {
            this.kdtEntries = this.kdtMaterial;
        } else if (this.kdtActivity.getRowCount() > 0) {
            this.kdtEntries = this.kdtActivity;
        }
        super.actionSubmit_actionPerformed(e);
        this.currentMaterialRowIndex = -1;
        this.currentActivityRowIndex = -1;
    }

    private int checkRowRepeat(KDTable kdt, String tableName) {
        if (kdt == null || kdt.getRowCount() <= 1) {
            return -1;
        }
        for (int i = 0; i < kdt.getRowCount(); ++i) {
            IRow row = kdt.getRow(i);
            if (row == null) continue;
            for (int j = i + 1; j < kdt.getRowCount(); ++j) {
                IRow anotherRow = kdt.getRow(j);
                if (anotherRow == null || !this.checkColumnForRow(row, anotherRow, tableName)) continue;
                return j;
            }
        }
        return -1;
    }

    private boolean checkColumnForRow(IRow row, IRow anotherRow, String tableName) {
        boolean flag = false;
        if ("kdtMaterial".equals(tableName)) {
            boolean costCenterFlag = this.checkCellForRow(row, anotherRow, "costCenter.number");
            boolean costItemFlag = this.checkCellForRow(row, anotherRow, "costItem.number");
            if (costCenterFlag && costItemFlag) {
                flag = true;
            }
        } else if ("kdtMatDetail".equals(tableName)) {
            boolean materialFlag = this.checkCellForRow(row, anotherRow, "material.number");
            boolean batchNoFlag = this.checkCellForRow(row, anotherRow, "material.batchNo");
            if (materialFlag && batchNoFlag) {
                flag = true;
            }
        }
        return flag;
    }

    private boolean checkCellForRow(IRow row, IRow anotherRow, String column) {
        boolean flag = false;
        ICell cell1 = row.getCell(column);
        ICell cell2 = anotherRow.getCell(column);
        if (cell1 == null && cell2 == null) {
            flag = true;
        } else if (cell1 != null && cell2 != null) {
            if (cell1.getValue() instanceof CoreBaseInfo && cell2.getValue() instanceof CoreBaseInfo) {
                CoreBaseInfo value1 = (CoreBaseInfo)cell1.getValue();
                CoreBaseInfo value2 = (CoreBaseInfo)cell2.getValue();
                if (value1 == null && value2 == null) {
                    flag = true;
                } else if (value1 != null && value2 != null && value1.getId().equals((Object)value2.getId())) {
                    flag = true;
                }
            } else if (cell1.getValue() instanceof String && cell2.getValue() instanceof String && cell1.getValue().equals(cell2.getValue())) {
                flag = true;
            }
        }
        return flag;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.kdtMaterial.getSelectManager().getActiveRowIndex();
        this.kdtMatDetail.getSelectManager().getActiveRowIndex();
        super.actionAddLine_actionPerformed(e);
    }

    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionInsertLine_actionPerformed(e);
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
    }

    @Override
    public void auditAction_actionPerformed(ActionEvent e) throws Exception {
        super.auditAction_actionPerformed(e);
    }

    @Override
    public void unauditAction_actionPerformed(ActionEvent e) throws Exception {
        super.unauditAction_actionPerformed(e);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return InitOrderFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        InitOrderInfo initOrderInfo = new InitOrderInfo();
        initOrderInfo.setCompanyOrg(this.currentCompany);
        initOrderInfo.setBillStatus(BillBaseStatusEnum.ADD);
        initOrderInfo.setBopWIPQty(SysConstant.BIGZERO);
        initOrderInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        return initOrderInfo;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        if (table.equals(this.kdtMaterial)) {
            InitOrderMaterialInfo InitOrderMaterialInfo2 = new InitOrderMaterialInfo();
            return InitOrderMaterialInfo2;
        }
        if (table.equals(this.kdtMatDetail)) {
            InitOrderMaterialEntryInfo initOrderMaterialEntryInfo = new InitOrderMaterialEntryInfo();
            return initOrderMaterialEntryInfo;
        }
        if (table.equals(this.kdtActivity)) {
            InitOrderActivityInfo initOrderActivityInfo = new InitOrderActivityInfo();
            return initOrderActivityInfo;
        }
        if (table.equals(this.kdtActDetail)) {
            InitOrderActivityEntryInfo initOrderActivityEntryInfo = new InitOrderActivityEntryInfo();
            return initOrderActivityEntryInfo;
        }
        return null;
    }

    protected KDTable getDetailTable() {
        KDTable detailTable = null;
        if (this.tabPane1.getSelectedIndex() == 0) {
            detailTable = this.kdtMaterial;
        } else if (this.tabPane1.getSelectedIndex() == 1) {
            detailTable = this.kdtActivity;
        }
        return detailTable;
    }

    protected void initNumber() throws EASBizException, BOSException {
        this.ruleStatus = CodingRuleManagerFactory.getRemoteInstance().getRuleStatus((IObjectValue)this.editData, this.editData.getCompanyOrg().getId().toString());
        if (!this.ruleStatus.isExist() || this.ruleStatus.isModifiable()) {
            this.txtNumber.setEnabled(true);
        } else {
            this.txtNumber.setEnabled(false);
        }
        if (!StringUtils.isEmpty((String)this.editData.getNumber())) {
            return;
        }
        if (!this.ruleStatus.isExist()) {
            return;
        }
        if (this.editData.getCU() == null) {
            this.editData.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        }
        if (this.ruleStatus.isAddView() || this.ruleStatus.isAddNoBreak()) {
            String orgId = SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"Company")).getId().toString();
            if (StringUtils.isEmpty((String)orgId)) {
                orgId = "00000000-0000-0000-0000-000000000000CCE7AED4";
            }
            String number = "";
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            if (this.ruleStatus.isAddNoBreak()) {
                number = iCodingRuleManager.readNumber((IObjectValue)this.editData, orgId);
            } else if (this.ruleStatus.isAddView()) {
                number = iCodingRuleManager.getNumber((IObjectValue)this.editData, orgId);
            }
            if (!StringUtils.isEmpty((String)number)) {
                this.editData.setNumber(number);
                this.txtNumber.setText(number);
            }
        }
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    @Override
    protected void isStart() throws Exception {
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        if (this.txtNumber.getText() == null || "".equals(this.txtNumber.getText().trim())) {
            MsgBox.showInfo((String)"\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            SysUtil.abort();
        }
        if (this.prmtCompanyOrg.getValue() == null) {
            MsgBox.showInfo((String)"\u8d22\u52a1\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            SysUtil.abort();
        }
        if (this.prmtOrder.getValue() == null) {
            MsgBox.showInfo((String)"\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            SysUtil.abort();
        }
        if (this.txtBopWIPQty.getBigDecimalValue() != null && this.txtBopWIPQty.getBigDecimalValue().compareTo(SysConstant.BIGZERO) <= 0) {
            MsgBox.showInfo((String)"\u671f\u521d\u5728\u5236\u54c1\u4ea7\u91cf\u5fc5\u987b\u5927\u4e8e0\u3002");
            SysUtil.abort();
        }
        if (this.txtFinishedQty.getBigDecimalValue() != null && this.txtFinishedQty.getBigDecimalValue().compareTo(SysConstant.BIGZERO) <= 0) {
            MsgBox.showInfo((String)"\u8ba2\u5355\u7d2f\u8ba1\u5b8c\u5de5\u4ea7\u91cf\u5fc5\u987b\u5927\u4e8e0\u3002");
            SysUtil.abort();
        }
        this.checkMaterial();
        this.checkActivity();
    }

    private void checkMaterial() {
        for (int i = 0; i < this.kdtMaterial.getRowCount(); ++i) {
            IRow row = this.kdtMaterial.getRow(i);
            if (row.getCell("costCenter.number").getValue() == null) {
                MsgBox.showInfo((String)"\u6750\u6599\u5728\u5236\u9875\u7b7e\u6210\u672c\u4e2d\u5fc3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                SysUtil.abort();
            }
            if (row.getCell("costItem.number").getValue() != null) continue;
            MsgBox.showInfo((String)"\u6750\u6599\u5728\u5236\u9875\u7b7e\u6210\u672c\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            SysUtil.abort();
        }
    }

    private void checkActivity() {
        for (int i = 0; i < this.kdtActivity.getRowCount(); ++i) {
            IRow row = this.kdtActivity.getRow(i);
            if (row.getCell("costCenter.number").getValue() == null) {
                MsgBox.showInfo((String)"\u4f5c\u4e1a\u5728\u5236\u9875\u7b7e\u6210\u672c\u4e2d\u5fc3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                SysUtil.abort();
            }
            if (row.getCell("activity.number").getValue() != null) continue;
            MsgBox.showInfo((String)"\u4f5c\u4e1a\u5728\u5236\u9875\u7b7e\u4f5c\u4e1a\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            SysUtil.abort();
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        this.checkData();
    }

    private void checkData() throws Exception {
        InitOrderInfo info = this.editData;
        InitOrderMaterialCollection materialColl = info.getMaterial();
        InitOrderActivityCollection activityColl = info.getActivity();
        if (materialColl.size() <= 0 && activityColl.size() <= 0) {
            throw new InitOrderException(InitOrderException.TEXT, new Object[]{"\u6750\u6599\u5728\u5236\u548c\u4f5c\u4e1a\u5728\u5236\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002"});
        }
        InitOrderMaterialInfo materialInfo = null;
        InitOrderMaterialEntryCollection matEntryColl = null;
        InitOrderMaterialEntryInfo matEntryInfo = null;
        for (int i = 0; i < materialColl.size(); ++i) {
            materialInfo = materialColl.get(i);
            matEntryColl = materialInfo.getDetailEntry();
            if (matEntryColl.size() <= 0) {
                throw new InitOrderException(InitOrderException.MATENTRY_NOTNULL, new Object[]{materialInfo.getCostCenter().getNumber(), materialInfo.getCostItem().getNumber()});
            }
            for (int j = 0; j < matEntryColl.size(); ++j) {
                matEntryInfo = matEntryColl.get(j);
                if (matEntryInfo.getMaterial() == null) {
                    throw new InitOrderException(InitOrderException.MATENTRY_MAT_NOTNULL, new Object[]{materialInfo.getCostCenter().getNumber(), materialInfo.getCostItem().getNumber(), "\u7269\u6599\u7f16\u7801"});
                }
                if (matEntryInfo.getQty() == null) {
                    throw new InitOrderException(InitOrderException.MATENTRY_MAT_NOTNULL, new Object[]{materialInfo.getCostCenter().getNumber(), materialInfo.getCostItem().getNumber(), "\u6570\u91cf"});
                }
                if (matEntryInfo.getPrice() == null) {
                    throw new InitOrderException(InitOrderException.MATENTRY_MAT_NOTNULL, new Object[]{materialInfo.getCostCenter().getNumber(), materialInfo.getCostItem().getNumber(), "\u5355\u4ef7"});
                }
                if (matEntryInfo.getQty() != null) continue;
                throw new InitOrderException(InitOrderException.MATENTRY_MAT_NOTNULL, new Object[]{materialInfo.getCostCenter().getNumber(), materialInfo.getCostItem().getNumber(), "\u91d1\u989d"});
            }
        }
        InitOrderActivityInfo activityInfo = null;
        InitOrderActivityEntryCollection actEntryColl = null;
        InitOrderActivityEntryInfo actEntryInfo = null;
        for (int k = 0; k < activityColl.size(); ++k) {
            activityInfo = activityColl.get(k);
            if (activityInfo.getBcToUnewhQty() == null) {
                MsgBox.showInfo((String)"\u671f\u521d\u7d2f\u8ba1\u8f6c\u51fa\u672a\u5165\u5e93\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                SysUtil.abort();
            }
            if (activityInfo.getBcToUnewhQty().compareTo(SysConstant.BIGZERO) < 0) {
                MsgBox.showInfo((String)"\u671f\u521d\u7d2f\u8ba1\u8f6c\u51fa\u672a\u5165\u5e93\u6570\u91cf\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0\u3002");
                SysUtil.abort();
            }
            BigDecimal baseQty = null;
            if (this.txtBaseQty.getText() != null) {
                baseQty = new BigDecimal(this.txtBaseQty.getText().toString());
            }
            if (this.txtBaseQty.getText() != null && activityInfo.getBcToUnewhQty().compareTo(baseQty) > 0) {
                MsgBox.showInfo((String)"\u671f\u521d\u7d2f\u8ba1\u8f6c\u51fa\u672a\u5165\u5e93\u6570\u91cf\u5fc5\u987b\u5c0f\u4e8e\u6216\u7b49\u4e8e\u8ba1\u5212\u4ea7\u91cf\u3002");
                SysUtil.abort();
            }
            if (activityInfo.getBUntoQty() == null) {
                MsgBox.showInfo((String)"\u671f\u521d\u672a\u8f6c\u51fa\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                SysUtil.abort();
            }
            if (activityInfo.getBUntoQty().compareTo(SysConstant.BIGZERO) < 0) {
                MsgBox.showInfo((String)"\u671f\u521d\u672a\u8f6c\u51fa\u6570\u91cf\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0\u3002");
                SysUtil.abort();
            }
            if (this.txtBaseQty.getText() != null && activityInfo.getBUntoQty().compareTo(baseQty) > 0) {
                MsgBox.showInfo((String)"\u671f\u521d\u672a\u8f6c\u51fa\u6570\u91cf\u5fc5\u987b\u5c0f\u4e8e\u6216\u7b49\u4e8e\u8ba1\u5212\u4ea7\u91cf\u3002");
                SysUtil.abort();
            }
            if ((actEntryColl = activityInfo.getDetailEntry()).size() <= 0) {
                throw new InitOrderException(InitOrderException.ACTENTRY_NOTNULL, new Object[]{activityInfo.getCostCenter().getNumber(), activityInfo.getActivity().getNumber()});
            }
            for (int m = 0; m < actEntryColl.size(); ++m) {
                actEntryInfo = actEntryColl.get(m);
                if (actEntryInfo.getCostItem() == null) {
                    throw new InitOrderException(InitOrderException.ACTENTRY_COSTITEM_NOTNULL, new Object[]{activityInfo.getCostCenter().getNumber(), activityInfo.getActivity().getNumber(), "\u6210\u672c\u9879\u76ee\u7f16\u7801"});
                }
                if (actEntryInfo.getBopQty() != null && actEntryInfo.getBopQty().compareTo(SysConstant.BIGZERO) <= 0) {
                    MsgBox.showInfo((String)"\u671f\u521d\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0\u3002");
                    SysUtil.abort();
                }
                if (actEntryInfo.getBopAmount() == null) {
                    throw new InitOrderException(InitOrderException.ACTENTRY_COSTITEM_NOTNULL, new Object[]{activityInfo.getCostCenter().getNumber(), activityInfo.getActivity().getNumber(), "\u671f\u521d\u6210\u672c"});
                }
                if (actEntryInfo.getBopAmount().compareTo(SysConstant.BIGZERO) <= 0) {
                    MsgBox.showInfo((String)"\u671f\u521d\u6210\u672c\u5fc5\u987b\u5927\u4e8e0\u3002");
                    SysUtil.abort();
                }
                if (actEntryInfo.getInputQty() != null && actEntryInfo.getInputQty().compareTo(SysConstant.BIGZERO) <= 0) {
                    MsgBox.showInfo((String)"\u7d2f\u8ba1\u6295\u5165\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0\u3002");
                    SysUtil.abort();
                }
                if (actEntryInfo.getInputAmount() == null || actEntryInfo.getInputAmount().compareTo(SysConstant.BIGZERO) > 0) continue;
                MsgBox.showInfo((String)"\u7d2f\u8ba1\u6295\u5165\u6210\u672c\u5fc5\u987b\u5927\u4e8e0\u3002");
                SysUtil.abort();
            }
        }
    }

    protected void checkValidDataForSubmit() throws Exception {
        IRow row;
        int i;
        if (this.kdtMaterial.getRowCount() <= 0 && this.kdtActivity.getRowCount() <= 0) {
            throw new InitOrderException(InitOrderException.TEXT, new Object[]{"\u6750\u6599\u5728\u5236\u548c\u4f5c\u4e1a\u5728\u5236\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002"});
        }
        BigDecimal amountRow = SysConstant.BIGZERO;
        BigDecimal amountTotal = SysConstant.BIGZERO;
        for (i = 0; i < this.kdtMaterial.getRowCount(); ++i) {
            row = this.kdtMaterial.getRow(i);
            amountRow = BDCMClientUtils.castToBigDecimal((KDTable)this.kdtMaterial, (int)row.getRowIndex(), (String)"bopAmount");
            amountTotal = amountTotal.add(amountRow);
        }
        for (i = 0; i < this.kdtActivity.getRowCount(); ++i) {
            row = this.kdtActivity.getRow(i);
            amountRow = BDCMClientUtils.castToBigDecimal((KDTable)this.kdtActivity, (int)row.getRowIndex(), (String)"bopAmount");
            amountTotal = amountTotal.add(amountRow);
        }
        if (BDCMUtils.equalsZero((BigDecimal)amountTotal)) {
            MsgBox.showInfo((String)"\u603b\u5408\u8ba1\u671f\u521d\u6210\u672c\u9700\u5927\u4e8e0\u3002");
            SysUtil.abort();
        }
        HashSet<String> activitySet = new HashSet<String>();
        for (int i2 = 0; i2 < this.kdtActivity.getRowCount(); ++i2) {
            IRow row2 = this.kdtActivity.getRow(i2);
            if (row2.getCell("activity.number").getValue() == null || !(row2.getCell("activity.number").getValue() instanceof ActivityInfo)) continue;
            ActivityInfo activityInfo = (ActivityInfo)row2.getCell("activity.number").getValue();
            if (!activitySet.contains(activityInfo.getNumber())) {
                activitySet.add(activityInfo.getNumber());
                continue;
            }
            MsgBox.showInfo((String)("\u4f5c\u4e1a " + activityInfo.getNumber() + " \u91cd\u590d\uff0c\u4e0d\u80fd\u63d0\u4ea4\uff01"));
            SysUtil.abort();
        }
    }
}

