/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ncm.common.utils.NCMConst;
import com.kingdee.eas.ncm.order.fact.alloc.OCAllocFacadeFactory;
import com.kingdee.eas.ncm.order.fact.bill.client.AbstractOrderCCActivityAllocEditUI;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import java.awt.Color;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class OrderCCActivityAllocEditUI
extends AbstractOrderCCActivityAllocEditUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(OrderCCActivityAllocEditUI.class);
    private static final String Col_Qty = "qty";
    private static final String Col_Price = "price";
    private static final String Col_Amount = "amount";
    private int qtyPrecision = 0;
    private int pricePrecision = 0;
    private int amountPrecision = 0;
    private Map _parentParam = null;
    private CompanyOrgUnitInfo _company = null;
    private String _periodId = null;
    private String _sourceBillId = null;
    private String _sourceBillEntryId = null;
    private String costItemName = null;
    private String departmentName = null;
    private tblMainIterator _iterator;
    private String _operType = null;
    private IRowSet _Data = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public static void showAllocEditUI(CoreUIObject ui, Map param, String operType, KDTable tblMain) throws Exception {
        Assert.that((boolean)param.containsKey("company"));
        Assert.that((boolean)param.containsKey("periodId"));
        Assert.that((tblMain != null ? 1 : 0) != 0);
        Assert.that((boolean)operType.equals("VIEW"));
        try {
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put((Object)"param", (Object)param);
            uiContext.put((Object)"operType", (Object)operType);
            uiContext.put((Object)"tblMain", (Object)tblMain);
            uiContext.put((Object)"parentUI", (Object)ui);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(OrderCCActivityAllocEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
        }
        catch (BOSException e) {
            logger.error((Object)"showAllocEditUI", (Throwable)e);
            SysUtil.abort((Throwable)e);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this._parentParam = (Map)this.getUIContext().get("param");
        this._operType = (String)this.getUIContext().get("operType");
        KDTable tbl = (KDTable)this.getUIContext().get("tblMain");
        this._iterator = new tblMainIterator(tbl);
        this._company = (CompanyOrgUnitInfo)this._parentParam.get("company");
        this._periodId = (String)this._parentParam.get("periodId");
        this.formatControls();
        this.fillData();
    }

    public void onShow() throws Exception {
        super.onShow();
        Window win = SwingUtilities.getWindowAncestor((JComponent)this.uiWindow.getUIObject());
        if (win instanceof UINewFrame) {
            ((UINewFrame)win).setExtendedState(6);
        }
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.btnPrintView.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnFirst.setIcon(EASResource.getIcon((String)"imgTbtn_first"));
        this.btnPre.setIcon(EASResource.getIcon((String)"imgTbtn_previous"));
        this.btnNext.setIcon(EASResource.getIcon((String)"imgTbtn_next"));
        this.btnLast.setIcon(EASResource.getIcon((String)"imgTbtn_last"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
    }

    private void formatControls() {
        this.tableMain.checkParsed();
        this.txtQty.setHorizontalAlignment(4);
        this.txtAmount.setHorizontalAlignment(4);
        this.tableMain.getColumn(Col_Qty).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tableMain.getColumn(Col_Price).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tableMain.getColumn(Col_Amount).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    @Override
    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        this._iterator.First();
        this.fillData();
    }

    @Override
    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        this._iterator.Pre();
        this.fillData();
    }

    @Override
    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        this._iterator.Next();
        this.fillData();
    }

    @Override
    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        this._iterator.Last();
        this.fillData();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.fillData();
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tableMain);
        this.tableMain.getPrintManager().print();
    }

    @Override
    public void actionPrintView_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tableMain);
        this.tableMain.getPrintManager().printPreview();
    }

    private void fillData() throws BOSException, EASBizException, SQLException {
        IRow row = this._iterator.CurrentRow();
        if (row == null) {
            return;
        }
        this.qtyPrecision = (Integer)row.getCell("unit.qtyPrecision").getValue();
        this.txtQty.setPrecision(this.qtyPrecision);
        this.tableMain.getColumn(Col_Qty).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)this.qtyPrecision));
        this.pricePrecision = (Integer)row.getCell("expense.pricePrecision").getValue();
        this.tableMain.getColumn(Col_Price).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)this.pricePrecision));
        this.amountPrecision = (Integer)row.getCell("baseCurrency.precision").getValue();
        this.txtAmount.setPrecision(this.amountPrecision);
        this.tableMain.getColumn(Col_Amount).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)this.amountPrecision));
        this.txtNumber.setText((String)row.getCell("number").getValue());
        this.txtEntrySeq.setText(String.valueOf(row.getCell("entries.seq").getValue()));
        this.txtCompany.setText(this._company.getName());
        this.txtCostCenter.setText((String)row.getCell("costCenter.name").getValue());
        this.txtExpense.setText((String)row.getCell("expense.name").getValue());
        this.costItemName = (String)row.getCell("costItem.name").getValue();
        this.txtCostItem.setText(this.costItemName);
        this.txtActivity.setText((String)row.getCell("activity.name").getValue());
        this.departmentName = (String)row.getCell("department.name").getValue();
        this.prmtDepartment.setText(this.departmentName);
        this.txtUnit.setText((String)row.getCell("unit.name").getValue());
        this.txtManufacturerOrder.setText((String)row.getCell("manufacturerOrder.number").getValue());
        this.txtDescription.setText((String)row.getCell("entries.remark").getValue());
        if (row.getCell("entries.qty").getValue() == null) {
            this.txtQty.setText("0");
        } else {
            this.txtQty.setText(row.getCell("entries.qty").getValue().toString());
        }
        if (row.getCell("entries.amount").getValue() == null) {
            this.txtAmount.setText("0");
        } else {
            this.txtAmount.setText(row.getCell("entries.amount").getValue().toString());
        }
        this._sourceBillId = (String)row.getCell("id").getValue();
        this._sourceBillEntryId = (String)row.getCell("entries.id").getValue();
        this._Data = this.GetAdjustData();
        this.initKDTable();
    }

    private void initKDTable() throws BOSException, EASBizException, SQLException {
        boolean flag = false;
        if (this._Data != null) {
            IRow row;
            this.tableMain.removeRows();
            BigDecimal activityTotalQty = BigDecimal.valueOf(0L);
            BigDecimal activityTotalAmount = BigDecimal.valueOf(0L);
            BigDecimal totalQty = BigDecimal.valueOf(0L);
            BigDecimal totalAmount = BigDecimal.valueOf(0L);
            String lastActivityNumber = null;
            BigDecimal lastactivityDriverAmount = null;
            this._Data.first();
            while (this._Data.getRow() > 0 && !this._Data.isAfterLast()) {
                flag = true;
                String currentActivityNumber = null;
                currentActivityNumber = this._Data.getString("FActivityNumber");
                if (currentActivityNumber != null && lastActivityNumber != null && !currentActivityNumber.equals(lastActivityNumber)) {
                    IRow activityTotalRow = this.tableMain.addRow();
                    activityTotalRow.getCell("activityName").setValue((Object)"\u5c0f\u8ba1");
                    activityTotalRow.getCell("activityDriver").setValue(lastactivityDriverAmount);
                    activityTotalRow.getCell(Col_Qty).setValue((Object)activityTotalQty);
                    activityTotalRow.getCell(Col_Amount).setValue((Object)activityTotalAmount);
                    activityTotalRow.getStyleAttributes().setBackground(new Color(255, 248, 220));
                    activityTotalRow.getStyleAttributes().setLocked(true);
                    activityTotalQty = BigDecimal.valueOf(0L);
                    activityTotalAmount = BigDecimal.valueOf(0L);
                }
                row = this.tableMain.addRow();
                row.getCell("activityNumber").setValue((Object)currentActivityNumber);
                row.getCell("activityName").setValue((Object)this._Data.getString("FActivityName"));
                row.getCell("manufacturerOrder").setValue((Object)this._Data.getString("FOrderNumber"));
                row.getCell("storageOrgUnit").setValue((Object)this._Data.getString("FStorageName"));
                row.getCell("material").setValue((Object)this._Data.getString("FMaterialName"));
                row.getCell("batchNo").setValue((Object)this._Data.getString("Flot"));
                row.getCell("orderDriver").setValue((Object)this._Data.getBigDecimal("FActivityDriverAmount"));
                this.txtCostCenterDriver.setText(this._Data.getString("FCostCenterDriverName"));
                this.txtActivityDriver.setText(this._Data.getString("FActivityDriverName"));
                if (this._Data.getBigDecimal("forderqty") == null) {
                    row.getCell(Col_Qty).setValue((Object)NCMConst.ZERO);
                } else {
                    row.getCell(Col_Qty).setValue((Object)this._Data.getBigDecimal("forderqty"));
                    activityTotalQty = activityTotalQty.add(this._Data.getBigDecimal("forderqty"));
                    totalQty = totalQty.add(this._Data.getBigDecimal("forderqty"));
                }
                row.getCell(Col_Price).setValue((Object)this._Data.getBigDecimal("FPrice"));
                if (this._Data.getBigDecimal("FAmount") == null) {
                    row.getCell(Col_Amount).setValue((Object)NCMConst.ZERO);
                } else {
                    row.getCell(Col_Amount).setValue((Object)this._Data.getBigDecimal("FAmount"));
                    activityTotalAmount = activityTotalAmount.add(this._Data.getBigDecimal("FAmount"));
                    totalAmount = totalAmount.add(this._Data.getBigDecimal("FAmount"));
                }
                row.getCell("costItem").setValue((Object)this.costItemName);
                row.getCell("department").setValue((Object)this.departmentName);
                lastActivityNumber = currentActivityNumber;
                lastactivityDriverAmount = this._Data.getBigDecimal("FCostCenterDriverAmount");
                this._Data.next();
            }
            if (flag) {
                IRow activityTotalRow = this.tableMain.addRow();
                activityTotalRow.getCell("activityName").setValue((Object)"\u5c0f\u8ba1");
                activityTotalRow.getCell("activityDriver").setValue(lastactivityDriverAmount);
                activityTotalRow.getCell(Col_Qty).setValue((Object)activityTotalQty);
                activityTotalRow.getCell(Col_Amount).setValue((Object)activityTotalAmount);
                activityTotalRow.getStyleAttributes().setBackground(new Color(255, 248, 220));
                activityTotalRow.getStyleAttributes().setLocked(true);
                row = this.tableMain.addRow();
                row.getCell("activityNumber").setValue((Object)"\u5408\u8ba1");
                row.getCell(Col_Amount).setValue((Object)totalAmount);
                row.getCell(Col_Qty).setValue((Object)totalQty);
                row.getStyleAttributes().setBackground(new Color(240, 230, 140));
                row.getStyleAttributes().setLocked(true);
            }
        }
    }

    private IRowSet GetAdjustData() throws BOSException {
        boolean forAdjust = this._operType.equals("ADJUST");
        return OCAllocFacadeFactory.getRemoteInstance().getCC2ActivityAdjustData(this._company.getId().toString(), this._periodId, this._sourceBillId, this._sourceBillEntryId, forAdjust);
    }

    private class tblMainIterator {
        private KDTable _tblMain;
        private int _currentRowIndex = -1;

        public tblMainIterator(KDTable tblMain) {
            this._tblMain = tblMain;
            this._currentRowIndex = this._tblMain.getSelectManager().getActiveRowIndex();
            if (this._currentRowIndex == 0) {
                OrderCCActivityAllocEditUI.this.actionFirst.setEnabled(false);
                OrderCCActivityAllocEditUI.this.actionPre.setEnabled(false);
            }
            if (this._currentRowIndex + 1 == this._tblMain.getRowCount()) {
                OrderCCActivityAllocEditUI.this.actionNext.setEnabled(false);
                OrderCCActivityAllocEditUI.this.actionLast.setEnabled(false);
            }
        }

        public void First() {
            this._currentRowIndex = 0;
            OrderCCActivityAllocEditUI.this.actionFirst.setEnabled(false);
            OrderCCActivityAllocEditUI.this.actionPre.setEnabled(false);
            OrderCCActivityAllocEditUI.this.actionNext.setEnabled(true);
            OrderCCActivityAllocEditUI.this.actionLast.setEnabled(true);
        }

        public void Pre() {
            --this._currentRowIndex;
            if (!this.IsFirst()) {
                OrderCCActivityAllocEditUI.this.actionFirst.setEnabled(true);
                OrderCCActivityAllocEditUI.this.actionPre.setEnabled(true);
                OrderCCActivityAllocEditUI.this.actionNext.setEnabled(true);
                OrderCCActivityAllocEditUI.this.actionLast.setEnabled(true);
            } else {
                OrderCCActivityAllocEditUI.this.actionFirst.setEnabled(false);
                OrderCCActivityAllocEditUI.this.actionPre.setEnabled(false);
                OrderCCActivityAllocEditUI.this.actionNext.setEnabled(true);
                OrderCCActivityAllocEditUI.this.actionLast.setEnabled(true);
            }
        }

        public void Next() {
            ++this._currentRowIndex;
            if (!this.IsLast()) {
                OrderCCActivityAllocEditUI.this.actionFirst.setEnabled(true);
                OrderCCActivityAllocEditUI.this.actionPre.setEnabled(true);
                OrderCCActivityAllocEditUI.this.actionNext.setEnabled(true);
                OrderCCActivityAllocEditUI.this.actionLast.setEnabled(true);
            } else {
                OrderCCActivityAllocEditUI.this.actionFirst.setEnabled(true);
                OrderCCActivityAllocEditUI.this.actionPre.setEnabled(true);
                OrderCCActivityAllocEditUI.this.actionNext.setEnabled(false);
                OrderCCActivityAllocEditUI.this.actionLast.setEnabled(false);
            }
        }

        public void Last() {
            this._currentRowIndex = this._tblMain.getRowCount() - 1;
            OrderCCActivityAllocEditUI.this.actionFirst.setEnabled(true);
            OrderCCActivityAllocEditUI.this.actionPre.setEnabled(true);
            OrderCCActivityAllocEditUI.this.actionNext.setEnabled(false);
            OrderCCActivityAllocEditUI.this.actionLast.setEnabled(false);
        }

        public boolean IsFirst() {
            return this._currentRowIndex == 0;
        }

        public boolean IsLast() {
            return this._tblMain.getRowCount() == this._currentRowIndex + 1;
        }

        public IRow CurrentRow() {
            return this._tblMain.getRow(this._currentRowIndex);
        }
    }
}

