/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ncm.bill.AllocTypeEnum;
import com.kingdee.eas.ncm.bill.client.FeeAllocClientUtils;
import com.kingdee.eas.ncm.common.AllocSourceBillEnum;
import com.kingdee.eas.ncm.common.BillBaseStatusEnum;
import com.kingdee.eas.ncm.common.progress.client.ProgressHintListener;
import com.kingdee.eas.ncm.common.progress.client.ProgressHintUI;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMCommonQueryProcessor;
import com.kingdee.eas.ncm.order.common.utils.OrderCMUtils;
import com.kingdee.eas.ncm.order.fact.alloc.AllocateException;
import com.kingdee.eas.ncm.order.fact.alloc.OCAllocFacadeFactory;
import com.kingdee.eas.ncm.order.fact.bill.OrderCCFeeBillFactory;
import com.kingdee.eas.ncm.order.fact.bill.client.AbstractOrderCCActivityAllocListUI;
import com.kingdee.eas.ncm.order.fact.bill.client.OrderCCActivityAllocEditUI;
import com.kingdee.eas.ncm.order.fact.bill.client.OrderFeeAllocLogReportUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class OrderCCActivityAllocListUI
extends AbstractOrderCCActivityAllocListUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(OrderCCActivityAllocListUI.class);
    private CompanyOrgUnitInfo _company = null;
    private PeriodInfo _period = null;
    private UserInfo userInfo = null;
    private CommonQueryDialog dialog = null;
    private FilterInfo _currFilterInfo = null;

    public OrderCCActivityAllocListUI() throws Exception {
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int firstRowIndex = e.getFirstRow();
                int lastRowIndex = e.getLastRow();
                IRow row = null;
                int precision = 0;
                for (int i = firstRowIndex; i <= lastRowIndex; ++i) {
                    row = OrderCCActivityAllocListUI.this.tblMain.getRow(i);
                    if (row.getCell("entries.amount") != null && row.getCell("entries.amount").getValue() != null) {
                        precision = ((BigDecimal)row.getCell("entries.amount").getValue()).scale();
                        NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell("entries.amount"), (int)precision);
                    }
                    if (row.getCell("entries.qty") != null && row.getCell("entries.qty").getValue() != null) {
                        precision = ((BigDecimal)row.getCell("entries.qty").getValue()).scale();
                        NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell("entries.qty"), (int)precision);
                    }
                    if (row.getCell("entries.price") == null || row.getCell("entries.price").getValue() == null) continue;
                    precision = ((BigDecimal)row.getCell("entries.price").getValue()).scale();
                    NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell("entries.price"), (int)precision);
                }
            }
        });
    }

    public void onLoad() throws Exception {
        this._company = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(OrgType.Company);
        this._period = OrderCMUtils.getCurrentPeriod(this._company.getId().toString());
        this.userInfo = SysContext.getSysContext().getCurrentUserInfo();
        super.onLoad();
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.menuBiz.setVisible(true);
        this.menuViewAllocReuslt.setEnabled(true);
        this.menuViewLog.setEnabled(true);
        this.btnSubmit.setVisible(false);
        this.btnManualAdjust.setVisible(false);
        this.btnViewAllocResult.setEnabled(true);
        this.btnViewLog.setEnabled(true);
        this.setButtonEnable();
    }

    private void setButtonEnable() {
        boolean flag = false;
        if (this.tblMain.getRowCount() > 0) {
            flag = true;
        }
        this.btnAutoAlloc.setEnabled(flag);
        this.btnViewAllocResult.setEnabled(flag);
        this.btnViewLog.setEnabled(flag);
        this.menuAutoAlloc.setEnabled(flag);
        this.menuViewAllocReuslt.setEnabled(flag);
        this.menuViewLog.setEnabled(flag);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.setButtonEnable();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.setButtonEnable();
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        try {
            while (rowSet.next()) {
                int precision = rowSet.getInt("baseCurrency.precision");
                BDCMUtils.iniColumnsPrecision((int)precision, (String)"entries.amount", (IRowSet)rowSet);
                precision = rowSet.getInt("unit.qtyPrecision");
                BDCMUtils.iniColumnsPrecision((int)precision, (String)"entries.qty", (IRowSet)rowSet);
                precision = rowSet.getInt("expense.pricePrecision");
                BDCMUtils.iniColumnsPrecision((int)precision, (String)"entries.price", (IRowSet)rowSet);
            }
        }
        catch (SQLException ex) {
            this.handUIException(ex);
        }
    }

    public String[] getMergeColumnKeys() {
        return new String[]{"number", "billStatus", "bizDate", "calculatePeriod.number", "companyOrg.name", "costCenter.number", "costCenter.name", "description", "expense.number", "expense.name", "department.number", "department.name", "fivouchered", "voucher", "unit.name"};
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return OrderCCFeeBillFactory.getRemoteInstance();
    }

    protected boolean isFootVisible() {
        return true;
    }

    @Override
    public void actionManualAdjust_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionAuotAlloc_actionPerformed(ActionEvent e) throws Exception {
        super.actionAuotAlloc_actionPerformed(e);
        if (!FeeAllocClientUtils.showCalHintBeforeFeeAlloc((CompanyOrgUnitInfo)this._company, (PeriodInfo)this._period)) {
            return;
        }
        this.checkISAlloced(this._company.getId().toString(), this._period.getId().toString(), this._currFilterInfo);
        String taskClazzName = "com.kingdee.eas.ncm.order.fact.alloc.app.task.OCCC2ActivityAllocTask";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("task.support.interrupt", Boolean.TRUE);
        param.put("task.show.time", Boolean.TRUE);
        param.put("filterInfo", this._currFilterInfo);
        param.put("companyId", this._company.getId().toString());
        param.put("periodId", this._period.getId().toString());
        param.put("userId", this.userInfo.getId().toString());
        param.put("allocType", AllocTypeEnum.AUTO);
        param.put("isForAllocate", "true");
        param.put("task.listener", new ProgressHintListener(){

            public void afterTaskExecute(Map param, List userObjects) throws Exception {
                NCMClientUtils.releaseMutex((CoreUI)OrderCCActivityAllocListUI.this, (String)OrderCCActivityAllocListUI.this._company.getId().toString());
            }

            public void beforeTaskExecute(Map param) throws Exception {
                NCMClientUtils.requestMutex((CoreUI)OrderCCActivityAllocListUI.this, (String)OrderCCActivityAllocListUI.this._company.getId().toString());
            }
        });
        param.put("allocSourceBill", AllocSourceBillEnum.OrderCCFeeBill);
        try {
            ProgressHintUI hintUI = ProgressHintUI.showProgressHintUI((Component)((Object)this), (String)taskClazzName, param);
            List userObjects = hintUI.getUserObjects();
            if (userObjects.size() > 0 && userObjects.get(0) instanceof String) {
                final String success = (String)userObjects.get(0);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if ("activityAlloc_error".equals(success)) {
                            OrderCCActivityAllocListUI.this.btnViewLog.doClick();
                        }
                    }
                });
            }
        }
        catch (AllocateException ex) {
            MsgBox.showInfo((String)ex.getMessage());
        }
    }

    @Override
    public void actionViewAllocReuslt_actionPerformed(ActionEvent e) throws Exception {
        this.showAllocEditUI("VIEW");
    }

    @Override
    public void actionViewLog_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("companyId", this._company.getId().toString());
        param.put("periodId", this._period.getId().toString());
        param.put("companyName", this._company.getName().toString());
        param.put("periodNumber", String.valueOf(this._period.getNumber()));
        param.put("feeType", "activityFee");
        param.put("UITitle", "\u6210\u672c\u4e2d\u5fc3\u4f5c\u4e1a\u8d39\u7528\u5206\u914d-\u9519\u8bef\u62a5\u544a");
        OrderFeeAllocLogReportUI.showAllocReportUI((CoreUIObject)this, param);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.actionViewAllocReuslt_actionPerformed(e);
    }

    private void showAllocEditUI(String operType) throws Exception {
        this.checkSelected();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("company", this._company);
        param.put("periodId", this._period.getId().toString());
        param.put("companyName", this._company.getName().toString());
        param.put("periodNumber", String.valueOf(this._period.getNumber()));
        OrderCCActivityAllocEditUI.showAllocEditUI((CoreUIObject)this, param, operType, this.tblMain);
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        super.beforeExcutQuery(ev);
        try {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("calculatePeriod.id", (Object)this._period.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)new Integer(4), CompareType.EQUALS));
            ev.getFilter().mergeFilter(filter, "and");
            this._currFilterInfo = (FilterInfo)ev.getFilter().clone();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    @Override
    protected void isStart() throws Exception {
        CompanyOrgUnitInfo companyInfo = SysContext.getSysContext().getCurrentFIUnit();
        if (companyInfo != null) {
            OrderCMUtils.checkStart(companyInfo.getId().toString());
        }
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog == null) {
            this.dialog = super.initCommonQueryDialog();
        }
        OrderCCAllocQueryProcessor cmcq = new OrderCCAllocQueryProcessor();
        cmcq.set("companyOrg", SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        cmcq.set("query", "orderCCFeeBillQuery");
        this.dialog.setProcessor((IProcessor)cmcq);
        return this.dialog;
    }

    private void checkISAlloced(String companyID, String periodID, FilterInfo filter) {
        try {
            int opr;
            boolean result = false;
            result = OCAllocFacadeFactory.getRemoteInstance().checkActivityFeeIsAlloced(companyID, periodID, filter);
            if (result && (opr = MsgBox.showConfirm2((String)"\u5f53\u524d\u5f85\u5904\u7406\u7684\u6210\u672c\u4e2d\u5fc3\u4f5c\u4e1a\u8d39\u7528\u5f52\u96c6\u5355\u636e\u5df2\u7ecf\u5b58\u5728\u5206\u914d\u7ed3\u679c\uff0c\u9009\u62e9\u786e\u5b9a\u5c06\u5220\u9664\u539f\u5206\u914d\u7ed3\u679c\u91cd\u65b0\u5206\u914d\u3002")) == 2) {
                SysUtil.abort();
            }
        }
        catch (BOSException ex) {
            logger.error((Object)"checkISAlloced", (Throwable)ex);
        }
    }

    private static class OrderCCAllocQueryProcessor
    extends NCMCommonQueryProcessor {
        private OrderCCAllocQueryProcessor() {
        }

        public void process() throws Exception {
            super.process();
            Object editor = this.get("CURRENT_EDITOR");
            String fieldProperty = (String)this.get("CURRENT_FIELD_PROP");
            if (editor instanceof KDComboBox && "billStatus".equals(fieldProperty)) {
                KDComboBox kdBox = (KDComboBox)editor;
                kdBox.removeItem((Object)BillBaseStatusEnum.ADD);
                kdBox.removeItem((Object)BillBaseStatusEnum.SUBMITED);
                kdBox.removeItem((Object)BillBaseStatusEnum.TEMPORARILYSAVED);
            }
        }
    }
}

