/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.ncm.ActivityInfo;
import com.kingdee.eas.basedata.ncm.ExpenseInfo;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.ncm.common.ICMBillBase;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.order.common.utils.OrderCMUtils;
import com.kingdee.eas.ncm.order.fact.bill.OrderCCFeeBillEntryInfo;
import com.kingdee.eas.ncm.order.fact.bill.OrderCCFeeBillFactory;
import com.kingdee.eas.ncm.order.fact.bill.OrderCCFeeBillInfo;
import com.kingdee.eas.ncm.order.fact.bill.client.AbstractOrderCCFeeBillEditUI;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.EventListener;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class OrderCCFeeBillEditUI
extends AbstractOrderCCFeeBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(OrderCCFeeBillEditUI.class);

    @Override
    public void loadFields() {
        EventListener[] prmtCompanyListners = this.prmtExpense.getListeners(DataChangeListener.class);
        BDCMClientUtils.removeDataChangeListeners((JComponent)this.prmtExpense);
        super.loadFields();
        BDCMClientUtils.addDataChangeListeners((JComponent)this.prmtExpense, (EventListener[])prmtCompanyListners);
        String companyOrgID = null;
        if (this.prmtCompanyOrg.getData() != null) {
            CompanyOrgUnitInfo comOrg = (CompanyOrgUnitInfo)this.prmtCompanyOrg.getData();
            companyOrgID = comOrg.getId().toString();
            try {
                BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)this.prmtCostCenter, (String)companyOrgID);
                CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(comOrg.getBaseCurrency().getId()));
                NCMClientUtils.changeTableColPrecisionByCurrency((CurrencyInfo)currency, (KDTable)this.kdtEntries, (String[])new String[]{"amount"});
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        try {
            BDCMClientUtils.filterDataBaseDF7((String)"4A255827", (KDBizPromptBox)this.prmtExpense, (String)"id", (Object)"ml7t5QEaEADgAAwawKgRe0olWCc=", (CompareType)CompareType.NOTEQUALS);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        try {
            BDCMClientUtils.filterAdminAndCostCenterF7((KDBizPromptBox)this.prmtDepartment, (String)companyOrgID);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.formatEntryTable();
    }

    @Override
    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
        if ("ADDNEW".equals(this.getOprtState())) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.ncm.order.fact.bill.client.OrderBillClientResource", (String)"OrderCCFeeBill_Title_new"));
        } else if ("EDIT".equals(this.getOprtState())) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.ncm.order.fact.bill.client.OrderBillClientResource", (String)"OrderCCFeeBill_Title_edit"));
        } else if ("VIEW".equals(this.getOprtState())) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.ncm.order.fact.bill.client.OrderBillClientResource", (String)"OrderCCFeeBill_Title_view"));
        }
    }

    private void formatEntryTable() {
        String companyOrgID = null;
        if (this.prmtCompanyOrg.getData() != null) {
            CompanyOrgUnitInfo comOrg = (CompanyOrgUnitInfo)this.prmtCompanyOrg.getData();
            companyOrgID = comOrg.getId().toString();
        }
        KDBizPromptBox prmtCostItem = new KDBizPromptBox();
        prmtCostItem.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostItemTreeListQuery");
        prmtCostItem.setEditable(true);
        prmtCostItem.setDisplayFormat("$number$");
        prmtCostItem.setEditFormat("$number$");
        prmtCostItem.setCommitFormat("$number$");
        prmtCostItem.setRequired(true);
        KDTDefaultCellEditor costItemEditor = new KDTDefaultCellEditor((IKDEditor)prmtCostItem);
        this.kdtEntries.getColumn("costItem.number").setEditor((ICellEditor)costItemEditor);
        ObjectValueRender costItemAvr = new ObjectValueRender();
        costItemAvr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntries.getColumn("costItem.number").setRenderer((IBasicRender)costItemAvr);
        KDBizPromptBox prmtActivity = new KDBizPromptBox();
        prmtActivity.setQueryInfo("com.kingdee.eas.basedata.ncm.app.F7ActivityQuery");
        prmtActivity.setEditable(true);
        prmtActivity.setDisplayFormat("$number$");
        prmtActivity.setEditFormat("$number$");
        prmtActivity.setCommitFormat("$number$");
        prmtActivity.setRequired(true);
        BDCMClientUtils.filterActivityF7((KDBizPromptBox)prmtActivity, (String)companyOrgID);
        CostCenterOrgUnitInfo costCenterInfo = (CostCenterOrgUnitInfo)this.prmtCostCenter.getValue();
        if (costCenterInfo != null) {
            try {
                this.filterActivityF7ByCostCenter(costCenterInfo, prmtActivity);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        KDTDefaultCellEditor activityEditor = new KDTDefaultCellEditor((IKDEditor)prmtActivity);
        this.kdtEntries.getColumn("activity.number").setEditor((ICellEditor)activityEditor);
        ObjectValueRender activityAvr = new ObjectValueRender();
        activityAvr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntries.getColumn("activity.number").setRenderer((IBasicRender)activityAvr);
        KDBizPromptBox prmtManfOrder = new KDBizPromptBox();
        prmtManfOrder.setQueryInfo("com.kingdee.eas.mm.mo.app.F7ManufactureOrderQuery");
        prmtManfOrder.setEditable(true);
        prmtManfOrder.setDisplayFormat("$number$");
        prmtManfOrder.setEditFormat("$number$");
        prmtManfOrder.setCommitFormat("$number$");
        prmtManfOrder.setRequired(true);
        try {
            BillBaseStatusEnum[] status = new BillBaseStatusEnum[]{BillBaseStatusEnum.RELEASED, BillBaseStatusEnum.BLOCKED, BillBaseStatusEnum.CLOSED, BillBaseStatusEnum.COMPLETE};
            BDCMClientUtils.filterOrderF7((KDBizPromptBox)prmtManfOrder, (String)companyOrgID, (BillBaseStatusEnum[])status);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        KDTDefaultCellEditor manfOrderEditor = new KDTDefaultCellEditor((IKDEditor)prmtManfOrder);
        this.kdtEntries.getColumn("manufacturer.number").setEditor((ICellEditor)manfOrderEditor);
        ObjectValueRender manfOrderAvr = new ObjectValueRender();
        manfOrderAvr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntries.getColumn("manufacturer.number").setRenderer((IBasicRender)manfOrderAvr);
        for (int rowIndex = 0; rowIndex < this.kdtEntries.getRowCount(); ++rowIndex) {
            IRow row = this.kdtEntries.getRow(rowIndex);
            Object activity = row.getCell("activity.number").getValue();
            if (activity == null) {
                row.getCell("manufacturer.number").getStyleAttributes().setBackground(new Color(231, 237, 243));
                continue;
            }
            row.getCell("manufacturer.number").getStyleAttributes().setLocked(false);
            row.getCell("manufacturer.number").getStyleAttributes().setBackground(Color.WHITE);
        }
        KDTDefaultCellEditor obj = (KDTDefaultCellEditor)this.kdtEntries.getColumn("amount").getEditor();
        KDFormattedTextField txtField = (KDFormattedTextField)obj.getComponent();
        txtField.setDataType(1);
        txtField.setRemoveingZeroInDispaly(false);
        txtField.setNegatived(true);
        this.kdtEntries.getColumn("costItem.name").getStyleAttributes().setLocked(true);
        this.setQtyPriceColumnPrecision();
        KDTextField colTxtField = new KDTextField();
        colTxtField.setMaxLength(255);
        KDTDefaultCellEditor col_CellEditor = new KDTDefaultCellEditor((JTextField)colTxtField);
        this.kdtEntries.getColumn("description").setEditor((ICellEditor)col_CellEditor);
    }

    private void setQtyPriceColumnPrecision() {
        ExpenseInfo expense = null;
        int qtyPrecision = 8;
        int pricePrecision = 8;
        if (this.prmtExpense.getData() instanceof ExpenseInfo) {
            expense = (ExpenseInfo)this.prmtExpense.getData();
            pricePrecision = expense.getPricePrecision();
            if (expense.getUnit() != null) {
                MeasureUnitInfo unit = (MeasureUnitInfo)BDCMUtils.getObjectValue(null, (String)expense.getUnit().getId().toString());
                qtyPrecision = unit.getQtyPrecision();
            }
        }
        boolean isAllocQty = expense != null && expense.isIsAllocateQty();
        this.kdtEntries.getColumn("qty").getStyleAttributes().setLocked(!isAllocQty);
        this.kdtEntries.getColumn("price").getStyleAttributes().setLocked(!isAllocQty);
        NCMClientUtils.changeTableColPrecision((int)qtyPrecision, (KDTable)this.kdtEntries, (String[])new String[]{"qty"}, (boolean)true);
        NCMClientUtils.changeTableColPrecision((int)pricePrecision, (KDTable)this.kdtEntries, (String[])new String[]{"price"});
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return OrderCCFeeBillFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        OrderCCFeeBillInfo objectValue = new OrderCCFeeBillInfo();
        objectValue.setFivouchered(false);
        super.applyBillDefaultValue((IObjectValue)objectValue);
        return objectValue;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        OrderCCFeeBillEntryInfo entry = new OrderCCFeeBillEntryInfo();
        entry.setAmount(SysConstant.BIGZERO);
        if (this.prmtExpense.getData() instanceof ExpenseInfo) {
            ExpenseInfo info = (ExpenseInfo)this.prmtExpense.getData();
            try {
                CostItemInfo ci = NCMUtils.getCostItemByExpense(null, (String)info.getId().toString(), (String)((CompanyOrgUnitInfo)this.prmtCompanyOrg.getData()).getId().toString());
                entry.setCostItem(ci);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        return entry;
    }

    @Override
    protected void prmtExpense_dataChanged(DataChangeEvent e) throws Exception {
        Object nValue = e.getNewValue();
        if (nValue == null) {
            this.txtUnit.setText(null);
            this.kdtEntries.removeRows();
            return;
        }
        if (nValue.equals(e.getOldValue())) {
            return;
        }
        this.kdtEntries.removeRows();
        this.editData.getEntries().clear();
        this.addLine(this.kdtEntries);
        this.setQtyPriceColumnPrecision();
        ExpenseInfo expense = (ExpenseInfo)nValue;
        if (expense.getUnit() != null) {
            MeasureUnitInfo unit = (MeasureUnitInfo)BDCMUtils.getObjectValue(null, (String)expense.getUnit().getId().toString());
            this.txtUnit.setText(unit.getName());
        } else {
            this.txtUnit.setText(null);
        }
    }

    @Override
    protected void kdtEntries_editStopped(KDTEditEvent e) throws Exception {
        int row = e.getRowIndex();
        if (e.getValue() instanceof CostItemInfo) {
            CostItemInfo ci = (CostItemInfo)e.getValue();
            this.kdtEntries.getCell(row, "costItem.name").setValue((Object)ci.getName());
            return;
        }
        if (e.getOldValue() instanceof CostItemInfo) {
            this.kdtEntries.getCell(row, "costItem.name").setValue(null);
            return;
        }
        if (e.getValue() instanceof ActivityInfo) {
            ActivityInfo ci = (ActivityInfo)e.getValue();
            this.kdtEntries.getCell(row, "activity.name").setValue((Object)ci.getName());
            this.kdtEntries.getCell(row, "manufacturer.number").getStyleAttributes().setLocked(false);
            this.kdtEntries.getCell(row, "manufacturer.number").getStyleAttributes().setBackground(Color.WHITE);
            return;
        }
        if (e.getOldValue() instanceof ActivityInfo) {
            this.kdtEntries.getCell(row, "activity.name").setValue(null);
            this.kdtEntries.getCell(row, "manufacturer.number").setValue(null);
            this.kdtEntries.getCell(row, "storageOrgUnit.name").setValue(null);
            this.kdtEntries.getCell(row, "manufacturer.number").getStyleAttributes().setLocked(true);
            this.kdtEntries.getCell(row, "manufacturer.number").getStyleAttributes().setBackground(new Color(231, 237, 243));
            return;
        }
        if (e.getValue() instanceof ManufactureOrderInfo) {
            ManufactureOrderInfo manfOrder = (ManufactureOrderInfo)e.getValue();
            String storageID = manfOrder.getStorageOrgUnit().getId().toString();
            StorageOrgUnitInfo storageOrgUnitInfo = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(storageID));
            this.kdtEntries.getCell(row, "storageOrgUnit.name").setValue((Object)storageOrgUnitInfo.getName());
            return;
        }
        if (e.getOldValue() instanceof ManufactureOrderInfo) {
            this.kdtEntries.getCell(row, "storageOrgUnit.name").setValue(null);
            return;
        }
        String column = this.kdtEntries.getColumnKey(e.getColIndex());
        BigDecimal qty = SysConstant.BIGZERO;
        BigDecimal price = SysConstant.BIGZERO;
        BigDecimal amount = SysConstant.BIGZERO;
        if ("qty".equals(column) || "price".equals(column)) {
            qty = BDCMClientUtils.castToBigDecimal((KDTable)this.kdtEntries, (int)row, (String)"qty");
            price = BDCMClientUtils.castToBigDecimal((KDTable)this.kdtEntries, (int)row, (String)"price");
            amount = qty.multiply(price);
            this.kdtEntries.getCell(row, "amount").setValue((Object)amount);
        } else if ("amount".equals(column)) {
            amount = BDCMClientUtils.castToBigDecimal((KDTable)this.kdtEntries, (int)row, (String)"amount");
            qty = BDCMClientUtils.castToBigDecimal((KDTable)this.kdtEntries, (int)row, (String)"qty");
            if (qty.compareTo(SysConstant.BIGZERO) != 0) {
                price = amount.divide(qty, 4);
            }
            this.kdtEntries.getCell(row, "price").setValue((Object)price);
        }
    }

    protected void setTableToSumField() {
        super.setTableToSumField(this.kdtEntries, new String[]{"qty", "amount"});
    }

    protected String[] getValidateColumns() {
        return new String[]{"costItem.number"};
    }

    protected void checkValidDataForSubmit() throws Exception {
        super.checkValidDataForSubmit();
        BDCMClientUtils.checkIsNull((JComponent)this.prmtCostCenter, (String)this.kDLabelCostCenterGroup.getBoundLabelText());
        BDCMClientUtils.checkIsNull((JComponent)this.prmtExpense, (String)this.kDLabelExpense.getBoundLabelText());
        int rowCount = this.kdtEntries.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Object val = this.kdtEntries.getCell(i, "costItem.number").getValue();
            if (val == null || "".equals(val)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"31_CCOFeeBillEditUI"));
                SysUtil.abort();
            }
            if (!((val = this.kdtEntries.getCell(i, "amount").getValue()) instanceof BigDecimal) || SysConstant.BIGZERO.compareTo((BigDecimal)val) != 0) continue;
            MsgBox.showInfo((String)NCMClientUtils.getNcmBillResource((String)"AmountCannotBeZero"));
            SysUtil.abort();
        }
    }

    @Override
    protected void prmtCostCenter_dataChanged(DataChangeEvent e) throws Exception {
        CostCenterOrgUnitInfo newCostCenterInfo = (CostCenterOrgUnitInfo)e.getNewValue();
        CostCenterOrgUnitInfo oldCostCenterInfo = (CostCenterOrgUnitInfo)e.getOldValue();
        if (newCostCenterInfo != null && newCostCenterInfo.equals((Object)oldCostCenterInfo)) {
            return;
        }
        int rowCount = this.kdtEntries.getRowCount();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            ICell cell = this.kdtEntries.getCell(rowIndex, "activity.number");
            cell.setValue(null);
        }
        if (this.prmtCompanyOrg.getData() != null) {
            String companyOrgID = null;
            CompanyOrgUnitInfo comOrg = (CompanyOrgUnitInfo)this.prmtCompanyOrg.getData();
            companyOrgID = comOrg.getId().toString();
            KDBizPromptBox prmtActivity = new KDBizPromptBox();
            prmtActivity.setQueryInfo("com.kingdee.eas.basedata.ncm.app.ActivityQuery");
            prmtActivity.setEditable(true);
            prmtActivity.setDisplayFormat("$name$");
            prmtActivity.setEditFormat("$number$");
            prmtActivity.setCommitFormat("$number$");
            prmtActivity.setRequired(true);
            BDCMClientUtils.filterActivityF7((KDBizPromptBox)prmtActivity, (String)companyOrgID);
            this.filterActivityF7ByCostCenter(newCostCenterInfo, prmtActivity);
            KDTDefaultCellEditor activityEditor = new KDTDefaultCellEditor((IKDEditor)prmtActivity);
            this.kdtEntries.getColumn("activity.number").setEditor((ICellEditor)activityEditor);
        }
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        ((ICMBillBase)this.getBizInterface()).logPrint(new OrderCCFeeBillInfo().getBOSType(), "OrderCCFeeBillPrint", (IObjectValue)this.editData);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        ((ICMBillBase)this.getBizInterface()).logPrint(new OrderCCFeeBillInfo().getBOSType(), "OrderCCFeeBillPrint", (IObjectValue)this.editData);
    }

    private void filterActivityF7ByCostCenter(CostCenterOrgUnitInfo costCenterInfo, KDBizPromptBox activityF7) throws BOSException {
        String companyOrgID = null;
        if (this.prmtCompanyOrg.getData() != null) {
            CompanyOrgUnitInfo comOrg = (CompanyOrgUnitInfo)this.prmtCompanyOrg.getData();
            companyOrgID = comOrg.getId().toString();
            BDCMClientUtils.filterActivityF7((KDBizPromptBox)activityF7, (String)companyOrgID);
        }
        if (costCenterInfo == null) {
            return;
        }
        String costCenterID = costCenterInfo.getId().toString();
        FilterInfo filterByCostCenter = new FilterInfo();
        filterByCostCenter.getFilterItems().add(new FilterItemInfo("costCenter.id", (Object)costCenterID, CompareType.EQUALS));
        FilterInfo filter = activityF7.getEntityViewInfo().getFilter();
        filterByCostCenter.mergeFilter(filter, "AND");
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterByCostCenter);
        activityF7.setEntityViewInfo(view);
    }

    @Override
    protected void isStart() throws Exception {
        CompanyOrgUnitInfo companyInfo = SysContext.getSysContext().getCurrentFIUnit();
        if (companyInfo != null) {
            OrderCMUtils.checkStart(companyInfo.getId().toString());
        }
    }

    private void filterOrder(KDBizPromptBox prmtManfOrder) throws BOSException {
        FilterInfo filter = new FilterInfo();
        HashSet<String> billStatus = new HashSet<String>();
        billStatus.add("5");
        billStatus.add("6");
        billStatus.add("7");
        billStatus.add("8");
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", billStatus, CompareType.INCLUDE));
        filter.mergeFilter(prmtManfOrder.getEntityViewInfo().getFilter(), "AND");
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        prmtManfOrder.setEntityViewInfo(view);
    }
}

