/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.bill.client;

import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.common.BillBaseStatusEnum;
import com.kingdee.eas.ncm.common.ICMBillBase;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMCommonQueryProcessor;
import com.kingdee.eas.ncm.order.common.utils.OrderCMUtils;
import com.kingdee.eas.ncm.order.fact.bill.OrderCCFeeBillFactory;
import com.kingdee.eas.ncm.order.fact.bill.OrderCCFeeBillInfo;
import com.kingdee.eas.ncm.order.fact.bill.client.AbstractOrderCCFeeBillListUI;
import com.kingdee.eas.ncm.order.fact.bill.client.OrderCCFeeBillEditUI;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class OrderCCFeeBillListUI
extends AbstractOrderCCFeeBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(OrderCCFeeBillListUI.class);
    private static final String ENTRY_AMOUNT = "entries.amount";
    private static final String ENTRY_QTY = "entries.qty";
    private static final String ENTRY_PRICE = "entries.price";
    private CompanyOrgUnitInfo currentCompany = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(OrgType.Company);
    CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.currentCompany.getBaseCurrency().getId()));
    private CommonQueryDialog dialog = null;

    public OrderCCFeeBillListUI() throws Exception {
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int firstRowIndex = e.getFirstRow();
                int lastRowIndex = e.getLastRow();
                IRow row = null;
                int precision = 0;
                for (int i = firstRowIndex; i <= lastRowIndex; ++i) {
                    row = OrderCCFeeBillListUI.this.tblMain.getRow(i);
                    if (row.getCell(OrderCCFeeBillListUI.ENTRY_AMOUNT) != null && row.getCell(OrderCCFeeBillListUI.ENTRY_AMOUNT).getValue() != null) {
                        precision = ((BigDecimal)row.getCell(OrderCCFeeBillListUI.ENTRY_AMOUNT).getValue()).scale();
                        NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell(OrderCCFeeBillListUI.ENTRY_AMOUNT), (int)precision);
                    }
                    if (row.getCell(OrderCCFeeBillListUI.ENTRY_QTY) != null && row.getCell(OrderCCFeeBillListUI.ENTRY_QTY).getValue() != null) {
                        precision = ((BigDecimal)row.getCell(OrderCCFeeBillListUI.ENTRY_QTY).getValue()).scale();
                        NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell(OrderCCFeeBillListUI.ENTRY_QTY), (int)precision);
                    }
                    if (row.getCell(OrderCCFeeBillListUI.ENTRY_PRICE) == null || row.getCell(OrderCCFeeBillListUI.ENTRY_PRICE).getValue() == null) continue;
                    precision = ((BigDecimal)row.getCell(OrderCCFeeBillListUI.ENTRY_PRICE).getValue()).scale();
                    NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell(OrderCCFeeBillListUI.ENTRY_PRICE), (int)precision);
                }
            }
        });
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        try {
            while (rowSet.next()) {
                int precision = rowSet.getInt("baseCurrency.precision");
                BDCMUtils.iniColumnsPrecision((int)precision, (String)ENTRY_AMOUNT, (IRowSet)rowSet);
                precision = rowSet.getInt("unit.qtyPrecision");
                BDCMUtils.iniColumnsPrecision((int)precision, (String)ENTRY_QTY, (IRowSet)rowSet);
                precision = rowSet.getInt("expense.pricePrecision");
                BDCMUtils.iniColumnsPrecision((int)precision, (String)ENTRY_PRICE, (IRowSet)rowSet);
            }
        }
        catch (SQLException ex) {
            this.handUIException(ex);
        }
    }

    public String[] getMergeColumnKeys() {
        return new String[]{"number", "billStatus", "bizDate", "calculatePeriod.number", "companyOrg.name", "costCenter.number", "costCenter.name", "description", "expense.number", "expense.name", "department.number", "department.name", "fivouchered", "voucher", "unit.name"};
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return OrderCCFeeBillFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        OrderCCFeeBillInfo objectValue = new OrderCCFeeBillInfo();
        return objectValue;
    }

    protected String getEditUIName() {
        return OrderCCFeeBillEditUI.class.getName();
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected boolean isEnableSubmit() {
        return true;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor qe = super.getQueryExecutor(queryPK, viewInfo);
        return qe;
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        super.tblMain_doRequestRowSet(e);
        int curPre = this.currency.getPrecision();
        NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)this.tblMain.getFootRow(0).getCell(ENTRY_QTY), (int)4);
        NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)this.tblMain.getFootRow(0).getCell(ENTRY_AMOUNT), (int)curPre);
    }

    @Override
    protected void isStart() throws Exception {
        CompanyOrgUnitInfo companyInfo = SysContext.getSysContext().getCurrentFIUnit();
        if (companyInfo != null) {
            OrderCMUtils.checkStart(companyInfo.getId().toString());
        }
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog == null) {
            this.dialog = super.initCommonQueryDialog();
        }
        OrderCCFeeBillQueryProcessor cmcq = new OrderCCFeeBillQueryProcessor();
        cmcq.set("companyOrg", SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        cmcq.set("query", "orderCCFeeBillQuery");
        this.dialog.setProcessor((IProcessor)cmcq);
        return this.dialog;
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        ((ICMBillBase)this.getBizInterface()).logPrint(new OrderCCFeeBillInfo().getBOSType(), "OrderCCFeeBillPrint", null);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        ((ICMBillBase)this.getBizInterface()).logPrint(new OrderCCFeeBillInfo().getBOSType(), "OrderCCFeeBillPrint", null);
    }

    private class OrderCCFeeBillQueryProcessor
    extends NCMCommonQueryProcessor {
        private OrderCCFeeBillQueryProcessor() {
        }

        public void process() throws Exception {
            super.process();
            Object editor = this.get("CURRENT_EDITOR");
            String fieldProperty = (String)this.get("CURRENT_FIELD_PROP");
            if (editor instanceof KDComboBox && "billStatus".equals(fieldProperty)) {
                KDComboBox kdBox = (KDComboBox)editor;
                kdBox.removeItem((Object)BillBaseStatusEnum.ADD);
            }
        }
    }
}

