/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.ncm.CostDriverFactory;
import com.kingdee.eas.basedata.ncm.CostDriverInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ncm.common.utils.NCMConst;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.order.fact.alloc.OCAllocFacadeFactory;
import com.kingdee.eas.ncm.order.fact.bill.OrderCCOFeeBillFactory;
import com.kingdee.eas.ncm.order.fact.bill.OrderCCOFeeBillInfo;
import com.kingdee.eas.ncm.order.fact.bill.client.AbstractOrderCCOAllocEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Map;
import org.apache.log4j.Logger;

public class OrderCCOAllocEditUI
extends AbstractOrderCCOAllocEditUI {
    private static final Logger logger = CoreUIObject.getLogger(OrderCCOAllocEditUI.class);
    private static final String Col_Qty = "qty";
    private static final String Col_Price = "price";
    private static final String Col_Amount = "amount";
    private Map _parentParam = null;
    private String _companyId = null;
    private String _periodId = null;
    private String _sourceBillId = null;
    private String _sourceBillEntryId = null;
    private CoreUIObject _parentUI;
    private tblMainIterator _iterator;
    private String _operType = null;
    private IRowSet _Data = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public static void showAllocEditUI(CoreUIObject ui, Map param, String operType, KDTable tblMain) throws Exception {
        Assert.that((boolean)param.containsKey("companyId"));
        Assert.that((boolean)param.containsKey("periodId"));
        Assert.that((tblMain != null ? 1 : 0) != 0);
        Assert.that((boolean)operType.equals("VIEW"));
        try {
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put((Object)"param", (Object)param);
            uiContext.put((Object)"operType", (Object)operType);
            uiContext.put((Object)"tblMain", (Object)tblMain);
            uiContext.put((Object)"parentUI", (Object)ui);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(OrderCCOAllocEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
        }
        catch (BOSException e) {
            SysUtil.abort((Throwable)e);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this._parentParam = (Map)this.getUIContext().get("param");
        this._operType = (String)this.getUIContext().get("operType");
        KDTable tbl = (KDTable)this.getUIContext().get("tblMain");
        this._parentUI = (CoreUIObject)this.getUIContext().get("parentUI");
        this._iterator = new tblMainIterator(tbl);
        this._companyId = (String)this._parentParam.get("companyId");
        this._periodId = (String)this._parentParam.get("periodId");
        this.formatControls();
        this.fillData();
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.btnPrintView.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnFirst.setIcon(EASResource.getIcon((String)"imgTbtn_first"));
        this.btnPre.setIcon(EASResource.getIcon((String)"imgTbtn_previous"));
        this.btnNext.setIcon(EASResource.getIcon((String)"imgTbtn_next"));
        this.btnLast.setIcon(EASResource.getIcon((String)"imgTbtn_last"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
    }

    private void formatControls() {
        this.tableMain.checkParsed();
        this.tableMain.getColumn(Col_Qty).getStyleAttributes().setNumberFormat("%{0.##########}f");
        this.tableMain.getColumn(Col_Price).getStyleAttributes().setNumberFormat("%{0.##########}f");
        this.tableMain.getColumn(Col_Amount).getStyleAttributes().setNumberFormat("%{0.##########}f");
    }

    @Override
    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        this._iterator.First();
        this.fillData();
    }

    @Override
    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        this._iterator.Pre();
        this.fillData();
    }

    @Override
    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        this._iterator.Next();
        this.fillData();
    }

    @Override
    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        this._iterator.Last();
        this.fillData();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.fillData();
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tableMain);
        this.tableMain.getPrintManager().print();
        OrderCCOFeeBillInfo info = new OrderCCOFeeBillInfo();
        info.setNumber(this.txtNumber.getText());
        OrderCCOFeeBillFactory.getRemoteInstance().logPrint(BOSObjectType.create((String)"380B932E"), "OrderCCOFeeAllocPrint", (IObjectValue)info);
    }

    @Override
    public void actionPrintView_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tableMain);
        this.tableMain.getPrintManager().printPreview();
        OrderCCOFeeBillInfo info = new OrderCCOFeeBillInfo();
        info.setNumber(this.txtNumber.getText());
        OrderCCOFeeBillFactory.getRemoteInstance().logPrint(BOSObjectType.create((String)"380B932E"), "OrderCCOFeeAllocPrint", (IObjectValue)info);
    }

    private void fillData() throws BOSException, EASBizException, SQLException {
        IRow row = this._iterator.CurrentRow();
        if (row == null) {
            return;
        }
        this.txtNumber.setText((String)row.getCell("number").getValue());
        this.txtEntrySeq.setText(String.valueOf(row.getCell("entries.seq").getValue()));
        this.txtCostCenter.setText((String)row.getCell("costCenterGroup.number").getValue());
        this.txtExpense.setText((String)row.getCell("expense.number").getValue());
        this.txtUnit.setText((String)row.getCell("unit.name").getValue());
        this.txtDepartment.setText((String)row.getCell("department.name").getValue());
        if (row.getCell("entries.qty").getValue() == null) {
            this.txtQty.setText("0");
        } else {
            this.txtQty.setText(row.getCell("entries.qty").getValue().toString());
        }
        if (row.getCell("entries.amount").getValue() == null) {
            this.txtAmount.setText("0");
        } else {
            this.txtAmount.setText(row.getCell("entries.amount").getValue().toString());
        }
        this._sourceBillId = (String)row.getCell("id").getValue();
        this._sourceBillEntryId = (String)row.getCell("entries.id").getValue();
        this._Data = this.GetAdjustData();
        this.initKDTable();
    }

    private void initKDTable() throws BOSException, EASBizException, SQLException {
        if (this._Data != null) {
            IRow row;
            boolean isSetted = false;
            this.tableMain.removeRows();
            BigDecimal totalAllocStdData = BigDecimal.valueOf(0L);
            BigDecimal totalAmount = BigDecimal.valueOf(0L);
            BigDecimal totalPrice = BigDecimal.valueOf(0L);
            BigDecimal totalQty = BigDecimal.valueOf(0L);
            this._Data.first();
            while (this._Data.getRow() > 0 && !this._Data.isAfterLast()) {
                if (!isSetted) {
                    if (this._operType.equals("VIEW")) {
                        this.prmtCostDriver.setText(this._Data.getString("FCostDriverName"));
                    } else if (this._Data.getString("FCostDriverId") != null) {
                        ObjectUuidPK pk = new ObjectUuidPK(this._Data.getString("FCostDriverID"));
                        CostDriverInfo std = CostDriverFactory.getRemoteInstance().getCostDriverInfo((IObjectPK)pk);
                        this.prmtCostDriver.setValue((Object)std);
                    } else {
                        this.prmtCostDriver.setValue(null);
                    }
                    isSetted = true;
                }
                row = this.tableMain.addRow();
                row.getCell("costCenterNumber").setValue((Object)this._Data.getString("FCostCenterNumber"));
                row.getCell("costCenterName").setValue((Object)this._Data.getString("FCostCenterName"));
                row.getCell("costDriver").setValue((Object)this._Data.getBigDecimal("FCostDriverData"));
                totalAllocStdData = totalAllocStdData.add(this._Data.getBigDecimal("FCostDriverData"));
                if (this._Data.getBigDecimal("FQty") == null) {
                    row.getCell(Col_Qty).setValue((Object)NCMConst.ZERO);
                    totalQty = totalQty.add(NCMConst.ZERO);
                } else {
                    row.getCell(Col_Qty).setValue((Object)this._Data.getBigDecimal("FQty"));
                    totalQty = totalQty.add(this._Data.getBigDecimal("FQty"));
                }
                row.getCell(Col_Price).setValue((Object)this._Data.getBigDecimal("FPrice"));
                totalPrice = totalPrice.add(this._Data.getBigDecimal("FPrice"));
                if (this._Data.getBigDecimal("FAmount") == null) {
                    row.getCell(Col_Amount).setValue((Object)NCMConst.ZERO);
                    totalAmount = totalAmount.add(NCMConst.ZERO);
                } else {
                    row.getCell(Col_Amount).setValue((Object)this._Data.getBigDecimal("FAmount"));
                    totalAmount = totalAmount.add(this._Data.getBigDecimal("FAmount"));
                }
                row.getCell("department").setValue((Object)this._Data.getString("Fdepartmentname"));
                row.getCell("costItem").setValue((Object)this._Data.getString("FCostItemName"));
                row.getCell("manufacturerOrder").setValue((Object)this._Data.getString("FManufantureNumber"));
                row.getCell("storageOrgUnit").setValue((Object)this._Data.getString("FStorageName"));
                this._Data.next();
            }
            if (!totalAllocStdData.equals(BigDecimal.valueOf(0L))) {
                row = this.tableMain.addRow();
                row.getCell("costCenterName").setValue((Object)NCMClientUtils.getNcmBillResource((String)"SubTotal"));
                row.getCell("costDriver").setValue((Object)totalAllocStdData);
                row.getCell(Col_Amount).setValue((Object)totalAmount);
                row.getCell(Col_Qty).setValue((Object)totalQty);
                row.getStyleAttributes().setBackground(Color.LIGHT_GRAY);
                row.getStyleAttributes().setLocked(true);
            }
        }
    }

    private IRowSet GetAdjustData() throws BOSException {
        boolean forAdjust = this._operType.equals("ADJUST");
        return OCAllocFacadeFactory.getRemoteInstance().getCCOFeeAdjustData(this._companyId, this._periodId, this._sourceBillId, this._sourceBillEntryId, forAdjust);
    }

    private class tblMainIterator {
        private KDTable _tblMain;
        private int _currentRowIndex = -1;

        public tblMainIterator(KDTable tblMain) {
            this._tblMain = tblMain;
            this._currentRowIndex = this._tblMain.getSelectManager().getActiveRowIndex();
            if (this._currentRowIndex == 0) {
                OrderCCOAllocEditUI.this.actionFirst.setEnabled(false);
                OrderCCOAllocEditUI.this.actionPre.setEnabled(false);
            }
            if (this._currentRowIndex + 1 == this._tblMain.getRowCount()) {
                OrderCCOAllocEditUI.this.actionNext.setEnabled(false);
                OrderCCOAllocEditUI.this.actionLast.setEnabled(false);
            }
        }

        public void First() {
            this._currentRowIndex = 0;
            OrderCCOAllocEditUI.this.actionFirst.setEnabled(false);
            OrderCCOAllocEditUI.this.actionPre.setEnabled(false);
            OrderCCOAllocEditUI.this.actionNext.setEnabled(true);
            OrderCCOAllocEditUI.this.actionLast.setEnabled(true);
        }

        public void Pre() {
            --this._currentRowIndex;
            if (!this.IsFirst()) {
                OrderCCOAllocEditUI.this.actionFirst.setEnabled(true);
                OrderCCOAllocEditUI.this.actionPre.setEnabled(true);
                OrderCCOAllocEditUI.this.actionNext.setEnabled(true);
                OrderCCOAllocEditUI.this.actionLast.setEnabled(true);
            } else {
                OrderCCOAllocEditUI.this.actionFirst.setEnabled(false);
                OrderCCOAllocEditUI.this.actionPre.setEnabled(false);
                OrderCCOAllocEditUI.this.actionNext.setEnabled(true);
                OrderCCOAllocEditUI.this.actionLast.setEnabled(true);
            }
        }

        public void Next() {
            ++this._currentRowIndex;
            if (!this.IsLast()) {
                OrderCCOAllocEditUI.this.actionFirst.setEnabled(true);
                OrderCCOAllocEditUI.this.actionPre.setEnabled(true);
                OrderCCOAllocEditUI.this.actionNext.setEnabled(true);
                OrderCCOAllocEditUI.this.actionLast.setEnabled(true);
            } else {
                OrderCCOAllocEditUI.this.actionFirst.setEnabled(true);
                OrderCCOAllocEditUI.this.actionPre.setEnabled(true);
                OrderCCOAllocEditUI.this.actionNext.setEnabled(false);
                OrderCCOAllocEditUI.this.actionLast.setEnabled(false);
            }
        }

        public void Last() {
            this._currentRowIndex = this._tblMain.getRowCount() - 1;
            OrderCCOAllocEditUI.this.actionFirst.setEnabled(true);
            OrderCCOAllocEditUI.this.actionPre.setEnabled(true);
            OrderCCOAllocEditUI.this.actionNext.setEnabled(false);
            OrderCCOAllocEditUI.this.actionLast.setEnabled(false);
        }

        public boolean IsFirst() {
            return this._currentRowIndex == 0;
        }

        public boolean IsLast() {
            return this._tblMain.getRowCount() == this._currentRowIndex + 1;
        }

        public IRow CurrentRow() {
            return this._tblMain.getRow(this._currentRowIndex);
        }
    }
}

