/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ncm.bill.AllocTypeEnum;
import com.kingdee.eas.ncm.bill.client.FeeAllocClientUtils;
import com.kingdee.eas.ncm.common.AllocSourceBillEnum;
import com.kingdee.eas.ncm.common.ICMBillBase;
import com.kingdee.eas.ncm.common.progress.client.ProgressHintListener;
import com.kingdee.eas.ncm.common.progress.client.ProgressHintUI;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMCommonQueryProcessor;
import com.kingdee.eas.ncm.order.common.utils.OrderCMUtils;
import com.kingdee.eas.ncm.order.fact.alloc.AllocateException;
import com.kingdee.eas.ncm.order.fact.alloc.OCAllocFacadeFactory;
import com.kingdee.eas.ncm.order.fact.bill.OrderBillException;
import com.kingdee.eas.ncm.order.fact.bill.OrderCCFeeBillInfo;
import com.kingdee.eas.ncm.order.fact.bill.client.AbstractOrderCCOAllocListUI;
import com.kingdee.eas.ncm.order.fact.bill.client.OrderCCOAllocEditUI;
import com.kingdee.eas.ncm.order.fact.bill.client.OrderFeeAllocLogReportUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class OrderCCOAllocListUI
extends AbstractOrderCCOAllocListUI {
    private static final Logger logger = CoreUIObject.getLogger(OrderCCOAllocListUI.class);
    private CompanyOrgUnitInfo _company;
    private PeriodInfo _period;
    private UserInfo userInfo;
    private FilterInfo _currFilterInfo = null;
    private boolean bFilter_all = false;
    private CommonQueryDialog dialog = null;

    public void onLoad() throws Exception {
        this._company = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(OrgType.Company);
        this._period = OrderCMUtils.getCurrentPeriod(this._company.getId().toString());
        this.userInfo = SysContext.getSysContext().getCurrentUserInfo();
        super.onLoad();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.btnAutoAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.btnViewAllocResult.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        this.btnViewLog.setIcon(EASResource.getIcon((String)"imgTbtn_distributelog"));
        this.actionViewAllocReuslt.setEnabled(true);
        this.actionViewLog.setEnabled(true);
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        this.menuItemAutoAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.menuItemViewAllocResult.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        this.menuItemViewLog.setIcon(EASResource.getIcon((String)"imgTbtn_distributelog"));
        this.menuWorkFlow.setVisible(false);
        this.menuEdit.setVisible(false);
        this.menuItemAddNew.setVisible(false);
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.actionViewAllocReuslt_actionPerformed(null);
        }
    }

    @Override
    public void actionAuotAlloc_actionPerformed(ActionEvent e) throws Exception {
        super.actionAuotAlloc_actionPerformed(e);
        this.ifHasCodingRule();
        if (!FeeAllocClientUtils.showCalHintBeforeFeeAlloc((CompanyOrgUnitInfo)this._company, (PeriodInfo)this._period)) {
            return;
        }
        this.checkISAlloced(this._company.getId().toString(), this._period.getId().toString(), this._currFilterInfo);
        String taskClazzName = "com.kingdee.eas.ncm.order.fact.alloc.app.task.OCCCOFeeAllocTask";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("task.show.time", Boolean.TRUE);
        param.put("ccoAllocFilterInfo", this._currFilterInfo);
        param.put("companyId", this._company.getId().toString());
        param.put("periodId", this._period.getId().toString());
        param.put("userId", this.userInfo.getId().toString());
        param.put("allocType", AllocTypeEnum.AUTO);
        param.put("isForAllocate", "true");
        param.put("task.listener", new ProgressHintListener(){

            public void afterTaskExecute(Map param, List userObjects) throws Exception {
                NCMClientUtils.releaseMutex((CoreUI)OrderCCOAllocListUI.this, (String)OrderCCOAllocListUI.this._company.getId().toString());
            }

            public void beforeTaskExecute(Map param) throws Exception {
                NCMClientUtils.requestMutex((CoreUI)OrderCCOAllocListUI.this, (String)OrderCCOAllocListUI.this._company.getId().toString());
            }
        });
        param.put("allocSourceBill", AllocSourceBillEnum.CCOFeeBill);
        try {
            ProgressHintUI hintUI = ProgressHintUI.showProgressHintUI((Component)((Object)this), (String)taskClazzName, param);
            List userObjects = hintUI.getUserObjects();
            if (userObjects.size() > 0 && userObjects.get(0) instanceof String) {
                final String success = (String)userObjects.get(0);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if ("ccoAlloc_error".equals(success)) {
                            OrderCCOAllocListUI.this.btnViewLog.doClick();
                        }
                    }
                });
            }
        }
        catch (AllocateException ex) {
            MsgBox.showInfo((String)ex.getMessage());
        }
    }

    @Override
    public void actionViewAllocReuslt_actionPerformed(ActionEvent e) throws Exception {
        this.showAllocEditUI("VIEW");
    }

    @Override
    public void actionViewLog_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("companyId", this._company.getId().toString());
        param.put("periodId", this._period.getId().toString());
        param.put("companyName", this._company.getName().toString());
        param.put("periodNumber", String.valueOf(this._period.getNumber()));
        param.put("feeType", "ccoFee");
        OrderFeeAllocLogReportUI.showAllocReportUI((CoreUIObject)this, param);
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        super.beforeExcutQuery(ev);
        try {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("calculatePeriod.id", (Object)this._period.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)String.valueOf(4)));
            filter.getFilterItems().add(new FilterItemInfo("companyOrg.id", (Object)this._company.getId().toString()));
            this.bFilter_all = ev.getFilter().getFilterItems().size() <= 3;
            try {
                ev.getFilter().mergeFilter(filter, "and");
                this._currFilterInfo = (FilterInfo)ev.getFilter().clone();
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    @Override
    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog == null) {
            this.dialog = super.initCommonQueryDialog();
        }
        NCMCommonQueryProcessor cmcq = new NCMCommonQueryProcessor();
        cmcq.set("companyOrg", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        cmcq.set("query", (Object)"orderCCOFeeBillQuery");
        this.dialog.setProcessor((IProcessor)cmcq);
        return this.dialog;
    }

    private void showAllocEditUI(String operType) throws Exception {
        this.checkSelected();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("companyId", this._company.getId().toString());
        param.put("periodId", this._period.getId().toString());
        param.put("companyName", this._company.getName().toString());
        param.put("periodNumber", String.valueOf(this._period.getNumber()));
        param.put("bFilter_all", String.valueOf(this.bFilter_all));
        OrderCCOAllocEditUI.showAllocEditUI((CoreUIObject)this, param, operType, this.tblMain);
    }

    private void ifHasCodingRule() throws OrderBillException, AllocateException {
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            if (!codingRuleManager.isExist((IObjectValue)new OrderCCFeeBillInfo(), this._company.getId().toString())) {
                throw new OrderBillException(OrderBillException.ITEM_CCFEEBILL_NOCODINGRULE);
            }
        }
        catch (OrderBillException e) {
            logger.error((Object)"", (Throwable)((Object)e));
            throw new AllocateException(AllocateException.ITEM_CCOFEEBILL_NO_CODINGRULE);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new OrderBillException(OrderBillException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            throw new OrderBillException(OrderBillException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        if (viewInfo == null) {
            viewInfo = new EntityViewInfo();
        }
        String filter = this.getDefaultFilterForQuery().toString();
        this.bFilter_all = viewInfo.getFilter().toString().startsWith(filter);
        IQueryExecutor qe = super.getQueryExecutor(queryPK, viewInfo);
        return qe;
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
        ((ICMBillBase)this.getBizInterface()).logPrint(BOSObjectType.create((String)"380B932E"), "OrderCCOFeeAllocPrint", null);
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
        ((ICMBillBase)this.getBizInterface()).logPrint(BOSObjectType.create((String)"380B932E"), "OrderCCOFeeAllocPrint", null);
    }

    @Override
    protected boolean isEnableSubmit() {
        return false;
    }

    private void checkISAlloced(String companyID, String periodID, FilterInfo filter) {
        try {
            int opr;
            boolean result = false;
            result = OCAllocFacadeFactory.getRemoteInstance().checkCCOFeeIsAlloced(companyID, periodID, filter);
            if (result && (opr = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.ncm.order.fact.bill.client.OrderBillClientResource", (String)"OrderCCOAllocFee_AllocedMessage"))) == 2) {
                SysUtil.abort();
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (BOSException ex) {
            logger.error((Object)"", (Throwable)ex);
        }
    }

    public void onGetRowSet(IRowSet rowSet) {
        if (rowSet == null || rowSet.size() == 0) {
            this.actionAuotAlloc.setEnabled(false);
            this.actionViewAllocReuslt.setEnabled(false);
            this.actionViewLog.setEnabled(false);
            this.actionPrint.setEnabled(false);
            this.actionPrintPreview.setEnabled(false);
        } else {
            this.actionAuotAlloc.setEnabled(true);
            this.actionViewAllocReuslt.setEnabled(true);
            this.actionViewLog.setEnabled(true);
            this.actionPrint.setEnabled(true);
            this.actionPrintPreview.setEnabled(true);
        }
    }
}

