/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.ncm.ActivityInfo;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.ncm.bill.TimeUnitEnum;
import com.kingdee.eas.ncm.common.ICMBillBase;
import com.kingdee.eas.ncm.common.utils.NCMConst;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.order.common.utils.OrderCMUtils;
import com.kingdee.eas.ncm.order.fact.bill.OrderReportBillFactory;
import com.kingdee.eas.ncm.order.fact.bill.OrderReportBillHourEntryInfo;
import com.kingdee.eas.ncm.order.fact.bill.OrderReportBillInfo;
import com.kingdee.eas.ncm.order.fact.bill.OrderReportBillQtyEntryInfo;
import com.kingdee.eas.ncm.order.fact.bill.client.AbstractOrderReportBillEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.EnumUtils;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashSet;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class OrderReportBillEditUI
extends AbstractOrderReportBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(OrderReportBillEditUI.class);
    private static final int DEFUALT_PRECISION = 4;

    public void onLoad() throws Exception {
        this.hour.checkParsed();
        this.qty.checkParsed();
        super.onLoad();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.formatEntryTable();
        String companyOrgID = null;
        if (this.prmtCompanyOrg.getData() != null) {
            CompanyOrgUnitInfo comOrg = (CompanyOrgUnitInfo)this.prmtCompanyOrg.getData();
            companyOrgID = comOrg.getId().toString();
        }
        try {
            this.filterOrder(this.prmtManuFacturerOrder, companyOrgID);
            this.setDataFormat();
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
        if ("ADDNEW".equals(this.getOprtState())) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.ncm.order.fact.bill.client.OrderBillClientResource", (String)"OrderReportBill_Title_new"));
        } else if ("EDIT".equals(this.getOprtState())) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.ncm.order.fact.bill.client.OrderBillClientResource", (String)"OrderReportBill_Title_edit"));
        } else if ("VIEW".equals(this.getOprtState())) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.ncm.order.fact.bill.client.OrderBillClientResource", (String)"OrderReportBill_Title_view"));
        }
    }

    private void formatEntryTable() {
        this.formatHourEntryTable();
        this.formatQtyEntryTable();
    }

    private void formatHourEntryTable() {
        String companyOrgID = null;
        if (this.prmtCompanyOrg.getData() != null) {
            CompanyOrgUnitInfo comOrg = (CompanyOrgUnitInfo)this.prmtCompanyOrg.getData();
            companyOrgID = comOrg.getId().toString();
        }
        KDBizPromptBox prmtActivity = new KDBizPromptBox();
        prmtActivity.setQueryInfo("com.kingdee.eas.basedata.ncm.app.F7ActivityQuery");
        prmtActivity.setEditable(true);
        prmtActivity.setDisplayFormat("$number$");
        prmtActivity.setEditFormat("$number$");
        prmtActivity.setCommitFormat("$number$");
        prmtActivity.setRequired(true);
        BDCMClientUtils.filterActivityF7((KDBizPromptBox)prmtActivity, (String)companyOrgID);
        KDTDefaultCellEditor activityEditor = new KDTDefaultCellEditor((IKDEditor)prmtActivity);
        this.hour.getColumn("activity.number").setEditor((ICellEditor)activityEditor);
        ObjectValueRender activityAvr = new ObjectValueRender();
        activityAvr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.hour.getColumn("activity.number").setRenderer((IBasicRender)activityAvr);
        KDBizPromptBox prmtCostCenter = new KDBizPromptBox();
        prmtCostCenter.setQueryInfo("com.kingdee.eas.basedata.org.app.CostCenterItemQuery");
        prmtCostCenter.setEditable(true);
        prmtCostCenter.setDisplayFormat("$name$");
        prmtCostCenter.setEditFormat("$number$");
        prmtCostCenter.setCommitFormat("$number$");
        prmtCostCenter.setRequired(true);
        try {
            BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)prmtCostCenter, (String)companyOrgID);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        KDTDefaultCellEditor costCenterEditor = new KDTDefaultCellEditor((IKDEditor)prmtCostCenter);
        this.hour.getColumn("costCenter.name").setEditor((ICellEditor)costCenterEditor);
        ObjectValueRender costCenterAvr = new ObjectValueRender();
        costCenterAvr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.hour.getColumn("costCenter.number").setRenderer((IBasicRender)costCenterAvr);
        KDComboBox timeUnit = new KDComboBox();
        timeUnit.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.ncm.bill.TimeUnitEnum").toArray());
        timeUnit.setRequired(true);
        KDTDefaultCellEditor col_typeEditor = new KDTDefaultCellEditor((JComboBox)timeUnit);
        this.hour.getColumn("unit").setEditor((ICellEditor)col_typeEditor);
        KDFormattedTextField colTxtField = new KDFormattedTextField();
        colTxtField.setDataType(1);
        colTxtField.setPrecision(4);
        colTxtField.setRemoveingZeroInDispaly(false);
        colTxtField.setMinimumValue((Comparable)SysConstant.BIGZERO);
        colTxtField.setMaximumValue((Comparable)NCMClientUtils.MAXVAL);
        colTxtField.setSupportedEmpty(true);
        colTxtField.setNegatived(false);
        KDTDefaultCellEditor col_CellEditor = new KDTDefaultCellEditor((JTextField)colTxtField);
        this.hour.getColumn("prepareTime").setEditor((ICellEditor)col_CellEditor);
        this.hour.getColumn("prepareTime").getStyleAttributes().setNumberFormat("%{0.##########}f");
        this.hour.getColumn("processTime").setEditor((ICellEditor)col_CellEditor);
        this.hour.getColumn("processTime").getStyleAttributes().setNumberFormat("%{0.##########}f");
        this.hour.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
                try {
                    OrderReportBillEditUI.this.kdtHour_editStopped(e);
                }
                catch (Exception exc) {
                    OrderReportBillEditUI.this.handUIException(exc);
                }
            }
        });
    }

    private void formatQtyEntryTable() {
        String companyOrgID = null;
        if (this.prmtCompanyOrg.getData() != null) {
            CompanyOrgUnitInfo comOrg = (CompanyOrgUnitInfo)this.prmtCompanyOrg.getData();
            companyOrgID = comOrg.getId().toString();
        }
        KDBizPromptBox prmtActivityQty = new KDBizPromptBox();
        prmtActivityQty.setQueryInfo("com.kingdee.eas.basedata.ncm.app.F7ActivityQuery");
        prmtActivityQty.setEditable(true);
        prmtActivityQty.setDisplayFormat("$number$");
        prmtActivityQty.setEditFormat("$number$");
        prmtActivityQty.setCommitFormat("$number$");
        prmtActivityQty.setRequired(true);
        BDCMClientUtils.filterActivityF7((KDBizPromptBox)prmtActivityQty, (String)companyOrgID);
        KDTDefaultCellEditor activityEditorQty = new KDTDefaultCellEditor((IKDEditor)prmtActivityQty);
        this.qty.getColumn("activity.number").setEditor((ICellEditor)activityEditorQty);
        ObjectValueRender activityAvrQty = new ObjectValueRender();
        activityAvrQty.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.qty.getColumn("activity.number").setRenderer((IBasicRender)activityAvrQty);
        KDBizPromptBox prmtCostCenter = new KDBizPromptBox();
        prmtCostCenter.setQueryInfo("com.kingdee.eas.basedata.org.app.CostCenterItemQuery");
        prmtCostCenter.setEditable(true);
        prmtCostCenter.setDisplayFormat("$name$");
        prmtCostCenter.setEditFormat("$number$");
        prmtCostCenter.setCommitFormat("$number$");
        prmtCostCenter.setRequired(true);
        try {
            BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)prmtCostCenter, (String)companyOrgID);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        KDTDefaultCellEditor costCenterEditor = new KDTDefaultCellEditor((IKDEditor)prmtCostCenter);
        this.qty.getColumn("costCenter.name").setEditor((ICellEditor)costCenterEditor);
        ObjectValueRender costCenterAvr = new ObjectValueRender();
        costCenterAvr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.qty.getColumn("costCenter.number").setRenderer((IBasicRender)costCenterAvr);
        KDBizPromptBox prmtUnit = new KDBizPromptBox();
        prmtUnit.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7MeasureUnitQuery");
        prmtUnit.setEditable(true);
        prmtUnit.setDisplayFormat("$name$");
        prmtUnit.setEditFormat("$number$");
        prmtUnit.setCommitFormat("$number$");
        prmtUnit.setRequired(true);
        KDTDefaultCellEditor unitEditor = new KDTDefaultCellEditor((IKDEditor)prmtUnit);
        this.qty.getColumn("unit").setEditor((ICellEditor)unitEditor);
        ObjectValueRender unitAvr = new ObjectValueRender();
        unitAvr.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.qty.getColumn("unit").setRenderer((IBasicRender)unitAvr);
        KDFormattedTextField colTxtField = new KDFormattedTextField();
        colTxtField.setDataType(1);
        colTxtField.setPrecision(4);
        colTxtField.setRemoveingZeroInDispaly(false);
        colTxtField.setMinimumValue((Comparable)SysConstant.BIGZERO);
        colTxtField.setMaximumValue((Comparable)NCMClientUtils.MAXVAL);
        colTxtField.setSupportedEmpty(true);
        colTxtField.setNegatived(false);
        KDTDefaultCellEditor col_CellEditor = new KDTDefaultCellEditor((JTextField)colTxtField);
        this.qty.getColumn("reportQty").setEditor((ICellEditor)col_CellEditor);
        this.qty.getColumn("reportQty").getStyleAttributes().setNumberFormat("%{0.##########}f");
        this.qty.getColumn("detectQty").setEditor((ICellEditor)col_CellEditor);
        this.qty.getColumn("detectQty").getStyleAttributes().setNumberFormat("%{0.##########}f");
        this.qty.getColumn("qualifiedQty").setEditor((ICellEditor)col_CellEditor);
        this.qty.getColumn("qualifiedQty").getStyleAttributes().setNumberFormat("%{0.##########}f");
        this.qty.getColumn("yieldQty").setEditor((ICellEditor)col_CellEditor);
        this.qty.getColumn("yieldQty").getStyleAttributes().setNumberFormat("%{0.##########}f");
        this.qty.getColumn("scrapQty").setEditor((ICellEditor)col_CellEditor);
        this.qty.getColumn("scrapQty").getStyleAttributes().setNumberFormat("%{0.##########}f");
        this.qty.getColumn("workerScrapQty").setEditor((ICellEditor)col_CellEditor);
        this.qty.getColumn("workerScrapQty").getStyleAttributes().setNumberFormat("%{0.##########}f");
        this.qty.getColumn("steelScrapQty").setEditor((ICellEditor)col_CellEditor);
        this.qty.getColumn("steelScrapQty").getStyleAttributes().setNumberFormat("%{0.##########}f");
        this.qty.getColumn("repairQty").setEditor((ICellEditor)col_CellEditor);
        this.qty.getColumn("repairQty").getStyleAttributes().setNumberFormat("%{0.##########}f");
        this.qty.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
                try {
                    OrderReportBillEditUI.this.kdtQty_editStopped(e);
                }
                catch (Exception exc) {
                    OrderReportBillEditUI.this.handUIException(exc);
                }
            }
        });
    }

    public void kdtHour_editStopped(KDTEditEvent e) throws Exception {
        int row = e.getRowIndex();
        if (e.getValue() instanceof ActivityInfo) {
            ActivityInfo ac = (ActivityInfo)e.getValue();
            this.hour.getCell(row, "activity.name").setValue((Object)ac.getName());
            CostCenterOrgUnitInfo costerCenter = ac.getCostCenter();
            if (costerCenter == null) {
                return;
            }
            String id = costerCenter.getId().toString();
            CostCenterOrgUnitInfo costCenterInfo = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(id));
            if (costCenterInfo == null) {
                return;
            }
            this.hour.getCell(row, "costCenter.number").setValue((Object)costCenterInfo);
            this.hour.getCell(row, "costCenter.name").setValue((Object)costCenterInfo.getName());
            return;
        }
        if (e.getOldValue() instanceof ActivityInfo) {
            this.hour.getCell(row, "activity.name").setValue(null);
            this.hour.getCell(row, "costCenter.number").setValue(null);
            this.hour.getCell(row, "costCenter.name").setValue(null);
            return;
        }
    }

    public void kdtQty_editStopped(KDTEditEvent e) throws Exception {
        int row = e.getRowIndex();
        if (e.getValue() instanceof ActivityInfo) {
            ActivityInfo ac = (ActivityInfo)e.getValue();
            this.qty.getCell(row, "activity.name").setValue((Object)ac.getName());
            CostCenterOrgUnitInfo costerCenter = ac.getCostCenter();
            if (costerCenter == null) {
                return;
            }
            String id = costerCenter.getId().toString();
            CostCenterOrgUnitInfo costCenterInfo = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(id));
            if (costCenterInfo == null) {
                return;
            }
            this.qty.getCell(row, "costCenter.number").setValue((Object)costCenterInfo);
            this.qty.getCell(row, "costCenter.name").setValue((Object)costCenterInfo.getName());
            return;
        }
        if (e.getOldValue() instanceof ActivityInfo) {
            this.qty.getCell(row, "activity.name").setValue(null);
            this.qty.getCell(row, "costCenter.number").setValue(null);
            this.qty.getCell(row, "costCenter.name").setValue(null);
            return;
        }
    }

    public void unauditAction_actionPerformed(ActionEvent e) throws Exception {
        super.unauditAction_actionPerformed(e);
    }

    protected KDTable getDetailTable() {
        if (this.kDTabbedPane.getSelectedIndex() == 1) {
            return this.qty;
        }
        return this.hour;
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return OrderReportBillFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        OrderReportBillInfo objectValue = new OrderReportBillInfo();
        super.applyBillDefaultValue((IObjectValue)objectValue);
        return objectValue;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        if (table.equals(this.hour)) {
            OrderReportBillHourEntryInfo entry = new OrderReportBillHourEntryInfo();
            entry.setPrepareTime(SysConstant.BIGZERO);
            entry.setProcessTime(SysConstant.BIGZERO);
            entry.setUnit(TimeUnitEnum.HOUR);
            return entry;
        }
        if (table.equals(this.qty)) {
            OrderReportBillQtyEntryInfo entry = new OrderReportBillQtyEntryInfo();
            entry.setReportQty(SysConstant.BIGZERO);
            entry.setDetectQty(SysConstant.BIGZERO);
            entry.setQualifiedQty(SysConstant.BIGZERO);
            entry.setYieldQty(SysConstant.BIGZERO);
            entry.setScrapQty(SysConstant.BIGZERO);
            entry.setSteelScrapQty(SysConstant.BIGZERO);
            entry.setWorkerScrapQty(SysConstant.BIGZERO);
            entry.setRepairQty(SysConstant.BIGZERO);
            return entry;
        }
        return null;
    }

    @Override
    protected void prmtManuFacturerOrder_dataChanged(DataChangeEvent e) throws Exception {
        ManufactureOrderInfo manfOrder = (ManufactureOrderInfo)e.getNewValue();
        if (manfOrder == null) {
            return;
        }
        String manfOrderID = manfOrder.getId().toString();
        ManufactureOrderInfo manfOrderAllInfo = ManufactureOrderFactory.getRemoteInstance().getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(manfOrderID));
        String productName = "";
        if (manfOrder.getStorageOrgUnit() != null) {
            String storageID = manfOrder.getStorageOrgUnit().getId().toString();
            StorageOrgUnitInfo storageInfo = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(storageID));
            this.prmtStorageOrgUnit.setValue((Object)storageInfo);
        }
        if (manfOrderAllInfo.getProject() != null) {
            String projactID = manfOrderAllInfo.getProject().getId().toString();
            ProjectInfo projectInfo = ProjectFactory.getRemoteInstance().getProjectInfo((IObjectPK)new ObjectUuidPK(projactID));
            this.prmtPorject.setValue((Object)projectInfo);
        }
        if (manfOrderAllInfo.getTrackNumber() != null) {
            String trackNumberID = manfOrderAllInfo.getTrackNumber().getId().toString();
            TrackNumberInfo trackNumberInfo = TrackNumberFactory.getRemoteInstance().getTrackNumberInfo((IObjectPK)new ObjectUuidPK(trackNumberID));
            this.prmtTrackNumber.setValue((Object)trackNumberInfo);
        }
        if (manfOrderAllInfo.getMaterial() != null) {
            String materialID = manfOrder.getMaterial().getId().toString();
            MaterialInfo materialInfo = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(materialID));
            this.prmtProductNumber.setValue((Object)materialInfo);
            productName = materialInfo.getName();
        }
        this.prmtProductName.setValue((Object)productName);
        this.editData.setOrderNumber(manfOrderAllInfo.getNumber());
        this.editData.setLot(manfOrderAllInfo.getLot());
    }

    protected String[] getValidateColumns() {
        return new String[]{"activity.number", "costCenter.number"};
    }

    protected void checkValidDataForSubmit() throws Exception {
        Object val;
        int i;
        super.checkValidDataForSubmit();
        BDCMClientUtils.checkIsNull((JComponent)this.prmtManuFacturerOrder, (String)this.contManuFacturerOrder.getBoundLabelText());
        int rowCount = this.hour.getRowCount();
        for (i = 0; i < rowCount; ++i) {
            val = this.hour.getCell(i, "activity.number").getValue();
            if (val == null || "".equals(val)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.order.fact.bill.client.OrderBillClientResource", (String)"HourEntry_NO_Activity"));
                SysUtil.abort();
            }
            if ((val = this.hour.getCell(i, "costCenter.number").getValue()) == null || "".equals(val)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.order.fact.bill.client.OrderBillClientResource", (String)"HourEntry_NO_CostCenter"));
                SysUtil.abort();
            }
            if ((val = this.hour.getCell(i, "unit").getValue()) != null && !"".equals(val)) continue;
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.order.fact.bill.client.OrderBillClientResource", (String)"HourEntry_NO_TimeUnit"));
            SysUtil.abort();
        }
        rowCount = this.qty.getRowCount();
        for (i = 0; i < rowCount; ++i) {
            val = this.qty.getCell(i, "activity.number").getValue();
            if (val == null || "".equals(val)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.order.fact.bill.client.OrderBillClientResource", (String)"QtyEntry_NO_Activity"));
                SysUtil.abort();
            }
            if ((val = this.qty.getCell(i, "costCenter.number").getValue()) == null || "".equals(val)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.order.fact.bill.client.OrderBillClientResource", (String)"QtyEntry_NO_CostCenter"));
                SysUtil.abort();
            }
            if ((val = this.qty.getCell(i, "unit").getValue()) != null && !"".equals(val)) continue;
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.order.fact.bill.client.OrderBillClientResource", (String)"QtyEntry_NO_Unit"));
            SysUtil.abort();
        }
    }

    @Override
    protected void isStart() throws Exception {
        CompanyOrgUnitInfo companyInfo = SysContext.getSysContext().getCurrentFIUnit();
        if (companyInfo != null) {
            OrderCMUtils.checkStart(companyInfo.getId().toString());
        }
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        ((ICMBillBase)this.getBizInterface()).logPrint(new OrderReportBillInfo().getBOSType(), "OrderReportBillPrint", (IObjectValue)this.editData);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        ((ICMBillBase)this.getBizInterface()).logPrint(new OrderReportBillInfo().getBOSType(), "OrderReportBillPrint", (IObjectValue)this.editData);
    }

    private void filterOrder(KDBizPromptBox prmtManfOrder, String companyOrgID) throws BOSException, EASBizException {
        IOrgUnitRelation iOUR = OrgUnitRelationFactory.getRemoteInstance();
        OrgUnitCollection ccColl = iOUR.getFromUnit(companyOrgID, 1, 4);
        int ccSize = ccColl.size();
        if (ccSize == 0) {
            MsgBox.showWarning((String)NCMClientUtils.getNcmBillResource((String)"NostorageOrgDelegateThisCompanyOrg"));
            SysUtil.abort();
        }
        HashSet<String> ccIDSet = new HashSet<String>(ccSize);
        for (int i = 0; i < ccSize; ++i) {
            ccIDSet.add(ccColl.get(i).getId().toString());
        }
        EntityViewInfo view = null;
        view = prmtManfOrder.getEntityViewInfo() == null ? new EntityViewInfo() : prmtManfOrder.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", ccIDSet, CompareType.INCLUDE));
        HashSet<Integer> status = new HashSet<Integer>();
        status.add(new Integer(5));
        status.add(new Integer(8));
        status.add(new Integer(7));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", status, CompareType.INCLUDE));
        try {
            filter.mergeFilter(view.getFilter(), "AND");
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        view.setFilter(filter);
        prmtManfOrder.setEntityViewInfo(view);
    }

    private void setDataFormat() throws EASBizException, BOSException {
        String unit = null;
        int rowCount = this.hour.getRowCount();
        BigDecimal factor = new BigDecimal(1);
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            if (this.hour.getCell(rowIndex, "unit").getValue() != null) {
                unit = this.hour.getCell(rowIndex, "unit").getValue().toString();
            }
            ICell cellPreparTime = this.hour.getCell(rowIndex, "prepareTime");
            ICell cellProessTime = this.hour.getCell(rowIndex, "processTime");
            BigDecimal prepareTime = NCMConst.ZERO;
            if (cellPreparTime.getValue() != null) {
                prepareTime = new BigDecimal(cellPreparTime.getValue().toString());
            }
            BigDecimal proessTime = NCMConst.ZERO;
            if (cellProessTime.getValue() != null) {
                proessTime = new BigDecimal(cellProessTime.getValue().toString());
            }
            if (TimeUnitEnum.HOUR.getAlias(this.getLocale()).equals(unit)) {
                factor = new BigDecimal(3600);
            }
            if (TimeUnitEnum.MINUTES.getAlias(this.getLocale()).equals(unit)) {
                factor = new BigDecimal(60);
            }
            if (TimeUnitEnum.SCEOND.getAlias(this.getLocale()).equals(unit)) {
                factor = new BigDecimal(1);
            }
            cellPreparTime.setValue((Object)prepareTime.divide(factor, 10, 3));
            cellProessTime.setValue((Object)proessTime.divide(factor, 10, 3));
        }
    }
}

