/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.bill.TimeUnitEnum;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.ICMBillBase;
import com.kingdee.eas.ncm.common.client.ProgressHintListener;
import com.kingdee.eas.ncm.common.client.ProgressHintUI;
import com.kingdee.eas.ncm.common.utils.NCMConst;
import com.kingdee.eas.ncm.common.utils.client.NCMCommonQueryProcessor;
import com.kingdee.eas.ncm.order.common.utils.OrderCMUtils;
import com.kingdee.eas.ncm.order.fact.bill.IOrderReportBill;
import com.kingdee.eas.ncm.order.fact.bill.OrderBillException;
import com.kingdee.eas.ncm.order.fact.bill.OrderReportBillFactory;
import com.kingdee.eas.ncm.order.fact.bill.OrderReportBillInfo;
import com.kingdee.eas.ncm.order.fact.bill.client.AbstractOrderReportBillListUI;
import com.kingdee.eas.ncm.order.fact.bill.client.OrderReportBillEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.Assert;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class OrderReportBillListUI
extends AbstractOrderReportBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(OrderReportBillListUI.class);
    private CommonQueryDialog dialog = null;

    public OrderReportBillListUI() throws Exception {
        this.actionImportQtyHour.setEnabled(true);
        this.actionImportQtyHour.setVisible(true);
        this.btnImport.setIcon(EASResource.getIcon((String)"imgTbtn_bill"));
    }

    public void onShow() throws Exception {
        super.onShow();
        this.setDataFormat();
        this.dealRender();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.refreshListForOrder();
        this.tblMain.repaint();
    }

    public void refreshListForOrder() throws Exception {
        super.refreshListForOrder();
        this.setDataFormat();
        this.dealRender();
    }

    @Override
    public void actionImportQtyHour_actionPerformed(ActionEvent e) throws Exception {
        CompanyOrgUnitInfo companyOrgInfo = SysContext.getSysContext().getCurrentFIUnit();
        try {
            HashMap<String, CompanyOrgUnitInfo> listenerParam = new HashMap<String, CompanyOrgUnitInfo>();
            listenerParam.put("company", companyOrgInfo);
            genProgressHintListener listener = new genProgressHintListener();
            ProgressHintUI.showProgressHintUI((CoreUIObject)this, (ProgressHintListener)listener, listenerParam);
            String result = listenerParam.get("result").toString();
            if ("Success".equals(result)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.order.fact.bill.client.OrderBillClientResource", (String)"OrderReportBill_ImportData_success"));
                this.actionRefresh_actionPerformed(e);
            }
        }
        catch (CMBillException ce) {
            logger.error((Object)"", (Throwable)ce);
            MsgBox.showInfo((String)ce.getMessage());
            SysUtil.abort();
        }
        catch (OrderBillException oe) {
            logger.error((Object)"", (Throwable)((Object)oe));
            MsgBox.showInfo((String)oe.getMessage());
            SysUtil.abort();
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ncm.order.fact.bill.client.OrderBillClientResource", (String)"OrderReportBill_ImportData_failure"), (String)ex.getMessage(), (int)8188);
            SysUtil.abort();
        }
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        ((ICMBillBase)this.getBizInterface()).logPrint(new OrderReportBillInfo().getBOSType(), "OrderReportBillPrint", null);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        ((ICMBillBase)this.getBizInterface()).logPrint(new OrderReportBillInfo().getBOSType(), "OrderReportBillPrint", null);
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog == null) {
            this.dialog = super.initCommonQueryDialog();
        }
        NCMCommonQueryProcessor cmcq = new NCMCommonQueryProcessor();
        cmcq.set("companyOrg", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        cmcq.set("query", (Object)"orderReportBillQuery");
        this.dialog.setProcessor((IProcessor)cmcq);
        return this.dialog;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return OrderReportBillFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        OrderReportBillInfo objectValue = new OrderReportBillInfo();
        return objectValue;
    }

    protected String getEditUIName() {
        return OrderReportBillEditUI.class.getName();
    }

    protected boolean isFootVisible() {
        return true;
    }

    public String[] getMergeColumnKeys() {
        return new String[]{"number", "billStatus", "bizDate", "calculatePeriod.number", "companyOrg.name", "manufacturer.number", "storageOrgUnit", "project", "trackNumber", "productNumber", "productName"};
    }

    protected boolean isEnableSubmit() {
        return true;
    }

    @Override
    protected void isStart() throws Exception {
        CompanyOrgUnitInfo companyInfo = SysContext.getSysContext().getCurrentFIUnit();
        if (companyInfo != null) {
            OrderCMUtils.checkStart(companyInfo.getId().toString());
        }
    }

    private void setDataFormat() throws EASBizException, BOSException {
        int rowCount = this.tblMain.getRowCount();
        BigDecimal factor = new BigDecimal(1);
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            ICell cell = this.tblMain.getRow(rowIndex).getCell("hourEntries.unit");
            if (cell.getValue() == null) continue;
            if (TimeUnitEnum.HOUR.getValue().equals(cell.getValue().toString())) {
                factor = new BigDecimal(3600);
            }
            if (TimeUnitEnum.MINUTES.getValue().equals(cell.getValue().toString())) {
                factor = new BigDecimal(60);
            }
            if (TimeUnitEnum.SCEOND.getValue().equals(cell.getValue().toString())) {
                factor = new BigDecimal(1);
            }
            ICell cellPrepareTime = this.tblMain.getRow(rowIndex).getCell("hourEntries.prepareTime");
            ICell cellProessTime = this.tblMain.getRow(rowIndex).getCell("hourEntries.proessTime");
            if (cellPrepareTime.getValue() != null) {
                BigDecimal valuePrepareTime = new BigDecimal(cellPrepareTime.getValue().toString());
                cellPrepareTime.setValue((Object)valuePrepareTime.divide(factor, 6, 4));
            }
            if (cellProessTime.getValue() == null) continue;
            BigDecimal valueProessTime = new BigDecimal(cellProessTime.getValue().toString());
            cellProessTime.setValue((Object)valueProessTime.divide(factor, 6, 4));
        }
    }

    private void dealRender() {
        this.tblMain.checkParsed();
        this.tblMain.getColumn("hourEntries.unit").setRenderer((IBasicRender)new ObjectValueRender(){

            public String getText(Object obj) {
                if (obj != null && obj instanceof String) {
                    if ("1".equals((String)obj)) {
                        return TimeUnitEnum.getEnum((String)"1").getAlias();
                    }
                    if ("2".equals((String)obj)) {
                        return TimeUnitEnum.getEnum((String)"2").getAlias();
                    }
                    if ("3".equals((String)obj)) {
                        return TimeUnitEnum.getEnum((String)"3").getAlias();
                    }
                }
                return "";
            }
        });
        this.tblMain.getColumn("qtyEntries.reportQty").setRenderer((IBasicRender)new ObjectValueRender(){

            public String getText(Object obj) {
                if (obj != null && obj instanceof BigDecimal ? NCMConst.ZERO.compareTo((BigDecimal)obj) == 0 : obj == null) {
                    return "";
                }
                return obj.toString();
            }
        });
        this.tblMain.getColumn("qtyEntries.detectQty").setRenderer((IBasicRender)new ObjectValueRender(){

            public String getText(Object obj) {
                if (obj != null && obj instanceof BigDecimal ? NCMConst.ZERO.compareTo((BigDecimal)obj) == 0 : obj == null) {
                    return "";
                }
                return obj.toString();
            }
        });
        this.tblMain.getColumn("qtyEntries.qualifiedQty").setRenderer((IBasicRender)new ObjectValueRender(){

            public String getText(Object obj) {
                if (obj != null && obj instanceof BigDecimal ? NCMConst.ZERO.compareTo((BigDecimal)obj) == 0 : obj == null) {
                    return "";
                }
                return obj.toString();
            }
        });
        this.tblMain.getColumn("qtyEntries.yieldQty").setRenderer((IBasicRender)new ObjectValueRender(){

            public String getText(Object obj) {
                if (obj != null && obj instanceof BigDecimal ? NCMConst.ZERO.compareTo((BigDecimal)obj) == 0 : obj == null) {
                    return "";
                }
                return obj.toString();
            }
        });
        this.tblMain.getColumn("qtyEntries.scrapQty").setRenderer((IBasicRender)new ObjectValueRender(){

            public String getText(Object obj) {
                if (obj != null && obj instanceof BigDecimal ? NCMConst.ZERO.compareTo((BigDecimal)obj) == 0 : obj == null) {
                    return "";
                }
                return obj.toString();
            }
        });
        this.tblMain.getColumn("qtyEntries.workerScrapQty").setRenderer((IBasicRender)new ObjectValueRender(){

            public String getText(Object obj) {
                if (obj != null && obj instanceof BigDecimal ? NCMConst.ZERO.compareTo((BigDecimal)obj) == 0 : obj == null) {
                    return "";
                }
                return obj.toString();
            }
        });
        this.tblMain.getColumn("qtyEntries.steelScrapQty").setRenderer((IBasicRender)new ObjectValueRender(){

            public String getText(Object obj) {
                if (obj != null && obj instanceof BigDecimal ? NCMConst.ZERO.compareTo((BigDecimal)obj) == 0 : obj == null) {
                    return "";
                }
                return obj.toString();
            }
        });
        this.tblMain.getColumn("qtyEntries.repairQty").setRenderer((IBasicRender)new ObjectValueRender(){

            public String getText(Object obj) {
                if (obj != null && obj instanceof BigDecimal ? NCMConst.ZERO.compareTo((BigDecimal)obj) == 0 : obj == null) {
                    return "";
                }
                return obj.toString();
            }
        });
        this.tblMain.getColumn("hourEntries.prepareTime").setRenderer((IBasicRender)new ObjectValueRender(){

            public String getText(Object obj) {
                if (obj != null && obj instanceof BigDecimal ? NCMConst.ZERO.compareTo((BigDecimal)obj) == 0 : obj == null) {
                    return "";
                }
                return obj.toString();
            }
        });
        this.tblMain.getColumn("hourEntries.proessTime").setRenderer((IBasicRender)new ObjectValueRender(){

            public String getText(Object obj) {
                if (obj != null && obj instanceof BigDecimal ? NCMConst.ZERO.compareTo((BigDecimal)obj) == 0 : obj == null) {
                    return "";
                }
                return obj.toString();
            }
        });
    }

    private static final class genProgressHintListener
    implements ProgressHintListener {
        private genProgressHintListener() {
        }

        public void doFunction(Map param) throws Exception {
            Assert.that((boolean)param.containsKey("company"));
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
            try {
                IOrderReportBill ctrl = OrderReportBillFactory.getRemoteInstance();
                String result = ctrl.importFromMM(company);
                param.put("result", result);
            }
            catch (CMBillException ce) {
                throw ce;
            }
            catch (OrderBillException oe) {
                throw oe;
            }
            catch (Exception ex) {
                MsgBox.showError((String)ex.getMessage().split(":")[1]);
            }
        }
    }
}

