/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.cal.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.ncm.order.fact.alloc.client.OCMaterialAllocLogReportUI;
import com.kingdee.eas.ncm.order.fact.bill.client.OrderFeeAllocLogReportUI;
import com.kingdee.eas.ncm.order.fact.cal.client.AbstractOrderCalProject3UI;
import com.kingdee.eas.ncm.order.fact.cal.client.ReportListElement;
import com.kingdee.eas.ncm.order.fact.cal.utils.client.CalcClientUntil;
import com.kingdee.util.Assert;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class OrderCalProject3UI
extends AbstractOrderCalProject3UI {
    private static final Logger logger = CoreUIObject.getLogger(OrderCalProject3UI.class);

    public OrderCalProject3UI() throws Exception {
        this.initUIContentLayout();
    }

    @Override
    protected void btnViewReport_actionPerformed(ActionEvent e) throws Exception {
        super.btnViewReport_actionPerformed(e);
        if (this.lstReportList.getSelectedIndex() == -1) {
            return;
        }
        ReportListElement item = (ReportListElement)this.lstReportList.getElement(this.lstReportList.getSelectedIndex());
        if (item != null) {
            String reportName = item.getReportName();
            Map data = item.getData();
            Assert.that((boolean)data.containsKey("company"));
            Assert.that((boolean)data.containsKey("period"));
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)data.get("company");
            PeriodInfo period = (PeriodInfo)data.get("period");
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("companyId", company.getId().toString());
            param.put("periodId", period.getId().toString());
            param.put("companyName", company.getName());
            param.put("periodNumber", String.valueOf(period.getNumber()));
            if (data.get("logData") != null) {
                param.put("logData", (String)data.get("logData"));
            }
            if (data.get("logDatas") != null) {
                param.put("logDatas", (String)data.get("logDatas"));
            }
            if (reportName.equals(CalcClientUntil.getClientCalcResource("InnerCCAllocErrorReport"))) {
                param.put("feeType", "ccoFee");
                OrderFeeAllocLogReportUI.showAllocReportUI(this, param);
            }
            if (reportName.equals(CalcClientUntil.getClientCalcResource("MatAllocErrorReport"))) {
                param.put("feeType", "matFee");
                OCMaterialAllocLogReportUI.showAllocReportUI(this, param);
            } else if (reportName.equals(CalcClientUntil.getClientCalcResource("ActivityAllocErrorReport"))) {
                param.put("feeType", "activityFee");
                OrderFeeAllocLogReportUI.showAllocReportUI(this, param);
            }
        }
    }

    @Override
    protected void lstReportList_mouseClicked(MouseEvent e) throws Exception {
        super.lstReportList_mouseClicked(e);
        if (e.getClickCount() == 2) {
            this.btnViewReport_actionPerformed(null);
        }
    }

    protected void setState(int state) {
        this.lblUnAlloc.setVisible(state == 1);
        this.lblSuccess.setVisible(state == 2);
        this.lblFail.setVisible(state == 3);
        this.lblSpendTime.setVisible(state != 1);
        if (state == 1) {
            this.lstReportList.removeAllElements();
        }
        this.btnViewReport.setEnabled(state == 3);
        if (state == 3) {
            this.lstReportList.setSelectedIndex(0);
        }
    }
}

