/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ncm.order.fact.cal.OrderCalcFacadeFactory;
import com.kingdee.eas.ncm.order.fact.cal.OrderCalcLogCollection;
import com.kingdee.eas.ncm.order.fact.cal.OrderCalcLogEntryCollection;
import com.kingdee.eas.ncm.order.fact.cal.OrderCalcLogInfo;
import com.kingdee.eas.ncm.order.fact.cal.client.AbstractOrderCalcLogReportUI;
import com.kingdee.eas.ncm.order.fact.cal.client.OrderCalcLogDetailReportUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.Assert;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class OrderCalcLogReportUI
extends AbstractOrderCalcLogReportUI {
    private static final Logger logger = CoreUIObject.getLogger(OrderCalcLogReportUI.class);
    private Map _parentParam = null;
    private String _companyId = null;
    private String _periodId = null;
    private String _companyName = null;
    private String _periodNumber = null;
    private OrderCalcLogCollection _logData = null;

    public static void showCalcReportUI(CoreUIObject ui, Map param) throws Exception {
        Assert.that((boolean)param.containsKey("companyId"));
        Assert.that((boolean)param.containsKey("periodId"));
        Assert.that((boolean)param.containsKey("companyName"));
        Assert.that((boolean)param.containsKey("periodNumber"));
        try {
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put((Object)"param", (Object)param);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(OrderCalcLogReportUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
        }
        catch (BOSException e) {
            SysUtil.abort((Throwable)e);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this._parentParam = (Map)this.getUIContext().get("param");
        this._companyId = (String)this._parentParam.get("companyId");
        this._periodId = (String)this._parentParam.get("periodId");
        this._companyName = (String)this._parentParam.get("companyName");
        this._periodNumber = (String)this._parentParam.get("periodNumber");
        this._logData = this._parentParam.containsKey("logData") ? (OrderCalcLogCollection)((Object)this._parentParam.get("logData")) : OrderCalcFacadeFactory.getRemoteInstance().getOrderCalcLogData(this._companyId, this._periodId);
        this.kDTable.checkParsed();
        this.kDTable.getGroupManager().setGroup(true);
        this.kDTable.getColumn("calcRank").setGroup(true);
        this.kDTable.getColumn("calcRank").setMergeable(true);
        this.kDDatePicker1.setEnabled(false);
        this.loadFields();
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.fillReportData();
    }

    private void fillReportData() {
        this.txtCompany.setText(this._companyName);
        this.txtPeriod.setText(this._periodNumber);
        if (this._logData == null) {
            return;
        }
        boolean isHandle = false;
        for (int i = 0; i < this._logData.size(); ++i) {
            OrderCalcLogInfo item = this._logData.get(i);
            if (!isHandle) {
                this.kDDatePicker1.setValue((Object)item.getCreateTime());
                this.txtLogUser.setText(item.getCreator().getName());
                isHandle = true;
            }
            IRow row = this.kDTable.addRow();
            row.getCell("calcRank").setValue((Object)item.getCalcRank());
            row.getCell("material").setValue((Object)item.getProdDispName());
            row.getCell("order").setValue((Object)item.getOrderNumber());
            row.getCell("storageOrgUnit").setValue((Object)item.getStorageOrgUnitDisp());
            row.getCell("calcItem").setValue((Object)item.getCalcItem());
            row.getCell("status").setValue((Object)item.getStatus());
            row.getCell("attachment").setValue((Object)item.getAttachment());
            row.getCell("logDetail").setValue((Object)item.getEntries());
            if (item.getEntries().size() <= 0) continue;
            row.getStyleAttributes().setBackground(new Color(246, 246, 191));
        }
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.kDTable);
        this.kDTable.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.kDTable);
        this.kDTable.getPrintManager().printPreview();
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
    }

    @Override
    protected void kDTable_tableClicked(KDTMouseEvent e) throws Exception {
        OrderCalcLogEntryCollection item;
        super.kDTable_tableClicked(e);
        if (e.getClickCount() == 2 && e.getColIndex() == this.kDTable.getColumnIndex("attachment") && (item = (OrderCalcLogEntryCollection)((Object)this.kDTable.getCell(e.getRowIndex(), this.kDTable.getColumnIndex("logDetail")).getValue())).size() > 0) {
            HashMap<String, OrderCalcLogEntryCollection> param = new HashMap<String, OrderCalcLogEntryCollection>();
            param.put("logDetail", item);
            OrderCalcLogDetailReportUI.showCalcDetailReportUI((CoreUIObject)this, param);
        }
    }
}

