/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.cal.client;

import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.order.common.utils.OrderCMUtils;
import com.kingdee.eas.ncm.order.fact.alloc.client.OCMaterialAllocLogReportUI;
import com.kingdee.eas.ncm.order.fact.bill.client.OrderFeeAllocLogReportUI;
import com.kingdee.eas.ncm.order.fact.cal.CheckStatusEnum;
import com.kingdee.eas.ncm.order.fact.cal.OrderCheckItemCollection;
import com.kingdee.eas.ncm.order.fact.cal.OrderCheckItemInfo;
import com.kingdee.eas.ncm.order.fact.cal.client.AbstractOrderLogReportPickUI;
import com.kingdee.eas.ncm.order.fact.cal.client.OrderCalcLogReportUI;
import com.kingdee.eas.ncm.order.fact.cal.client.ReportListElement;
import com.kingdee.eas.ncm.order.fact.cal.utils.client.CalcClientUntil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class OrderLogReportPickUI
extends AbstractOrderLogReportPickUI {
    private static final Logger logger = CoreUIObject.getLogger(OrderLogReportPickUI.class);
    private CompanyOrgUnitInfo _company = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(OrgType.Company);
    private PeriodInfo _period = OrderCMUtils.getCurrentPeriod(this._company.getId().toString());

    public OrderLogReportPickUI() throws Exception {
        BDCMClientUtils.checkLoginCompanyOrgIsVirtual();
        NCMClientUtils.checkIsStart_OrderCost();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtCompany.setText(this._company.getName());
        this.txtPeriod.setText(String.valueOf(this._period.getNumber()));
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("companyId", this._company.getId().toString());
        param.put("periodId", this._period.getId().toString());
        param.put("companyName", this._company.getName());
        param.put("periodNumber", String.valueOf(this._period.getNumber()));
        this.lstLogList.removeAllElements();
        this.lstLogList.addElement((Object)new ReportListElement(CalcClientUntil.getClientCalcResource("InnerCCAllocErrorReport"), param));
        this.lstLogList.addElement((Object)new ReportListElement(CalcClientUntil.getClientCalcResource("MatAllocErrorReport"), param));
        this.lstLogList.addElement((Object)new ReportListElement(CalcClientUntil.getClientCalcResource("ActivityAllocErrorReport"), param));
        this.lstLogList.addElement((Object)new ReportListElement(CalcClientUntil.getClientCalcResource("CalWizCalcCheckReport"), param));
        this.lstLogList.addElement((Object)new ReportListElement(CalcClientUntil.getClientCalcResource("CalWizCalcReport"), param));
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
        if (this.lstLogList.getSelectedIndex() == -1) {
            return;
        }
        ReportListElement item = (ReportListElement)this.lstLogList.getElement(this.lstLogList.getSelectedIndex());
        if (item != null) {
            String reportName = item.getReportName();
            Map data = item.getData();
            if (reportName.equals(CalcClientUntil.getClientCalcResource("InnerCCAllocErrorReport"))) {
                data.put("feeType", "ccoFee");
                OrderFeeAllocLogReportUI.showAllocReportUI((CoreUIObject)this, data);
            }
            if (reportName.equals(CalcClientUntil.getClientCalcResource("MatAllocErrorReport"))) {
                data.put("feeType", "matFee");
                OCMaterialAllocLogReportUI.showAllocReportUI((CoreUIObject)this, data);
            } else if (reportName.equals(CalcClientUntil.getClientCalcResource("ActivityAllocErrorReport"))) {
                data.put("feeType", "activityFee");
                OrderFeeAllocLogReportUI.showAllocReportUI((CoreUIObject)this, data);
            } else if (reportName.equals(CalcClientUntil.getClientCalcResource("CalWizCalcCheckReport"))) {
                String companyOrgID = this._company.getId().toString();
                OrderCheckItemCollection aOrderCheckItemCollection = null;
                aOrderCheckItemCollection = new OrderCheckItemCollection();
                StringBuffer kSql = new StringBuffer();
                kSql.append(" select * ");
                kSql.append(" from t_ncm_OrderCheckItem ");
                kSql.append(" where (FCompanyID = '" + companyOrgID + "' or FCompanyID = '' or FCompanyID is null)");
                kSql.append(" order by FSeq asc");
                String locale = SysContext.getSysContext().getLocale().toString();
                IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)kSql.toString()).executeSQL();
                while (rs.next()) {
                    OrderCheckItemInfo info = new OrderCheckItemInfo();
                    info.setId(BOSUuid.read((String)rs.getString("FID")));
                    info.setCheckStatus(CheckStatusEnum.getEnum(rs.getString("FCheckStatus")));
                    info.setIsNeed(rs.getBoolean("FIsNeed"));
                    info.setSeq(rs.getInt("FSeq"));
                    info.setCalcHMSString(rs.getString("FCalcHMSString"));
                    info.setStartDateTime(rs.getTimestamp("FStartDateTime"));
                    info.setEndDateTime(rs.getTimestamp("FEndDateTime"));
                    info.setCompanyID(rs.getString("FCompanyID"));
                    info.setDescription(rs.getString("FDescription_" + locale));
                    aOrderCheckItemCollection.add(info);
                }
                OrderCheckItemCollection temp = new OrderCheckItemCollection();
                HashMap<String, OrderCheckItemInfo> checkItems = new HashMap<String, OrderCheckItemInfo>();
                for (int i = 0; i < aOrderCheckItemCollection.size(); ++i) {
                    OrderCheckItemInfo checkItem = aOrderCheckItemCollection.get(i);
                    String seq = String.valueOf(checkItem.getSeq());
                    if (checkItems.containsKey(seq)) {
                        if (checkItem.getCompanyID() == null || checkItem.getCompanyID().equals("")) continue;
                        temp.remove((OrderCheckItemInfo)checkItems.get(seq));
                        checkItems.put(seq, checkItem);
                        temp.add(checkItem);
                        continue;
                    }
                    checkItems.put(seq, checkItem);
                    temp.add(checkItem);
                }
                aOrderCheckItemCollection = temp;
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"OrderCheckItemCollection", (Object)aOrderCheckItemCollection);
                uiContext.put((Object)"companyOrgUnitInfo", (Object)this._company);
                uiContext.put((Object)"periodInfo", (Object)this._period);
                IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                IUIWindow window = uiFactory.create("com.kingdee.eas.ncm.order.fact.cal.client.OrderCheckResultUI", (Map)uiContext, null);
                window.show();
            } else if (reportName.equals(CalcClientUntil.getClientCalcResource("CalWizCalcReport"))) {
                OrderCalcLogReportUI.showCalcReportUI((CoreUIObject)this, data);
            }
        }
    }

    @Override
    protected void lstLogList_mouseClicked(MouseEvent e) throws Exception {
        super.lstLogList_mouseClicked(e);
        if (e.getClickCount() == 2) {
            this.actionView_actionPerformed(null);
        }
    }
}

