/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CostItemCollection;
import com.kingdee.eas.basedata.assistant.CostItemFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.ncm.ActivityCollection;
import com.kingdee.eas.basedata.ncm.ActivityFactory;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.ncm.cal.report.client.BizPromptFilterElement;
import com.kingdee.eas.ncm.cal.report.client.SpinnerFilterElement;
import com.kingdee.eas.ncm.common.utils.SpinnerUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.order.common.utils.OrderCMUtils;
import com.kingdee.eas.ncm.order.fact.report.client.AbstractOCActivityCostStatReportFilterUI;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import javax.swing.JSpinner;
import org.apache.log4j.Logger;

public class OCActivityCostStatReportFilterUI
extends AbstractOCActivityCostStatReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(OCActivityCostStatReportFilterUI.class);
    private PeriodInfo startPeriod = null;
    private PeriodInfo period = null;
    private PeriodInfo maxPeriod = null;
    private CustomerParams cp = null;

    public OCActivityCostStatReportFilterUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
        OrderCMUtils.checkStart(SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        CompanyOrgUnitInfo companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        this.prmtCompanyOrg.setValue((Object)companyOrg);
        this.period = OrderCMUtils.getCurrentPeriod(companyOrg.getId().toString());
        this.startPeriod = OrderCMUtils.getStartPeriod(companyOrg.getId().toString());
        this.maxPeriod = OrderCMUtils.getMaxPeriod(companyOrg, this.period);
        BDCMClientUtils.setBizOrgF7ByType((KDBizPromptBox)this.prmtCompanyOrg, (OrgType)OrgType.Company);
        BDCMClientUtils.filterOrderF7((KDBizPromptBox)this.prmtManufacturerOrderFrom, (String)companyOrg.getId().toString(), (BillBaseStatusEnum[])new BillBaseStatusEnum[]{BillBaseStatusEnum.AUDITED, BillBaseStatusEnum.COMPLETE, BillBaseStatusEnum.CLOSED, BillBaseStatusEnum.RELEASED});
        BDCMClientUtils.filterOrderF7((KDBizPromptBox)this.prmtManufacturerOrderTo, (String)companyOrg.getId().toString(), (BillBaseStatusEnum[])new BillBaseStatusEnum[]{BillBaseStatusEnum.AUDITED, BillBaseStatusEnum.COMPLETE, BillBaseStatusEnum.CLOSED, BillBaseStatusEnum.RELEASED});
        BDCMClientUtils.filterF7((KDBizPromptBox)this.prmtProductFrom, (String)"company.id", (Object)companyOrg.getId().toString());
        BDCMClientUtils.filterF7((KDBizPromptBox)this.prmtProductTo, (String)"company.id", (Object)companyOrg.getId().toString());
        BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)this.prmtCostCenterFrom, (String)companyOrg.getId().toString());
        BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)this.prmtCostCenterTo, (String)companyOrg.getId().toString());
        FilterInfo costItemFilterInfo = this.getCostItemFilter();
        this.setFilterInfoF7(this.prmtCostItemFrom, costItemFilterInfo);
        this.setFilterInfoF7(this.prmtCostItemTo, costItemFilterInfo);
        OCActivityCostStatReportFilterUI.setF7CostItem(this.prmtCostItemFrom, new Integer("2"));
        OCActivityCostStatReportFilterUI.setF7CostItem(this.prmtCostItemTo, new Integer("2"));
        CompositeFilterElement elements = new CompositeFilterElement(0);
        BizPromptFilterElement filterElement = new BizPromptFilterElement("companyorg", this.prmtCompanyOrg);
        filterElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"183_CCFeeTotalReportFilterUI")));
        elements.add((FilterElement)filterElement);
        SpinnerFilterElement element = new SpinnerFilterElement("yearFrom", (Component)this.spYearFrom);
        elements.add((FilterElement)element);
        element = new SpinnerFilterElement("periodFrom", (Component)this.spPeriodFrom);
        elements.add((FilterElement)element);
        element = new SpinnerFilterElement("yearTo", (Component)this.spYearTo);
        elements.add((FilterElement)element);
        element = new SpinnerFilterElement("periodTo", (Component)this.spPeriodTo);
        elements.add((FilterElement)element);
        elements.add((FilterElement)new SingleFilterElement("manufacturerOrderFrom", (Component)this.prmtManufacturerOrderFrom));
        elements.add((FilterElement)new SingleFilterElement("manufacturerOrderTo", (Component)this.prmtManufacturerOrderTo));
        elements.add((FilterElement)new SingleFilterElement("productFrom", (Component)this.prmtProductFrom));
        elements.add((FilterElement)new SingleFilterElement("productTo", (Component)this.prmtProductTo));
        elements.add((FilterElement)new SingleFilterElement("costcenterFrom", (Component)this.prmtCostCenterFrom));
        elements.add((FilterElement)new SingleFilterElement("costcenterTo", (Component)this.prmtCostCenterTo));
        elements.add((FilterElement)new SingleFilterElement("costitemFrom", (Component)this.prmtCostItemFrom));
        elements.add((FilterElement)new SingleFilterElement("costitemTo", (Component)this.prmtCostItemTo));
        BDCMClientUtils.filterActivityF7((KDBizPromptBox)this.prmtActivityFrom, (String)companyOrg.getId().toString());
        BDCMClientUtils.filterActivityF7((KDBizPromptBox)this.prmtActivityTo, (String)companyOrg.getId().toString());
        elements.add((FilterElement)new SingleFilterElement("activityFrom", (Component)this.prmtActivityFrom));
        elements.add((FilterElement)new SingleFilterElement("activityTo", (Component)this.prmtActivityTo));
        this.getFilterManager().setElement((FilterElement)elements);
    }

    protected void setDefaultValue() {
        CompanyOrgUnitInfo companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        this.prmtCompanyOrg.setValue((Object)companyOrg);
        BDCMClientUtils.setBizOrgF7ByType((KDBizPromptBox)this.prmtCompanyOrg, (OrgType)OrgType.Company);
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.period, (JSpinner)this.spYearFrom, (JSpinner)this.spPeriodFrom, (PeriodInfo)this.period, (JSpinner)this.spYearTo, (JSpinner)this.spPeriodTo, (PeriodInfo)this.period);
        this.prmtManufacturerOrderFrom.setValue(null);
        this.prmtManufacturerOrderTo.setValue(null);
        this.prmtProductFrom.setValue(null);
        this.prmtProductTo.setValue(null);
        this.prmtCostCenterFrom.setValue(null);
        this.prmtCostCenterTo.setValue(null);
        this.prmtCostItemFrom.setValue(null);
        this.prmtCostItemTo.setValue(null);
        this.prmtActivityFrom.setValue(null);
        this.prmtActivityTo.setValue(null);
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        CompanyOrgUnitInfo companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        this.prmtCompanyOrg.setValue((Object)companyOrg);
        CustomerParams params = this.cp;
        if (params != null) {
            this.loadPeriod(params);
            this.loadManufacturerOrder(params);
            this.loadProduct(params);
            this.loadCostCenter(params);
            this.loadCostItem(params);
            this.loadActivity(params);
        }
    }

    private void loadCostItem(CustomerParams params) {
        String costItemFrom = "";
        String costItemTo = "";
        if (params.getCustomerParam("prmtCostItemFrom") != null) {
            costItemFrom = params.getCustomerParam("prmtCostItemFrom");
        }
        if (params.getCustomerParam("prmtCostItemTo") != null) {
            costItemTo = params.getCustomerParam("prmtCostItemTo");
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costItemFrom));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costItemTo));
            filter.setMaskString("#0 or #1");
            try {
                FilterInfo costItemFilterInfo = this.getCostItemFilter();
                costItemFilterInfo.mergeFilter(filter, "and");
                view.setFilter(costItemFilterInfo);
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
            CostItemCollection costItemColl = CostItemFactory.getRemoteInstance().getCostItemCollection(view);
            if (costItemColl != null && costItemColl.size() > 0) {
                if (costItemColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (costItemColl.get(i).getNumber().equals(costItemFrom)) {
                            this.prmtCostItemFrom.setData((Object)costItemColl.get(i));
                            continue;
                        }
                        this.prmtCostItemTo.setData((Object)costItemColl.get(i));
                    }
                } else if (costItemColl.size() == 1) {
                    if (costItemColl.get(0).getNumber().equals(costItemFrom)) {
                        this.prmtCostItemFrom.setData((Object)costItemColl.get(0));
                    }
                    if (costItemColl.get(0).getNumber().equals(costItemTo)) {
                        this.prmtCostItemTo.setData((Object)costItemColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.prmtCostItemFrom.setData(null);
            this.prmtCostItemTo.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadProduct(CustomerParams params) {
        String productFrom = "";
        String productTo = "";
        if (params.getCustomerParam("prmtProductFrom") != null) {
            productFrom = params.getCustomerParam("prmtProductFrom");
        }
        if (params.getCustomerParam("prmtProductTo") != null) {
            productTo = params.getCustomerParam("prmtProductTo");
        }
        try {
            String companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
            String oql = "select mateial.id, mateial.name, mateial.number ";
            oql = oql + "where (mateial.number ='" + productFrom + "' or mateial.number = '" + productTo + "') ";
            oql = oql + "AND company = '" + companyId + "'";
            MaterialCompanyInfoCollection materialColl = MaterialCompanyInfoFactory.getRemoteInstance().getMaterialCompanyInfoCollection(oql);
            if (materialColl != null && materialColl.size() > 0) {
                if (materialColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (materialColl.get(i).getMateial().getNumber().equals(productFrom)) {
                            this.prmtProductFrom.setData((Object)materialColl.get(i).getMateial());
                            continue;
                        }
                        this.prmtProductTo.setData((Object)materialColl.get(i).getMateial());
                    }
                } else if (materialColl.size() == 1) {
                    if (materialColl.get(0).getMateial().getNumber().equals(productFrom)) {
                        this.prmtProductFrom.setData((Object)materialColl.get(0).getMateial());
                    }
                    if (materialColl.get(0).getMateial().getNumber().equals(productTo)) {
                        this.prmtProductTo.setData((Object)materialColl.get(0).getMateial());
                    }
                }
            }
        }
        catch (BOSException e) {
            this.prmtProductFrom.setData(null);
            this.prmtProductTo.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadCostCenter(CustomerParams params) {
        String costCenterFrom = "";
        String costCenterTo = "";
        if (params.getCustomerParam("prmtCostCenterFrom") != null) {
            costCenterFrom = params.getCustomerParam("prmtCostCenterFrom");
        }
        if (params.getCustomerParam("prmtCostCenterTo") != null) {
            costCenterTo = params.getCustomerParam("prmtCostCenterTo");
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costCenterFrom));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costCenterTo));
            view.setFilter(filter);
            view.getFilter().setMaskString("#0 or #1");
            CostCenterOrgUnitCollection costCenterColl = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitCollection(view);
            if (costCenterColl != null && costCenterColl.size() > 0) {
                if (costCenterColl.size() == 2) {
                    this.prmtCostCenterFrom.setData((Object)costCenterColl.get(0));
                    this.prmtCostCenterTo.setData((Object)costCenterColl.get(1));
                } else if (costCenterColl.size() == 1) {
                    if (costCenterColl.get(0).getNumber().equals(costCenterFrom)) {
                        this.prmtCostCenterFrom.setData((Object)costCenterColl.get(0));
                    }
                    if (costCenterColl.get(0).getNumber().equals(costCenterTo)) {
                        this.prmtCostCenterTo.setData((Object)costCenterColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.prmtCostCenterFrom.setData(null);
            this.prmtCostCenterTo.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadManufacturerOrder(CustomerParams params) {
        String manufacturerOrderFrom = "";
        String manufacturerOrderTo = "";
        if (params.getCustomerParam("prmtManufacturerOrderFrom") != null) {
            manufacturerOrderFrom = params.getCustomerParam("prmtManufacturerOrderFrom");
        }
        if (params.getCustomerParam("prmtManufacturerOrderTo") != null) {
            manufacturerOrderTo = params.getCustomerParam("prmtManufacturerOrderTo");
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)manufacturerOrderFrom));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)manufacturerOrderTo));
            view.setFilter(filter);
            view.getFilter().setMaskString("#0 or #1");
            ManufactureOrderCollection manufactureOrderCenterColl = ManufactureOrderFactory.getRemoteInstance().getManufactureOrderCollection(view);
            if (manufactureOrderCenterColl != null && manufactureOrderCenterColl.size() > 0) {
                if (manufactureOrderCenterColl.size() == 2) {
                    this.prmtManufacturerOrderFrom.setData((Object)manufactureOrderCenterColl.get(0));
                    this.prmtManufacturerOrderTo.setData((Object)manufactureOrderCenterColl.get(1));
                } else if (manufactureOrderCenterColl.size() == 1) {
                    if (manufactureOrderCenterColl.get(0).getNumber().equals(manufacturerOrderFrom)) {
                        this.prmtManufacturerOrderFrom.setData((Object)manufactureOrderCenterColl.get(0));
                    }
                    if (manufactureOrderCenterColl.get(0).getNumber().equals(manufacturerOrderTo)) {
                        this.prmtManufacturerOrderTo.setData((Object)manufactureOrderCenterColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.prmtManufacturerOrderFrom.setData(null);
            this.prmtManufacturerOrderTo.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadActivity(CustomerParams params) {
        String activityFrom = "";
        String activityTo = "";
        if (params.getCustomerParam("prmtActivityFrom") != null) {
            activityFrom = params.getCustomerParam("prmtActivityFrom");
        }
        if (params.getCustomerParam("prmtActivityTo") != null) {
            activityTo = params.getCustomerParam("prmtActivityTo");
        }
        CompanyOrgUnitInfo companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        try {
            String oql = "select id, name, number ";
            oql = oql + "where (number ='" + activityFrom + "' or number = '" + activityTo + "') ";
            oql = oql + "AND company = '" + companyOrg.getId().toString() + "'";
            ActivityCollection activityColl = ActivityFactory.getRemoteInstance().getActivityCollection(oql);
            if (activityColl != null && activityColl.size() > 0) {
                if (activityColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (activityColl.get(i).getNumber().equals(activityFrom)) {
                            this.prmtActivityFrom.setData((Object)activityColl.get(i));
                            continue;
                        }
                        this.prmtActivityTo.setData((Object)activityColl.get(i));
                    }
                } else if (activityColl.size() == 1) {
                    if (activityColl.get(0).getNumber().equals(activityFrom)) {
                        this.prmtActivityFrom.setData((Object)activityColl.get(0));
                    }
                    if (activityColl.get(0).getNumber().equals(activityTo)) {
                        this.prmtActivityTo.setData((Object)activityColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.prmtActivityFrom.setData(null);
            this.prmtActivityTo.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadPeriod(CustomerParams params) {
        PeriodInfo initPeriodFrom = this.period;
        PeriodInfo initPeriodTo = this.period;
        String initYearFrom = params.getCustomerParam("spYearFrom");
        String initMonthFrom = params.getCustomerParam("spPeriodFrom");
        String initYearTo = params.getCustomerParam("spYearTo");
        String initMonthTo = params.getCustomerParam("spPeriodTo");
        try {
            if (!StringUtils.isEmpty((String)initYearFrom) && !StringUtils.isEmpty((String)initMonthFrom)) {
                initPeriodFrom = new PeriodInfo();
                initPeriodFrom.setPeriodYear(Integer.parseInt(initYearFrom));
                initPeriodFrom.setPeriodNumber(Integer.parseInt(initMonthFrom));
            }
            if (!StringUtils.isEmpty((String)initYearTo) && !StringUtils.isEmpty((String)initMonthTo)) {
                initPeriodTo = new PeriodInfo();
                initPeriodTo.setPeriodYear(Integer.parseInt(initYearTo));
                initPeriodTo.setPeriodNumber(Integer.parseInt(initMonthTo));
            }
        }
        catch (Exception e) {
            initPeriodFrom = null;
            initPeriodTo = null;
            logger.error((Object)"", (Throwable)e);
        }
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.period, (JSpinner)this.spYearFrom, (JSpinner)this.spPeriodFrom, (PeriodInfo)initPeriodFrom, (JSpinner)this.spYearTo, (JSpinner)this.spPeriodTo, (PeriodInfo)initPeriodTo);
    }

    public boolean verify() {
        Integer yearFrom = (Integer)this.spYearFrom.getValue();
        Integer yearTo = (Integer)this.spYearTo.getValue();
        if (yearTo.compareTo(yearFrom) < 0) {
            MsgBox.showInfo((String)"\u7ed3\u675f\u671f\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f00\u59cb\u671f\u95f4\u3002");
            return false;
        }
        if (yearTo.compareTo(yearFrom) == 0) {
            Integer periodFrom = (Integer)this.spPeriodFrom.getValue();
            Integer periodTo = (Integer)this.spPeriodTo.getValue();
            if (periodTo.compareTo(periodFrom) < 0) {
                MsgBox.showInfo((String)"\u7ed3\u675f\u671f\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f00\u59cb\u671f\u95f4.");
                return false;
            }
        }
        return super.verify();
    }

    private void setFilterInfoF7(KDBizPromptBox f7, FilterInfo filter) {
        EntityViewInfo view = f7.getEntityViewInfo() != null ? f7.getEntityViewInfo() : new EntityViewInfo();
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    protected IObjectPK getBizCUPK() {
        Object object = this.getUIContext().get(this.getMainBizOrgType());
        CtrlUnitInfo currentBizOrg = object == null ? SysContext.getSysContext().getCurrentCtrlUnit() : (OrgUnitInfo)object;
        return new ObjectUuidPK(currentBizOrg.getCU().getId());
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getAdminCUFieldName() {
        return "adminCU.id";
    }

    protected FilterInfo getCostItemFilter() throws Exception {
        return CostItemFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), this.getKeyFieldName(), this.getAdminCUFieldName());
    }

    public static void setF7CostItem(KDBizPromptBox bizBox, Integer itemType) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.appendFilterItem("ItemType", (Object)itemType);
        filterInfo.setMaskString("#0");
        viewInfo.setFilter(filterInfo);
        bizBox.setHasCUDefaultFilter(false);
        bizBox.setEntityViewInfo(viewInfo);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompanyOrg;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }
}

