/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.order.common.utils.OrderCMUtils;
import com.kingdee.eas.ncm.order.fact.report.client.AbstractOCActivityHourCostReportFilterUI;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeCollection;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeFactory;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeInfo;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class OCActivityHourCostReportFilterUI
extends AbstractOCActivityHourCostReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(OCActivityHourCostReportFilterUI.class);
    private CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
    private String companyId = this.company.getId().toString();
    protected boolean isNormal = true;
    private Set storageOrgUnitIds = null;
    private CustomerParams cp = null;
    private FilterInfo costTypeBaseFilter = null;
    private FilterInfo orderBaseFilter = null;

    public OCActivityHourCostReportFilterUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
        OrderCMUtils.checkStart(SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        this.prmtCostType.setQueryInfo("com.kingdee.eas.ncm.order.std.basedata.app.CostTypeQuery");
        this.prmtCostType.setEditable(true);
        this.prmtCostType.setRequired(true);
        this.prmtCostType.setDisplayFormat("$name$");
        this.prmtCostType.setEditFormat("$number$");
        this.prmtCostType.setCommitFormat("$number$");
        FilterInfo costTypeBaseFilter = this.getCostTypeBaseFilter();
        this.setFilterInfoF7(this.prmtCostType, costTypeBaseFilter);
        this.prmtOrder.setQueryInfo("com.kingdee.eas.mm.mo.app.F7ManufactureOrderQuery");
        this.prmtOrder.setVisible(true);
        this.prmtOrder.setEditable(true);
        this.prmtOrder.setDisplayFormat("$number$");
        this.prmtOrder.setEditFormat("$number$");
        this.prmtOrder.setCommitFormat("$number$");
        this.prmtOrder.setEnabledMultiSelection(true);
        FilterInfo orderBaseFilter = this.getOrderBaseFilter();
        this.setFilterInfoF7(this.prmtOrder, orderBaseFilter);
        for (int i = 0; i < 7; ++i) {
            this.combOrderStatus.removeItemAt(0);
        }
        this.combOrderStatus.removeItemAt(2);
        this.combOrderStatus.removeItemAt(4);
        this.combOrderStatus.removeItemAt(4);
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)new SingleBizPromptFilterElement("company", this.prmtCompany));
        elements.add((FilterElement)new SingleBizPromptFilterElement("costType", this.prmtCostType));
        elements.add((FilterElement)new SingleFilterElement("order", (Component)this.prmtOrder));
        elements.add((FilterElement)new SingleFilterElement("billStatus", (Component)this.combOrderStatus));
        this.getFilterManager().setElement((FilterElement)elements);
    }

    private Set getStorageOrgUnitIds() throws EASBizException, BOSException {
        if (this.storageOrgUnitIds == null) {
            this.storageOrgUnitIds = BDCMUtils.getStorageOrgUnitIdsOfCompany(null, (String)this.companyId);
        }
        return this.storageOrgUnitIds;
    }

    protected void setDefaultValue() {
        this.prmtCompany.setValue((Object)this.company);
        String sql = "select * where company.id = '" + this.company.getId().toString() + "' and number = '" + "STD_001" + "'";
        try {
            CostTypeInfo costTypeInfo = CostTypeFactory.getRemoteInstance().getCostTypeInfo(sql);
            this.prmtCostType.setValue((Object)costTypeInfo);
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        this.prmtOrder.setValue(null);
        this.combOrderStatus.setSelectedIndex(2);
    }

    private void setFilterInfoF7(KDBizPromptBox f7, FilterInfo filter) {
        EntityViewInfo view = f7.getEntityViewInfo() != null ? f7.getEntityViewInfo() : new EntityViewInfo();
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    private FilterInfo getCostTypeBaseFilter() {
        if (this.costTypeBaseFilter == null) {
            this.costTypeBaseFilter = new FilterInfo();
            this.costTypeBaseFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyId));
            this.costTypeBaseFilter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(4)));
            FilterInfo filterStd = new FilterInfo();
            filterStd.getFilterItems().add(new FilterItemInfo("number", (Object)"STD_001"));
            filterStd.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyId));
            try {
                this.costTypeBaseFilter.mergeFilter(filterStd, "OR");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        return (FilterInfo)this.costTypeBaseFilter.clone();
    }

    protected FilterInfo getOrderBaseFilter() throws Exception {
        if (this.orderBaseFilter == null) {
            this.orderBaseFilter = new FilterInfo();
            Set storageOrgUnitIds = this.getStorageOrgUnitIds();
            this.orderBaseFilter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitIds, CompareType.INCLUDE));
            HashSet<Integer> set = new HashSet<Integer>();
            set.add(new Integer(4));
            set.add(new Integer(5));
            set.add(new Integer(7));
            set.add(new Integer(8));
            set.add(new Integer(11));
            this.orderBaseFilter.getFilterItems().add(new FilterItemInfo("baseStatus", set, CompareType.INCLUDE));
        }
        return (FilterInfo)this.orderBaseFilter.clone();
    }

    protected IObjectPK getBizCUPK() {
        Object object = this.getUIContext().get(this.getMainBizOrgType());
        CtrlUnitInfo currentBizOrg = object == null ? SysContext.getSysContext().getCurrentCtrlUnit() : (OrgUnitInfo)object;
        return new ObjectUuidPK(currentBizOrg.getCU().getId());
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
    }

    public void clear() {
        this.getFilterManager().clearAll();
        this.setDefaultValue();
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompany;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    public boolean verify() {
        Object temp = this.prmtCostType.getValue();
        if (temp == null || !(temp instanceof CostTypeInfo)) {
            MsgBox.showInfo((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u7c7b\u578b\u3002");
            return false;
        }
        return true;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        this.prmtCompany.setValue((Object)this.company);
        CustomerParams params = this.cp;
        if (params != null) {
            this.loadCostType(params);
            this.loadOrder(params);
        }
    }

    private void loadCostType(CustomerParams params) {
        this.prmtCostType.setData(null);
        String costType = "";
        if (params.getCustomerParam("prmtCostType") != null) {
            costType = params.getCustomerParam("prmtCostType");
        }
        if (StringUtils.isEmpty((String)costType)) {
            return;
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costType));
            FilterInfo costTypeBaseFilter = this.getCostTypeBaseFilter();
            filter.mergeFilter(costTypeBaseFilter, "and");
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            view.setSelector(sic);
            CostTypeCollection coll = CostTypeFactory.getRemoteInstance().getCostTypeCollection(view);
            if (coll != null && coll.size() > 0) {
                this.prmtCostType.setValue((Object)coll.get(0));
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadOrder(CustomerParams params) {
        this.prmtOrder.setData(null);
        String order = "";
        if (params.getCustomerParam("prmtOrder") != null) {
            order = params.getCustomerParam("prmtOrder");
        }
        String[] numbers = order.split(";");
        HashSet<String> numbersSet = new HashSet<String>();
        for (int i = 0; i < numbers.length; ++i) {
            numbersSet.add(numbers[i].trim());
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", numbersSet, CompareType.INCLUDE));
            FilterInfo orderBaseFilter = this.getOrderBaseFilter();
            filter.mergeFilter(orderBaseFilter, "and");
            view.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("number");
            selector.add("name");
            view.setSelector(selector);
            ManufactureOrderCollection coll = ManufactureOrderFactory.getRemoteInstance().getManufactureOrderCollection(view);
            if (coll != null && coll.size() > 0) {
                int size = coll.size();
                ManufactureOrderInfo[] orders = new ManufactureOrderInfo[size];
                for (int i = 0; i < size; ++i) {
                    orders[i] = coll.get(i);
                }
                this.prmtOrder.setData((Object)orders);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    static class SingleBizPromptFilterElement
    extends SingleFilterElement {
        KDBizPromptBox prmt;

        public SingleBizPromptFilterElement(String id, KDBizPromptBox component) {
            super(id, (Component)component);
            this.prmt = component;
        }

        public void addRptParams(RptParams cp) {
            Object object = this.prmt.getValue();
            if (object == null) {
                try {
                    this.prmt.commitEdit();
                }
                catch (ParseException e) {
                    logger.error((Object)"", (Throwable)e);
                }
                object = this.prmt.getValue();
            }
            if (object instanceof Object[]) {
                object = ((Object[])object)[0];
            }
            cp.setObject(this.getId(), object);
        }
    }
}

