/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.order.common.utils.OrderCMUtils;
import com.kingdee.eas.ncm.order.fact.report.client.AbstractOCCostCenterFeeDiffReportFilterUI;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeCollection;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeFactory;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeInfo;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.text.ParseException;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class OCCostCenterFeeDiffReportFilterUI
extends AbstractOCCostCenterFeeDiffReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(OCCostCenterFeeDiffReportFilterUI.class);
    private CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
    private String companyId = this.company.getId().toString();
    protected boolean isNormal = true;
    private CustomerParams cp = null;
    private FilterInfo costTypeBaseFilter = null;
    private PeriodInfo period = null;
    private PeriodInfo startPeriod = null;
    private FilterInfo periodBaseFilter = null;

    public OCCostCenterFeeDiffReportFilterUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
        OrderCMUtils.checkStart(SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        this.period = OrderCMUtils.getCurrentPeriod(this.companyId);
        this.startPeriod = OrderCMUtils.getStartPeriod(this.companyId);
        this.prmtCostType.setQueryInfo("com.kingdee.eas.ncm.order.std.basedata.app.CostTypeQuery");
        this.prmtCostType.setEditable(true);
        this.prmtCostType.setRequired(true);
        this.prmtCostType.setDisplayFormat("$name$");
        this.prmtCostType.setEditFormat("$number$");
        this.prmtCostType.setCommitFormat("$number$");
        FilterInfo costTypeBaseFilter = this.getCostTypeBaseFilter();
        this.setFilterInfoF7(this.prmtCostType, costTypeBaseFilter);
        this.prmtCostCenter.setVisible(true);
        this.prmtCostCenter.setEditable(true);
        this.prmtCostCenter.setDisplayFormat("$name$");
        this.prmtCostCenter.setEditFormat("$number$");
        this.prmtCostCenter.setCommitFormat("$number$");
        this.prmtCostCenter.setEnabledMultiSelection(true);
        BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)this.prmtCostCenter, (String)this.company.getId().toString());
        this.prmtPeriod.setVisible(true);
        this.prmtPeriod.setEditable(true);
        this.prmtPeriod.setRequired(true);
        this.prmtPeriod.setDisplayFormat("$periodYear$\u5e74$periodNumber$\u671f");
        this.prmtPeriod.setEditFormat("$number$");
        FilterInfo periodBaseFilter = this.getPeriodBaseFilter();
        this.setFilterInfoF7(this.prmtPeriod, periodBaseFilter);
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)new SingleBizPromptFilterElement("company", this.prmtCompany));
        elements.add((FilterElement)new SingleFilterElement("costType", (Component)this.prmtCostType));
        elements.add((FilterElement)new SingleFilterElement("costCenter", (Component)this.prmtCostCenter));
        elements.add((FilterElement)new PeriodFilterElement("period", this.prmtPeriod));
        this.getFilterManager().setElement((FilterElement)elements);
    }

    protected void setDefaultValue() {
        this.prmtCompany.setValue((Object)this.company);
        String sql = "select * where company.id = '" + this.company.getId().toString() + "' and number = '" + "STD_001" + "'";
        try {
            CostTypeInfo costTypeInfo = CostTypeFactory.getRemoteInstance().getCostTypeInfo(sql);
            this.prmtCostType.setValue((Object)costTypeInfo);
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        this.prmtCostCenter.setValue(null);
        this.prmtPeriod.setValue((Object)this.period);
    }

    private void setFilterInfoF7(KDBizPromptBox f7, FilterInfo filter) {
        EntityViewInfo view = f7.getEntityViewInfo() != null ? f7.getEntityViewInfo() : new EntityViewInfo();
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    private FilterInfo getCostTypeBaseFilter() {
        if (this.costTypeBaseFilter == null) {
            this.costTypeBaseFilter = new FilterInfo();
            this.costTypeBaseFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyId));
            this.costTypeBaseFilter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(4)));
            FilterInfo filterStd = new FilterInfo();
            filterStd.getFilterItems().add(new FilterItemInfo("number", (Object)"STD_001"));
            filterStd.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyId));
            try {
                this.costTypeBaseFilter.mergeFilter(filterStd, "OR");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        return (FilterInfo)this.costTypeBaseFilter.clone();
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
    }

    public void clear() {
        this.getFilterManager().clearAll();
        this.setDefaultValue();
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompany;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    public boolean verify() {
        Object temp = this.prmtCostType.getValue();
        if (temp == null || !(temp instanceof CostTypeInfo)) {
            MsgBox.showInfo((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u7c7b\u578b\u3002");
            return false;
        }
        temp = this.prmtPeriod.getValue();
        if (temp == null || !(temp instanceof PeriodInfo)) {
            MsgBox.showInfo((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u671f\u95f4\u3002");
            return false;
        }
        return true;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        this.prmtCompany.setValue((Object)this.company);
        CustomerParams params = this.cp;
        if (params != null) {
            this.loadCostType(params);
            this.loadCostCenter(params);
            this.loadPeriod(params);
        }
    }

    private void loadCostType(CustomerParams params) {
        this.prmtCostType.setData(null);
        String costType = "";
        if (params.getCustomerParam("prmtCostType") != null) {
            costType = params.getCustomerParam("prmtCostType");
        }
        if (StringUtils.isEmpty((String)costType)) {
            return;
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costType));
            FilterInfo costTypeBaseFilter = this.getCostTypeBaseFilter();
            filter.mergeFilter(costTypeBaseFilter, "and");
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            view.setSelector(sic);
            CostTypeCollection coll = CostTypeFactory.getRemoteInstance().getCostTypeCollection(view);
            if (coll != null && coll.size() > 0) {
                this.prmtCostType.setValue((Object)coll.get(0));
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadCostCenter(CustomerParams params) {
        this.prmtCostCenter.setData(null);
        String order = "";
        if (params.getCustomerParam("prmtCostCenter") != null) {
            order = params.getCustomerParam("prmtCostCenter");
        }
        String[] numbers = order.split(";");
        HashSet<String> numbersSet = new HashSet<String>();
        for (int i = 0; i < numbers.length; ++i) {
            numbersSet.add(numbers[i].trim());
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", numbersSet, CompareType.INCLUDE));
            view.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("number");
            selector.add("name");
            view.setSelector(selector);
            CostCenterOrgUnitCollection coll = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitCollection(view);
            if (coll != null && coll.size() > 0) {
                int size = coll.size();
                CostCenterOrgUnitInfo[] orders = new CostCenterOrgUnitInfo[size];
                for (int i = 0; i < size; ++i) {
                    orders[i] = coll.get(i);
                }
                this.prmtCostCenter.setData((Object)orders);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadPeriod(CustomerParams params) {
        this.prmtPeriod.setData(null);
        String period = "";
        if (params.getCustomerParam("prmtPeriod") != null) {
            period = params.getCustomerParam("prmtPeriod");
        }
        if (StringUtils.isEmpty((String)period)) {
            return;
        }
        int number = 0;
        try {
            number = Integer.parseInt(period);
            if (number < this.startPeriod.getNumber() || number > this.period.getNumber()) {
                return;
            }
        }
        catch (Exception e) {
            return;
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)new Integer(number)));
            filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)this.company.getAccountPeriodType().getId().toString()));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("periodYear"));
            sic.add(new SelectorItemInfo("periodNumber"));
            view.setSelector(sic);
            PeriodCollection coll = PeriodFactory.getRemoteInstance().getPeriodCollection(view);
            if (coll != null && coll.size() > 0) {
                this.prmtPeriod.setValue((Object)coll.get(0));
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    protected FilterInfo getPeriodBaseFilter() throws Exception {
        if (this.periodBaseFilter == null) {
            this.periodBaseFilter = new FilterInfo();
            this.periodBaseFilter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)this.company.getAccountPeriodType().getId().toString()));
            this.periodBaseFilter.getFilterItems().add(new FilterItemInfo("periodYear * 100 + periodNumber", (Object)new Integer(this.startPeriod.getPeriodYear() * 100 + this.startPeriod.getPeriodNumber()), CompareType.GREATER_EQUALS));
            this.periodBaseFilter.getFilterItems().add(new FilterItemInfo("periodYear * 100 + periodNumber", (Object)new Integer(this.period.getPeriodYear() * 100 + this.period.getPeriodNumber()), CompareType.LESS_EQUALS));
        }
        return (FilterInfo)this.periodBaseFilter.clone();
    }

    static class PeriodFilterElement
    extends SingleFilterElement {
        KDBizPromptBox prmt;

        public PeriodFilterElement(String id, KDBizPromptBox component) {
            super(id, (Component)component);
            this.prmt = component;
        }

        public void addCustomerParam(CustomerParams cp, String key, Object obj) {
            Object temp = this.prmt.getValue();
            if (temp instanceof PeriodInfo) {
                String number = String.valueOf(((PeriodInfo)temp).getNumber());
                cp.addCustomerParam(key, number);
            }
        }

        public void addRptParams(RptParams cp) {
            Object object = this.prmt.getValue();
            if (object == null) {
                try {
                    this.prmt.commitEdit();
                }
                catch (ParseException e) {
                    logger.error((Object)"", (Throwable)e);
                }
                object = this.prmt.getValue();
            }
            if (object instanceof Object[]) {
                object = ((Object[])object)[0];
            }
            cp.setObject(this.getId(), object);
        }
    }

    static class SingleBizPromptFilterElement
    extends SingleFilterElement {
        KDBizPromptBox prmt;

        public SingleBizPromptFilterElement(String id, KDBizPromptBox component) {
            super(id, (Component)component);
            this.prmt = component;
        }

        public void addRptParams(RptParams cp) {
            Object object = this.prmt.getValue();
            if (object == null) {
                try {
                    this.prmt.commitEdit();
                }
                catch (ParseException e) {
                    logger.error((Object)"", (Throwable)e);
                }
                object = this.prmt.getValue();
            }
            if (object instanceof Object[]) {
                object = ((Object[])object)[0];
            }
            cp.setObject(this.getId(), object);
        }
    }
}

