/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CostItemCollection;
import com.kingdee.eas.basedata.assistant.CostItemFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.basedata.OperationCollection;
import com.kingdee.eas.mm.basedata.OperationFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.SpinnerUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.order.common.utils.OrderCMUtils;
import com.kingdee.eas.ncm.order.fact.report.client.AbstractOCMatFeeTotalReportFilterUI;
import com.kingdee.eas.ncm.order.fact.report.client.OCMatAllocTotalReportFilterUI;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JSpinner;
import org.apache.log4j.Logger;

public class OCMatFeeTotalReportFilterUI
extends AbstractOCMatFeeTotalReportFilterUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(OCMatAllocTotalReportFilterUI.class);
    private CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
    private String companyId = this.company.getId().toString();
    private PeriodInfo startPeriod = null;
    private PeriodInfo period = null;
    private PeriodInfo maxPeriod = null;
    protected boolean isNormal = false;
    private Set storageOrgUnitIds = null;
    private CustomerParams cp = null;
    private FilterInfo costItemBaseFilter = null;
    private FilterInfo costCenterBaseFilter = null;
    private FilterInfo operationBaseFilter = null;
    private FilterInfo orderBaseFilter = null;

    public OCMatFeeTotalReportFilterUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
        OrderCMUtils.checkStart(SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        this.period = OrderCMUtils.getCurrentPeriod(this.companyId);
        this.startPeriod = OrderCMUtils.getStartPeriod(this.companyId);
        this.maxPeriod = OrderCMUtils.getMaxPeriod(this.company, this.period);
        BDCMClientUtils.filterF7((KDBizPromptBox)this.prmtMaterialNumberFrom, (String)"company.id", (Object)this.company.getId().toString());
        BDCMClientUtils.filterF7((KDBizPromptBox)this.prmtMaterialNumberTo, (String)"company.id", (Object)this.company.getId().toString());
        FilterInfo filterPrmt = this.prmtMaterialNumberFrom.getEntityViewInfo().getFilter();
        filterPrmt.getFilterItems().add(new FilterItemInfo("FIInfo.status", (Object)String.valueOf(1), CompareType.EQUALS));
        this.prmtMaterialNumberFrom = NCMUtils.materialTreeDisplay((Object)((Object)this), (KDBizPromptBox)this.prmtMaterialNumberFrom, (FilterInfo)filterPrmt);
        this.prmtMaterialNumberTo = NCMUtils.materialTreeDisplay((Object)((Object)this), (KDBizPromptBox)this.prmtMaterialNumberTo, (FilterInfo)filterPrmt);
        FilterInfo orderBaseFilter = this.getOrderBaseFilter();
        this.prmtOrderFrom.setQueryInfo("com.kingdee.eas.mm.mo.app.F7ManufactureOrderQuery");
        this.prmtOrderFrom.setEditFormat("$number$");
        this.prmtOrderFrom.setDisplayFormat("$number$");
        this.setFilterInfoF7(this.prmtOrderFrom, orderBaseFilter);
        orderBaseFilter = this.getOrderBaseFilter();
        this.prmtOrderTo.setQueryInfo("com.kingdee.eas.mm.mo.app.F7ManufactureOrderQuery");
        this.prmtOrderTo.setEditFormat("$number$");
        this.prmtOrderTo.setDisplayFormat("$number$");
        this.setFilterInfoF7(this.prmtOrderTo, orderBaseFilter);
        FilterInfo operationBaseFilter = this.getOperationBaseFilter();
        this.prmtOperationFrom.setQueryInfo("com.kingdee.eas.mm.basedata.app.F7OperationQuery");
        this.prmtOperationFrom.setEditFormat("$number$");
        this.prmtOperationFrom.setDisplayFormat("$name$");
        this.setFilterInfoF7(this.prmtOperationFrom, operationBaseFilter);
        operationBaseFilter = this.getOperationBaseFilter();
        this.prmtOperationTo.setQueryInfo("com.kingdee.eas.mm.basedata.app.F7OperationQuery");
        this.prmtOperationTo.setEditFormat("$number$");
        this.prmtOperationTo.setDisplayFormat("$name$");
        this.setFilterInfoF7(this.prmtOperationTo, operationBaseFilter);
        FilterInfo costItemBaseFilter = this.getCostItemBaseFilter();
        this.setFilterInfoF7(this.prmtCostItemFrom, costItemBaseFilter);
        this.setFilterInfoF7(this.prmtCostItemTo, costItemBaseFilter);
        BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)this.prmtCostCenterFrom, (String)this.companyId);
        BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)this.prmtCostCenterTo, (String)this.companyId);
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleBizPromptFilterElement filterElement = new SingleBizPromptFilterElement("companyorg", this.prmtCompanyOrg);
        elements.add((FilterElement)filterElement);
        SpinnerFilterElement element = new SpinnerFilterElement("yearFrom", (Component)this.spYearFrom);
        elements.add((FilterElement)element);
        element = new SpinnerFilterElement("periodFrom", (Component)this.spPeriodFrom);
        elements.add((FilterElement)element);
        element = new SpinnerFilterElement("yearTo", (Component)this.spYearTo);
        elements.add((FilterElement)element);
        element = new SpinnerFilterElement("periodTo", (Component)this.spPeriodTo);
        elements.add((FilterElement)element);
        elements.add((FilterElement)new SingleFilterElement("costCenterFrom", (Component)this.prmtCostCenterFrom));
        elements.add((FilterElement)new SingleFilterElement("costCenterTo", (Component)this.prmtCostCenterTo));
        elements.add((FilterElement)new SingleFilterElement("materialFrom", (Component)this.prmtMaterialNumberFrom));
        elements.add((FilterElement)new SingleFilterElement("materialTo", (Component)this.prmtMaterialNumberTo));
        elements.add((FilterElement)new SingleFilterElement("orderFrom", (Component)this.prmtOrderFrom));
        elements.add((FilterElement)new SingleFilterElement("orderTo", (Component)this.prmtOrderTo));
        elements.add((FilterElement)new SingleFilterElement("operationFrom", (Component)this.prmtOperationFrom));
        elements.add((FilterElement)new SingleFilterElement("operationTo", (Component)this.prmtOperationTo));
        elements.add((FilterElement)new SingleFilterElement("costItemFrom", (Component)this.prmtCostItemFrom));
        elements.add((FilterElement)new SingleFilterElement("costItemTo", (Component)this.prmtCostItemTo));
        this.getFilterManager().setElement((FilterElement)elements);
    }

    private Set getStorageOrgUnitIds() throws EASBizException, BOSException {
        if (this.storageOrgUnitIds == null) {
            this.storageOrgUnitIds = BDCMUtils.getStorageOrgUnitIdsOfCompany(null, (String)this.companyId);
        }
        return this.storageOrgUnitIds;
    }

    protected void setDefaultValue() {
        this.prmtCompanyOrg.setValue((Object)this.company);
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.period, (JSpinner)this.spYearFrom, (JSpinner)this.spPeriodFrom, (PeriodInfo)this.period, (JSpinner)this.spYearTo, (JSpinner)this.spPeriodTo, (PeriodInfo)this.period);
        this.prmtCostCenterFrom.setValue(null);
        this.prmtCostCenterTo.setValue(null);
        this.prmtOrderFrom.setValue(null);
        this.prmtOrderTo.setValue(null);
        this.prmtOperationFrom.setValue(null);
        this.prmtOperationTo.setValue(null);
        this.prmtMaterialNumberFrom.setValue(null);
        this.prmtMaterialNumberTo.setValue(null);
        this.prmtCostItemTo.setValue(null);
        this.prmtCostItemTo.setValue(null);
    }

    private void setFilterInfoF7(KDBizPromptBox f7, FilterInfo filter) {
        EntityViewInfo view = f7.getEntityViewInfo() != null ? f7.getEntityViewInfo() : new EntityViewInfo();
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    protected FilterInfo getCostItemBaseFilter() throws Exception {
        if (this.costItemBaseFilter == null) {
            this.costItemBaseFilter = CostItemFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), "id", "adminCU.id");
        }
        return (FilterInfo)this.costItemBaseFilter.clone();
    }

    protected FilterInfo getCostCenterBaseFilter() throws Exception {
        if (this.costCenterBaseFilter == null) {
            this.costCenterBaseFilter = new FilterInfo();
            HashSet<Integer> set = new HashSet<Integer>();
            set.add(new Integer(0));
            set.add(new Integer(1));
            this.costCenterBaseFilter.getFilterItems().add(new FilterItemInfo("costCenterType", set, CompareType.INCLUDE));
        }
        return this.costCenterBaseFilter;
    }

    protected FilterInfo getOrderBaseFilter() throws Exception {
        if (this.orderBaseFilter == null) {
            this.orderBaseFilter = new FilterInfo();
            Set storageOrgUnitIds = this.getStorageOrgUnitIds();
            this.orderBaseFilter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitIds, CompareType.INCLUDE));
            HashSet<Integer> set = new HashSet<Integer>();
            set.add(new Integer(5));
            set.add(new Integer(7));
            set.add(new Integer(8));
            this.orderBaseFilter.getFilterItems().add(new FilterItemInfo("baseStatus", set, CompareType.INCLUDE));
        }
        return (FilterInfo)this.orderBaseFilter.clone();
    }

    protected FilterInfo getOperationBaseFilter() throws Exception {
        if (this.operationBaseFilter == null) {
            this.operationBaseFilter = new FilterInfo();
            Set storageOrgUnitIds = this.getStorageOrgUnitIds();
            this.operationBaseFilter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitIds, CompareType.INCLUDE));
            HashSet<Integer> set = new HashSet<Integer>();
            set.add(new Integer(40));
            set.add(new Integer(10));
            set.add(new Integer(50));
            this.operationBaseFilter.getFilterItems().add(new FilterItemInfo("status", set, CompareType.NOTINCLUDE));
        }
        return (FilterInfo)this.operationBaseFilter.clone();
    }

    protected IObjectPK getBizCUPK() {
        Object object = this.getUIContext().get(this.getMainBizOrgType());
        CtrlUnitInfo currentBizOrg = object == null ? SysContext.getSysContext().getCurrentCtrlUnit() : (OrgUnitInfo)object;
        return new ObjectUuidPK(currentBizOrg.getCU().getId());
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
    }

    public void clear() {
        this.getFilterManager().clearAll();
        this.setDefaultValue();
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompanyOrg;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    public boolean verify() {
        Integer yearFrom = (Integer)this.spYearFrom.getValue();
        Integer yearTo = (Integer)this.spYearTo.getValue();
        if (yearTo.compareTo(yearFrom) < 0) {
            MsgBox.showInfo((String)"\u7ed3\u675f\u671f\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f00\u59cb\u671f\u95f4\u3002");
            return false;
        }
        if (yearTo.compareTo(yearFrom) == 0) {
            Integer periodFrom = (Integer)this.spPeriodFrom.getValue();
            Integer periodTo = (Integer)this.spPeriodTo.getValue();
            if (periodTo.compareTo(periodFrom) < 0) {
                MsgBox.showInfo((String)"\u7ed3\u675f\u671f\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f00\u59cb\u671f\u95f4.");
                return false;
            }
        }
        return super.verify();
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        this.prmtCompanyOrg.setValue((Object)this.company);
        CustomerParams params = this.cp;
        if (params != null) {
            this.loadPeriod(params);
            this.loadCostCenter(params);
            this.loadMaterial(params);
            this.loadOrder(params);
            this.loadOperation(params);
            this.loadCostItem(params);
        }
    }

    private void loadPeriod(CustomerParams params) {
        PeriodInfo initPeriodFrom = this.period;
        PeriodInfo initPeriodTo = this.period;
        String initYearFrom = params.getCustomerParam("spYearFrom");
        String initMonthFrom = params.getCustomerParam("spPeriodFrom");
        String initYearTo = params.getCustomerParam("spYearTo");
        String initMonthTo = params.getCustomerParam("spPeriodTo");
        try {
            if (!StringUtils.isEmpty((String)initYearFrom) && !StringUtils.isEmpty((String)initMonthFrom)) {
                initPeriodFrom = new PeriodInfo();
                initPeriodFrom.setPeriodYear(Integer.parseInt(initYearFrom));
                initPeriodFrom.setPeriodNumber(Integer.parseInt(initMonthFrom));
            }
            if (!StringUtils.isEmpty((String)initYearTo) && !StringUtils.isEmpty((String)initMonthTo)) {
                initPeriodTo = new PeriodInfo();
                initPeriodTo.setPeriodYear(Integer.parseInt(initYearTo));
                initPeriodTo.setPeriodNumber(Integer.parseInt(initMonthTo));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.period, (JSpinner)this.spYearFrom, (JSpinner)this.spPeriodFrom, (PeriodInfo)initPeriodFrom, (JSpinner)this.spYearTo, (JSpinner)this.spPeriodTo, (PeriodInfo)initPeriodTo);
    }

    private void loadCostCenter(CustomerParams params) {
        String costCenterFrom = "";
        String costCenterTo = "";
        if (params.getCustomerParam("prmtCostCenterFrom") != null) {
            costCenterFrom = params.getCustomerParam("prmtCostCenterFrom");
        }
        if (params.getCustomerParam("prmtCostCenterTo") != null) {
            costCenterTo = params.getCustomerParam("prmtCostCenterTo");
        }
        this.prmtCostCenterFrom.setData(null);
        this.prmtCostCenterTo.setData(null);
        try {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costCenterFrom));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costCenterTo));
            view.setFilter(filter);
            view.getFilter().setMaskString("#0 or #1");
            CostCenterOrgUnitCollection costCenterColl = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitCollection(view);
            if (costCenterColl != null && costCenterColl.size() > 0) {
                if (costCenterColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (costCenterColl.get(i).getNumber().equals(costCenterFrom)) {
                            this.prmtCostCenterFrom.setData((Object)costCenterColl.get(i));
                            continue;
                        }
                        this.prmtCostCenterTo.setData((Object)costCenterColl.get(i));
                    }
                } else if (costCenterColl.size() == 1) {
                    if (costCenterColl.get(0).getNumber().equals(costCenterFrom)) {
                        this.prmtCostCenterFrom.setData((Object)costCenterColl.get(0));
                    }
                    if (costCenterColl.get(0).getNumber().equals(costCenterTo)) {
                        this.prmtCostCenterTo.setData((Object)costCenterColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadMaterial(CustomerParams params) {
        String materialFrom = "";
        String materialTo = "";
        if (params.getCustomerParam("prmtMaterialNumberFrom") != null) {
            materialFrom = params.getCustomerParam("prmtMaterialNumberFrom");
        }
        if (params.getCustomerParam("prmtMaterialNumberTo") != null) {
            materialTo = params.getCustomerParam("prmtMaterialNumberTo");
        }
        this.prmtMaterialNumberFrom.setData(null);
        this.prmtMaterialNumberTo.setData(null);
        try {
            String sql = "select mateial.id, mateial.name, mateial.number where (mateial.number = '" + materialFrom + "' or mateial.number = '" + materialTo + "') and company = '" + this.company.getId().toString() + "'";
            MaterialCompanyInfoCollection coll = MaterialCompanyInfoFactory.getRemoteInstance().getMaterialCompanyInfoCollection(sql);
            if (coll != null && coll.size() > 0) {
                if (coll.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (coll.get(i).getMateial().getNumber().equals(materialFrom)) {
                            this.prmtMaterialNumberFrom.setData((Object)coll.get(i).getMateial());
                            continue;
                        }
                        this.prmtMaterialNumberTo.setData((Object)coll.get(i).getMateial());
                    }
                } else if (coll.size() == 1) {
                    if (coll.get(0).getMateial().getNumber().equals(materialFrom)) {
                        this.prmtMaterialNumberFrom.setData((Object)coll.get(0).getMateial());
                    }
                    if (coll.get(0).getMateial().getNumber().equals(materialTo)) {
                        this.prmtMaterialNumberTo.setData((Object)coll.get(0).getMateial());
                    }
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadOrder(CustomerParams params) {
        String orderFrom = "";
        String orderTo = "";
        if (params.getCustomerParam("prmtOrderFrom") != null) {
            orderFrom = params.getCustomerParam("prmtOrderFrom");
        }
        if (params.getCustomerParam("prmtOrderTo") != null) {
            orderTo = params.getCustomerParam("prmtOrderTo");
        }
        this.prmtOrderFrom.setData(null);
        this.prmtOrderTo.setData(null);
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)orderFrom));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)orderTo));
            filter.setMaskString("(#0 or #1)");
            try {
                FilterInfo orderBaseFilter = this.getOrderBaseFilter();
                filter.mergeFilter(orderBaseFilter, "and");
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
            view.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("number");
            selector.add("name");
            view.setSelector(selector);
            ManufactureOrderCollection coll = ManufactureOrderFactory.getRemoteInstance().getManufactureOrderCollection(view);
            if (coll != null && coll.size() > 0) {
                if (coll.size() == 1) {
                    if (coll.get(0).getNumber().equals(orderFrom)) {
                        this.prmtOrderFrom.setData((Object)coll.get(0));
                    }
                    if (coll.get(0).getNumber().equals(orderTo)) {
                        this.prmtOrderTo.setData((Object)coll.get(0));
                    }
                } else {
                    for (int i = 0; i < coll.size(); ++i) {
                        if (coll.get(i).getNumber().equals(orderFrom)) {
                            this.prmtOrderFrom.setData((Object)coll.get(i));
                            continue;
                        }
                        if (!coll.get(i).getNumber().equals(orderTo)) continue;
                        this.prmtOrderTo.setData((Object)coll.get(i));
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadOperation(CustomerParams params) {
        String operationFrom = "";
        String operationTo = "";
        if (params.getCustomerParam("prmtOperationFrom") != null) {
            operationFrom = params.getCustomerParam("prmtOperationFrom");
        }
        if (params.getCustomerParam("prmtOperationTo") != null) {
            operationTo = params.getCustomerParam("prmtOperationTo");
        }
        this.prmtOperationFrom.setData(null);
        this.prmtOperationTo.setData(null);
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)operationFrom));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)operationTo));
            filter.setMaskString("(#0 or #1)");
            try {
                FilterInfo operationBaseFilter = this.getOperationBaseFilter();
                filter.mergeFilter(operationBaseFilter, "and");
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
            view.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("number");
            selector.add("name");
            view.setSelector(selector);
            OperationCollection coll = OperationFactory.getRemoteInstance().getOperationCollection(view);
            if (coll != null && coll.size() > 0) {
                if (coll.size() == 1) {
                    if (coll.get(0).getNumber().equals(operationFrom)) {
                        this.prmtOperationFrom.setData((Object)coll.get(0));
                    }
                    if (coll.get(0).getNumber().equals(operationTo)) {
                        this.prmtOperationTo.setData((Object)coll.get(0));
                    }
                } else {
                    for (int i = 0; i < coll.size(); ++i) {
                        if (coll.get(i).getNumber().equals(operationFrom)) {
                            this.prmtOperationFrom.setData((Object)coll.get(i));
                            continue;
                        }
                        if (!coll.get(i).getNumber().equals(operationTo)) continue;
                        this.prmtOperationTo.setData((Object)coll.get(i));
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadCostItem(CustomerParams params) {
        String costItemFrom = "";
        String costItemTo = "";
        if (params.getCustomerParam("prmtCostItemFrom") != null) {
            costItemFrom = params.getCustomerParam("prmtCostItemFrom");
        }
        if (params.getCustomerParam("prmtCostItemTo") != null) {
            costItemTo = params.getCustomerParam("prmtCostItemTo");
        }
        this.prmtCostItemFrom.setData(null);
        this.prmtCostItemTo.setData(null);
        try {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costItemFrom));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costItemTo));
            filter.setMaskString("#0 or #1");
            try {
                FilterInfo costItemBaseFilter = this.getCostItemBaseFilter();
                filter.mergeFilter(costItemBaseFilter, "and");
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
            view.setFilter(filter);
            CostItemCollection costItemColl = CostItemFactory.getRemoteInstance().getCostItemCollection(view);
            if (costItemColl != null && costItemColl.size() > 0) {
                if (costItemColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (costItemColl.get(i).getNumber().equals(costItemFrom)) {
                            this.prmtCostItemFrom.setData((Object)costItemColl.get(i));
                            continue;
                        }
                        this.prmtCostItemTo.setData((Object)costItemColl.get(i));
                    }
                } else if (costItemColl.size() == 1) {
                    if (costItemColl.get(0).getNumber().equals(costItemFrom)) {
                        this.prmtCostItemFrom.setData((Object)costItemColl.get(0));
                    }
                    if (costItemColl.get(0).getNumber().equals(costItemTo)) {
                        this.prmtCostItemTo.setData((Object)costItemColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    class SingleBizPromptFilterElement
    extends SingleFilterElement {
        KDBizPromptBox prmt;

        public SingleBizPromptFilterElement(String id, KDBizPromptBox component) {
            super(id, (Component)component);
            this.prmt = component;
        }

        public void addRptParams(RptParams cp) {
            Object object = this.prmt.getValue();
            if (object == null) {
                object = this.prmt.getValue();
            }
            if (object instanceof Object[]) {
                object = ((Object[])object)[0];
            }
            cp.setObject(this.getId(), object);
        }
    }

    class SpinnerFilterElement
    extends SingleFilterElement {
        private KDSpinner spinner;

        public SpinnerFilterElement(String id, Component component) {
            super(id, component);
            this.spinner = (KDSpinner)component;
        }

        protected void setNumber(Object obj, String value) {
            this.spinner.setValue((Object)new Integer(value));
        }

        protected String getName(Object obj) {
            return ((Component)obj).getName();
        }

        protected void setData(Component obj, Object value) {
            this.spinner.setValue(value);
        }
    }
}

