/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CostItemFactory;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.ncm.ExpenseCollection;
import com.kingdee.eas.basedata.ncm.ExpenseFactory;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.CommRptResourceUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.cal.report.client.SpinnerFilterElement;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.order.common.utils.OrderCMUtils;
import com.kingdee.eas.ncm.order.fact.report.client.AbstractOrderCCFeeTotalReportFilterUI;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.text.ParseException;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class OrderCCFeeTotalReportFilterUI
extends AbstractOrderCCFeeTotalReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(OrderCCFeeTotalReportFilterUI.class);

    public OrderCCFeeTotalReportFilterUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
        OrderCMUtils.checkStart(SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        CompanyOrgUnitInfo companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getRemoteInstance();
        PeriodInfo currentPeriod = sysctrol.getCacheCurrentPeriod(1010, companyOrg.getId().toString());
        if (currentPeriod == null) {
            throw new CMBillException(CMBillException.NCMDIRECTSHOWMESG, new Object[]{EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"182_CCFeeTotalReportFilterUI")});
        }
        this.prmtCompanyOrg.setValue((Object)companyOrg);
        BDCMClientUtils.setBizOrgF7ByType((KDBizPromptBox)this.prmtCompanyOrg, (OrgType)OrgType.Company);
        BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)this.prmtCostCenterFrom, (String)companyOrg.getId().toString());
        BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)this.prmtCostCenterTo, (String)companyOrg.getId().toString());
        FilterInfo expenseFilterInfo = this.getExpenseFilter();
        this.setFilterInfoF7(this.prmtExpenseFrom, expenseFilterInfo);
        this.setFilterInfoF7(this.prmtExpenseTo, expenseFilterInfo);
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleBizPromptFilterElement filterElement = new SingleBizPromptFilterElement("companyorg", this.prmtCompanyOrg);
        filterElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"183_CCFeeTotalReportFilterUI")));
        elements.add((FilterElement)filterElement);
        SpinnerFilterElement element = new SpinnerFilterElement("yearfrom", (Component)this.spYearFrom);
        element.setDefaultValue((Object)new Integer(currentPeriod.getPeriodYear()));
        elements.add((FilterElement)element);
        element = new SpinnerFilterElement("yearto", (Component)this.spYearTo);
        element.setDefaultValue((Object)new Integer(currentPeriod.getPeriodYear()));
        elements.add((FilterElement)element);
        element = new SpinnerFilterElement("periodfrom", (Component)this.spPeriodFrom);
        element.setDefaultValue((Object)new Integer(currentPeriod.getPeriodNumber()));
        elements.add((FilterElement)element);
        element = new SpinnerFilterElement("periodto", (Component)this.spPeriodTo);
        element.setDefaultValue((Object)new Integer(currentPeriod.getPeriodNumber()));
        elements.add((FilterElement)element);
        elements.add((FilterElement)new SingleFilterElement("costcenterfrom", (Component)this.prmtCostCenterFrom));
        elements.add((FilterElement)new SingleFilterElement("costcenterto", (Component)this.prmtCostCenterTo));
        elements.add((FilterElement)new SingleBizPromptFilterElement("expensefrom", this.prmtExpenseFrom));
        elements.add((FilterElement)new SingleBizPromptFilterElement("expenseto", this.prmtExpenseTo));
        this.getFilterManager().setElement((FilterElement)elements);
    }

    private void setFilterInfoF7(KDBizPromptBox f7, FilterInfo filter) {
        EntityViewInfo view = f7.getEntityViewInfo() != null ? f7.getEntityViewInfo() : new EntityViewInfo();
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    protected FilterInfo getCostItemFilter() throws Exception {
        return CostItemFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), this.getKeyFieldName(), this.getAdminCUFieldName());
    }

    protected FilterInfo getExpenseFilter() throws Exception {
        return ExpenseFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), this.getKeyFieldName(), this.getAdminCUFieldName());
    }

    protected IObjectPK getBizCUPK() {
        Object object = this.getUIContext().get(this.getMainBizOrgType());
        CtrlUnitInfo currentBizOrg = object == null ? SysContext.getSysContext().getCurrentCtrlUnit() : (OrgUnitInfo)object;
        return new ObjectUuidPK(currentBizOrg.getCU().getId());
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getAdminCUFieldName() {
        return "adminCU.id";
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
    }

    public void clear() {
        this.getFilterManager().clearAll();
        this.setDefaultValue();
    }

    protected void setDefaultValue() {
        CompanyOrgUnitInfo companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        this.prmtCompanyOrg.setValue((Object)companyOrg);
        BDCMClientUtils.setBizOrgF7ByType((KDBizPromptBox)this.prmtCompanyOrg, (OrgType)OrgType.Company);
        this.prmtCostCenterFrom.setValue(null);
        this.prmtCostCenterTo.setValue(null);
        this.prmtExpenseFrom.setValue(null);
        this.prmtExpenseTo.setValue(null);
        try {
            this.setPeriodRange(this.spYearFrom, this.spPeriodFrom, this.spYearTo, this.spPeriodTo);
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompanyOrg;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    public boolean verify() {
        Integer yearFrom = (Integer)this.spYearFrom.getValue();
        Integer yearTo = (Integer)this.spYearTo.getValue();
        if (yearTo.compareTo(yearFrom) < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"184_CCFeeTotalReportFilterUI"));
            return false;
        }
        if (yearTo.compareTo(yearFrom) == 0) {
            Integer periodFrom = (Integer)this.spPeriodFrom.getValue();
            Integer periodTo = (Integer)this.spPeriodTo.getValue();
            if (periodTo.compareTo(periodFrom) < 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"184_CCFeeTotalReportFilterUI"));
                return false;
            }
        }
        return super.verify();
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        CompanyOrgUnitInfo companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        this.prmtCompanyOrg.setValue((Object)companyOrg);
        CustomerParams params = this.getCustomerParams();
        if (params != null) {
            this.loadExpense(params);
            this.loadCostCenter(params);
        }
    }

    private void loadCostCenter(CustomerParams params) {
        String costCenterFrom = "";
        String costCenterTo = "";
        if (params.getCustomerParam("prmtCostCenterFrom") != null) {
            costCenterFrom = params.getCustomerParam("prmtCostCenterFrom");
        }
        if (params.getCustomerParam("prmtCostCenterTo") != null) {
            costCenterTo = params.getCustomerParam("prmtCostCenterTo");
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costCenterFrom));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costCenterTo));
            view.setFilter(filter);
            view.getFilter().setMaskString("#0 or #1 ");
            SorterItemCollection sorter = new SorterItemCollection();
            sorter.add(new SorterItemInfo("number"));
            view.setSorter(sorter);
            CostCenterOrgUnitCollection costCenterColl = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitCollection(view);
            if (costCenterColl != null && costCenterColl.size() > 0) {
                if (costCenterColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (costCenterColl.get(i).getNumber().equals(costCenterFrom)) {
                            this.prmtCostCenterFrom.setData((Object)costCenterColl.get(0));
                            continue;
                        }
                        this.prmtCostCenterTo.setData((Object)costCenterColl.get(1));
                    }
                } else if (costCenterColl.size() == 1) {
                    if (costCenterColl.get(0).getNumber().equals(costCenterFrom)) {
                        this.prmtCostCenterFrom.setData((Object)costCenterColl.get(0));
                    }
                    if (costCenterColl.get(0).getNumber().equals(costCenterTo)) {
                        this.prmtCostCenterTo.setData((Object)costCenterColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.prmtCostCenterFrom.setData(null);
            this.prmtCostCenterTo.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadExpense(CustomerParams params) {
        String expenseFrom = "";
        String expenseTo = "";
        if (params.getCustomerParam("prmtExpenseFrom") != null) {
            expenseFrom = params.getCustomerParam("prmtExpenseFrom");
        }
        if (params.getCustomerParam("prmtExpenseTo") != null) {
            expenseTo = params.getCustomerParam("prmtExpenseTo");
        }
        try {
            ExpenseCollection expenseColl = ExpenseFactory.getRemoteInstance().getExpenseCollection("select * where number ='" + expenseFrom + "' or number = '" + expenseTo + "' order by number");
            if (expenseColl != null && expenseColl.size() > 0) {
                if (expenseColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (expenseColl.get(i).getNumber().equals(expenseFrom)) {
                            this.prmtExpenseFrom.setData((Object)expenseColl.get(0));
                            continue;
                        }
                        this.prmtExpenseTo.setData((Object)expenseColl.get(1));
                    }
                } else if (expenseColl.size() == 1) {
                    if (expenseColl.get(0).getNumber().equals(expenseFrom)) {
                        this.prmtExpenseFrom.setData((Object)expenseColl.get(0));
                    }
                    if (expenseColl.get(0).getNumber().equals(expenseTo)) {
                        this.prmtExpenseTo.setData((Object)expenseColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.prmtExpenseFrom.setData(null);
            this.prmtExpenseTo.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void setPeriodRange(KDSpinner spYearFrom, KDSpinner spPeriodFrom, KDSpinner spYearTo, KDSpinner spPeriodTo) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        if (companyOrg == null) {
            return;
        }
        PeriodInfo currentPeriod = OrderCMUtils.getCurrentPeriod(companyOrg.getId().toString());
        PeriodInfo startPaeriod = OrderCMUtils.getStartPeriod(companyOrg.getId().toString());
        spYearFrom.setModel((SpinnerModel)new SpinnerNumberExModel(currentPeriod.getPeriodYear(), startPaeriod.getPeriodYear(), currentPeriod.getPeriodYear(), 1));
        spPeriodFrom.setModel((SpinnerModel)new SpinnerNumberExModel(currentPeriod.getPeriodNumber(), startPaeriod.getPeriodNumber(), currentPeriod.getPeriodNumber(), 1));
        spYearTo.setModel((SpinnerModel)new SpinnerNumberExModel(currentPeriod.getPeriodYear(), startPaeriod.getPeriodYear(), currentPeriod.getPeriodYear(), 1));
        spPeriodTo.setModel((SpinnerModel)new SpinnerNumberExModel(currentPeriod.getPeriodNumber(), startPaeriod.getPeriodNumber(), currentPeriod.getPeriodNumber(), 1));
    }

    static class SingleBizPromptFilterElement
    extends SingleFilterElement {
        KDBizPromptBox prmt;

        public SingleBizPromptFilterElement(String id, KDBizPromptBox component) {
            super(id, (Component)component);
            this.prmt = component;
        }

        public void addRptParams(RptParams cp) {
            Object object = this.prmt.getValue();
            if (object == null) {
                try {
                    this.prmt.commitEdit();
                }
                catch (ParseException e) {
                    logger.error((Object)"", (Throwable)e);
                }
                object = this.prmt.getValue();
            }
            if (object instanceof Object[]) {
                object = ((Object[])object)[0];
            }
            cp.setObject(this.getId(), object);
        }
    }

    private static class SpinnerNumberExModel
    extends SpinnerNumberModel {
        private Object lastValue = null;

        public SpinnerNumberExModel(int value, int minimum, int maximum, int stepSize) {
            super(value, minimum, maximum, stepSize);
            this.lastValue = new Integer(value);
        }

        @Override
        public void setValue(Object value) {
            Object curValue = this.getValue();
            super.setValue(value);
            if (curValue != value) {
                this.lastValue = value;
            }
        }

        public int getLastValue() {
            if (this.lastValue == null) {
                throw new RuntimeException(CommRptResourceUtil.getRes((String)"not_init"));
            }
            return (Integer)this.lastValue;
        }

        public int getIntValue() {
            return (Integer)this.getValue();
        }

        public boolean isUp() {
            return this.getIntValue() > this.getLastValue();
        }
    }
}

