/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.base.report.ReportListener;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.order.fact.cal.OrderCostCalcResultVoucheredFactory;
import com.kingdee.eas.ncm.order.fact.cal.VoucherDAPTransImpl;
import com.kingdee.eas.ncm.order.fact.cal.utils.client.CalcClientUntil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JFrame;

public class OrderCostCalcPreDtlVoucherReportListener
extends ReportListener {
    private String companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();

    public void onInitialize() throws Exception {
        String sView = CalcClientUntil.getClientReportResource("OrderCostCalcVchRep_VoucherView");
        this.reportApplication.addBarItem("VoucherView", sView, sView, sView, null, (Object)EASResource.getIcon((String)"imgTbtn_downview"), "", true, true, false);
        String sByAll = CalcClientUntil.getClientReportResource("OrderCostCalcVchRep_GenByAll");
        this.reportApplication.addBarItem("All", sByAll, sByAll, sByAll, null, (Object)EASResource.getIcon((String)"imgTbtn_collect"), "", true, true, false);
        String sByCostCenter = CalcClientUntil.getClientReportResource("OrderCostCalcVchRep_GenByCostCenter");
        this.reportApplication.addBarItem("CostCenter", sByCostCenter, sByCostCenter, sByCostCenter, null, (Object)EASResource.getIcon((String)"imgTbtn_flowexample"), "", true, true, false);
        String sDelVoucher = CalcClientUntil.getClientReportResource("OrderCostCalcVchRep_DelVoucher");
        this.reportApplication.addBarItem("DelVoucher", sDelVoucher, sDelVoucher, sDelVoucher, null, (Object)EASResource.getIcon((String)"imgTbtn_deletecredence"), "", true, true, true);
    }

    public void onMenuClick(String name) throws Exception {
        Set cCIdSet;
        IRowSet data = null;
        try {
            data = this.getReportApplication().getData();
        }
        catch (Throwable exc) {
            throw new Exception(exc);
        }
        if (data == null || !data.first()) {
            String sHint = CalcClientUntil.getClientReportResource("OrderCostCalcVchRep_CanntOperate");
            MsgBox.showWarning((String)sHint);
            SysUtil.abort();
        }
        if (name.equalsIgnoreCase("All")) {
            this.checkVoucherPermission("ordercalccost_voucher");
            cCIdSet = (Set)this.getReportApplication().getFilter().getObject("costcenter");
            this.checkPeriodEquals("All", cCIdSet);
            this.getReportApplication().Refresh();
        } else if (name.equalsIgnoreCase("CostCenter")) {
            this.checkVoucherPermission("ordercalccost_voucher");
            cCIdSet = (Set)this.getReportApplication().getFilter().getObject("costcenter");
            this.checkPeriodEquals("CostCenter", cCIdSet);
            this.getReportApplication().Refresh();
        } else if (name.equalsIgnoreCase("VoucherView")) {
            this.checkVoucherPermission("ordercalccost_downview");
            this.actionView_actionPerformed();
        } else if (name.equalsIgnoreCase("DelVoucher")) {
            this.checkVoucherPermission("ordercalccost_delete");
            this.actionDelVoucher_actionPerformed();
            this.getReportApplication().Refresh();
        }
    }

    private boolean checkVoucherPermission(String printPermission) throws Exception {
        boolean bPermission = false;
        if (!printPermission.equals("")) {
            PermissionHelper.checkFunctionPermission(null, null, (String)printPermission);
            bPermission = true;
        }
        return bPermission;
    }

    public void checkPeriodEquals(String Type2, Set iDset) throws Exception {
        List voucherIdList;
        BOTMappingInfo botMappingInfo;
        PeriodInfo cmCurPeriod = SystemStatusCtrolFactory.getRemoteInstance().getCacheCurrentPeriod(1010, this.companyId);
        ISystemStatusCtrol ctrol = SystemStatusCtrolFactory.getRemoteInstance();
        PeriodInfo glCurPeriod = ctrol.getCacheCurrentPeriod(6, this.companyId);
        if (glCurPeriod == null) {
            String sPeriod = CalcClientUntil.getClientReportResource("OrderCostCalcVchRep_Period");
            throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{SystemEnum.GENERALLEDGER.getAlias() + sPeriod});
        }
        if (!NCMUtils.isEquals((PeriodInfo)glCurPeriod, (PeriodInfo)cmCurPeriod)) {
            throw new CMBillException(CMBillException.NOTEQUALS_VOUCHER);
        }
        CtrlUnitInfo cu = SysContext.getSysContext().getCurrentCtrlUnit();
        if (Type2.equalsIgnoreCase("CostCenter")) {
            List voucherIdList2;
            BOTMappingInfo botMappingInfo2 = VoucherDAPTransImpl.getBotpInfo(cu, null, "C819BF74");
            if (botMappingInfo2 != null && (voucherIdList2 = OrderCostCalcResultVoucheredFactory.getRemoteInstance().addVoucherByCostCenter(this.companyId, cmCurPeriod.getId().toString(), iDset, botMappingInfo2)) != null && voucherIdList2.size() > 0) {
                this.showWindow(botMappingInfo2, voucherIdList2);
            }
        } else if (Type2.equalsIgnoreCase("All") && (botMappingInfo = VoucherDAPTransImpl.getBotpInfo(cu, null, "C819BF74")) != null && (voucherIdList = OrderCostCalcResultVoucheredFactory.getRemoteInstance().addVoucherByAll(this.companyId, cmCurPeriod.getId().toString(), iDset, botMappingInfo)) != null && voucherIdList.size() > 0) {
            this.showWindow(botMappingInfo, voucherIdList);
        }
    }

    private void showWindow(BOTMappingInfo botMappingInfo, List voucherIdList) throws Exception {
        if (botMappingInfo == null || voucherIdList == null) {
            return;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        IUIWindow uiWindow = null;
        if (botMappingInfo.getIsShowEditUI() == 1) {
            RealModeIDList idList = RealModeIDList.getEmptyIDList();
            int size = voucherIdList.toArray().length;
            for (int i = 0; i < size; ++i) {
                idList.add(voucherIdList.toArray()[i].toString());
                param.put("ID", idList.getCurrentID());
                param.put("IDList", (String)idList);
            }
            try {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.gl.client.VoucherEditUI", param, null, OprtState.EDIT);
            }
            catch (UIException e) {
                throw new BOSException((Throwable)e);
            }
        } else if (botMappingInfo.getIsShowEditUI() != 2 && botMappingInfo.getIsShowEditUI() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.btp.btpResource.transSuccess"));
            return;
        }
        if (uiWindow != null) {
            uiWindow.show();
            if (uiWindow instanceof JFrame) {
                ((JFrame)uiWindow).setExtendedState(6);
            }
        }
    }

    public void actionView_actionPerformed() throws Exception {
        if (UIRuleUtil.getIntValue(this.reportApplication.getCurrentRow().get("FFIVOUCHERED")) == 0) {
            String sHint = CalcClientUntil.getClientReportResource("OrderCostCalcVchRep_NoGen");
            MsgBox.showInfo((String)sHint);
            SysUtil.abort();
        } else if (this.reportApplication.getCurrentRow().get("FVOUCHERNUMBER") != null && this.reportApplication.getCurrentRow().get("FVOUCHERNUMBER").toString().length() != 0) {
            this.reportApplication.showEditUI("FVOUCHERID", "com.kingdee.eas.fi.gl.client.VoucherEditUI");
        } else {
            String sHint = CalcClientUntil.getClientReportResource("OrderCostCalcVchRep_CanntView");
            MsgBox.showInfo((String)sHint);
            SysUtil.abort();
        }
    }

    public void actionDelVoucher_actionPerformed() throws Exception {
        boolean isSCMVouchered = false;
        IVoucher ctrl = VoucherFactory.getRemoteInstance();
        ArrayList rows = this.reportApplication.getSelectRows();
        int idCount = rows.size();
        String[] ids = new String[idCount];
        Vector<ObjectUuidPK> vec = new Vector<ObjectUuidPK>(idCount);
        Map row = null;
        String voucherID = null;
        ObjectUuidPK voucherPk = null;
        for (int i = 0; i < idCount; ++i) {
            row = (Map)rows.get(i);
            if (UIRuleUtil.getIntValue(row.get("FFIVOUCHERED")) == 0) {
                String sHint = CalcClientUntil.getClientReportResource("OrderCostCalcVchRep_NoVch");
                MsgBox.showInfo((String)sHint);
                SysUtil.abort();
            }
            if (UIRuleUtil.isNotNull((String)(voucherID = (String)row.get("FVOUCHERID")))) {
                voucherPk = new ObjectUuidPK(voucherID);
                if (vec.contains(voucherPk)) continue;
                vec.add(voucherPk);
                ids[i] = voucherID.toString();
                continue;
            }
            isSCMVouchered = true;
        }
        if (MsgBox.isYes((int)MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")))) {
            if (vec.size() > 0) {
                IObjectPK[] pks = new IObjectPK[vec.size()];
                OrderCostCalcResultVoucheredFactory.getRemoteInstance().delete(vec.toArray(pks));
            }
            if (isSCMVouchered) {
                String sHint = CalcClientUntil.getClientReportResource("OrderCostCalcVchRep_CanntDelVoucher");
                MsgBox.showInfo((String)sHint);
                SysUtil.abort();
            }
        }
    }

    public void fireBeforePrint(boolean isPreview) throws Exception {
        this.checkVoucherPermission("ordercalccost_print");
        super.fireBeforePrint(isPreview);
    }
}

