/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.std.basedata.client;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.IRefChecker;
import com.kingdee.eas.common.RefCheckerFactory;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.common.BillBaseStatusEnum;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeFactory;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeInfo;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeLevelEnum;
import com.kingdee.eas.ncm.order.std.basedata.client.AbstractCostTypeEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public class CostTypeEditUI
extends AbstractCostTypeEditUI {
    private static final long serialVersionUID = -6243540087367065324L;

    public CostTypeEditUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.spinnerPrecision.setModel((SpinnerModel)new SpinnerNumberModel(2, 0, 12, 1));
        if (!"ADDNEW".equals(this.getOprtState())) {
            this.spinnerPrecision.setValue((Object)new Integer(this.editData.getPricePrecision()));
        }
        if ("ADDNEW".equals(this.getOprtState())) {
            this.setOprtState(BillBaseStatusEnum.ADD);
        } else if ("VIEW".equals(this.getOprtState())) {
            this.actionAddNew.setEnabled(false);
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
            this.actionSubmit.setEnabled(false);
            this.actionAudit.setEnabled(false);
            this.actionUnAudit.setEnabled(false);
        } else if (this.editData != null && this.editData.getStatus() != null) {
            this.setOprtState(this.editData.getStatus());
        }
        if (this.editData != null && "STD_001".equals(this.editData.getNumber())) {
            this.actionAddNew.setEnabled(false);
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
            this.actionSubmit.setEnabled(false);
            this.actionAudit.setEnabled(false);
            this.actionUnAudit.setEnabled(false);
        }
    }

    protected IObjectValue createNewData() {
        CostTypeInfo value = new CostTypeInfo();
        value.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        value.setStatus(BillBaseStatusEnum.ADD);
        value.setIsIncludeScrapRatio(true);
        value.setIsIncludeYieldRatio(true);
        value.setPricePrecision(2);
        value.setLevel(CostTypeLevelEnum.product);
        return value;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CostTypeFactory.getRemoteInstance();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.menuItemSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
    }

    protected void setOprtState(BillBaseStatusEnum status) {
        if (BillBaseStatusEnum.ADD.equals((Object)status)) {
            this.actionAddNew.setEnabled(true);
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
            this.actionSubmit.setEnabled(false);
            this.actionAudit.setEnabled(false);
            this.actionUnAudit.setEnabled(false);
        } else if (BillBaseStatusEnum.TEMPORARILYSAVED.equals((Object)status)) {
            this.actionAddNew.setEnabled(true);
            this.actionEdit.setEnabled(true);
            this.actionRemove.setEnabled(true);
            this.actionSubmit.setEnabled(true);
            this.actionAudit.setEnabled(false);
            this.actionUnAudit.setEnabled(false);
        } else if (BillBaseStatusEnum.SUBMITED.equals((Object)status)) {
            this.actionAddNew.setEnabled(true);
            this.actionEdit.setEnabled(true);
            this.actionRemove.setEnabled(true);
            this.actionSubmit.setEnabled(false);
            this.actionAudit.setEnabled(true);
            this.actionUnAudit.setEnabled(false);
        } else if (BillBaseStatusEnum.AUDITED.equals((Object)status)) {
            this.actionAddNew.setEnabled(true);
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
            this.actionSubmit.setEnabled(false);
            this.actionAudit.setEnabled(false);
            this.actionUnAudit.setEnabled(true);
        }
    }

    protected void beforeStoreFields(ActionEvent event) throws Exception {
        if (UIRuleUtil.isNull((String)this.txtNumber.getText())) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{this.labelNumber.getBoundLabelText()});
        }
        if (UIRuleUtil.isNull((String)this.txtName.getText())) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{this.lblName.getBoundLabelText()});
        }
        if (UIRuleUtil.isNull((Object)this.spinnerPrecision.getValue())) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{this.lblPrecision.getBoundLabelText()});
        }
        if (UIRuleUtil.isNull((Object)this.combLevel.getSelectedItem())) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{this.lblLevel.getBoundLabelText()});
        }
        super.beforeStoreFields(event);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        this.setOprtState(BillBaseStatusEnum.TEMPORARILYSAVED);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        CostTypeFactory.getRemoteInstance().audit(this.editData.getId().toString());
        this.setOprtState(BillBaseStatusEnum.AUDITED);
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        String id;
        IRefChecker checker = RefCheckerFactory.getRemoteInstance();
        if (checker.isReferenced(BOSUuid.read((String)(id = this.editData.getId().toString())))) {
            MsgBox.showWarning((String)"\u6570\u636e\u88ab\u5f15\u7528\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\uff01");
            SysUtil.abort();
        }
        CostTypeFactory.getRemoteInstance().unAudit(this.editData.getId().toString());
        this.setOprtState(BillBaseStatusEnum.TEMPORARILYSAVED);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData != null && this.editData.getId() != null) {
            CostTypeFactory.getRemoteInstance().submit(this.editData.getId().toString());
        } else {
            CostTypeFactory.getRemoteInstance().submit((CoreBaseInfo)this.editData);
        }
        this.setOprtState(BillBaseStatusEnum.SUBMITED);
    }
}

