/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.std.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.uistatemanage.ActionManager;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionEvent;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.ncm.ActivityInfo;
import com.kingdee.eas.basedata.ncm.TimeUnitTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.bill.NcmBillException;
import com.kingdee.eas.ncm.common.client.ProgressHintListener;
import com.kingdee.eas.ncm.common.client.ProgressHintUI;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMCommonQueryProcessor;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeInfo;
import com.kingdee.eas.ncm.order.std.bill.OSActivityStdPriceFactory;
import com.kingdee.eas.ncm.order.std.bill.client.AbstractOSActivityStdPriceListUI;
import com.kingdee.eas.ncm.order.std.bill.client.OSActivityStdPriceFilterUI;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class OSActivityStdPriceListUI
extends AbstractOSActivityStdPriceListUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(OSActivityStdPriceListUI.class);
    private static final String RES_CLASSNAME = "com.kingdee.eas.ncm.order.fact.bill.CostDriverSetByWIPResource";
    private static final String ID_TEMP_PREX = "OSActivityStdPrice.id_";
    private int idCounter = 0;
    protected static final String Col_ID = "id";
    protected static final String Col_CompanyOrgId = "companyOrg.id";
    protected static final String Col_CompanyOrgNumber = "companyOrg.number";
    protected static final String Col_CompanyOrgName = "companyOrg.name";
    protected static final String Col_CostTypeId = "costType.id";
    protected static final String Col_CostTypeNumber = "costType.number";
    protected static final String Col_CostTypeName = "costType.name";
    protected static final String Col_ActivityId = "activity.id";
    protected static final String Col_ActivityNumber = "activity.number";
    protected static final String Col_ActivityName = "activity.name";
    protected static final String Col_BaseUnitName = "baseUnit.name";
    protected static final String Col_CostItemId = "costItem.id";
    protected static final String Col_CostItemNumber = "costItem.number";
    protected static final String Col_CostItemName = "costItem.name";
    protected static final String Col_StdPrice = "stdPrice";
    protected static final String Col_GenerateBySystem = "generateBySystem";
    protected static final String Col_PricePrecision = "costType.pricePrecision";
    private CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
    private String companyId = this.company.getId().toString();
    private ActionManager actionManager = null;
    private CommonQueryDialog dialog = null;
    private KDBizPromptBox prmtCostType = null;
    private KDBizPromptBox prmtActivity = null;
    private KDBizPromptBox prmtCostItem = null;
    Set costCenterIds = null;
    private Object oldValue = null;
    private Map updateMap = new HashMap();

    public OSActivityStdPriceListUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                OSActivityStdPriceListUI.this.tblMain_afterDataFill(e);
            }
        });
        this.tblMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                try {
                    OSActivityStdPriceListUI.this.tblMain_editStarting(e);
                }
                catch (Exception exc) {
                    OSActivityStdPriceListUI.this.handUIException(exc);
                }
            }

            public void editStarted(KDTEditEvent e) {
                try {
                    OSActivityStdPriceListUI.this.tblMain_editStarted(e);
                }
                catch (Exception exc) {
                    OSActivityStdPriceListUI.this.handUIException(exc);
                }
            }

            public void editStopped(KDTEditEvent e) {
                try {
                    OSActivityStdPriceListUI.this.tblMain_editStopped(e);
                }
                catch (Exception exc) {
                    OSActivityStdPriceListUI.this.handUIException(exc);
                }
            }
        });
    }

    public ActionManager getActionManager() {
        if (this.actionManager == null) {
            this.actionManager = new ActionManager((CoreUIObject)this){

                public void registerAction(String actionName, ItemAction itemAction) {
                    if ("actionImportData".equals(actionName)) {
                        OSActivityStdPriceListUI.this.actionImportData.putValue("AcceleratorKey", (Object)KeyStroke.getKeyStroke("ctrl I"));
                    } else if ("actionExportData".equals(actionName)) {
                        OSActivityStdPriceListUI.this.actionExportData.putValue("AcceleratorKey", (Object)KeyStroke.getKeyStroke("ctrl shift E"));
                    }
                    super.registerAction(actionName, itemAction);
                }
            };
        }
        return this.actionManager;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnSave.setEnabled(false);
        this.btnGenerate.setEnabled(true);
        this.btnAddLine.setEnabled(true);
        this.btnInsertLine.setEnabled(true);
        this.btnDeleteLine.setEnabled(true);
        this.btnCopyLine.setEnabled(true);
        this.btnCopyLine.setVisible(true);
        this.btnEdit.setVisible(false);
        this.tblMain.getSelectManager().setSelectMode(11);
        this.actionSave.setEnabled(false);
        this.tblMain.getColumn(Col_CompanyOrgName).setWidth(120);
        this.tblMain.getColumn(Col_CostTypeName).setWidth(120);
        this.tblMain.getColumn(Col_ActivityName).setWidth(120);
        this.tblMain.getColumn(Col_CostItemName).setWidth(120);
    }

    protected int getCommonQueryDialogWidth() {
        return 450;
    }

    protected int getCommonQueryDialogHeight() {
        return 320;
    }

    protected CustomerQueryPanel getFilterUI() {
        return null;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog != null) {
            return this.dialog;
        }
        this.dialog = super.initCommonQueryDialog();
        OSActivityStdPriceQueryProcessor cmcq = new OSActivityStdPriceQueryProcessor();
        cmcq.set("companyOrg", SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        cmcq.set("query", "orderCCFeeBillQuery");
        this.dialog.setProcessor((IProcessor)cmcq);
        if (this.getFilterUI() != null) {
            this.dialog.addUserPanel((KDPanel)this.getFilterUI());
        }
        return this.dialog;
    }

    public void onShow() throws Exception {
        super.onShow();
        this.btnCopyLine.setEnabled(true);
        this.btnCopyLine.setVisible(true);
        this.menuItemEdit.setVisible(false);
        this.menuBiz.setVisible(true);
        this.menuGenarate.setEnabled(true);
        this.menuInsertLine.setEnabled(true);
        this.menuAddLine.setEnabled(true);
        this.menuDeleteLine.setEnabled(true);
        this.menuCopyTo.setEnabled(true);
        this.menuCopyTo.setVisible(true);
    }

    protected void initTableParams() {
        super.initTableParams();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(Col_StdPrice).getStyleAttributes().setLocked(false);
        this.tblMain.getColumn(Col_StdPrice).setRequired(true);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return OSActivityStdPriceFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return "";
    }

    protected String getKeyFieldName() {
        return Col_ID;
    }

    private void initCostTypeF7(IRow row, boolean enabled) {
        this.prmtCostType = new KDBizPromptBox();
        this.prmtCostType.setQueryInfo("com.kingdee.eas.ncm.order.std.basedata.app.CostTypeQuery");
        this.prmtCostType.setVisible(true);
        this.prmtCostType.setEditable(true);
        this.prmtCostType.setDisplayFormat("$number$");
        this.prmtCostType.setEditFormat("$number$");
        this.prmtCostType.setCommitFormat("$number$");
        EntityViewInfo eviCostType = new EntityViewInfo();
        eviCostType.setFilter(this.getCostTypeFilter());
        this.prmtCostType.setEntityViewInfo(eviCostType);
        KDTDefaultCellEditor cellCostType = new KDTDefaultCellEditor((IKDEditor)this.prmtCostType);
        ObjectValueRender ovrCostType = new ObjectValueRender();
        ovrCostType.setFormat((IDataFormat)new BizDataFormat("$number$"));
        row.getCell(Col_CostTypeNumber).getStyleAttributes().setLocked(false);
        row.getCell(Col_CostTypeNumber).setEditor((ICellEditor)cellCostType);
        row.getCell(Col_CostTypeNumber).setRenderer((IBasicRender)ovrCostType);
        this.prmtCostType.setEnabled(enabled);
        this.prmtCostType.setRequired(true);
    }

    private void initActivityF7(IRow row, boolean enabled) {
        this.prmtActivity = new KDBizPromptBox();
        this.prmtActivity.setQueryInfo("com.kingdee.eas.basedata.ncm.app.ActivityQuery");
        this.prmtActivity.setVisible(true);
        this.prmtActivity.setEditable(true);
        this.prmtActivity.setDisplayFormat("$number$");
        this.prmtActivity.setEditFormat("$number$");
        this.prmtActivity.setCommitFormat("$number$");
        EntityViewInfo eviActivity = new EntityViewInfo();
        eviActivity.setFilter(this.getActivityFilter());
        this.prmtActivity.setEntityViewInfo(eviActivity);
        KDTDefaultCellEditor cellActivity = new KDTDefaultCellEditor((IKDEditor)this.prmtActivity);
        ObjectValueRender ovrActivity = new ObjectValueRender();
        ovrActivity.setFormat((IDataFormat)new BizDataFormat("$number$"));
        row.getCell(Col_ActivityNumber).getStyleAttributes().setLocked(false);
        row.getCell(Col_ActivityNumber).setEditor((ICellEditor)cellActivity);
        row.getCell(Col_ActivityNumber).setRenderer((IBasicRender)ovrActivity);
        this.prmtActivity.setEnabled(enabled);
        this.prmtActivity.setRequired(true);
    }

    private void initCostItemF7(IRow row, boolean enabled) {
        this.prmtCostItem = new KDBizPromptBox();
        this.prmtCostItem.setQueryInfo("com.kingdee.eas.basedata.ncm.app.CostItem4ActivityQuery");
        this.prmtCostItem.setVisible(true);
        this.prmtCostItem.setEditable(true);
        this.prmtCostItem.setDisplayFormat("$number$");
        this.prmtCostItem.setEditFormat("$number$");
        this.prmtCostItem.setCommitFormat("$number$");
        KDTDefaultCellEditor cellCostItem = new KDTDefaultCellEditor((IKDEditor)this.prmtCostItem);
        ObjectValueRender ovrCostItem = new ObjectValueRender();
        ovrCostItem.setFormat((IDataFormat)new BizDataFormat("$number$"));
        row.getCell(Col_CostItemNumber).getStyleAttributes().setLocked(false);
        row.getCell(Col_CostItemNumber).setEditor((ICellEditor)cellCostItem);
        row.getCell(Col_CostItemNumber).setRenderer((IBasicRender)ovrCostItem);
        this.prmtCostItem.setEnabled(enabled);
        this.prmtCostItem.setRequired(true);
    }

    private void setPrecision4StdPrice(IRow row, CostTypeInfo costType) {
        int precision = 0;
        ICell cell3 = row.getCell(Col_PricePrecision);
        if (cell3.getValue() != null) {
            precision = (Integer)cell3.getValue();
            row.getCell(Col_StdPrice).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            row.getCell(Col_StdPrice).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)precision));
        }
    }

    private FilterInfo getCostTypeFilter() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(4), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"STD_001", CompareType.NOTEQUALS));
        return filter;
    }

    private FilterInfo getActivityFilter() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyId));
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1), CompareType.EQUALS));
        return filter;
    }

    private FilterInfo getCostItemFilter(ActivityInfo activityInfo) {
        FilterInfo filter = new FilterInfo();
        if (activityInfo != null && activityInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo(Col_ActivityId, (Object)activityInfo.getId().toString(), CompareType.EQUALS));
        }
        return filter;
    }

    private void filterCostItem(SelectorEvent e) throws EASBizException, BOSException {
        int activeRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow activeRow = this.tblMain.getRow(activeRowIndex);
        this.prmtCostItem = (KDBizPromptBox)activeRow.getCell(Col_CostItemNumber).getEditor().getComponent();
        EntityViewInfo view = null;
        view = this.prmtCostItem.getEntityViewInfo() == null ? new EntityViewInfo() : this.prmtCostItem.getEntityViewInfo();
        ActivityInfo activeActivityInfo = this.getActivityInfo(activeRow);
        FilterInfo filter = this.getCostItemFilter(activeActivityInfo);
        view.setFilter(filter);
        this.prmtCostItem.getQueryAgent().resetRuntimeEntityView();
        this.prmtCostItem.setEntityViewInfo(view);
    }

    private ActivityInfo getActivityInfo(IRow row) {
        ActivityInfo activityInfo = null;
        Object temp = row.getCell(Col_ActivityNumber).getValue();
        if (temp != null && temp instanceof ActivityInfo) {
            activityInfo = (ActivityInfo)temp;
        }
        return activityInfo;
    }

    protected void beforeExcutQuery(EntityViewInfo evi) {
        super.beforeExcutQuery(evi);
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        super.getRowSetBeforeFillTable(rowSet);
    }

    public void tblMain_afterDataFill(KDTDataRequestEvent e) {
        int firstRowIndex = e.getFirstRow();
        int lastRowIndex = e.getLastRow();
        IRow row = null;
        Object value = null;
        boolean editable = true;
        for (int i = firstRowIndex; i <= lastRowIndex; ++i) {
            row = this.tblMain.getRow(i);
            ICell cell2 = row.getCell(Col_GenerateBySystem);
            editable = cell2 == null || (Boolean)cell2.getValue() == false;
            this.formatLine(row, editable);
            CostTypeInfo costType = null;
            value = row.getCell(Col_CostTypeId).getValue();
            if (value != null) {
                costType = new CostTypeInfo();
                costType.setId(BOSUuid.read((String)value.toString()));
                value = row.getCell(Col_CostTypeNumber).getValue();
                if (value != null) {
                    costType.setNumber(value.toString());
                }
                if ((value = row.getCell(Col_CostTypeName).getValue()) != null) {
                    costType.setName(value.toString());
                }
            }
            row.getCell(Col_CostTypeNumber).setValue((Object)costType);
            CostItemInfo costItem = null;
            value = row.getCell(Col_CostItemId).getValue();
            if (value != null) {
                costItem = new CostItemInfo();
                costItem.setId(BOSUuid.read((String)value.toString()));
                value = row.getCell(Col_CostItemNumber).getValue();
                if (value != null) {
                    costItem.setNumber(value.toString());
                }
                if ((value = row.getCell(Col_CostItemName).getValue()) != null) {
                    costItem.setName(value.toString());
                }
            }
            row.getCell(Col_CostItemNumber).setValue((Object)costItem);
            ActivityInfo activity = null;
            value = row.getCell(Col_ActivityId).getValue();
            if (value != null) {
                activity = new ActivityInfo();
                activity.setId(BOSUuid.read((String)value.toString()));
                value = row.getCell(Col_ActivityNumber).getValue();
                if (value != null) {
                    activity.setNumber(value.toString());
                }
                if ((value = row.getCell(Col_ActivityName).getValue()) != null) {
                    activity.setName(value.toString());
                }
            }
            row.getCell(Col_ActivityNumber).setValue((Object)activity);
            this.setPrecision4StdPrice(row, null);
        }
    }

    public void refresh(ActionEvent e) throws Exception {
        this.updateMap.clear();
        this.actionSave.setEnabled(false);
        super.refresh(e);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.showSaveConfirm();
        super.actionRefresh_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.showSaveConfirm();
        super.actionQuery_actionPerformed(e);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(Col_CompanyOrgId, (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString(), CompareType.EQUALS));
        return filter;
    }

    protected boolean checkBeforeWindowClosing() {
        this.showSaveConfirm(true);
        return super.checkBeforeWindowClosing();
    }

    public void tblMain_editStarting(KDTEditEvent e) throws Exception {
        IRow row;
        ActivityInfo activityInfo;
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        this.oldValue = this.tblMain.getRow(rowIndex).getCell(colIndex).getValue();
        if (!e.isCancel() && this.tblMain.getColumnIndex(Col_CostItemNumber) == colIndex && (activityInfo = (ActivityInfo)(row = this.tblMain.getRow(rowIndex)).getCell(Col_ActivityNumber).getValue()) == null) {
            e.setCancel(true);
            MsgBox.showInfo((String)"\u8bf7\u5148\u9009\u62e9\u4f5c\u4e1a\u7f16\u7801\u3002");
            this.tblMain.getEditManager().editCellAt(rowIndex, row.getCell(Col_ActivityNumber).getColumnIndex());
            SysUtil.abort();
        }
        if (this.tblMain.getColumnIndex(Col_CostItemNumber) == colIndex) {
            this.filterCostItem(null);
        }
    }

    public void tblMain_editStarted(KDTEditEvent e) throws Exception {
    }

    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (e.getRowIndex() < 0) {
            return;
        }
        IRow row = this.tblMain.getRow(rowIndex);
        Object newValue = row.getCell(colIndex).getValue();
        if (this.isValueEquals(newValue, colIndex)) {
            return;
        }
        String id = row.getCell(Col_ID).getValue().toString();
        HashMap<String, String> info = (HashMap<String, String>)this.updateMap.get(id);
        if (info == null) {
            info = new HashMap<String, String>();
            info.put(Col_ID, id);
            this.updateMap.put(id, info);
        }
        info.put(Col_CompanyOrgId, this.companyId);
        if (this.tblMain.getColumn(Col_CostTypeNumber).getColumnIndex() == colIndex) {
            this.costType_editStopped(row, info, newValue);
        } else if (this.tblMain.getColumn(Col_CostItemNumber).getColumnIndex() == colIndex) {
            this.costItem_editStopped(row, info, newValue);
        } else if (this.tblMain.getColumn(Col_ActivityNumber).getColumnIndex() == colIndex) {
            this.activity_editStopped(row, info, newValue);
        } else if (this.tblMain.getColumn(Col_StdPrice).getColumnIndex() == colIndex) {
            this.stdPrice_editStopped(row, info, newValue);
        }
        this.actionSave.setEnabled(true);
    }

    protected void costType_editStopped(IRow row, Map info, Object newValue) throws Exception {
        if (newValue != null && newValue instanceof CostTypeInfo) {
            CostTypeInfo costType = (CostTypeInfo)newValue;
            row.getCell(Col_CostTypeId).setValue((Object)costType.getId());
            row.getCell(Col_CostTypeName).setValue((Object)costType.getName());
            row.getCell(Col_PricePrecision).setValue((Object)new Integer(costType.getPricePrecision()));
            info.put(Col_CostTypeId, costType.getId().toString());
            if (row.getCell(Col_ActivityId).getValue() != null) {
                info.put(Col_ActivityId, row.getCell(Col_ActivityId).getValue().toString());
            }
            if (row.getCell(Col_CostItemId).getValue() != null) {
                info.put(Col_CostItemId, row.getCell(Col_CostItemId).getValue().toString());
            }
            this.setPrecision4StdPrice(row, costType);
        } else {
            this.clearCostType(row, info);
        }
    }

    protected void costItem_editStopped(IRow row, Map info, Object newValue) throws Exception {
        if (newValue != null && newValue instanceof CostItemInfo) {
            CostItemInfo costItem = (CostItemInfo)newValue;
            row.getCell(Col_CostItemId).setValue((Object)costItem.getId());
            row.getCell(Col_CostItemName).setValue((Object)costItem.getName());
            info.put(Col_CostItemId, costItem.getId().toString());
            if (row.getCell(Col_ActivityId).getValue() != null) {
                info.put(Col_ActivityId, row.getCell(Col_ActivityId).getValue().toString());
            }
            if (row.getCell(Col_CostTypeId).getValue() != null) {
                info.put(Col_CostTypeId, row.getCell(Col_CostTypeId).getValue().toString());
            }
        } else {
            this.clearCostItem(row, info);
        }
    }

    protected void activity_editStopped(IRow row, Map info, Object newValue) throws Exception {
        if (newValue != null && newValue instanceof ActivityInfo) {
            ActivityInfo activity = (ActivityInfo)newValue;
            row.getCell(Col_ActivityId).setValue((Object)activity.getId());
            row.getCell(Col_ActivityName).setValue((Object)activity.getName());
            info.put(Col_ActivityId, activity.getId().toString());
            if (row.getCell(Col_CostTypeId).getValue() != null) {
                info.put(Col_CostTypeId, row.getCell(Col_CostTypeId).getValue().toString());
            }
            if (row.getCell(Col_CostItemId).getValue() != null) {
                info.put(Col_CostItemId, row.getCell(Col_CostItemId).getValue().toString());
            }
            if (activity.getBaseUnit() != null) {
                MeasureUnitInfo baseUnit = MeasureUnitFactory.getRemoteInstance().getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(activity.getBaseUnit().getId()));
                row.getCell(Col_BaseUnitName).setValue((Object)baseUnit.getName());
            }
            if (activity.getTimeUnit() != null) {
                row.getCell("timeUnit").setValue((Object)activity.getTimeUnit());
            }
        } else {
            this.clearActivity(row, info);
        }
        row.getCell(Col_CostItemNumber).setValue(null);
        row.getCell(Col_CostItemName).setValue(null);
    }

    protected void stdPrice_editStopped(IRow row, Map info, Object newValue) throws Exception {
        if (newValue != null) {
            String value = newValue.toString();
            if (value.length() > 15) {
                value = value.substring(0, 15);
            }
            row.getCell(Col_StdPrice).setValue((Object)value);
            info.put(Col_StdPrice, value);
        }
    }

    private void clearCostType(IRow row, Map info) {
        row.getCell(Col_CostTypeName).setValue(null);
        row.getCell(Col_CostTypeNumber).setValue(null);
        info.put(Col_CostTypeId, null);
    }

    private void clearCostItem(IRow row, Map info) {
        row.getCell(Col_CostItemNumber).setValue(null);
        row.getCell(Col_CostItemName).setValue(null);
        info.put(Col_CostItemId, null);
    }

    private void clearActivity(IRow row, Map info) {
        row.getCell(Col_ActivityName).setValue(null);
        row.getCell(Col_ActivityNumber).setValue(null);
        row.getCell(Col_BaseUnitName).setValue(null);
        row.getCell("timeUnit").setValue(null);
        info.put(Col_ActivityId, null);
    }

    private void clearRow(IRow row, Map info) {
        this.clearCostType(row, info);
        this.clearCostItem(row, info);
        this.clearActivity(row, info);
    }

    private boolean isValueEquals(Object newValue, int colIndex) {
        if (this.oldValue == null && newValue == null) {
            return true;
        }
        if (this.oldValue == null || newValue == null) {
            return false;
        }
        if (newValue instanceof String) {
            return ((String)newValue).trim().equals(this.oldValue.toString().trim());
        }
        if (this.tblMain.getColumn(Col_CostTypeNumber).getColumnIndex() == colIndex) {
            if (newValue instanceof CostTypeInfo && this.oldValue instanceof CostTypeInfo) {
                return ((CostTypeInfo)newValue).getId().equals((Object)((CostTypeInfo)this.oldValue).getId());
            }
        } else if (this.tblMain.getColumn(Col_ActivityNumber).getColumnIndex() == colIndex) {
            if (newValue instanceof ActivityInfo && this.oldValue instanceof ActivityInfo) {
                return ((ActivityInfo)newValue).getId().equals((Object)((ActivityInfo)this.oldValue).getId());
            }
        } else if (this.tblMain.getColumn(Col_CostItemNumber).getColumnIndex() == colIndex && newValue instanceof CostItemInfo && this.oldValue instanceof CostItemInfo) {
            return ((CostItemInfo)newValue).getId().equals((Object)((CostItemInfo)this.oldValue).getId());
        }
        return newValue == this.oldValue;
    }

    protected void addLine(int rowIndex) throws Exception {
        if (this.tblMain.getRowCount() == 0) {
            this.actionRemove.setEnabled(true);
        }
        IRow row = this.tblMain.addRow(rowIndex);
        this.formatLine(row, true);
        String id = ID_TEMP_PREX + ++this.idCounter;
        HashMap<String, Object> info = new HashMap<String, Object>();
        this.updateMap.put(id, info);
        row.getCell(Col_ID).setValue((Object)id);
        row.getCell(Col_CompanyOrgName).setValue((Object)this.company.getName());
        info.put(Col_CostTypeId, null);
        info.put(Col_CostItemId, null);
        info.put(Col_ActivityId, null);
        row.getCell(Col_GenerateBySystem).setValue((Object)new Boolean(false));
        this.tblMain.setRowCount(this.tblMain.getRowCount() + 1);
        this.actionSave.setEnabled(true);
        this.tblMain.getEditManager().editCellAt(rowIndex, this.tblMain.getColumnIndex(Col_CostTypeNumber));
    }

    @Override
    public void actionGenerate_actionPerformed(ActionEvent e) throws Exception {
        Object owner = null;
        UIContext uiContext = new UIContext(owner);
        int winStyle = 16;
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow uiWindow = uiFactory.create(OSActivityStdPriceFilterUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW, winStyle);
        uiWindow.show();
        OSActivityStdPriceFilterUI filter = (OSActivityStdPriceFilterUI)uiWindow.getUIObject();
        if (filter.isCancel()) {
            SysUtil.abort();
        }
        CostTypeInfo costTypeInfo = filter.getCostType();
        HashMap<String, Object> listenerParam = new HashMap<String, Object>();
        listenerParam.put("company", this.company);
        listenerParam.put("costTypeInfo", costTypeInfo);
        genProgressHintListener listener = new genProgressHintListener();
        ProgressHintUI.showProgressHintUI((CoreUIObject)this, (ProgressHintListener)listener, listenerParam);
        MsgBox.showInfo((String)"\u751f\u6210\u6570\u636e\u6210\u529f\u3002");
        this.refreshList();
    }

    @Override
    public void actionCopyTo_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() == 0) {
            this.actionRemove.setEnabled(true);
        }
        this.checkSelected();
        IRow selectedRow = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        IRow row = this.tblMain.addRow(0);
        this.formatLine(row, true);
        String id = ID_TEMP_PREX + ++this.idCounter;
        HashMap<String, String> info = new HashMap<String, String>();
        this.updateMap.put(id, info);
        Object temp = null;
        row.getCell(Col_ID).setValue((Object)id);
        row.getCell(Col_CompanyOrgName).setValue((Object)this.company.getName());
        info.put(Col_CompanyOrgId, this.companyId);
        CostTypeInfo costType = null;
        temp = selectedRow.getCell(Col_CostTypeNumber).getValue();
        if (temp != null && temp instanceof CostTypeInfo) {
            costType = (CostTypeInfo)temp;
        }
        Integer precision = (Integer)selectedRow.getCell(Col_PricePrecision).getValue();
        ActivityInfo activity = null;
        temp = selectedRow.getCell(Col_ActivityNumber).getValue();
        if (temp != null && temp instanceof ActivityInfo) {
            activity = (ActivityInfo)temp;
        }
        String baseUnitName = (String)selectedRow.getCell(Col_BaseUnitName).getValue();
        TimeUnitTypeEnum timeUnit = null;
        if (selectedRow.getCell("timeUnit").getValue() instanceof TimeUnitTypeEnum) {
            timeUnit = (TimeUnitTypeEnum)selectedRow.getCell("timeUnit").getValue();
        }
        CostItemInfo costItem = null;
        temp = selectedRow.getCell(Col_CostItemNumber).getValue();
        if (temp != null && temp instanceof CostItemInfo) {
            costItem = (CostItemInfo)temp;
        }
        BigDecimal stdPrice = null;
        temp = selectedRow.getCell(Col_StdPrice).getValue();
        if (temp != null && temp instanceof BigDecimal) {
            stdPrice = (BigDecimal)temp;
        }
        if (costType != null) {
            row.getCell(Col_CostTypeId).setValue((Object)costType.getId());
            row.getCell(Col_CostTypeNumber).setValue((Object)costType);
            row.getCell(Col_CostTypeName).setValue((Object)costType.getName());
            row.getCell(Col_PricePrecision).setValue((Object)precision);
            this.setPrecision4StdPrice(row, costType);
            info.put(Col_CostTypeId, costType.getId().toString());
        }
        if (activity != null) {
            row.getCell(Col_ActivityId).setValue((Object)activity.getId());
            row.getCell(Col_ActivityNumber).setValue((Object)activity);
            row.getCell(Col_ActivityName).setValue((Object)activity.getName());
            row.getCell(Col_BaseUnitName).setValue((Object)baseUnitName);
            row.getCell("timeUnit").setValue((Object)timeUnit);
            info.put(Col_ActivityId, activity.getId().toString());
        }
        if (costItem != null) {
            if (costType != null && activity != null) {
                int rowIndex = row.getRowIndex();
                int colIndex = row.getCell(Col_CostItemNumber).getColumnIndex();
                this.tblMain.getEditManager().editCellAt(rowIndex, colIndex);
            } else {
                row.getCell(Col_CostItemId).setValue((Object)costItem.getId());
                row.getCell(Col_CostItemNumber).setValue((Object)costItem.getNumber());
                row.getCell(Col_CostItemName).setValue((Object)costItem.getName());
                info.put(Col_CostItemId, costItem.getId().toString());
            }
        }
        if (stdPrice != null) {
            row.getCell(Col_StdPrice).setValue((Object)stdPrice);
            info.put(Col_StdPrice, stdPrice.toString());
        }
        this.tblMain.setRowCount(this.tblMain.getRowCount() + 1);
        this.actionSave.setEnabled(true);
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.addLine(0);
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectManager selectManager = this.tblMain.getSelectManager();
        if (selectManager.size() == 0) {
            this.addLine(0);
        } else if (selectManager.size() > 0) {
            int inserRowIndex = selectManager.get(0).getBeginRow();
            this.addLine(inserRowIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionDeleteLine_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        for (int i = 0; i < selectRows.length; ++i) {
            Boolean generateBySystem = (Boolean)this.tblMain.getRow(selectRows[i]).getCell(Col_GenerateBySystem).getValue();
            if (generateBySystem == null || !generateBySystem.booleanValue()) continue;
            MsgBox.showInfo((String)"\u7cfb\u7edf\u81ea\u52a8\u751f\u6210\u7684\u8bb0\u5f55\u4e0d\u80fd\u5220\u9664\u3002");
            SysUtil.abort();
        }
        this.checkSelected();
        if (!this.confirmRemove()) {
            return;
        }
        this.requestMutex(this.companyId);
        try {
            int i;
            TreeSet<Integer> set = new TreeSet<Integer>();
            for (int i2 = 0; i2 < this.tblMain.getSelectManager().size(); ++i2) {
                IBlock block = KDTSelectBlock.change((KDTable)this.tblMain, (IBlock)this.tblMain.getSelectManager().get(i2));
                for (int j = block.getTop(); j <= block.getBottom(); ++j) {
                    set.add(new Integer(j));
                }
            }
            Object[] rowIndexs = set.toArray(new Integer[set.size()]);
            Arrays.sort(rowIndexs);
            ArrayList<String> existIds = new ArrayList<String>();
            ArrayList<String> tempIDs = new ArrayList<String>();
            for (i = rowIndexs.length - 1; i >= 0; --i) {
                IRow row = this.tblMain.getRow(((Integer)rowIndexs[i]).intValue());
                String id = row.getCell(Col_ID).getValue().toString();
                if (id.startsWith(ID_TEMP_PREX)) {
                    tempIDs.add(id);
                    continue;
                }
                existIds.add(id);
            }
            for (i = rowIndexs.length - 1; i >= 0; --i) {
                this.tblMain.removeRow(((Integer)rowIndexs[i]).intValue());
            }
            for (i = 0; i < tempIDs.size(); ++i) {
                this.updateMap.remove(tempIDs.get(i));
            }
            if (existIds.size() == 0) {
                this.actionSave.setEnabled(this.hasModify());
                return;
            }
            for (i = 0; i < existIds.size(); ++i) {
                this.updateMap.remove(existIds.get(i));
            }
            IObjectPK[] pks = new IObjectPK[existIds.size()];
            for (int i3 = 0; i3 < existIds.size(); ++i3) {
                pks[i3] = new ObjectUuidPK(existIds.get(i3).toString());
            }
            this.getBizInterface().delete(pks);
        }
        finally {
            this.releaseMutex(this.companyId);
        }
        this.actionSave.setEnabled(this.hasModify());
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.actionDeleteLine_actionPerformed(e);
    }

    private void formatLine(IRow row, boolean editable) {
        this.initCostTypeF7(row, editable);
        this.initCostItemF7(row, editable);
        this.initActivityF7(row, editable);
    }

    private boolean hasModify() {
        return this.updateMap.size() > 0;
    }

    private void showSaveConfirm() {
        this.showSaveConfirm(false);
    }

    private void showSaveConfirm(boolean exit) {
        if (this.hasModify()) {
            String msg = exit ? NCMClientUtils.getNcmBillResource((String)"CHECK_DIRTY") : EASResource.getString((String)RES_CLASSNAME, (String)"SAVE_BEFORE_ACTION");
            int ret = MsgBox.showConfirm3((String)msg);
            if (ret == 0) {
                try {
                    this.runUpdate();
                }
                catch (NcmBillException e) {
                    ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                    SysUtil.abort();
                }
                catch (AbortException e) {
                    throw e;
                }
                catch (Exception e) {
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)RES_CLASSNAME, (String)"SAVE_FAIL"), (String)e.getMessage(), (int)8188);
                    SysUtil.abort();
                }
            } else if (ret != 1 && ret == 2) {
                SysUtil.abort();
            }
        }
    }

    public void initTableListner(KDTable table) {
        super.initTableListner(table);
        this.tblMain.setBeforeAction(new BeforeActionListener(){

            public void beforeAction(BeforeActionEvent e) {
                OSActivityStdPriceListUI.this.tblMain_beforeAction(e);
            }
        });
    }

    private void tblMain_beforeAction(BeforeActionEvent e) {
        if (e.getType() != 7) {
            return;
        }
        int costCenterColIndex = this.tblMain.getColumnIndex(Col_CostTypeNumber);
        int costItemColIndex = this.tblMain.getColumnIndex(Col_CostItemNumber);
        int costDriverColIndex = this.tblMain.getColumnIndex(Col_ActivityNumber);
        int size = this.tblMain.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            int rowIndex;
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(i);
            if (selectBlock == null) continue;
            if (8 == selectBlock.getMode()) {
                for (rowIndex = 0; rowIndex < this.tblMain.getExpandedRowCount(); ++rowIndex) {
                    IRow row = this.tblMain.getRow(rowIndex);
                    String id = row.getCell(Col_ID).getValue().toString();
                    HashMap<String, String> info = (HashMap<String, String>)this.updateMap.get(id);
                    if (info == null) {
                        info = new HashMap<String, String>();
                        info.put(Col_ID, id);
                    }
                    this.clearRow(row, info);
                    if (info.size() <= 1) continue;
                    this.updateMap.put(id, info);
                }
                break;
            }
            int rowCount = selectBlock.getBottom();
            for (rowIndex = selectBlock.getTop(); rowIndex >= 0 && rowIndex <= rowCount; ++rowIndex) {
                IRow row = this.tblMain.getRow(rowIndex);
                String id = row.getCell(Col_ID).getValue().toString();
                HashMap<String, String> info = (HashMap<String, String>)this.updateMap.get(id);
                if (info == null) {
                    info = new HashMap<String, String>();
                    info.put(Col_ID, id);
                }
                if (2 == selectBlock.getMode()) {
                    this.clearRow(row, info);
                } else {
                    int colCount = selectBlock.getRight();
                    for (int colIndex = selectBlock.getLeft(); colIndex >= 0 && colIndex <= colCount; ++colIndex) {
                        if (row.getCell(colIndex).getValue() == null) continue;
                        if (colIndex == costCenterColIndex) {
                            this.clearCostType(row, info);
                        }
                        if (colIndex == costItemColIndex) {
                            this.clearCostItem(row, info);
                        }
                        if (colIndex != costDriverColIndex) continue;
                        this.clearActivity(row, info);
                    }
                }
                if (info.size() <= 1) continue;
                this.updateMap.put(id, info);
            }
        }
        this.actionSave.setEnabled(this.updateMap.size() > 0);
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        if (this.runUpdate()) {
            this.actionSave.setEnabled(false);
            MsgBox.showInfo((String)EASResource.getString((String)RES_CLASSNAME, (String)"SAVE_SUCCESS"));
            this.refreshList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runUpdate() throws Exception {
        boolean successful = true;
        if (this.updateMap.size() > 0) {
            this.verify();
            ArrayList list = new ArrayList(this.updateMap.size());
            list.addAll(this.updateMap.values());
            this.requestMutex(this.companyId);
            Map resultMap = null;
            try {
                resultMap = OSActivityStdPriceFactory.getRemoteInstance().UpdateAllocStdSetting(list);
            }
            catch (Exception e) {
                logger.error((Object)"actionSave_actionPerformed", (Throwable)e);
                this.handUIException(e);
            }
            finally {
                this.releaseMutex(this.companyId);
            }
            if (resultMap != null) {
                IRow repeatRow = this.getRow(resultMap);
                successful = false;
                if (repeatRow != null) {
                    MsgBox.showInfo((String)("\u7b2c" + (repeatRow.getRowIndex() + 1) + "\u884c\u8d22\u52a1\u7ec4\u7ec7+\u6210\u672c\u7c7b\u578b+\u4f5c\u4e1a+\u6210\u672c\u9879\u76ee\u91cd\u590d\u3002"));
                    repeatRow.getCell(Col_CostItemId).setValue(null);
                    repeatRow.getCell(Col_CostItemNumber).setValue(null);
                    repeatRow.getCell(Col_CostItemName).setValue(null);
                    this.tblMain.getEditManager().editCellAt(repeatRow.getRowIndex(), repeatRow.getCell(Col_CostItemNumber).getColumnIndex());
                }
                SysUtil.abort();
            }
        }
        return successful;
    }

    private void verify() {
        int length = this.tblMain.getExpandedRowCount();
        for (int rowIndex = 0; rowIndex < length; ++rowIndex) {
            int colIndex;
            IRow row = this.tblMain.getRow(rowIndex);
            if (row.getCell(Col_CostTypeNumber).getValue() == null) {
                MsgBox.showInfo((String)"\u6210\u672c\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                colIndex = row.getCell(Col_CostTypeNumber).getColumnIndex();
                this.tblMain.getEditManager().editCellAt(rowIndex, colIndex);
                SysUtil.abort();
            }
            if (row.getCell(Col_CostItemNumber).getValue() == null) {
                MsgBox.showInfo((String)"\u6210\u672c\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                colIndex = row.getCell(Col_CostItemNumber).getColumnIndex();
                this.tblMain.getEditManager().editCellAt(rowIndex, colIndex);
                SysUtil.abort();
            }
            if (row.getCell(Col_ActivityNumber).getValue() == null) {
                MsgBox.showInfo((String)"\u4f5c\u4e1a\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                colIndex = row.getCell(Col_ActivityNumber).getColumnIndex();
                this.tblMain.getEditManager().editCellAt(rowIndex, colIndex);
                SysUtil.abort();
            }
            if (row.getCell(Col_StdPrice).getValue() == null) {
                MsgBox.showInfo((String)"\u7efc\u5408\u8d39\u7387\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                colIndex = row.getCell(Col_StdPrice).getColumnIndex();
                this.tblMain.getEditManager().editCellAt(rowIndex, colIndex);
                SysUtil.abort();
                continue;
            }
            Pattern pattern = Pattern.compile("^(([0-9]+\\.[0-9]*[1-9][0-9]*)|([0-9]*[1-9][0-9]*\\.[0-9]+)|([0-9]*[1-9][0-9]*))$");
            Matcher matcher = pattern.matcher(row.getCell(Col_StdPrice).getValue().toString());
            if (matcher.find()) continue;
            MsgBox.showInfo((String)"\u7efc\u5408\u8d39\u7387\u5fc5\u987b\u662f\u5927\u4e8e\u96f6\u7684\u6570\u5b57\u3002");
            this.tblMain.getEditManager().editCellAt(row.getRowIndex(), row.getCell(Col_StdPrice).getColumnIndex());
            SysUtil.abort();
        }
        Map resultMap = this.checkRepeat();
        if (resultMap != null) {
            IRow repeatRow = this.getRow(resultMap);
            if (repeatRow != null) {
                MsgBox.showInfo((String)("\u7b2c" + (repeatRow.getRowIndex() + 1) + "\u884c\u8d22\u52a1\u7ec4\u7ec7+\u6210\u672c\u7c7b\u578b+\u4f5c\u4e1a+\u6210\u672c\u9879\u76ee\u91cd\u590d\u3002"));
                repeatRow.getCell(Col_CostItemId).setValue(null);
                repeatRow.getCell(Col_CostItemNumber).setValue(null);
                repeatRow.getCell(Col_CostItemName).setValue(null);
                this.tblMain.getEditManager().editCellAt(repeatRow.getRowIndex(), repeatRow.getCell(Col_CostItemNumber).getColumnIndex());
            }
            SysUtil.abort();
        }
    }

    private IRow getRow(Map map) {
        String costType = (String)map.get(Col_CostTypeId);
        String activity = (String)map.get(Col_ActivityId);
        String costItem = (String)map.get(Col_CostItemId);
        if (costType == null || activity == null || costItem == null) {
            return null;
        }
        int length = this.tblMain.getExpandedRowCount();
        for (int rowIndex = 0; rowIndex < length; ++rowIndex) {
            IRow row = this.tblMain.getRow(rowIndex);
            Boolean generateBySystem = (Boolean)row.getCell(Col_GenerateBySystem).getValue();
            if (row.getCell(Col_CostTypeId).getValue() == null || row.getCell(Col_ActivityId).getValue() == null || row.getCell(Col_CostItemId).getValue() == null || generateBySystem != null && generateBySystem.booleanValue() || !costType.equals(row.getCell(Col_CostTypeId).getValue().toString()) || !activity.equals(row.getCell(Col_ActivityId).getValue().toString()) || !costItem.equals(row.getCell(Col_CostItemId).getValue().toString())) continue;
            return row;
        }
        return null;
    }

    private Map checkRepeat() {
        HashMap<String, String> resultMap = null;
        boolean flag = false;
        ArrayList list = new ArrayList(this.updateMap.size());
        list.addAll(this.updateMap.values());
        if (list.size() <= 1) {
            return resultMap;
        }
        Map info = null;
        Map anotherInfo = null;
        for (int i = 0; i < list.size(); ++i) {
            info = (Map)list.get(i);
            for (int j = i + 1; j < list.size(); ++j) {
                anotherInfo = (Map)list.get(j);
                if (anotherInfo == null || !this.isSame(info, anotherInfo)) continue;
                resultMap = new HashMap<String, String>();
                resultMap.put(Col_CostTypeId, (String)info.get(Col_CostTypeId));
                resultMap.put(Col_ActivityId, (String)info.get(Col_ActivityId));
                resultMap.put(Col_CostItemId, (String)info.get(Col_CostItemId));
                flag = true;
                break;
            }
            if (flag) break;
        }
        return resultMap;
    }

    private boolean isSame(Map info, Map anotherInfo) {
        String companyOrgId = (String)info.get(Col_CompanyOrgId);
        String costTypeId = (String)info.get(Col_CostTypeId);
        String activityId = (String)info.get(Col_ActivityId);
        String costItemId = (String)info.get(Col_CostItemId);
        String anotherCompanyOrgId = (String)anotherInfo.get(Col_CompanyOrgId);
        String anotherCostTypeId = (String)anotherInfo.get(Col_CostTypeId);
        String anotherActivityId = (String)anotherInfo.get(Col_ActivityId);
        String anotherCostItemId = (String)anotherInfo.get(Col_CostItemId);
        return companyOrgId != null && costTypeId != null && activityId != null && costItemId != null && companyOrgId.equals(anotherCompanyOrgId) && costTypeId.equals(anotherCostTypeId) && activityId.equals(anotherActivityId) && costItemId.equals(anotherCostItemId);
    }

    protected void requestMutex(String comID) throws Exception {
        try {
            this.setOprtState("CLOSING");
            this.pubFireVOChangeListener("d3T+lgEaEADgAAobwKgRj53UGuM=" + comID);
        }
        catch (Throwable t) {
            this.handUIException(t);
            this.abort();
        }
    }

    protected void releaseMutex(String comID) throws Exception {
        this.setOprtState("RELEASEALL");
        try {
            this.pubFireVOChangeListener("d3T+lgEaEADgAAobwKgRj53UGuM=" + comID);
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "OSActivityStdPrice";
        param.alias = "\u4f5c\u4e1a\u6807\u51c6\u8d39\u7387\u8bbe\u7f6e";
        param.datataskMode = 0;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        this.showSaveConfirm();
        this.requestMutex(this.companyId);
        try {
            super.actionImportData_actionPerformed(e);
            this.refresh(e);
        }
        finally {
            this.releaseMutex(this.companyId);
        }
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "OSActivityStdPrice";
        param.alias = "\u4f5c\u4e1a\u6807\u51c6\u8d39\u7387\u8bbe\u7f6e";
        param.datataskMode = 1;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        this.showSaveConfirm();
        super.actionExportData_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.actionAddLine_actionPerformed(e);
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        if (viewInfo == null) {
            viewInfo = new EntityViewInfo();
        }
        if (viewInfo.getSorter() == null || viewInfo.getSorter().size() <= 0 || viewInfo.getSorter().size() == 1 && viewInfo.getSorter().get(0).getPropertyName().equalsIgnoreCase(Col_ID)) {
            SorterItemCollection sorter = new SorterItemCollection();
            SorterItemInfo sorterItemCc = new SorterItemInfo(Col_CompanyOrgName);
            SorterItemInfo sorterItemCi = new SorterItemInfo(Col_CostTypeNumber);
            SorterItemInfo sorterItemCd = new SorterItemInfo(Col_ActivityNumber);
            SorterItemInfo sorterItemCq = new SorterItemInfo(Col_CostItemNumber);
            sorterItemCc.setSortType(SortType.ASCEND);
            sorterItemCi.setSortType(SortType.ASCEND);
            sorterItemCd.setSortType(SortType.ASCEND);
            sorterItemCq.setSortType(SortType.ASCEND);
            sorter.add(sorterItemCc);
            sorter.add(sorterItemCi);
            sorter.add(sorterItemCd);
            sorter.add(sorterItemCq);
            viewInfo.setSorter(sorter);
        }
        IQueryExecutor qe = super.getQueryExecutor(queryPK, viewInfo);
        return qe;
    }

    private class OSActivityStdPriceQueryProcessor
    extends NCMCommonQueryProcessor {
        private OSActivityStdPriceQueryProcessor() {
        }

        public void process() throws Exception {
            super.process();
            Object editor = this.get("CURRENT_EDITOR");
            String fieldProperty = (String)this.get("CURRENT_FIELD_PROP");
            if (editor instanceof KDBizPromptBox) {
                KDBizPromptBox prmt = (KDBizPromptBox)editor;
                if (OSActivityStdPriceListUI.Col_CostTypeNumber.equals(fieldProperty) || OSActivityStdPriceListUI.Col_CostTypeName.equals(fieldProperty)) {
                    EntityViewInfo eviCostType = new EntityViewInfo();
                    eviCostType.setFilter(OSActivityStdPriceListUI.this.getCostTypeFilter());
                    prmt.setEntityViewInfo(eviCostType);
                }
            }
        }
    }

    private final class genProgressHintListener
    implements ProgressHintListener {
        private genProgressHintListener() {
        }

        public void doFunction(Map param) throws Exception {
            Assert.that((boolean)param.containsKey("company"));
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
            CostTypeInfo costTypeInfo = (CostTypeInfo)param.get("costTypeInfo");
            OSActivityStdPriceFactory.getRemoteInstance().GenSettingData(company, costTypeInfo);
        }
    }
}

