/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.std.bill.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ncm.common.BillBaseStatusEnum;
import com.kingdee.eas.ncm.common.NCMIFilterParam;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeInfo;
import com.kingdee.eas.ncm.order.std.bill.OSCostAdjustReqBillFilterParam;
import com.kingdee.eas.ncm.order.std.bill.OSCostAdjustReqBillInfo;
import com.kingdee.eas.ncm.order.std.bill.client.AbstractOSCostAdjustReqBillFilterUI;
import java.util.Date;
import java.util.GregorianCalendar;

public class OSCostAdjustReqBillFilterUI
extends AbstractOSCostAdjustReqBillFilterUI {
    private static final long serialVersionUID = -7869009291799675077L;
    private CompanyOrgUnitInfo companyOrg = null;
    private String CostType = "costType";
    private String BillStatus = "billStatus";
    private String BillNumber = "billNumber";
    private String BizDataFrom = "bizDataFrom";
    private String BizDateTo = "bizDateTo";

    public OSCostAdjustReqBillFilterUI() throws Exception {
        this.cbStatus.removeAllItems();
        this.cbStatus.addItems(new Object[]{BillBaseStatusEnum.TEMPORARILYSAVED, BillBaseStatusEnum.AUDITED});
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        this.f7Company.setData((Object)this.companyOrg);
        BDCMClientUtils.filterF7((KDBizPromptBox)this.f7CostType, (String)"company.id", (Object)this.companyOrg.getId().toString());
        BDCMClientUtils.filterF7((KDBizPromptBox)this.f7CostType, (String)"status", (Object)new Integer(4));
        BDCMClientUtils.filterF7((KDBizPromptBox)this.f7Bill, (String)"companyOrg.id", (Object)this.companyOrg.getId().toString());
        this.setDefualtValue();
    }

    protected void isStart() throws Exception {
    }

    public OSCostAdjustReqBillFilterParam getFilterParam() {
        OSCostAdjustReqBillFilterParam filterParam = (OSCostAdjustReqBillFilterParam)this.createNewFilterParam();
        this.storeFilterParam(filterParam);
        return filterParam;
    }

    protected NCMIFilterParam createNewFilterParam() {
        return new OSCostAdjustReqBillFilterParam();
    }

    protected void loadBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof OSCostAdjustReqBillFilterParam)) {
            return;
        }
        OSCostAdjustReqBillFilterParam fp = (OSCostAdjustReqBillFilterParam)filterParam;
        CostTypeInfo costType = null;
        String costTypeData = customerParams.getCustomerParam(this.CostType);
        if (costTypeData != null && costTypeData.length() > 0) {
            costType = new CostTypeInfo();
            costType.setId(BOSUuid.read((String)costTypeData));
        }
        fp.setCostType(costType);
        OSCostAdjustReqBillInfo bill = null;
        String billData = customerParams.getCustomerParam(this.BillNumber);
        if (billData != null && billData.length() > 0) {
            bill = new OSCostAdjustReqBillInfo();
            bill.setId(BOSUuid.read((String)billData));
        }
        fp.setBill(bill);
        BillBaseStatusEnum status = null;
        String statusDate = customerParams.getCustomerParam(this.BillStatus);
        if ("2".equals(statusDate)) {
            status = BillBaseStatusEnum.TEMPORARILYSAVED;
        } else if ("4".equals(statusDate)) {
            status = BillBaseStatusEnum.AUDITED;
        }
        fp.setStatus(status);
        String beginDate = customerParams.getCustomerParam(this.BizDataFrom);
        String endDate = customerParams.getCustomerParam(this.BizDateTo);
        fp.setBizDateFrom(Long.parseLong(beginDate));
        fp.setBizDateTo(Long.parseLong(endDate));
    }

    protected void loadFilterParam(NCMIFilterParam filterParam) {
        if (!(filterParam instanceof OSCostAdjustReqBillFilterParam)) {
            return;
        }
        OSCostAdjustReqBillFilterParam fp = (OSCostAdjustReqBillFilterParam)filterParam;
        this.f7CostType.setData((Object)fp.getCostType());
        this.f7Bill.setData((Object)fp.getBill());
        this.cbStatus.setSelectedItem((Object)fp.getStatus());
        if (fp.getBizDateFrom() != 0L) {
            this.pickerBizDateFrom.setValue((Object)new Date(fp.getBizDateFrom()));
        } else {
            this.pickerBizDateFrom.setValue(null);
        }
        if (fp.getBizDateTo() != 0L) {
            this.pickerBizDateTo.setValue((Object)new Date(fp.getBizDateTo()));
        } else {
            this.pickerBizDateTo.setValue(null);
        }
    }

    protected void storeBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof OSCostAdjustReqBillFilterParam)) {
            return;
        }
        OSCostAdjustReqBillFilterParam fp = (OSCostAdjustReqBillFilterParam)filterParam;
        super.putIdByKey(customerParams, (Object)fp.getCostType(), this.CostType);
        super.putIdByKey(customerParams, (Object)fp.getBill(), this.BillNumber);
        super.putIdByKey(customerParams, (Object)String.valueOf(fp.getStatus().getValue()), this.BillStatus);
        super.putIdByKey(customerParams, (Object)new Long(fp.getBizDateFrom()).toString(), this.BizDataFrom);
        super.putIdByKey(customerParams, (Object)new Long(fp.getBizDateTo()).toString(), this.BizDateTo);
    }

    protected void storeFilterParam(NCMIFilterParam filterParam) {
        if (!(filterParam instanceof OSCostAdjustReqBillFilterParam)) {
            return;
        }
        OSCostAdjustReqBillFilterParam fp = (OSCostAdjustReqBillFilterParam)filterParam;
        Object temp = null;
        CostTypeInfo costTypeInfo = null;
        temp = this.f7CostType.getData();
        if (temp != null && temp instanceof CostTypeInfo) {
            costTypeInfo = (CostTypeInfo)temp;
        }
        fp.setCostType(costTypeInfo);
        OSCostAdjustReqBillInfo billInfo = null;
        temp = this.f7Bill.getData();
        if (temp != null && temp instanceof OSCostAdjustReqBillInfo) {
            billInfo = (OSCostAdjustReqBillInfo)temp;
        }
        fp.setBill(billInfo);
        Object status = this.cbStatus.getSelectedItem();
        if (status instanceof BillBaseStatusEnum) {
            fp.setStatus((BillBaseStatusEnum)status);
        }
        long bizDateFrom = 0L;
        long bizDateTo = 0L;
        temp = this.pickerBizDateFrom.getValue();
        if (temp != null && temp instanceof Date) {
            bizDateFrom = ((Date)temp).getTime();
        }
        if ((temp = this.pickerBizDateTo.getValue()) != null && temp instanceof Date) {
            bizDateTo = ((Date)temp).getTime();
        }
        fp.setBizDateFrom(bizDateFrom);
        fp.setBizDateTo(bizDateTo);
    }

    private void setDefualtValue() {
        Date today = new Date();
        GregorianCalendar beginCalendar = new GregorianCalendar();
        beginCalendar.setTime(today);
        int day = beginCalendar.get(5);
        day = day > 5 ? (day -= 5) : 1;
        beginCalendar.set(5, day);
        beginCalendar.set(11, 0);
        beginCalendar.set(12, 0);
        beginCalendar.set(13, 0);
        this.pickerBizDateFrom.setValue((Object)beginCalendar.getTime());
        GregorianCalendar endCalendar = new GregorianCalendar();
        endCalendar.setTime(today);
        endCalendar.set(11, 23);
        endCalendar.set(12, 59);
        endCalendar.set(13, 59);
        this.pickerBizDateTo.setValue((Object)endCalendar.getTime());
        this.cbStatus.setSelectedIndex(0);
    }

    public void clear() {
        try {
            this.clearFilterData();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void clearFilterData() {
        this.f7CostType.setValue(null);
        this.f7Bill.setValue(null);
        this.setDefualtValue();
    }
}

