/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.std.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.order.common.utils.OrderCMUtils;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeCollection;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeFactory;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeInfo;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeLevelEnum;
import com.kingdee.eas.ncm.order.std.report.client.AbstractMaterialCostDiffReportFilterUI;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.text.ParseException;
import java.util.HashSet;

public class MaterialCostDiffReportFilterUI
extends AbstractMaterialCostDiffReportFilterUI {
    private static final long serialVersionUID = -6841644810674134496L;
    private CompanyOrgUnitInfo company = null;
    private static final String _f7Company = "f7Company";
    private static final String _f7CostType = "f7CostType";
    private static final String _f7OrderFrom = "f7OrderFrom";
    private static final String _f7OrderTo = "f7OrderTo";
    private static final String _f7ProductFrom = "f7ProductFrom";
    private static final String _f7ProductTo = "f7ProductTo";
    private static final String _f7Period = "f7Period";

    public MaterialCostDiffReportFilterUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
        this.company = SysContext.getSysContext().getCurrentFIUnit();
        OrderCMUtils.checkStart(this.company.getId().toString());
        this.init();
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    private void init() throws Exception {
        this.f7Company.setValue((Object)this.company);
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)new SingleBizPromptFilterElement("company", this.f7Company));
        elements.add((FilterElement)new SingleBizPromptFilterElement("costType", this.f7CostType));
        elements.add((FilterElement)new SingleBizPromptFilterElement("orderFrom", this.f7OrderFrom));
        elements.add((FilterElement)new SingleBizPromptFilterElement("orderTo", this.f7OrderTo));
        elements.add((FilterElement)new SingleBizPromptFilterElement("productFrom", this.f7ProductFrom));
        elements.add((FilterElement)new SingleBizPromptFilterElement("productTo", this.f7ProductTo));
        elements.add((FilterElement)new SingleBizPromptFilterElement("period", this.f7Period));
        this.getFilterManager().setElement((FilterElement)elements);
        this.filterCostType();
        this.filterOrder(this.f7OrderFrom);
        this.f7OrderFrom.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                if (MaterialCostDiffReportFilterUI.this.f7CostType.getValue() == null) {
                    MsgBox.showWarning((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u7c7b\u578b\uff01");
                    SysUtil.abort();
                }
                try {
                    MaterialCostDiffReportFilterUI.this.filterOrder(MaterialCostDiffReportFilterUI.this.f7OrderFrom);
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Throwable)ex);
                }
            }
        });
        this.filterOrder(this.f7OrderTo);
        this.f7OrderTo.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                if (MaterialCostDiffReportFilterUI.this.f7CostType.getValue() == null) {
                    MsgBox.showWarning((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u7c7b\u578b\uff01");
                    SysUtil.abort();
                }
                try {
                    MaterialCostDiffReportFilterUI.this.filterOrder(MaterialCostDiffReportFilterUI.this.f7OrderTo);
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Throwable)ex);
                }
            }
        });
        this.filterPeriod();
        this.f7Period.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                if (MaterialCostDiffReportFilterUI.this.f7CostType.getValue() == null) {
                    MsgBox.showWarning((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u7c7b\u578b\uff01");
                    SysUtil.abort();
                }
                try {
                    MaterialCostDiffReportFilterUI.this.filterPeriod();
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Throwable)ex);
                }
            }
        });
        this.filterProduct(this.f7ProductFrom);
        this.f7ProductFrom.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                if (MaterialCostDiffReportFilterUI.this.f7CostType.getValue() == null) {
                    MsgBox.showWarning((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u7c7b\u578b\uff01");
                    SysUtil.abort();
                }
                try {
                    MaterialCostDiffReportFilterUI.this.filterProduct(MaterialCostDiffReportFilterUI.this.f7ProductFrom);
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Throwable)ex);
                }
            }
        });
        this.filterProduct(this.f7ProductTo);
        this.f7ProductTo.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                if (MaterialCostDiffReportFilterUI.this.f7CostType.getValue() == null) {
                    MsgBox.showWarning((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u7c7b\u578b\uff01");
                    SysUtil.abort();
                }
                try {
                    MaterialCostDiffReportFilterUI.this.filterProduct(MaterialCostDiffReportFilterUI.this.f7ProductTo);
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Throwable)ex);
                }
            }
        });
    }

    private void filterCostType() throws Exception {
        BDCMClientUtils.filterF7((KDBizPromptBox)this.f7CostType, (String)"company.id", (Object)this.company.getId().toString());
        BDCMClientUtils.filterF7((KDBizPromptBox)this.f7CostType, (String)"status", (Object)new Integer(4));
    }

    private void filterOrder(KDBizPromptBox f7Order) throws Exception {
        BDCMClientUtils.filterOrderF7((KDBizPromptBox)f7Order, (String)this.company.getId().toString(), (BillBaseStatusEnum[])new BillBaseStatusEnum[]{BillBaseStatusEnum.FINCLOSED});
    }

    private void filterPeriod() throws Exception {
        EntityViewInfo view = null;
        view = this.f7Period.getEntityViewInfo() == null ? new EntityViewInfo() : this.f7Period.getEntityViewInfo();
        PeriodInfo startPeriod = OrderCMUtils.getStartPeriod(this.company.getId().toString());
        PeriodInfo curPeriod = OrderCMUtils.getCurrentPeriod(this.company.getId().toString());
        String fiPeriodTypeId = this.company.getAccountPeriodType().getId().toString();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)fiPeriodTypeId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)new Integer(startPeriod.getNumber()), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)new Integer(curPeriod.getNumber()), CompareType.LESS_EQUALS));
        try {
            filter.mergeFilter(view.getFilter(), "AND");
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        view.setFilter(filter);
        this.f7Period.setEntityViewInfo(view);
    }

    private void filterProduct(KDBizPromptBox f7Product) throws Exception {
        BDCMClientUtils.filterF7((KDBizPromptBox)f7Product, (String)"company.id", (Object)this.company.getId().toString());
        BDCMClientUtils.filterF7((KDBizPromptBox)f7Product, (String)"materialCompany.calculateType", (Object)new Integer(2));
    }

    @Override
    protected void f7CostType_dataChanged(DataChangeEvent event) throws Exception {
        CostTypeInfo costType = null;
        if (this.f7CostType.getValue() instanceof CostTypeInfo) {
            costType = (CostTypeInfo)this.f7CostType.getValue();
        } else if (this.f7CostType.getValue() instanceof CostTypeInfo[]) {
            costType = ((CostTypeInfo[])this.f7CostType.getValue())[0];
        }
        if (costType != null) {
            if (costType.getLevel() == null) {
                costType = CostTypeFactory.getRemoteInstance().getCostTypeInfo((IObjectPK)new ObjectUuidPK(costType.getId().toString()));
            }
            if (CostTypeLevelEnum.order.equals((Object)costType.getLevel())) {
                this.f7OrderFrom.setEnabled(true);
                this.f7OrderTo.setEnabled(true);
                this.f7Period.setEnabled(false);
                this.f7ProductFrom.setEnabled(false);
                this.f7ProductTo.setEnabled(false);
                this.f7Period.setValue(null);
                this.f7ProductFrom.setValue(null);
                this.f7ProductTo.setValue(null);
            } else {
                this.f7OrderFrom.setValue(null);
                this.f7OrderTo.setValue(null);
                this.f7Period.setEnabled(true);
                this.f7OrderFrom.setEnabled(false);
                this.f7OrderTo.setEnabled(false);
                this.f7ProductFrom.setEnabled(true);
                this.f7ProductTo.setEnabled(true);
            }
        } else {
            this.f7OrderFrom.setValue(null);
            this.f7OrderTo.setValue(null);
            this.f7ProductFrom.setValue(null);
            this.f7ProductTo.setValue(null);
            this.f7Period.setValue(null);
            this.f7OrderFrom.setEnabled(true);
            this.f7OrderTo.setEnabled(true);
            this.f7ProductFrom.setEnabled(true);
            this.f7ProductTo.setEnabled(true);
            this.f7Period.setEnabled(true);
        }
    }

    @Override
    protected void f7OrderFrom_dataChanged(DataChangeEvent event) throws Exception {
    }

    @Override
    protected void f7OrderTo_dataChanged(DataChangeEvent event) throws Exception {
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        CostTypeInfo[] costTypes;
        super.loadData(entityViewInfo);
        this.company = SysContext.getSysContext().getCurrentFIUnit();
        this.f7Company.setValue((Object)this.company);
        CustomerParams params = this.getCustomerParams();
        if (params != null) {
            this.loadCosType(params);
            this.loadPeriod(params);
            this.loadOrder(params, _f7OrderFrom, this.f7OrderFrom);
            this.loadOrder(params, _f7OrderTo, this.f7OrderTo);
            this.loadMaterial(params, _f7ProductFrom, this.f7ProductFrom);
            this.loadMaterial(params, _f7ProductTo, this.f7ProductTo);
        }
        if (this.f7CostType.getValue() instanceof CostTypeInfo[] && (costTypes = (CostTypeInfo[])this.f7CostType.getValue()).length > 0) {
            CostTypeInfo costType = costTypes[0];
            if (CostTypeLevelEnum.order.equals((Object)costType.getLevel())) {
                this.f7OrderFrom.setEnabled(true);
                this.f7OrderTo.setEnabled(true);
                this.f7Period.setEnabled(false);
                this.f7ProductFrom.setEnabled(false);
                this.f7ProductTo.setEnabled(false);
            } else {
                this.f7Period.setEnabled(true);
                this.f7OrderFrom.setEnabled(false);
                this.f7OrderTo.setEnabled(false);
                this.f7ProductFrom.setEnabled(true);
                this.f7ProductTo.setEnabled(true);
            }
        }
        try {
            this.f7CostType_dataChanged(null);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private void loadCosType(CustomerParams params) {
        String costType = "";
        if (params.getCustomerParam(_f7CostType) != null) {
            costType = params.getCustomerParam(_f7CostType);
        }
        if (StringUtils.isEmpty((String)costType)) {
            this.f7CostType.setData(null);
            return;
        }
        String[] costTypeNumbers = costType.split(";");
        HashSet<String> costTypeSet = new HashSet<String>();
        for (int i = 0; i < costTypeNumbers.length; ++i) {
            costTypeSet.add(costTypeNumbers[i].trim());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", costTypeSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.company.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        view.setSelector(sic);
        CostTypeCollection costTypeCol = null;
        try {
            costTypeCol = CostTypeFactory.getRemoteInstance().getCostTypeCollection(view);
            if (costTypeCol != null && costTypeCol.size() > 0) {
                int size = costTypeCol.size();
                CostTypeInfo[] costTypes = new CostTypeInfo[size];
                for (int i = 0; i < size; ++i) {
                    costTypes[i] = costTypeCol.get(i);
                }
                this.f7CostType.setData((Object)costTypes);
            }
        }
        catch (BOSException e) {
            this.f7CostType.setData(null);
        }
    }

    private void loadPeriod(CustomerParams params) {
        String period = "";
        if (params.getCustomerParam(_f7Period) != null) {
            period = params.getCustomerParam(_f7Period);
        }
        if (StringUtils.isEmpty((String)period)) {
            this.f7Period.setData(null);
            return;
        }
        String[] periodNumbers = period.split(";");
        HashSet<String> periodSet = new HashSet<String>();
        for (int i = 0; i < periodNumbers.length; ++i) {
            periodSet.add(periodNumbers[i].trim());
        }
        int startPeriodNumber = 209911;
        int curPeriodNumber = 190001;
        try {
            PeriodInfo curPeriod;
            PeriodInfo startPeriod = OrderCMUtils.getStartPeriod(this.company.getId().toString());
            if (startPeriod != null) {
                startPeriodNumber = startPeriod.getNumber();
            }
            if ((curPeriod = OrderCMUtils.getCurrentPeriod(this.company.getId().toString())) != null) {
                curPeriodNumber = curPeriod.getNumber();
            }
        }
        catch (Exception exc) {
            this.handUIException(exc);
        }
        String fiPeriodTypeId = this.company.getAccountPeriodType().getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", periodSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)fiPeriodTypeId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)new Integer(startPeriodNumber), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)new Integer(curPeriodNumber), CompareType.LESS_EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        view.setSelector(sic);
        PeriodCollection periodCol = null;
        try {
            periodCol = PeriodFactory.getRemoteInstance().getPeriodCollection(view);
            if (periodCol != null && periodCol.size() > 0) {
                int size = periodCol.size();
                PeriodInfo[] periods = new PeriodInfo[size];
                for (int i = 0; i < size; ++i) {
                    periods[i] = periodCol.get(i);
                }
                this.f7Period.setData((Object)periods);
            }
        }
        catch (BOSException e) {
            this.f7Period.setData(null);
        }
    }

    private void loadOrder(CustomerParams params, String _f7Order, KDBizPromptBox f7Order) {
        String order = "";
        if (params.getCustomerParam(_f7Order) != null) {
            order = params.getCustomerParam(_f7Order);
        }
        if (StringUtils.isEmpty((String)order)) {
            f7Order.setData(null);
            return;
        }
        String[] orderNumbers = order.split(";");
        HashSet<String> orderNumbersSet = new HashSet<String>();
        for (int i = 0; i < orderNumbers.length; ++i) {
            orderNumbersSet.add(orderNumbers[i].trim());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", orderNumbersSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        view.setSelector(sic);
        ManufactureOrderCollection orderCol = null;
        try {
            orderCol = ManufactureOrderFactory.getRemoteInstance().getManufactureOrderCollection(view);
            if (orderCol != null && orderCol.size() > 0) {
                int size = orderCol.size();
                ManufactureOrderInfo[] orders = new ManufactureOrderInfo[size];
                for (int i = 0; i < size; ++i) {
                    orders[i] = orderCol.get(i);
                }
                f7Order.setData((Object)orders);
            }
        }
        catch (BOSException e) {
            f7Order.setData(null);
        }
    }

    private void loadMaterial(CustomerParams params, String _f7Product, KDBizPromptBox f7Product) {
        String material = "";
        if (params.getCustomerParam(_f7Product) != null) {
            material = params.getCustomerParam(_f7Product);
        }
        if (StringUtils.isEmpty((String)material)) {
            f7Product.setData(null);
            return;
        }
        String[] matNumbers = material.split(";");
        HashSet<String> matNumbersSet = new HashSet<String>();
        for (int i = 0; i < matNumbers.length; ++i) {
            matNumbersSet.add(matNumbers[i].trim());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("mateial.number", matNumbersSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.company.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("mateial.id"));
        sic.add(new SelectorItemInfo("mateial.name"));
        sic.add(new SelectorItemInfo("mateial.number"));
        view.setSelector(sic);
        MaterialCompanyInfoCollection expenseColl = null;
        try {
            expenseColl = MaterialCompanyInfoFactory.getRemoteInstance().getMaterialCompanyInfoCollection(view);
            if (expenseColl != null && expenseColl.size() > 0) {
                int size = expenseColl.size();
                MaterialInfo[] materials = new MaterialInfo[size];
                for (int i = 0; i < size; ++i) {
                    materials[i] = expenseColl.get(i).getMateial();
                }
                f7Product.setData((Object)materials);
            }
        }
        catch (BOSException e) {
            f7Product.setData(null);
        }
    }

    protected void setDefaultValue() {
        this.company = SysContext.getSysContext().getCurrentFIUnit();
        this.f7Company.setValue((Object)this.company);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.company.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"STD_001", CompareType.EQUALS));
        view.setFilter(filter);
        CostTypeCollection col = null;
        try {
            col = CostTypeFactory.getRemoteInstance().getCostTypeCollection(view);
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        if (col != null && col.size() > 0) {
            this.f7CostType.setValue((Object)col.get(0));
        }
    }

    public void clear() {
        this.getFilterManager().clearAll();
        this.setDefaultValue();
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.f7Company;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    public boolean verify() {
        int level;
        boolean ok = super.verify();
        if (!(this.f7CostType.getValue() instanceof CostTypeInfo[]) && !(this.f7CostType.getValue() instanceof CostTypeInfo)) {
            MsgBox.showWarning((String)"\u8bf7\u9009\u62e9\u6210\u672c\u7c7b\u578b\uff01");
            return false;
        }
        CostTypeInfo costType = null;
        if (this.f7CostType.getValue() instanceof CostTypeInfo[]) {
            costType = ((CostTypeInfo[])this.f7CostType.getValue())[0];
        } else if (this.f7CostType.getValue() instanceof CostTypeInfo) {
            costType = (CostTypeInfo)this.f7CostType.getValue();
        } else {
            return false;
        }
        if (costType.getLevel() == null) {
            try {
                costType = CostTypeFactory.getRemoteInstance().getCostTypeInfo((IObjectPK)new ObjectUuidPK(costType.getId().toString()));
            }
            catch (Exception e) {
                return false;
            }
        }
        if ((level = costType.getLevel().getValue()) != 6 && level == 3 && this.f7Period.getValue() == null) {
            MsgBox.showWarning((String)"\u8bf7\u9009\u62e9\u4f1a\u8ba1\u671f\u95f4\uff01");
            return false;
        }
        return ok;
    }

    static class SingleBizPromptFilterElement
    extends SingleFilterElement {
        KDBizPromptBox prmt;

        public SingleBizPromptFilterElement(String id, KDBizPromptBox component) {
            super(id, (Component)component);
            this.prmt = component;
        }

        public void addRptParams(RptParams cp) {
            Object object = this.prmt.getValue();
            if (object == null) {
                try {
                    this.prmt.commitEdit();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                object = this.prmt.getValue();
            }
            if (object instanceof Object[]) {
                object = ((Object[])object)[0];
            }
            cp.setObject(this.getId(), object);
        }
    }
}

