/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.std.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.order.common.utils.OrderCMUtils;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeCollection;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeFactory;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeInfo;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeLevelEnum;
import com.kingdee.eas.ncm.order.std.report.client.AbstractOCActivityCostDiffReportFilterUI;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class OCActivityCostDiffReportFilterUI
extends AbstractOCActivityCostDiffReportFilterUI {
    private static final long serialVersionUID = 8846435613762698263L;
    private static final Logger logger = CoreUIObject.getLogger(OCActivityCostDiffReportFilterUI.class);
    private CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
    private String companyId = this.company.getId().toString();
    private PeriodInfo period = null;
    private PeriodInfo startPeriod = null;
    protected boolean isNormal = true;
    private Set storageOrgUnitIds = null;
    private CustomerParams cp = null;
    private FilterInfo costTypeBaseFilter = null;
    private CostTypeInfo std001 = null;
    private FilterInfo orderBaseFilter = null;
    private FilterInfo periodBaseFilter = null;
    private FilterInfo productBaseFilter = null;

    public OCActivityCostDiffReportFilterUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
        OrderCMUtils.checkStart(SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        this.period = OrderCMUtils.getCurrentPeriod(this.companyId);
        this.startPeriod = OrderCMUtils.getStartPeriod(this.companyId);
        this.prmtCostType.setQueryInfo("com.kingdee.eas.ncm.order.std.basedata.app.CostTypeQuery");
        this.prmtCostType.setEditable(true);
        this.prmtCostType.setRequired(true);
        this.prmtCostType.setDisplayFormat("$name$");
        this.prmtCostType.setEditFormat("$number$");
        this.prmtCostType.setCommitFormat("$number$");
        FilterInfo costTypeBaseFilter = this.getCostTypeBaseFilter();
        this.setFilterInfoF7(this.prmtCostType, costTypeBaseFilter);
        this.prmtCostType.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                OCActivityCostDiffReportFilterUI.this.prmtCostTypeDataChanged(eventObj);
            }
        });
        this.prmtCostTypeDataChanged(null);
        this.prmtOrderFrom.setQueryInfo("com.kingdee.eas.mm.mo.app.F7ManufactureOrderQuery");
        this.prmtOrderFrom.setVisible(true);
        this.prmtOrderFrom.setEditable(true);
        this.prmtOrderFrom.setDisplayFormat("$number$");
        this.prmtOrderFrom.setEditFormat("$number$");
        this.prmtOrderFrom.setCommitFormat("$number$");
        FilterInfo orderBaseFilter = this.getOrderBaseFilter();
        this.setFilterInfoF7(this.prmtOrderFrom, orderBaseFilter);
        this.prmtOrderTo.setQueryInfo("com.kingdee.eas.mm.mo.app.F7ManufactureOrderQuery");
        this.prmtOrderTo.setVisible(true);
        this.prmtOrderTo.setEditable(true);
        this.prmtOrderTo.setDisplayFormat("$number$");
        this.prmtOrderTo.setEditFormat("$number$");
        this.prmtOrderTo.setCommitFormat("$number$");
        orderBaseFilter = this.getOrderBaseFilter();
        this.setFilterInfoF7(this.prmtOrderTo, orderBaseFilter);
        this.prmtPeriod.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7PeriodQuery");
        this.prmtPeriod.setVisible(true);
        this.prmtPeriod.setEditable(true);
        this.prmtPeriod.setDisplayFormat("$periodYear$\u5e74$periodNumber$\u671f");
        this.prmtPeriod.setEditFormat("$number$");
        this.prmtPeriod.setCommitFormat("$number$");
        FilterInfo periodBaseFilter = this.getPeriodBaseFilter();
        this.setFilterInfoF7(this.prmtPeriod, periodBaseFilter);
        this.prmtProductFrom.setVisible(true);
        this.prmtProductFrom.setEditable(true);
        this.prmtProductFrom.setDisplayFormat("$name$");
        this.prmtProductFrom.setEditFormat("$number$");
        this.prmtProductFrom.setCommitFormat("$number$");
        FilterInfo productBaseFilter = this.getProductBaseFilter();
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(productBaseFilter);
        this.prmtProductFrom.setEntityViewInfo(view);
        NCMUtils.materialTreeDisplay((Object)((Object)this), (KDBizPromptBox)this.prmtProductFrom, (FilterInfo)productBaseFilter);
        this.prmtProductTo.setVisible(true);
        this.prmtProductTo.setEditable(true);
        this.prmtProductTo.setDisplayFormat("$name$");
        this.prmtProductTo.setEditFormat("$number$");
        this.prmtProductTo.setCommitFormat("$number$");
        productBaseFilter = this.getProductBaseFilter();
        view = new EntityViewInfo();
        view.setFilter(productBaseFilter);
        this.prmtProductTo.setEntityViewInfo(view);
        NCMUtils.materialTreeDisplay((Object)((Object)this), (KDBizPromptBox)this.prmtProductTo, (FilterInfo)productBaseFilter);
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)new SingleBizPromptFilterElement("company", this.prmtCompany));
        elements.add((FilterElement)new SingleFilterElement("costType", (Component)this.prmtCostType));
        elements.add((FilterElement)new SingleFilterElement("orderFrom", (Component)this.prmtOrderFrom));
        elements.add((FilterElement)new SingleFilterElement("orderTo", (Component)this.prmtOrderTo));
        elements.add((FilterElement)new PeriodFilterElement("period", this.prmtPeriod));
        elements.add((FilterElement)new SingleFilterElement("productFrom", (Component)this.prmtProductFrom));
        elements.add((FilterElement)new SingleFilterElement("productTo", (Component)this.prmtProductTo));
        this.getFilterManager().setElement((FilterElement)elements);
    }

    public void prmtCostTypeDataChanged(DataChangeEvent eventObj) {
        Object temp = this.prmtCostType.getValue();
        this.prmtOrderFrom.setEnabled(false);
        this.prmtOrderTo.setEnabled(false);
        this.prmtPeriod.setEnabled(false);
        this.prmtPeriod.setRequired(false);
        this.prmtProductFrom.setEnabled(false);
        this.prmtProductTo.setEnabled(false);
        if (temp instanceof CostTypeInfo) {
            CostTypeInfo costType = (CostTypeInfo)temp;
            if (costType.getLevel().equals((Object)CostTypeLevelEnum.product)) {
                this.prmtPeriod.setEnabled(true);
                this.prmtPeriod.setRequired(true);
                this.prmtProductFrom.setEnabled(true);
                this.prmtProductTo.setEnabled(true);
                this.prmtOrderFrom.setValue(null);
                this.prmtOrderTo.setValue(null);
            } else if (costType.getLevel().equals((Object)CostTypeLevelEnum.order)) {
                this.prmtOrderFrom.setEnabled(true);
                this.prmtOrderTo.setEnabled(true);
                this.prmtPeriod.setValue(null);
                this.prmtProductFrom.setValue(null);
                this.prmtProductTo.setValue(null);
            }
        }
    }

    private Set getStorageOrgUnitIds() throws EASBizException, BOSException {
        if (this.storageOrgUnitIds == null) {
            this.storageOrgUnitIds = BDCMUtils.getStorageOrgUnitIdsOfCompany(null, (String)this.companyId);
        }
        return this.storageOrgUnitIds;
    }

    protected void setDefaultValue() {
        this.prmtCompany.setValue((Object)this.company);
        this.prmtCostType.setValue((Object)this.getCostTypeSTD001());
        this.prmtOrderFrom.setValue(null);
        this.prmtOrderTo.setValue(null);
        this.prmtPeriod.setValue(null);
        this.prmtProductFrom.setValue(null);
        this.prmtProductTo.setValue(null);
    }

    private void setFilterInfoF7(KDBizPromptBox f7, FilterInfo filter) {
        EntityViewInfo view = f7.getEntityViewInfo() != null ? f7.getEntityViewInfo() : new EntityViewInfo();
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    private FilterInfo getCostTypeBaseFilter() {
        if (this.costTypeBaseFilter == null) {
            this.costTypeBaseFilter = new FilterInfo();
            this.costTypeBaseFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyId));
            this.costTypeBaseFilter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(4)));
        }
        return (FilterInfo)this.costTypeBaseFilter.clone();
    }

    protected FilterInfo getOrderBaseFilter() throws Exception {
        if (this.orderBaseFilter == null) {
            this.orderBaseFilter = new FilterInfo();
            Set storageOrgUnitIds = this.getStorageOrgUnitIds();
            this.orderBaseFilter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitIds, CompareType.INCLUDE));
            HashSet<Integer> set = new HashSet<Integer>();
            set.add(new Integer(11));
            this.orderBaseFilter.getFilterItems().add(new FilterItemInfo("baseStatus", set, CompareType.INCLUDE));
        }
        return (FilterInfo)this.orderBaseFilter.clone();
    }

    protected FilterInfo getPeriodBaseFilter() throws Exception {
        if (this.periodBaseFilter == null) {
            this.periodBaseFilter = new FilterInfo();
            this.periodBaseFilter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)this.company.getAccountPeriodType().getId().toString()));
            this.periodBaseFilter.getFilterItems().add(new FilterItemInfo("number", (Object)new Integer(this.startPeriod.getNumber()), CompareType.GREATER_EQUALS));
            this.periodBaseFilter.getFilterItems().add(new FilterItemInfo("number", (Object)new Integer(this.period.getNumber()), CompareType.LESS_EQUALS));
        }
        return (FilterInfo)this.periodBaseFilter.clone();
    }

    protected FilterInfo getProductBaseFilter() throws Exception {
        if (this.productBaseFilter == null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyId));
            filter.getFilterItems().add(new FilterItemInfo("FIInfo.status", (Object)new Integer(1)));
            filter.getFilterItems().add(new FilterItemInfo("FIInfo.calculateType", (Object)new Integer(2)));
            return filter;
        }
        return (FilterInfo)this.productBaseFilter.clone();
    }

    protected IObjectPK getBizCUPK() {
        Object object = this.getUIContext().get(this.getMainBizOrgType());
        CtrlUnitInfo currentBizOrg = object == null ? SysContext.getSysContext().getCurrentCtrlUnit() : (OrgUnitInfo)object;
        return new ObjectUuidPK(currentBizOrg.getCU().getId());
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
    }

    public void clear() {
        this.getFilterManager().clearAll();
        this.setDefaultValue();
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompany;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    public boolean verify() {
        Object temp = this.prmtCostType.getValue();
        if (temp == null || !(temp instanceof CostTypeInfo)) {
            MsgBox.showInfo((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u7c7b\u578b\u3002");
            return false;
        }
        CostTypeInfo costType = (CostTypeInfo)temp;
        if (costType.getLevel().equals((Object)CostTypeLevelEnum.product)) {
            temp = this.prmtPeriod.getValue();
            if (temp == null || !(temp instanceof PeriodInfo)) {
                MsgBox.showInfo((String)"\u8bf7\u5148\u9009\u62e9\u4f1a\u8ba1\u671f\u95f4\u3002");
                return false;
            }
        } else {
            Object orderFrom = this.prmtOrderFrom.getValue();
            Object orderTo = this.prmtOrderTo.getValue();
            if (!(orderFrom != null && orderFrom instanceof ManufactureOrderInfo || orderTo != null && orderTo instanceof ManufactureOrderInfo)) {
                MsgBox.showInfo((String)"\u8bf7\u5148\u9009\u62e9\u8ba2\u5355\u3002");
                return false;
            }
        }
        return true;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        this.prmtCompany.setValue((Object)this.company);
        CustomerParams params = this.cp;
        if (params != null) {
            this.loadCostType(params);
            this.loadPeriod(params);
            this.loadProduct(params);
            this.loadOrder(params);
        }
    }

    private void loadCostType(CustomerParams params) {
        this.prmtCostType.setData(null);
        String costType = "";
        if (params.getCustomerParam("prmtCostType") != null) {
            costType = params.getCustomerParam("prmtCostType");
        }
        if (StringUtils.isEmpty((String)costType)) {
            return;
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costType));
            FilterInfo costTypeBaseFilter = this.getCostTypeBaseFilter();
            filter.mergeFilter(costTypeBaseFilter, "and");
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("level"));
            view.setSelector(sic);
            CostTypeCollection coll = CostTypeFactory.getRemoteInstance().getCostTypeCollection(view);
            if (coll != null && coll.size() > 0) {
                this.prmtCostType.setValue((Object)coll.get(0));
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    private CostTypeInfo getCostTypeSTD001() {
        if (this.std001 != null) {
            return this.std001;
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)"STD_001"));
            FilterInfo costTypeBaseFilter = this.getCostTypeBaseFilter();
            filter.mergeFilter(costTypeBaseFilter, "and");
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("level"));
            view.setSelector(sic);
            CostTypeCollection coll = CostTypeFactory.getRemoteInstance().getCostTypeCollection(view);
            if (coll != null && coll.size() > 0) {
                this.std001 = coll.get(0);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return this.std001;
    }

    private void loadOrder(CustomerParams params) {
        this.prmtOrderFrom.setData(null);
        this.prmtOrderTo.setData(null);
        Object temp = this.prmtCostType.getValue();
        if (temp == null || !(temp instanceof CostTypeInfo) || !((CostTypeInfo)temp).getLevel().equals((Object)CostTypeLevelEnum.order)) {
            return;
        }
        HashSet<String> numbersSet = new HashSet<String>();
        String orderFrom = "";
        String orderTo = "";
        if (params.getCustomerParam("prmtOrderFrom") != null && (orderFrom = params.getCustomerParam("prmtOrderFrom").trim()).length() > 0) {
            numbersSet.add(orderFrom);
        }
        if (params.getCustomerParam("prmtOrderTo") != null && (orderTo = params.getCustomerParam("prmtOrderTo").trim()).length() > 0) {
            numbersSet.add(orderTo);
        }
        if (numbersSet.size() <= 0) {
            return;
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", numbersSet, CompareType.INCLUDE));
            FilterInfo orderBaseFilter = this.getOrderBaseFilter();
            filter.mergeFilter(orderBaseFilter, "and");
            view.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("number");
            selector.add("name");
            view.setSelector(selector);
            ManufactureOrderCollection coll = ManufactureOrderFactory.getRemoteInstance().getManufactureOrderCollection(view);
            if (coll != null && coll.size() > 0) {
                if (coll.size() == 1) {
                    if (coll.get(0).getNumber().equals(orderFrom)) {
                        this.prmtOrderFrom.setData((Object)coll.get(0));
                    }
                    if (coll.get(0).getNumber().equals(orderTo)) {
                        this.prmtOrderTo.setData((Object)coll.get(0));
                    }
                } else {
                    for (int i = 0; i < coll.size(); ++i) {
                        if (coll.get(i).getNumber().equals(orderFrom)) {
                            this.prmtOrderFrom.setData((Object)coll.get(i));
                            continue;
                        }
                        if (!coll.get(i).getNumber().equals(orderTo)) continue;
                        this.prmtOrderTo.setData((Object)coll.get(i));
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadPeriod(CustomerParams params) {
        this.prmtPeriod.setData(null);
        Object temp = this.prmtCostType.getValue();
        if (temp == null || !(temp instanceof CostTypeInfo) || !((CostTypeInfo)temp).getLevel().equals((Object)CostTypeLevelEnum.product)) {
            return;
        }
        String period = "";
        if (params.getCustomerParam("prmtPeriod") != null) {
            period = params.getCustomerParam("prmtPeriod");
        }
        if (StringUtils.isEmpty((String)period)) {
            return;
        }
        int number = 0;
        try {
            number = Integer.parseInt(period);
            if (number < this.startPeriod.getNumber() || number > this.period.getNumber()) {
                return;
            }
        }
        catch (Exception e) {
            return;
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)new Integer(number)));
            filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)this.company.getAccountPeriodType().getId().toString()));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("periodYear"));
            sic.add(new SelectorItemInfo("periodNumber"));
            view.setSelector(sic);
            PeriodCollection coll = PeriodFactory.getRemoteInstance().getPeriodCollection(view);
            if (coll != null && coll.size() > 0) {
                this.prmtPeriod.setValue((Object)coll.get(0));
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadProduct(CustomerParams params) {
        this.prmtProductFrom.setData(null);
        this.prmtProductTo.setData(null);
        Object temp = this.prmtCostType.getValue();
        if (temp == null || !(temp instanceof CostTypeInfo) || !((CostTypeInfo)temp).getLevel().equals((Object)CostTypeLevelEnum.product)) {
            return;
        }
        HashSet<String> numbersSet = new HashSet<String>();
        String productFrom = "";
        String productTo = "";
        if (params.getCustomerParam("prmtProductFrom") != null && (productFrom = params.getCustomerParam("prmtProductFrom").trim()).length() > 0) {
            numbersSet.add(productFrom);
        }
        if (params.getCustomerParam("prmtProductTo") != null && (productTo = params.getCustomerParam("prmtProductTo").trim()).length() > 0) {
            numbersSet.add(productTo);
        }
        if (numbersSet.size() <= 0) {
            return;
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("mateial.number", numbersSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyId));
            filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1)));
            filter.getFilterItems().add(new FilterItemInfo("calculateType", (Object)new Integer(2)));
            view.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("mateial.id");
            selector.add("mateial.number");
            selector.add("mateial.name");
            view.setSelector(selector);
            MaterialCompanyInfoCollection coll = MaterialCompanyInfoFactory.getRemoteInstance().getMaterialCompanyInfoCollection(view);
            if (coll != null && coll.size() > 0) {
                if (coll.size() == 1) {
                    if (coll.get(0).getMateial().getNumber().equals(productFrom)) {
                        this.prmtProductFrom.setData((Object)coll.get(0).getMateial());
                    }
                    if (coll.get(0).getMateial().getNumber().equals(productTo)) {
                        this.prmtProductTo.setData((Object)coll.get(0).getMateial());
                    }
                } else {
                    for (int i = 0; i < coll.size(); ++i) {
                        if (coll.get(i).getMateial().getNumber().equals(productFrom)) {
                            this.prmtProductFrom.setData((Object)coll.get(i).getMateial());
                            continue;
                        }
                        this.prmtProductTo.setData((Object)coll.get(i).getMateial());
                    }
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    static class PeriodFilterElement
    extends SingleFilterElement {
        KDBizPromptBox prmt;

        public PeriodFilterElement(String id, KDBizPromptBox component) {
            super(id, (Component)component);
            this.prmt = component;
        }

        public void addCustomerParam(CustomerParams cp, String key, Object obj) {
            Object temp = this.prmt.getData();
            if (temp instanceof PeriodInfo) {
                String number = String.valueOf(((PeriodInfo)temp).getNumber());
                cp.addCustomerParam(key, number);
            }
        }

        protected String getNumber(Object obj) {
            Object temp = this.prmt.getData();
            if (temp instanceof PeriodInfo) {
                return String.valueOf(((PeriodInfo)temp).getNumber());
            }
            return super.getNumber(obj);
        }
    }

    static class SingleBizPromptFilterElement
    extends SingleFilterElement {
        KDBizPromptBox prmt;

        public SingleBizPromptFilterElement(String id, KDBizPromptBox component) {
            super(id, (Component)component);
            this.prmt = component;
        }

        public void addRptParams(RptParams cp) {
            Object object = this.prmt.getValue();
            if (object == null) {
                try {
                    this.prmt.commitEdit();
                }
                catch (ParseException e) {
                    logger.error((Object)"", (Throwable)e);
                }
                object = this.prmt.getValue();
            }
            if (object instanceof Object[]) {
                object = ((Object[])object)[0];
            }
            cp.setObject(this.getId(), object);
        }
    }
}

