/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.std.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.order.common.utils.OrderCMUtils;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeCollection;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeFactory;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeInfo;
import com.kingdee.eas.ncm.order.std.report.client.AbstractOCCostTypeDiffReportFilterUI;
import com.kingdee.eas.ncm.order.std.report.client.OCActivityCostDiffReportFilterUI;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class OCCostTypeDiffReportFilterUI
extends AbstractOCCostTypeDiffReportFilterUI {
    private static final long serialVersionUID = 4901638607694751503L;
    private static final Logger logger = CoreUIObject.getLogger(OCActivityCostDiffReportFilterUI.class);
    private CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
    private String companyId = this.company.getId().toString();
    private PeriodInfo period = null;
    private PeriodInfo startPeriod = null;
    protected boolean isNormal = true;
    private Set storageOrgUnitIds = null;
    private CustomerParams cp = null;
    private FilterInfo costTypeBaseFilter = null;
    private FilterInfo orderBaseFilter = null;
    private FilterInfo periodBaseFilter = null;
    private FilterInfo prouctBaseFilter = null;
    private CostTypeInfo defaultSTD001 = null;

    public OCCostTypeDiffReportFilterUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
        OrderCMUtils.checkStart(SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        this.prmtCompany.setValue((Object)SysContext.getSysContext().getCurrentFIUnit());
        this.period = OrderCMUtils.getCurrentPeriod(this.companyId);
        this.startPeriod = OrderCMUtils.getStartPeriod(this.companyId);
        this.prmtCostTypeFrom.setQueryInfo("com.kingdee.eas.ncm.order.std.basedata.app.CostTypeQuery");
        this.prmtCostTypeFrom.setDisplayFormat("$name$");
        this.prmtCostTypeFrom.setEditFormat("$number$");
        this.prmtCostTypeFrom.setCommitFormat("$number$");
        FilterInfo costTypeBaseFilter = this.getCostTypeBaseFilter();
        this.setFilterInfoF7(this.prmtCostTypeFrom, costTypeBaseFilter);
        this.prmtCostTypeTo.setQueryInfo("com.kingdee.eas.ncm.order.std.basedata.app.CostTypeQuery");
        this.prmtCostTypeTo.setDisplayFormat("$name$");
        this.prmtCostTypeTo.setEditFormat("$number$");
        this.prmtCostTypeTo.setCommitFormat("$number$");
        this.setFilterInfoF7(this.prmtCostTypeTo, costTypeBaseFilter);
        this.prmtOrderFrom.setQueryInfo("com.kingdee.eas.mm.mo.app.F7ManufactureOrderQuery");
        this.prmtOrderFrom.setVisible(true);
        this.prmtOrderFrom.setEditable(true);
        this.prmtOrderFrom.setDisplayFormat("$number$");
        this.prmtOrderFrom.setEditFormat("$number$");
        this.prmtOrderFrom.setCommitFormat("$number$");
        FilterInfo orderBaseFilter = this.getOrderBaseFilter();
        this.setFilterInfoF7(this.prmtOrderFrom, orderBaseFilter);
        this.prmtOrderTo.setQueryInfo("com.kingdee.eas.mm.mo.app.F7ManufactureOrderQuery");
        this.prmtOrderTo.setVisible(true);
        this.prmtOrderTo.setEditable(true);
        this.prmtOrderTo.setDisplayFormat("$number$");
        this.prmtOrderTo.setEditFormat("$number$");
        this.prmtOrderTo.setCommitFormat("$number$");
        this.setFilterInfoF7(this.prmtOrderTo, orderBaseFilter);
        this.prmtProductFrom.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7MaterialCostObjectQuery");
        this.prmtProductFrom.setVisible(true);
        this.prmtProductFrom.setEditable(true);
        this.prmtProductFrom.setDisplayFormat("$name$");
        this.prmtProductFrom.setEditFormat("$number$");
        this.prmtProductFrom.setCommitFormat("$number$");
        FilterInfo productBaseFilter = this.getProuctBaseFilter();
        this.setFilterInfoF7(this.prmtProductFrom, productBaseFilter);
        this.prmtProductTo.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7MaterialCostObjectQuery");
        this.prmtProductTo.setVisible(true);
        this.prmtProductTo.setEditable(true);
        this.prmtProductTo.setDisplayFormat("$name$");
        this.prmtProductTo.setEditFormat("$number$");
        this.prmtProductTo.setCommitFormat("$number$");
        this.setFilterInfoF7(this.prmtProductTo, productBaseFilter);
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)new SingleBizPromptFilterElement("company", this.prmtCompany));
        elements.add((FilterElement)new RadioButtonFilterElement("byOrder", this.kdrByOrder));
        elements.add((FilterElement)new RadioButtonFilterElement("byProduct", this.kdrByproduct));
        elements.add((FilterElement)new SingleBizPromptFilterElement("costTypeFrom", this.prmtCostTypeFrom));
        elements.add((FilterElement)new SingleBizPromptFilterElement("costTypeTo", this.prmtCostTypeTo));
        elements.add((FilterElement)new SingleBizPromptFilterElement("orderFrom", this.prmtOrderFrom));
        elements.add((FilterElement)new SingleBizPromptFilterElement("orderTo", this.prmtOrderTo));
        elements.add((FilterElement)new SingleBizPromptFilterElement("productFrom", this.prmtProductFrom));
        elements.add((FilterElement)new SingleBizPromptFilterElement("productTo", this.prmtProductTo));
        this.getFilterManager().setElement((FilterElement)elements);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kdrByproduct.setSelected(true);
        StringBuffer oql = new StringBuffer(100);
        oql.append("select id, name, number where number = '");
        oql.append("STD_001");
        oql.append("' and company = '");
        oql.append(this.companyId);
        oql.append("'");
        try {
            this.defaultSTD001 = (CostTypeInfo)CostTypeFactory.getRemoteInstance().getValue(oql.toString());
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        this.prmtCostTypeFrom.setValue((Object)this.defaultSTD001);
        this.compareTypeControl();
        this.kdrByproduct.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                OCCostTypeDiffReportFilterUI.this.compareTypeControl();
            }
        });
        this.kdrByOrder.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                OCCostTypeDiffReportFilterUI.this.compareTypeControl();
            }
        });
        this.prmtCostTypeFrom.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                FilterInfo costTypeBaseFilter = null;
                try {
                    costTypeBaseFilter = OCCostTypeDiffReportFilterUI.this.getCostTypeBaseFilter();
                    OCCostTypeDiffReportFilterUI.this.setFilterInfoF7(OCCostTypeDiffReportFilterUI.this.prmtCostTypeFrom, costTypeBaseFilter);
                }
                catch (Exception e1) {
                    logger.error((Object)"", (Throwable)e1);
                }
            }
        });
        this.prmtCostTypeFrom.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent paramCommitEvent) {
                FilterInfo costTypeBaseFilter = null;
                try {
                    costTypeBaseFilter = OCCostTypeDiffReportFilterUI.this.getCostTypeBaseFilter();
                    OCCostTypeDiffReportFilterUI.this.setFilterInfoF7(OCCostTypeDiffReportFilterUI.this.prmtCostTypeFrom, costTypeBaseFilter);
                }
                catch (Exception e1) {
                    logger.error((Object)"", (Throwable)e1);
                }
            }
        });
        this.prmtCostTypeTo.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                FilterInfo costTypeBaseFilter = null;
                try {
                    costTypeBaseFilter = OCCostTypeDiffReportFilterUI.this.getCostTypeBaseFilter();
                    OCCostTypeDiffReportFilterUI.this.setFilterInfoF7(OCCostTypeDiffReportFilterUI.this.prmtCostTypeTo, costTypeBaseFilter);
                }
                catch (Exception e1) {
                    logger.error((Object)"", (Throwable)e1);
                }
            }
        });
        this.prmtCostTypeTo.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent paramCommitEvent) {
                FilterInfo costTypeBaseFilter = null;
                try {
                    costTypeBaseFilter = OCCostTypeDiffReportFilterUI.this.getCostTypeBaseFilter();
                    OCCostTypeDiffReportFilterUI.this.setFilterInfoF7(OCCostTypeDiffReportFilterUI.this.prmtCostTypeTo, costTypeBaseFilter);
                }
                catch (Exception e1) {
                    logger.error((Object)"", (Throwable)e1);
                }
            }
        });
    }

    private void compareTypeControl() {
        if (this.kdrByproduct.isSelected()) {
            this.prmtProductFrom.setEnabled(true);
            this.prmtProductTo.setEnabled(true);
            this.prmtOrderFrom.setValue(null);
            this.prmtOrderFrom.setEnabled(false);
            this.prmtOrderTo.setValue(null);
            this.prmtOrderTo.setEnabled(false);
            this.prmtCostTypeFrom.setValue((Object)this.defaultSTD001);
            this.prmtCostTypeTo.setValue(null);
            this.prmtProductFrom.setRequired(true);
            this.prmtProductTo.setRequired(true);
        } else if (this.kdrByOrder.isSelected()) {
            this.prmtOrderFrom.setEnabled(true);
            this.prmtOrderTo.setEnabled(true);
            this.prmtProductFrom.setValue(null);
            this.prmtProductFrom.setEnabled(false);
            this.prmtProductTo.setValue(null);
            this.prmtProductTo.setEnabled(false);
            this.prmtCostTypeFrom.setValue(null);
            this.prmtCostTypeTo.setValue(null);
            this.prmtOrderFrom.setRequired(true);
            this.prmtOrderTo.setRequired(true);
        }
    }

    private Set getStorageOrgUnitIds() throws EASBizException, BOSException {
        if (this.storageOrgUnitIds == null) {
            this.storageOrgUnitIds = BDCMUtils.getStorageOrgUnitIdsOfCompany(null, (String)this.companyId);
        }
        return this.storageOrgUnitIds;
    }

    protected void setDefaultValue() {
        this.kdrByproduct.setSelected(true);
        this.prmtCompany.setValue((Object)this.company);
        this.prmtCostTypeFrom.setValue((Object)this.defaultSTD001);
        this.prmtCostTypeTo.setValue(null);
        this.prmtOrderFrom.setValue(null);
        this.prmtOrderTo.setValue(null);
        this.prmtProductFrom.setValue(null);
        this.prmtProductTo.setValue(null);
    }

    private void setFilterInfoF7(KDBizPromptBox f7, FilterInfo filter) {
        EntityViewInfo view = f7.getEntityViewInfo() != null ? f7.getEntityViewInfo() : new EntityViewInfo();
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
        f7.getQueryAgent().resetRuntimeEntityView();
    }

    private FilterInfo getCostTypeBaseFilter() {
        this.costTypeBaseFilter = new FilterInfo();
        this.costTypeBaseFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyId));
        this.costTypeBaseFilter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(4)));
        if (this.kdrByproduct.isSelected()) {
            this.costTypeBaseFilter.getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(3)));
        } else if (this.kdrByOrder.isSelected()) {
            this.costTypeBaseFilter.getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(6)));
        }
        return this.costTypeBaseFilter;
    }

    protected FilterInfo getOrderBaseFilter() throws Exception {
        if (this.orderBaseFilter == null) {
            this.orderBaseFilter = new FilterInfo();
            Set storageOrgUnitIds = this.getStorageOrgUnitIds();
            this.orderBaseFilter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitIds, CompareType.INCLUDE));
            HashSet<Integer> set = new HashSet<Integer>();
            set.add(new Integer(4));
            set.add(new Integer(5));
            set.add(new Integer(6));
            set.add(new Integer(7));
            set.add(new Integer(8));
            set.add(new Integer(90));
            set.add(new Integer(10));
            set.add(new Integer(11));
            this.orderBaseFilter.getFilterItems().add(new FilterItemInfo("baseStatus", set, CompareType.INCLUDE));
        }
        return (FilterInfo)this.orderBaseFilter.clone();
    }

    protected FilterInfo getPeriodBaseFilter() throws Exception {
        if (this.periodBaseFilter == null) {
            this.periodBaseFilter = new FilterInfo();
            this.periodBaseFilter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)this.company.getAccountPeriodType().getId().toString()));
            this.periodBaseFilter.getFilterItems().add(new FilterItemInfo("periodYear * 100 + periodNumber", (Object)new Integer(this.startPeriod.getPeriodYear() * 100 + this.startPeriod.getPeriodNumber()), CompareType.GREATER_EQUALS));
            this.periodBaseFilter.getFilterItems().add(new FilterItemInfo("periodYear * 100 + periodNumber", (Object)new Integer(this.period.getPeriodYear() * 100 + this.period.getPeriodNumber()), CompareType.LESS_EQUALS));
        }
        return (FilterInfo)this.periodBaseFilter.clone();
    }

    protected FilterInfo getProuctBaseFilter() throws Exception {
        if (this.prouctBaseFilter == null) {
            this.prouctBaseFilter = new FilterInfo();
            this.prouctBaseFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyId));
        }
        return (FilterInfo)this.prouctBaseFilter.clone();
    }

    protected IObjectPK getBizCUPK() {
        Object object = this.getUIContext().get(this.getMainBizOrgType());
        CtrlUnitInfo currentBizOrg = object == null ? SysContext.getSysContext().getCurrentCtrlUnit() : (OrgUnitInfo)object;
        return new ObjectUuidPK(currentBizOrg.getCU().getId());
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
    }

    public void clear() {
        this.getFilterManager().clearAll();
        this.setDefaultValue();
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompany;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    public boolean verify() {
        Object temp2;
        Object temp1;
        CostTypeInfo costTypeFrom = null;
        CostTypeInfo costTypeTo = null;
        Object temp = this.prmtCostTypeFrom.getValue();
        if (temp == null || !(temp instanceof CostTypeInfo)) {
            MsgBox.showInfo((String)"\u8bf7\u9009\u62e9\u57fa\u51c6\u6210\u672c\u7c7b\u578b\u3002");
            return false;
        }
        costTypeFrom = (CostTypeInfo)this.prmtCostTypeFrom.getValue();
        temp = this.prmtCostTypeTo.getValue();
        if (temp == null || !(temp instanceof CostTypeInfo)) {
            MsgBox.showInfo((String)"\u8bf7\u9009\u62e9\u6bd4\u8f83\u6210\u672c\u7c7b\u578b\u3002");
            return false;
        }
        costTypeTo = (CostTypeInfo)this.prmtCostTypeTo.getValue();
        if (costTypeFrom.getNumber() != null && costTypeFrom.getNumber().equals(costTypeTo.getNumber())) {
            MsgBox.showInfo((String)"\u57fa\u51c6\u6210\u672c\u7c7b\u578b\u548c\u6bd4\u8f83\u6210\u672c\u7c7b\u578b\u4e0d\u80fd\u76f8\u540c\u3002");
            return false;
        }
        if (this.kdrByproduct.isSelected()) {
            temp1 = this.prmtProductFrom.getValue();
            temp2 = this.prmtProductTo.getValue();
            if (temp1 == null && temp2 == null) {
                MsgBox.showInfo((String)"\u8bf7\u9009\u62e9\u7269\u6599\u3002");
                return false;
            }
        }
        if (this.kdrByOrder.isSelected()) {
            temp1 = this.prmtOrderFrom.getValue();
            temp2 = this.prmtOrderTo.getValue();
            if (temp1 == null && temp2 == null) {
                MsgBox.showInfo((String)"\u8bf7\u9009\u62e9\u751f\u4ea7\u8ba2\u5355\u3002");
                return false;
            }
        }
        return true;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        this.prmtCompany.setValue((Object)this.company);
        CustomerParams params = this.cp;
        if (params != null) {
            this.loadCostType(params, this.prmtCostTypeFrom, "prmtCostTypeFrom");
            this.loadCostType(params, this.prmtCostTypeTo, "prmtCostTypeTo");
            this.loadProduct(params, this.prmtProductFrom, "prmtProductFrom");
            this.loadProduct(params, this.prmtProductTo, "prmtProductTo");
            this.loadOrder(params, this.prmtOrderFrom, "prmtOrderFrom");
            this.loadOrder(params, this.prmtOrderTo, "prmtOrderTo");
        }
    }

    private void loadCostType(CustomerParams params, KDBizPromptBox prmtCostType, String key) {
        prmtCostType.setData(null);
        String costType = params.getCustomerParam(key);
        if (StringUtils.isEmpty((String)costType)) {
            return;
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costType));
            FilterInfo costTypeBaseFilter = this.getCostTypeBaseFilter();
            filter.mergeFilter(costTypeBaseFilter, "and");
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            view.setSelector(sic);
            CostTypeCollection coll = CostTypeFactory.getRemoteInstance().getCostTypeCollection(view);
            if (coll != null && coll.size() > 0) {
                prmtCostType.setValue((Object)coll.get(0));
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadOrder(CustomerParams params, KDBizPromptBox prmtOrder, String key) {
        prmtOrder.setData(null);
        String order = params.getCustomerParam(key);
        if (StringUtils.isEmpty((String)order)) {
            return;
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)order));
            FilterInfo orderBaseFilter = this.getOrderBaseFilter();
            filter.mergeFilter(orderBaseFilter, "and");
            view.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("number");
            selector.add("name");
            view.setSelector(selector);
            ManufactureOrderCollection coll = ManufactureOrderFactory.getRemoteInstance().getManufactureOrderCollection(view);
            if (coll != null && coll.size() > 0) {
                prmtOrder.setValue((Object)coll.get(0));
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadProduct(CustomerParams params, KDBizPromptBox prmtProduct, String key) {
        prmtProduct.setData(null);
        String product = params.getCustomerParam(key);
        if (StringUtils.isEmpty((String)product)) {
            return;
        }
        String[] numbers = product.split(";");
        HashSet<String> numbersSet = new HashSet<String>();
        for (int i = 0; i < numbers.length; ++i) {
            numbersSet.add(numbers[i].trim());
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("mateial.number", numbersSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyId));
            filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1)));
            view.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("mateial.id");
            selector.add("mateial.number");
            selector.add("mateial.name");
            view.setSelector(selector);
            MaterialCompanyInfoCollection coll = MaterialCompanyInfoFactory.getRemoteInstance().getMaterialCompanyInfoCollection(view);
            if (coll != null && coll.size() > 0) {
                int size = coll.size();
                MaterialInfo[] orders = new MaterialInfo[size];
                for (int i = 0; i < size; ++i) {
                    orders[i] = coll.get(i).getMateial();
                }
                prmtProduct.setData((Object)orders);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    class RadioButtonFilterElement
    extends SingleFilterElement {
        KDRadioButton kdCb;

        public RadioButtonFilterElement(String id, KDRadioButton component) {
            super(id, (Component)component);
            this.kdCb = component;
        }

        public void addRptParams(RptParams cp) {
            cp.setObject(this.getId(), (Object)new Boolean(this.kdCb.isSelected()));
        }
    }

    class SingleBizPromptFilterElement
    extends SingleFilterElement {
        KDBizPromptBox prmt;

        public SingleBizPromptFilterElement(String id, KDBizPromptBox component) {
            super(id, (Component)component);
            this.prmt = component;
        }

        public void addRptParams(RptParams cp) {
            Object object = this.prmt.getValue();
            if (object == null) {
                try {
                    this.prmt.commitEdit();
                }
                catch (ParseException e) {
                    logger.error((Object)"", (Throwable)e);
                }
                object = this.prmt.getValue();
            }
            if (object instanceof Object[]) {
                object = ((Object[])object)[0];
            }
            cp.setObject(this.getId(), object);
        }
    }
}

