/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.std.report.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.SimpleTextRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.order.common.utils.OrderCMUtils;
import com.kingdee.eas.ncm.order.std.cal.IOSCostCalcFacade;
import com.kingdee.eas.ncm.order.std.cal.OSCostCalcFacadeFactory;
import com.kingdee.eas.ncm.order.std.cal.OSCostDetailEntrylInfo;
import com.kingdee.eas.ncm.order.std.cal.OSCostDetailInfo;
import com.kingdee.eas.ncm.order.std.report.OSCostDetailReportFilterParam;
import com.kingdee.eas.ncm.order.std.report.client.AbstractOSCostDetailReportMainUI;
import com.kingdee.eas.ncm.order.std.report.client.OSCostDetailReportFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.HashMap;

public class OSCostDetailReportMainUI
extends AbstractOSCostDetailReportMainUI {
    private static final long serialVersionUID = -6230696640703533477L;
    private CommonQueryDialog dialog = null;
    protected OSCostDetailReportFilterUI defaultFilterUI = null;
    protected OSCostDetailReportFilterParam defaultFilterParam = null;
    protected IMetaDataPK mainQueryPk = null;
    protected BOSUuid solutionId = null;
    protected BomTreeRender treeRender = new BomTreeRender();
    private final DecimalFormat DEFAULT_AMOUNT_FORMAT = new DecimalFormat("#,##0.000");
    private static final String col_material_number = "material.number";
    private static final String col_material_name = "material.name";
    private static final String col_model = "model";
    private static final String col_costItem = "costItem";
    private static final String col_measureunit = "mu";
    private static final String col_price = "price";
    private static final String col_qty = "qty";
    private static final String col_amount = "amount";
    OSCostDetailInfo result = null;
    OSCostDetailEntrylInfo[] entrys = null;

    public OSCostDetailReportMainUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
        OrderCMUtils.checkStart(SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        this.mainQueryPk = new MetaDataPK("com.kingdee.eas.ncm.order.std.basedata.app", "CostTypeQuery");
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.miRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.miQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.miPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.miPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnRefresh.setIsControlByParent(false);
        this.btnQuery.setIsControlByParent(false);
        this.btnPrint.setIsControlByParent(false);
        this.btnPrintPreview.setIsControlByParent(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getColumn(col_material_number).setRenderer((IBasicRender)this.treeRender);
        boolean hasDefaultQuery = this.getDefaultFilterParam();
        if (hasDefaultQuery) {
            this.executeQuery();
        } else {
            this.dialog = this.getCommonQueryDialog();
            if (this.dialog.show()) {
                QuerySolutionInfo solutionInfo = this.dialog.getCurrentSolutionInfo();
                this.solutionId = solutionInfo != null ? solutionInfo.getId() : null;
                this.setFilterParam(this.getFilterUI().getCustomerParams());
                this.executeQuery();
            } else {
                SysUtil.abort();
            }
        }
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                NumberExpandInfo expandInfo;
                int rowIndex;
                IRow row;
                if (e.getColIndex() == 0 && e.getClickCount() == 1 && (row = OSCostDetailReportMainUI.this.tblMain.getRow(rowIndex = e.getRowIndex())).getCell(0).getValue() != null && row.getCell(0).getValue() instanceof NumberExpandInfo && (expandInfo = (NumberExpandInfo)row.getCell(0).getValue()) != null && OSCostDetailReportMainUI.this.treeRender != null && OSCostDetailReportMainUI.this.treeRender.inRect(expandInfo, e.getX(), e.getY())) {
                    try {
                        OSCostDetailReportMainUI.this.setTreeDisplayStyle(row, expandInfo);
                    }
                    catch (Exception ex) {
                        ExceptionHandler.handle((Throwable)ex);
                    }
                }
            }
        });
    }

    protected boolean getDefaultFilterParam() throws Exception {
        if (this.getFilterParam() != null) {
            return true;
        }
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        QuerySolutionInfo ds = iQuery.getDefaultSolution(this.getQueryMainName(), this.mainQueryPk.getFullName());
        if (ds != null && ds.getSolutionType().equals((Object)SolutionTypeEnum.CUSTOMER_SOLUTION) && ds.getQueryPanelInfo().size() > 0) {
            this.solutionId = ds.getId();
            CustomerParams cp = new CustomerParams().getCustomerParams(ds.getQueryPanelInfo().get(0).getCustomerParams());
            this.setFilterParam(cp);
        }
        return this.getFilterParam() != null;
    }

    protected String getQueryMainName() {
        return OSCostDetailReportMainUI.class.getName();
    }

    protected IOSCostCalcFacade getInterface() throws Exception {
        return OSCostCalcFacadeFactory.getRemoteInstance();
    }

    protected void setFilterParam(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        this.setFilterParam((OSCostDetailReportFilterParam)this.getFilterUI().getFilterObject(cp));
    }

    public void setFilterParam(OSCostDetailReportFilterParam filterParam) {
        if (filterParam == null) {
            filterParam = this.getFilterUI().createNewFilterParam();
        }
        this.defaultFilterParam = filterParam;
    }

    public OSCostDetailReportFilterParam getFilterParam() {
        return this.defaultFilterParam;
    }

    protected OSCostDetailReportFilterUI getFilterUI() {
        if (this.defaultFilterUI == null) {
            try {
                this.defaultFilterUI = new OSCostDetailReportFilterUI((Object)this);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
        return this.defaultFilterUI;
    }

    protected CommonQueryDialog getCommonQueryDialog() throws Exception {
        if (this.dialog != null) {
            return this.dialog;
        }
        this.dialog = new CommonQueryDialog();
        this.dialog.setOwner((Component)this.getUIContext().get("Owner"));
        this.dialog.setParentUIClassName(((Object)((Object)this)).getClass().getName());
        this.dialog.setEntityViewInfo(new EntityViewInfo());
        this.dialog.setQueryObjectPK(this.mainQueryPk);
        this.dialog.setTitle(this.getFilterUI().getUITitle());
        this.dialog.setWidth(this.getWidthOfDialog());
        this.dialog.setHeight(this.getHeightOfDialog());
        this.dialog.addUserPanel((KDPanel)this.getFilterUI());
        this.dialog.setShowFilter(false);
        this.dialog.setShowSorter(false);
        return this.dialog;
    }

    protected int getWidthOfDialog() {
        return 290;
    }

    protected int getHeightOfDialog() {
        return 280;
    }

    public void query() {
        this.executeQuery();
    }

    protected void executeQuery() {
        if (this.defaultFilterParam == null) {
            return;
        }
        this.tblMain.removeRows();
        String companyId = this.defaultFilterParam.getCompany().getId().toString();
        String costTypeId = this.defaultFilterParam.getCostType().getId().toString();
        String orderId = null;
        if (this.defaultFilterParam.getOrder() != null && this.defaultFilterParam.getOrder().getId() != null) {
            orderId = this.defaultFilterParam.getOrder().getId().toString();
        }
        String materialId = this.defaultFilterParam.getMaterial().getId().toString();
        this.result = null;
        try {
            this.result = this.getInterface().queryDetail(companyId, costTypeId, orderId, materialId);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (this.result == null) {
            return;
        }
        this.f7Company.setValue((Object)SysContext.getSysContext().getCurrentFIUnit());
        this.f7CostType.setValue((Object)this.result.getCostType());
        this.f7Order.setValue((Object)this.result.getOrder());
        this.f7MaterialNumber.setValue((Object)this.result.getProduct());
        this.f7MaterialName.setValue((Object)this.result.getProduct());
        this.f7Porject.setValue((Object)this.result.getProject());
        this.f7Track.setValue((Object)this.result.getTrackNumber());
        this.f7Bom.setValue((Object)this.result.getBom());
        this.txtModel.setText(this.result.getBatchNo());
        if (this.result.getEntry() == null || this.result.getEntry().length == 0) {
            return;
        }
        for (OSCostDetailEntrylInfo entryInfo : this.result.getEntry()) {
            if (entryInfo.getIsMat() == 0) {
                entryInfo.setLeaf(true);
            }
            if (entryInfo.getIsMat() == 1) {
                entryInfo.setLeaf(false);
            }
            if (entryInfo.getIsMat() == 2) {
                entryInfo.setSpreadPath(entryInfo.getSpreadPath().substring(0, entryInfo.getSpreadPath().lastIndexOf(",")));
                entryInfo.setLeaf(false);
            }
            if (entryInfo.getIsMat() != 3) continue;
            entryInfo.setSpreadPath(entryInfo.getSpreadPath().substring(0, entryInfo.getSpreadPath().lastIndexOf(",")));
            entryInfo.setSpreadPath(entryInfo.getSpreadPath().substring(0, entryInfo.getSpreadPath().lastIndexOf(",")));
            entryInfo.setLeaf(false);
        }
        this.tblMain.setRefresh(false);
        int size = this.entrys.length;
        for (int i = 0; i < size; ++i) {
            OSCostDetailEntrylInfo entryInfo;
            entryInfo = this.entrys[i];
            IRow row = this.tblMain.addRow();
            row.getCell(col_material_number).setValue((Object)entryInfo.getMaterialNumber());
            row.getCell(col_material_name).setValue((Object)entryInfo.getMaterialName());
            row.getCell(col_model).setValue((Object)entryInfo.getModel());
            row.getCell(col_costItem).setValue((Object)entryInfo.getCostItemName());
            row.getCell(col_measureunit).setValue((Object)entryInfo.getMeasureUnitName());
            row.getCell(col_qty).setValue(this.formatBigDecimal(entryInfo.getChildQty()));
            row.getCell(col_price).setValue(this.formatBigDecimal(entryInfo.getChildStdPrice()));
            row.getCell(col_amount).setValue(this.formatBigDecimal(entryInfo.getChildAmount()));
            this.addExpandInfo(this.tblMain.getRow(i).getCell(col_material_number), entryInfo);
        }
        IRow row = null;
        String firstLongNumber = null;
        NumberExpandInfo expandInfo = null;
        for (int i = 0; i < this.tblMain.getBody().size(); ++i) {
            row = this.tblMain.getRow(i);
            if (row == null) continue;
            expandInfo = (NumberExpandInfo)row.getCell(col_material_number).getValue();
            expandInfo.setExpandStatus(false);
            if (firstLongNumber != null && expandInfo.getLongNumber().startsWith(firstLongNumber + ",")) {
                row.getStyleAttributes().setHided(true);
                continue;
            }
            firstLongNumber = expandInfo.getLongNumber();
        }
        this.tblMain.setRefresh(true);
        this.tblMain.reLayoutAndPaint();
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        CommonQueryDialog dialog = this.getCommonQueryDialog();
        if (dialog.show()) {
            this.setFilterParam(this.getFilterUI().getCustomerParams());
            QuerySolutionInfo solutionInfo = dialog.getCurrentSolutionInfo();
            if (solutionInfo != null) {
                this.solutionId = solutionInfo.getId();
            }
            this.executeQuery();
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.executeQuery();
    }

    protected void setTreeDisplayStyle(IRow row, NumberExpandInfo expandInfo) throws Exception {
        this.tblMain.setRefresh(false);
        this.expandTable(row, expandInfo);
        this.tblMain.setRefresh(true);
        this.tblMain.reLayoutAndPaint();
    }

    private void expandTable(IRow row, NumberExpandInfo parentExpandInfo) throws Exception {
        if (row == null) {
            return;
        }
        IRow child = null;
        int parentLevel = parentExpandInfo.getLevel();
        String longNumber = null;
        String parentLongNumber = null;
        NumberExpandInfo expandInfo = null;
        parentLongNumber = parentExpandInfo.getLongNumber();
        boolean isExpandStatus = parentExpandInfo.isExpandStatus();
        if (isExpandStatus) {
            parentExpandInfo.setExpandStatus(false);
            int rowCount = this.tblMain.getBody().size();
            for (int rowIndex = row.getRowIndex() + 1; rowIndex < rowCount; ++rowIndex) {
                child = this.tblMain.getRow(rowIndex);
                expandInfo = (NumberExpandInfo)child.getCell(col_material_number).getValue();
                if (expandInfo == null || expandInfo.getLongNumber() == null) {
                    child.getStyleAttributes().setHided(true);
                    continue;
                }
                longNumber = expandInfo.getLongNumber();
                if (longNumber.startsWith(parentLongNumber + ",")) {
                    child.getStyleAttributes().setHided(true);
                    continue;
                }
                break;
            }
        } else {
            int rowIndex;
            parentExpandInfo.setExpandStatus(true);
            int rowCount = this.tblMain.getBody().size();
            if (rowIndex >= rowCount) {
                this.dealChildRow(parentExpandInfo, rowIndex);
            } else {
                for (rowIndex = row.getRowIndex() + 1; rowIndex < rowCount; ++rowIndex) {
                    child = this.tblMain.getRow(rowIndex);
                    expandInfo = (NumberExpandInfo)child.getCell(col_material_number).getValue();
                    if (expandInfo == null || expandInfo.getLongNumber() == null) {
                        child.getStyleAttributes().setHided(false);
                        continue;
                    }
                    longNumber = expandInfo.getLongNumber();
                    if (longNumber.startsWith(parentLongNumber + ",")) {
                        if (expandInfo.getLevel() - parentLevel != 1) continue;
                        child.getStyleAttributes().setHided(false);
                        if (!expandInfo.isLeaf()) {
                            expandInfo.setExpandStatus(false);
                            continue;
                        }
                        expandInfo.setExpandStatus(true);
                        continue;
                    }
                    if (rowIndex != row.getRowIndex() + 1) break;
                    this.dealChildRow(parentExpandInfo, rowIndex);
                    break;
                }
            }
        }
    }

    private void dealChildRow(NumberExpandInfo expandInfo, int rowIndex) throws Exception {
    }

    private void addExpandInfo(ICell cell, OSCostDetailEntrylInfo entryInfo) {
        if (cell == null) {
            return;
        }
        NumberExpandInfo expandInfo = new NumberExpandInfo();
        expandInfo.setId(entryInfo.getParentMaterialId());
        expandInfo.setNumber(entryInfo.getMaterialNumber());
        expandInfo.setName(entryInfo.getMaterialName());
        expandInfo.setLongNumber(entryInfo.getSpreadPath());
        if (entryInfo.getIsMat() == 0) {
            expandInfo.setLevel(entryInfo.getSpreadPath().split(",").length - 2);
        } else {
            expandInfo.setLevel(entryInfo.getSpreadPath().split(",").length - 1);
        }
        if (entryInfo.getIsMat() == 0) {
            expandInfo.setLeaf(true);
        }
        expandInfo.setLeaf(true);
        expandInfo.setExpandStatus(false);
        int currentIndex = cell.getRowIndex();
        int size = this.entrys.length;
        for (int i = 0; i < size; ++i) {
            OSCostDetailEntrylInfo _entryInfo;
            if (i == currentIndex || (_entryInfo = this.entrys[i]).getSpreadPath().indexOf(entryInfo.getSpreadPath()) != 0) continue;
            expandInfo.setLeaf(false);
        }
        if (entryInfo.getIsMat() == 2) {
            expandInfo.setLeaf(false);
            expandInfo.setExpandStatus(false);
        }
        if (entryInfo.getIsMat() == 3) {
            expandInfo.setLeaf(false);
            expandInfo.setExpandStatus(false);
        }
        cell.setValue((Object)expandInfo);
    }

    private Object formatBigDecimal(Object value) {
        if (value instanceof BigDecimal) {
            return this.DEFAULT_AMOUNT_FORMAT.format((BigDecimal)value);
        }
        if (value instanceof String) {
            BigDecimal _value = null;
            try {
                _value = new BigDecimal((String)value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (_value == null) {
                return null;
            }
            return this.DEFAULT_AMOUNT_FORMAT.format(_value);
        }
        return value;
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.tblMain.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        this.tblMain.getPrintManager().printPreview();
    }

    protected static class BomTreeRender
    implements IBasicRender {
        private int TABSIZE = 8;
        private int ICONSIZE = 10;
        private int margin = 2;
        protected SimpleTextRender simpleRender = new SimpleTextRender();
        protected HashMap acctIdToPos = new HashMap();

        protected BomTreeRender() {
        }

        protected void drawExpanded(Graphics g, int x, int y) {
            g.drawRect(x, y, this.ICONSIZE, this.ICONSIZE);
            int lineSize = this.ICONSIZE - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.ICONSIZE / 2, x + this.margin + lineSize, y + this.ICONSIZE / 2);
        }

        protected void drawCollapsed(Graphics g, int x, int y) {
            g.drawRect(x, y, this.ICONSIZE, this.ICONSIZE);
            int lineSize = this.ICONSIZE - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.ICONSIZE / 2, x + this.margin + lineSize, y + this.ICONSIZE / 2);
            g.drawLine(x + this.ICONSIZE / 2, y + this.margin, x + this.ICONSIZE / 2, y + this.margin + lineSize);
        }

        protected void drawLeaf(Graphics g, int x, int y) {
        }

        protected boolean inRect(NumberExpandInfo numberExpandInfo, int x, int y) {
            String acctId = numberExpandInfo.getNumber();
            Rectangle rec = (Rectangle)this.acctIdToPos.get(acctId);
            if (rec != null) {
                return rec.getX() < (double)x && rec.getX() + rec.getWidth() > (double)x;
            }
            return false;
        }

        public void draw(Graphics graphics, Shape clip, Object obj, Style style) {
            if (obj instanceof NumberExpandInfo) {
                NumberExpandInfo numberExpandInfo = (NumberExpandInfo)obj;
                int ident = numberExpandInfo.getLevel() * this.TABSIZE;
                Rectangle rect = clip.getBounds();
                int x = rect.x + ident;
                int y = rect.y + (rect.height - this.ICONSIZE) / 2;
                Rectangle iconRect = new Rectangle(x, y, this.ICONSIZE, this.ICONSIZE);
                this.acctIdToPos.put(numberExpandInfo.getNumber(), iconRect);
                this.simpleRender.draw(graphics, (Shape)new Rectangle(x + this.ICONSIZE + this.TABSIZE, rect.y, rect.width - x - this.ICONSIZE - this.TABSIZE, rect.height), numberExpandInfo.getNumber(), style);
                this.paintIcon(graphics, numberExpandInfo, iconRect);
            } else if (obj != null) {
                this.simpleRender.draw(graphics, clip, obj.toString(), style);
            }
        }

        private void paintIcon(Graphics graphics, NumberExpandInfo numberExpandInfo, Rectangle iconRect) {
            if (numberExpandInfo.isLeaf()) {
                this.drawLeaf(graphics, iconRect.x, iconRect.y);
            } else if (numberExpandInfo.isExpandStatus()) {
                this.drawExpanded(graphics, iconRect.x, iconRect.y);
            } else if (!numberExpandInfo.isExpandStatus()) {
                this.drawCollapsed(graphics, iconRect.x, iconRect.y);
            }
        }
    }

    protected static class NumberExpandInfo {
        private String id = null;
        private String number = null;
        private String name = null;
        private String longNumber = null;
        private boolean isExpandStatus = false;
        private int level = 0;
        private boolean isLeaf = false;
        private boolean isEffective = true;

        protected NumberExpandInfo() {
        }

        public boolean isExpandStatus() {
            return this.isExpandStatus;
        }

        public void setExpandStatus(boolean isExpandStatus) {
            this.isExpandStatus = isExpandStatus;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getLongNumber() {
            return this.longNumber;
        }

        public void setLongNumber(String longNumber) {
            this.longNumber = longNumber;
        }

        public String toString() {
            return this.number;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public boolean isLeaf() {
            return this.isLeaf;
        }

        public void setLeaf(boolean isLeaf) {
            this.isLeaf = isLeaf;
        }

        public boolean isEffective() {
            return this.isEffective;
        }

        public void setEffective(boolean isEffective) {
            this.isEffective = isEffective;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

