/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.std.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.IRefChecker;
import com.kingdee.eas.common.RefCheckerFactory;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.std.basedata.ISTDCostEstimateScheme;
import com.kingdee.eas.ncm.std.basedata.STDCostEstimateSchemeCombinationInfo;
import com.kingdee.eas.ncm.std.basedata.STDCostEstimateSchemeFactory;
import com.kingdee.eas.ncm.std.basedata.STDCostEstimateSchemeInfo;
import com.kingdee.eas.ncm.std.basedata.STDCostEstimateSchemeStateEnum;
import com.kingdee.eas.ncm.std.basedata.STDCostEstimateSchemeTypeEnum;
import com.kingdee.eas.ncm.std.basedata.client.AbstractSTDCostEstimateSchemeEditUI;
import com.kingdee.eas.ncm.std.basedata.client.STDCostEstimateSchemeCombinationUI;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;

public class STDCostEstimateSchemeEditUI
extends AbstractSTDCostEstimateSchemeEditUI {
    private static final long serialVersionUID = -2172375801423963709L;
    protected static final int BasePageIndex = 0;
    protected static final int CombinationPageIndex = 1;
    protected int lastSelectedIndex = 0;
    private STDCostEstimateSchemeCombinationUI currentCombinationUI = null;
    private CompanyOrgUnitInfo currentCompany = null;
    private PeriodInfo currentPeriod = null;
    private RuleStatus ruleStatus = null;

    public STDCostEstimateSchemeEditUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getRemoteInstance();
        if (!sysctrol.isStart(1001, SysContext.getSysContext().getCurrentFIUnit().getId().toString())) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
        this.currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        this.currentPeriod = SystemStatusCtrolFactory.getRemoteInstance().getCacheCurrentPeriod(1001, this.currentCompany.getId().toString());
    }

    public void onLoad() throws Exception {
        super.onLoad();
        int curYear = this.currentPeriod.getPeriodYear();
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
        this.setAutoNumberForOrg("Company");
        this.yearSpinner.setModel((SpinnerModel)new SpinnerNumberModel(curYear, curYear, curYear + 10, 1));
        this.beginPeriodSpinner.setModel((SpinnerModel)new SpinnerNumberModel(1, 1, 12, 1));
        this.endPeriodSpinner.setModel((SpinnerModel)new SpinnerNumberModel(12, 1, 12, 1));
        this.beginPeriodSpinner.setValue((Object)this.editData.getBeginPeriod());
        this.endPeriodSpinner.setValue((Object)this.editData.getEndPeriod());
        this.filterStorageOrgBox();
    }

    public void onShow() throws Exception {
        super.onShow();
        BDCMClientUtils.setResizble((boolean)false, (IUIWindow)this.uiWindow);
        ICodingRuleManager ICodingRule = CodingRuleManagerFactory.getRemoteInstance();
        boolean hasCodingRule = ICodingRule.isExist((IObjectValue)new STDCostEstimateSchemeInfo(), this.currentCompany.getId().toString());
        if (hasCodingRule && !this.ruleStatus.isModifiable()) {
            this.numberTextField.setEnabled(false);
            this.nameTextField.requestFocus();
            this.nameTextField.requestFocusInWindow();
        } else {
            this.numberTextField.requestFocus();
            this.numberTextField.requestFocusInWindow();
        }
    }

    @Override
    public void loadFields() {
        block7: {
            super.loadFields();
            try {
                if (!"EDIT".equals(this.getOprtState())) break block7;
                boolean isRefered = false;
                ISTDCostEstimateScheme iSTDCostEstimateScheme = STDCostEstimateSchemeFactory.getRemoteInstance();
                try {
                    ArrayList<String> ids = new ArrayList<String>();
                    ids.add(this.editData.getId().toString());
                    iSTDCostEstimateScheme.checkRefered(ids);
                }
                catch (ObjectReferedException ex) {
                    isRefered = true;
                }
                IRefChecker checker = RefCheckerFactory.getRemoteInstance();
                if (isRefered || checker.isReferenced(this.editData.getId())) {
                    this.numberTextField.setEnabled(false);
                    this.schemeTypeComboBox.setEnabled(false);
                    this.storageOrgPromptBox.setEnabled(false);
                    this.yearSpinner.setEnabled(false);
                    this.beginPeriodSpinner.setEnabled(false);
                    this.endPeriodSpinner.setEnabled(false);
                } else if (iSTDCostEstimateScheme.existsCombination(this.editData.getId())) {
                    this.schemeTypeComboBox.setEnabled(false);
                    this.storageOrgPromptBox.setEnabled(false);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.handle((Throwable)ex);
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected IObjectValue createNewData() {
        STDCostEstimateSchemeInfo objectValue = new STDCostEstimateSchemeInfo();
        objectValue.setCompany(this.currentCompany);
        objectValue.setYear(this.currentPeriod.getPeriodYear());
        objectValue.setBeginPeriod(1);
        objectValue.setEndPeriod(12);
        objectValue.setSchemeType(STDCostEstimateSchemeTypeEnum.fixed);
        objectValue.setState(STDCostEstimateSchemeStateEnum.save);
        return objectValue;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return STDCostEstimateSchemeFactory.getRemoteInstance();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        if (this.tabbedPane.getSelectedIndex() == 0) {
            super.actionAddNew_actionPerformed(e);
            this.setAutoNumberForOrg("Company");
        } else {
            this.currentCombinationUI.actionAddNew_actionPerformed(e);
            this.btnSubmit.setEnabled(true);
        }
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        if (this.tabbedPane.getSelectedIndex() == 0) {
            super.actionCopy_actionPerformed(e);
        } else {
            this.currentCombinationUI.actionCopy_actionPerformed(e);
            this.btnSubmit.setEnabled(true);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.tabbedPane.getSelectedIndex() == 0) {
            super.actionEdit_actionPerformed(e);
        } else {
            this.currentCombinationUI.actionEdit_actionPerformed(e);
            this.btnSubmit.setEnabled(true);
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.tabbedPane.getSelectedIndex() == 0) {
            super.actionRemove_actionPerformed(e);
        } else {
            this.currentCombinationUI.actionRemove_actionPerformed(e);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.tabbedPane.getSelectedIndex() == 0) {
            super.actionSubmit_actionPerformed(e);
        } else {
            this.currentCombinationUI.actionSubmit_actionPerformed(e);
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    protected void beforeStoreFields(ActionEvent arg0) throws Exception {
        ICodingRuleManager ICodingRule = CodingRuleManagerFactory.getRemoteInstance();
        boolean hasCodingRule = ICodingRule.isExist((IObjectValue)new STDCostEstimateSchemeInfo(), this.currentCompany.getId().toString());
        if (!hasCodingRule && UIRuleUtil.isNull((String)this.numberTextField.getText())) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{this.numberLabelContainer.getBoundLabelText()});
        }
        if (UIRuleUtil.isNull((String)this.nameTextField.getText())) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{this.nameLableContainer.getBoundLabelText()});
        }
        if (UIRuleUtil.isNull((Object)this.storageOrgPromptBox.getValue())) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{this.storageOrgLabelContainer.getBoundLabelText()});
        }
        if (UIRuleUtil.isNull((Object)this.schemeTypeComboBox.getSelectedItem())) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{this.schemeTypeLabelContainer.getBoundLabelText()});
        }
        if (UIRuleUtil.isNull((Object)this.yearSpinner.getValue())) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{EASResource.getString((String)"com.kingdee.eas.ncm.std.basedata.BASEDATAAutoGenerateResource", (String)"0_STDCostEstimateSchemeEditUI")});
        }
        if (UIRuleUtil.isNull((Object)this.beginPeriodSpinner.getValue())) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{EASResource.getString((String)"com.kingdee.eas.ncm.std.basedata.BASEDATAAutoGenerateResource", (String)"1_STDCostEstimateSchemeEditUI")});
        }
        if (UIRuleUtil.isNull((Object)this.endPeriodSpinner.getValue())) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{EASResource.getString((String)"com.kingdee.eas.ncm.std.basedata.BASEDATAAutoGenerateResource", (String)"2_STDCostEstimateSchemeEditUI")});
        }
        Integer beginPeriod = (Integer)this.beginPeriodSpinner.getValue();
        Integer endPeriod = (Integer)this.endPeriodSpinner.getValue();
        if (beginPeriod > endPeriod) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ncm.std.basedata.BASEDATAAutoGenerateResource", (String)"3_STDCostEstimateSchemeEditUI"));
            this.endPeriodSpinner.setValue((Object)beginPeriod);
            SysUtil.abort();
        }
        super.beforeStoreFields(arg0);
    }

    @Override
    protected void tabbedPane_stateChanged(ChangeEvent e) throws Exception {
        int forwardIndex = this.tabbedPane.getSelectedIndex();
        if (forwardIndex == 1) {
            if (!"VIEW".equals(this.getOprtState())) {
                this.btnRemove.setVisible(true);
            } else {
                this.btnRemove.setVisible(false);
            }
            this.initCombinationUI();
        } else {
            this.btnRemove.setVisible(false);
        }
        if (this.lastSelectedIndex == 0 && forwardIndex == 1) {
            if (this.isModify() || "ADDNEW".equals(this.getOprtState())) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"saveCurrentPageFirst"));
                this.tabbedPane.setSelectedIndex(0);
                return;
            }
            if (STDCostEstimateSchemeTypeEnum.fixed.equals(this.schemeTypeComboBox.getSelectedItem())) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.std.basedata.BASEDATAAutoGenerateResource", (String)"4_STDCostEstimateSchemeEditUI"));
                this.tabbedPane.setSelectedIndex(0);
                return;
            }
        } else if (this.lastSelectedIndex == 1 && forwardIndex == 0 && this.currentCombinationUI != null) {
            this.currentCombinationUI.setDataObject((IObjectValue)this.currentCombinationUI.editData);
            if (this.currentCombinationUI.isModify()) {
                int answer = MsgBox.showConfirm3(null, (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"confirmSaveModifideData"));
                if (MsgBox.isYes((int)answer)) {
                    this.currentCombinationUI.runSubmit();
                    this.currentCombinationUI.loadFields();
                    this.tabbedPane.setSelectedIndex(1);
                }
                return;
            }
        }
        this.lastSelectedIndex = forwardIndex;
    }

    protected void initCombinationUI() throws Exception {
        if (this.combinationUI.getComponentCount() == 0) {
            try {
                this.currentCombinationUI = new STDCostEstimateSchemeCombinationUI();
            }
            catch (AbortException ex) {
                this.tabbedPane.setSelectedIndex(0);
                SysUtil.abort();
            }
            this.currentCombinationUI.initLayout();
            if (this.editData.getId() == null) {
                return;
            }
            STDCostEstimateSchemeCombinationInfo combinationInfo = null;
            if (SysContext.getSysContext().getCurrentFIUnit() != null) {
                combinationInfo = this.currentCombinationUI.getCombinationInfo(this.editData.getId().toString());
            }
            if (combinationInfo == null || "ADDNEW".equals(this.getOprtState())) {
                combinationInfo = new STDCostEstimateSchemeCombinationInfo();
            }
            this.getUIContext().put("InitDataObject", combinationInfo);
            this.getUIContext().put("baseUIReference", this);
            if (combinationInfo.getId() == null) {
                this.getUIContext().put("IDList", null);
            } else {
                RealModeIDList secondTabIDList = new RealModeIDList();
                secondTabIDList.add(combinationInfo.getId().toString());
                this.getUIContext().put("IDList", secondTabIDList);
            }
            this.currentCombinationUI.getUIContext().putAll(this.getUIContext());
            this.currentCombinationUI.getUIContext().put("_EstimateInfo", this.editData);
            this.currentCombinationUI.setDataObject((IObjectValue)combinationInfo);
        }
        this.combinationUI.add((Component)((Object)this.currentCombinationUI));
        this.currentCombinationUI.setOprtState(this.getOprtState());
        this.currentCombinationUI.onLoad();
        this.currentCombinationUI.repaint();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("schemeType"));
        sic.add(new SelectorItemInfo("year"));
        sic.add(new SelectorItemInfo("beginPeriod"));
        sic.add(new SelectorItemInfo("endPeriod"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("combination.*"));
        return sic;
    }

    @Override
    protected void storageOrgPromptBox_willCommit(CommitEvent e) throws Exception {
        super.storageOrgPromptBox_willCommit(e);
    }

    @Override
    protected void storageOrgPromptBox_dataChanged(DataChangeEvent e) throws Exception {
        super.storageOrgPromptBox_dataChanged(e);
    }

    @Override
    protected void storageOrgPromptBox_willShow(SelectorEvent e) throws Exception {
        super.storageOrgPromptBox_willShow(e);
    }

    @Override
    protected void schemeTypeComboBox_itemStateChanged(ItemEvent e) throws Exception {
        super.schemeTypeComboBox_itemStateChanged(e);
    }

    private void filterStorageOrgBox() throws Exception {
        BDCMClientUtils.filterStorageFromCompanyF7((KDBizPromptBox)this.storageOrgPromptBox, (String)"isBizUnit", (Object)1, (String)this.currentCompany.getId().toString(), (String)"id");
    }

    protected void removeByPK(IObjectPK pk) throws Exception {
        super.removeByPK(pk);
        this.recycleNumberByOrg((IObjectValue)this.editData, "NONE", this.editData.getString("number"));
    }

    protected void recycleNumberByOrg(IObjectValue editData2, String orgType, String number) {
        if (!StringUtils.isEmpty((String)number)) {
            try {
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                iCodingRuleManager.recycleNumber(editData2, orgType, number);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    protected void setAutoNumberForOrg(String orgType) throws EASBizException, BOSException {
        this.ruleStatus = CodingRuleManagerFactory.getRemoteInstance().getRuleStatus((IObjectValue)this.editData, this.currentCompany.getId().toString());
        if (!this.ruleStatus.isExist()) {
            return;
        }
        if (this.editData.getNumber() == null) {
            String sysNumber = null;
            if (this.editData.getCU() == null) {
                this.editData.setCU(this.getRootCU());
            }
            try {
                String orgId = SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)).getString("id");
                if (!StringUtils.isEmpty((String)orgType) && !"NONE".equalsIgnoreCase(orgType) && orgId != null && (this.ruleStatus.isAddView() || this.ruleStatus.isAddNoBreak())) {
                    sysNumber = this.getNumberByClient((IObjectValue)this.editData, orgId);
                }
                if (!StringUtils.isEmpty(sysNumber)) {
                    this.editData.setNumber(sysNumber);
                    if (this.ruleStatus.isAddView() || this.ruleStatus.isAddNoBreak()) {
                        this.numberTextField.setText(sysNumber);
                    }
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    public String getNumberByClient(IObjectValue caller, String orgID) throws CodingRuleException, EASBizException, BOSException {
        String strNumber = "";
        if (orgID == null || orgID.trim().length() == 0) {
            orgID = "00000000-0000-0000-0000-000000000000CCE7AED4";
        }
        if (this.ruleStatus.isExist()) {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            strNumber = this.ruleStatus.isAddNoBreak() ? iCodingRuleManager.readNumber(caller, orgID) : iCodingRuleManager.getNumber(caller, orgID);
        }
        return strNumber;
    }

    private CtrlUnitInfo getRootCU() {
        CtrlUnitInfo rootCU = new CtrlUnitInfo();
        rootCU.setId(BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4"));
        return rootCU;
    }
}

