/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.std.bill.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.std.bill.ISTDCostData;
import com.kingdee.eas.ncm.std.bill.STDCostDataFactory;
import com.kingdee.eas.ncm.std.bill.client.AbstractSTDCostDataDetailUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.Assert;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class STDCostDataDetailUI
extends AbstractSTDCostDataDetailUI {
    private static final long serialVersionUID = 7794340115029117851L;
    private static final String COL_costItem = "costItem";
    private static final String COL_resType = "resType";
    private static final String COL_qty = "qty";
    private static final String COL_mu = "mu";
    private static final String COL_stdPrice = "stdPrice";
    private static final String COL_stdAmount = "stdAmount";
    private List dataList = null;
    private ListIterator dataIterator = null;
    private static final DecimalFormat fomart = new DecimalFormat("#,##0.000000");

    public void onLoad() throws Exception {
        String _stdCostDataId;
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getMergeManager().setMergeMode(5);
        this.tblMain.getGroupManager().group();
        String stdCostDataId = (String)this.getUIContext().get("stdCostDataId");
        FilterInfo currFilter = (FilterInfo)this.getUIContext().get("filter");
        Assert.that((!StringUtils.isEmpty((String)stdCostDataId) ? 1 : 0) != 0);
        Assert.that((currFilter != null ? 1 : 0) != 0);
        ISTDCostData iStdCostData = STDCostDataFactory.getRemoteInstance();
        this.dataList = iStdCostData.getStdCostDataIds(currFilter);
        this.dataIterator = this.dataList.listIterator();
        while (this.dataIterator.hasNext() && !stdCostDataId.equals(_stdCostDataId = (String)this.dataIterator.next())) {
        }
        Map detailMap = iStdCostData.getDetail(stdCostDataId);
        this.loadDetail(detailMap);
        this.processBtns();
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        ISTDCostData iStdCostData;
        Map detailMap;
        if (this.dataList == null || this.dataIterator == null) {
            return;
        }
        String stdCostDataId = null;
        while (this.dataIterator.hasPrevious()) {
            stdCostDataId = (String)this.dataIterator.previous();
        }
        if (stdCostDataId != null && (detailMap = (iStdCostData = STDCostDataFactory.getRemoteInstance()).getDetail(stdCostDataId)) != null && !detailMap.isEmpty()) {
            this.loadDetail(detailMap);
        }
        this.processBtns();
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        ISTDCostData iStdCostData;
        Map detailMap;
        String stdCostDataId;
        if (this.dataList == null || this.dataIterator == null) {
            return;
        }
        if (this.dataIterator.hasPrevious() && (stdCostDataId = (String)this.dataIterator.previous()) != null && (detailMap = (iStdCostData = STDCostDataFactory.getRemoteInstance()).getDetail(stdCostDataId)) != null && !detailMap.isEmpty()) {
            this.loadDetail(detailMap);
        }
        this.processBtns();
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        ISTDCostData iStdCostData;
        Map detailMap;
        String stdCostDataId;
        if (this.dataList == null || this.dataIterator == null) {
            return;
        }
        if (this.dataIterator.hasNext() && (stdCostDataId = (String)this.dataIterator.next()) != null && (detailMap = (iStdCostData = STDCostDataFactory.getRemoteInstance()).getDetail(stdCostDataId)) != null && !detailMap.isEmpty()) {
            this.loadDetail(detailMap);
        }
        this.processBtns();
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        ISTDCostData iStdCostData;
        Map detailMap;
        if (this.dataList == null || this.dataIterator == null) {
            return;
        }
        String stdCostDataId = null;
        while (this.dataIterator.hasNext()) {
            stdCostDataId = (String)this.dataIterator.next();
        }
        if (stdCostDataId != null && (detailMap = (iStdCostData = STDCostDataFactory.getRemoteInstance()).getDetail(stdCostDataId)) != null && !detailMap.isEmpty()) {
            this.loadDetail(detailMap);
        }
        this.processBtns();
    }

    private void loadDetail(Map detailMap) {
        if (detailMap == null || detailMap.isEmpty()) {
            return;
        }
        this.tblMain.removeRows();
        String caption = detailMap.keySet().iterator().next().toString();
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"24_STDCostDataDetailUI") + caption);
        List dataList = (List)detailMap.get(caption);
        if (dataList == null || dataList.isEmpty()) {
            return;
        }
        BigDecimal stdCost = SysConstant.BIGZERO;
        IRow row = null;
        int size = dataList.size();
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.addRow();
            Object[] values = (Object[])dataList.get(i);
            BigDecimal qty = values[3] instanceof BigDecimal ? (BigDecimal)values[3] : SysConstant.BIGZERO;
            BigDecimal stdPrice = values[4] instanceof BigDecimal ? (BigDecimal)values[4] : SysConstant.BIGZERO;
            BigDecimal stdAmount = values[5] instanceof BigDecimal ? (BigDecimal)values[5] : SysConstant.BIGZERO;
            row.getCell(COL_costItem).setValue(values[0]);
            row.getCell(COL_resType).setValue(values[1]);
            row.getCell(COL_qty).setValue((Object)fomart.format(qty));
            row.getCell(COL_mu).setValue(values[2]);
            row.getCell(COL_stdPrice).setValue((Object)fomart.format(stdPrice));
            row.getCell(COL_stdAmount).setValue((Object)fomart.format(stdAmount));
            stdCost = stdCost.add(stdAmount);
        }
        row = this.tblMain.addRow();
        row.getCell(COL_costItem).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"25_STDCostDataDetailUI"));
        row.getCell(COL_resType).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"25_STDCostDataDetailUI"));
        row.getCell(COL_qty).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"25_STDCostDataDetailUI"));
        row.getCell(COL_mu).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"25_STDCostDataDetailUI"));
        row.getCell(COL_stdPrice).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"25_STDCostDataDetailUI"));
        row.getCell(COL_stdAmount).setValue((Object)fomart.format(stdCost));
        this.tblMain.getMergeManager().mergeBlock(row.getRowIndex(), 0, row.getRowIndex(), 4);
        row.getStyleAttributes().setBackground(new Color(245, 245, 230));
        this.tblMain.getGroupManager().group();
    }

    private void processBtns() {
        if (this.dataList == null || this.dataIterator == null) {
            return;
        }
        if (this.dataIterator.hasNext()) {
            this.actionNext.setEnabled(true);
            this.actionLast.setEnabled(true);
        } else {
            this.actionNext.setEnabled(false);
            this.actionLast.setEnabled(false);
        }
        if (this.dataIterator.hasPrevious()) {
            this.actionPre.setEnabled(true);
            this.actionFirst.setEnabled(true);
        } else {
            this.actionPre.setEnabled(false);
            this.actionFirst.setEnabled(false);
        }
    }

    protected void loadData() throws Exception {
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }
}

