/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.std.bill.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.CalculateTypeEnum;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ncm.common.NCMIFilterParam;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.std.basedata.STDCostEstimateSchemeInfo;
import com.kingdee.eas.ncm.std.bill.STDCostDataFilterParam;
import com.kingdee.eas.ncm.std.bill.STDCostDataSourceTypeEnum;
import com.kingdee.eas.ncm.std.bill.client.AbstractSTDCostDataFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.util.List;

public class STDCostDataFilterUI
extends AbstractSTDCostDataFilterUI {
    private static final long serialVersionUID = -3345488944700106935L;
    private static final String STORAGE_ORG_UNIT_ID = "StorageOrgUnitId";
    private static final String ESTIMATE_SCHEME_NUMBERS = "EstimateSchemeNumbers";
    private static final String CALCULATE_TYPE = "CalculateType";
    private static final String MATERIAL_NUMBERS_FROM = "MaterialNumberFrom";
    private static final String MATERIAL_NUMBERS_TO = "MaterialNumberTo";
    private static final String DATA_TYPE = "DataType";
    private static final String IS_ONLY_NO_STD_PRICE = "IsOnlyNoStdPrice";
    CompanyOrgUnitInfo currCompany = null;
    PeriodInfo currPeriod = null;

    public STDCostDataFilterUI() throws Exception {
        this.init();
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    private void init() throws Exception {
        this.currCompany = SysContext.getSysContext().getCurrentFIUnit();
        this.currPeriod = NCMUtils.GetCurrentPeriod(null, (String)this.currCompany.getId().toString());
        this.filterStorageOrgBox();
        this.storageBizPromptBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                boolean clear = false;
                if (!(eventObj.getNewValue() instanceof StorageOrgUnitInfo) || !(eventObj.getOldValue() instanceof StorageOrgUnitInfo)) {
                    clear = true;
                } else {
                    StorageOrgUnitInfo newOrg = (StorageOrgUnitInfo)eventObj.getNewValue();
                    StorageOrgUnitInfo oldOrg = (StorageOrgUnitInfo)eventObj.getOldValue();
                    if (!newOrg.getId().toString().equals(oldOrg.getId().toString())) {
                        clear = true;
                    }
                }
                if (clear) {
                    STDCostDataFilterUI.this.numberBizPromptBox.setValue(null);
                    STDCostDataFilterUI.this.materialBizPromptBox.setValue(null);
                    STDCostDataFilterUI.this.materialBizPromptBoxTo.setValue(null);
                    try {
                        STDCostDataFilterUI.this.filterSchemeNumberBox();
                        STDCostDataFilterUI.this.filterMaterialBox(STDCostDataFilterUI.this.materialBizPromptBox);
                        STDCostDataFilterUI.this.filterMaterialBox(STDCostDataFilterUI.this.materialBizPromptBoxTo);
                    }
                    catch (Exception exc) {
                        ExceptionHandler.handle((Throwable)exc);
                    }
                }
            }
        });
        this.filterSchemeNumberBox();
        this.numberBizPromptBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                if (STDCostDataFilterUI.this.storageBizPromptBox.getValue() == null) {
                    MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"26_STDCostDataFilterUI"));
                    SysUtil.abort();
                }
                try {
                    STDCostDataFilterUI.this.filterSchemeNumberBox();
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Throwable)ex);
                }
            }
        });
        this.filterMaterialBox(this.materialBizPromptBox);
        this.materialBizPromptBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                if (STDCostDataFilterUI.this.storageBizPromptBox.getValue() == null) {
                    MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"26_STDCostDataFilterUI"));
                    SysUtil.abort();
                }
                try {
                    STDCostDataFilterUI.this.filterMaterialBox(STDCostDataFilterUI.this.materialBizPromptBox);
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Throwable)ex);
                }
            }
        });
        this.filterMaterialBox(this.materialBizPromptBoxTo);
        this.materialBizPromptBoxTo.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                if (STDCostDataFilterUI.this.storageBizPromptBox.getValue() == null) {
                    MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"26_STDCostDataFilterUI"));
                    SysUtil.abort();
                }
                try {
                    STDCostDataFilterUI.this.filterMaterialBox(STDCostDataFilterUI.this.materialBizPromptBoxTo);
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Throwable)ex);
                }
            }
        });
    }

    public void clear() {
        super.clear();
        this.storageBizPromptBox.setData(null);
        this.numberBizPromptBox.setData(null);
        this.calTypeComboBox.setSelectedIndex(0);
        this.dataTypeComboBox.setSelectedIndex(0);
        this.materialBizPromptBox.setData(null);
        this.materialBizPromptBoxTo.setData(null);
        this.onlyNoStdPriceCheckBox.setSelected(false);
    }

    private void filterStorageOrgBox() throws Exception {
        BDCMClientUtils.filterStorageFromCompanyF7((KDBizPromptBox)this.storageBizPromptBox, (String)"isBizUnit", (Object)1, (String)this.currCompany.getId().toString(), (String)"id");
    }

    private void filterSchemeNumberBox() throws Exception {
        if (this.currPeriod == null) {
            return;
        }
        EntityViewInfo view = null;
        view = this.numberBizPromptBox.getEntityViewInfo() == null ? new EntityViewInfo() : this.numberBizPromptBox.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (this.storageBizPromptBox.getValue() != null) {
            String storageOrgUnitId = ((StorageOrgUnitInfo)this.storageBizPromptBox.getValue()).getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitId, CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)this.currPeriod.getEndDate(), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("schemeType", (Object)1, CompareType.EQUALS));
        view.setFilter(filter);
        this.numberBizPromptBox.getQueryAgent().resetRuntimeEntityView();
        this.numberBizPromptBox.setEntityViewInfo(view);
    }

    private void filterMaterialBox(KDBizPromptBox prmt) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (this.storageBizPromptBox.getValue() != null) {
            String storageOrgUnitId = ((StorageOrgUnitInfo)this.storageBizPromptBox.getValue()).getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitId, CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)this.currCompany.getId().toString(), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currCompany.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("FIInfo.status", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("MaterialInventory.status", (Object)1, CompareType.EQUALS));
        view.setFilter(filter);
        prmt.setEntityViewInfo(view);
        FilterInfo filterPrmt = prmt.getEntityViewInfo().getFilter();
        NCMUtils.materialTreeDisplay((Object)((Object)this), (KDBizPromptBox)prmt, (FilterInfo)filterPrmt);
    }

    protected NCMIFilterParam createNewFilterParam() {
        return new STDCostDataFilterParam();
    }

    protected void storeBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof STDCostDataFilterParam)) {
            return;
        }
        STDCostDataFilterParam _filterParam = (STDCostDataFilterParam)filterParam;
        super.putIdByKey(customerParams, (Object)_filterParam.getStorageOrgUnitInfo(), STORAGE_ORG_UNIT_ID);
        super.putIdByKey(customerParams, (Object)_filterParam.getEstimateSchemes(), ESTIMATE_SCHEME_NUMBERS);
        super.putIdByKey(customerParams, (Object)_filterParam.getMaterialInfoFrom(), MATERIAL_NUMBERS_FROM);
        super.putIdByKey(customerParams, (Object)_filterParam.getMaterialInfoTo(), MATERIAL_NUMBERS_TO);
        customerParams.addCustomerParam(CALCULATE_TYPE, String.valueOf(_filterParam.getCalculateTypeEnum().getValue()));
        customerParams.addCustomerParam(DATA_TYPE, String.valueOf(_filterParam.getDataType().getValue()));
        customerParams.addCustomerParam(IS_ONLY_NO_STD_PRICE, String.valueOf(_filterParam.getIsOnlyNoStdPrice()));
    }

    protected void storeFilterParam(NCMIFilterParam filterParam) {
        if (!(filterParam instanceof STDCostDataFilterParam)) {
            return;
        }
        STDCostDataFilterParam _filterParam = (STDCostDataFilterParam)filterParam;
        if (this.storageBizPromptBox.getData() instanceof StorageOrgUnitInfo) {
            _filterParam.setStorageOrgUnitInfo((StorageOrgUnitInfo)this.storageBizPromptBox.getData());
        }
        STDCostEstimateSchemeInfo[] schemes = null;
        Object estimateSchemesObject = this.numberBizPromptBox.getData();
        if (estimateSchemesObject instanceof STDCostEstimateSchemeInfo) {
            schemes = new STDCostEstimateSchemeInfo[]{(STDCostEstimateSchemeInfo)estimateSchemesObject};
        } else if (estimateSchemesObject instanceof Object[]) {
            schemes = new STDCostEstimateSchemeInfo[((Object[])estimateSchemesObject).length];
            System.arraycopy(estimateSchemesObject, 0, schemes, 0, ((Object[])estimateSchemesObject).length);
        }
        _filterParam.setEstimateSchemes(schemes);
        if (this.calTypeComboBox.getSelectedItem() instanceof CalculateTypeEnum) {
            _filterParam.setCalculateTypeEnum((CalculateTypeEnum)this.calTypeComboBox.getSelectedItem());
        }
        if (this.materialBizPromptBox.getData() instanceof MaterialInfo) {
            _filterParam.setMaterialInfoFrom((MaterialInfo)this.materialBizPromptBox.getData());
        }
        if (this.materialBizPromptBoxTo.getData() instanceof MaterialInfo) {
            _filterParam.setMaterialInfoTo((MaterialInfo)this.materialBizPromptBoxTo.getData());
        }
        if (this.dataTypeComboBox.getSelectedItem() instanceof STDCostDataSourceTypeEnum) {
            _filterParam.setDataType((STDCostDataSourceTypeEnum)((Object)this.dataTypeComboBox.getSelectedItem()));
        }
        _filterParam.setIsOnlyNoStdPrice(this.onlyNoStdPriceCheckBox.isSelected());
    }

    protected void loadBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof STDCostDataFilterParam)) {
            return;
        }
        STDCostDataFilterParam _filterParam = (STDCostDataFilterParam)filterParam;
        try {
            String storageOrgUnitId = customerParams.getCustomerParam(STORAGE_ORG_UNIT_ID);
            if (!StringUtils.isEmpty((String)storageOrgUnitId)) {
                StorageOrgUnitInfo storageOrgUnitInfo = new StorageOrgUnitInfo();
                storageOrgUnitInfo.setId(BOSUuid.read((String)storageOrgUnitId));
                _filterParam.setStorageOrgUnitInfo(storageOrgUnitInfo);
            } else {
                _filterParam.setStorageOrgUnitInfo(null);
            }
            List estimateSchemeNumbers = (List)this.getObject(this.decode(customerParams.getCustomerParam(ESTIMATE_SCHEME_NUMBERS)));
            if (estimateSchemeNumbers != null) {
                _filterParam.setEstimateSchemes(new STDCostEstimateSchemeInfo[estimateSchemeNumbers.size()]);
                String id = null;
                int in = estimateSchemeNumbers.size();
                for (int i = 0; i < in; ++i) {
                    id = (String)estimateSchemeNumbers.get(i);
                    if (StringUtils.isEmpty((String)id)) continue;
                    _filterParam.getEstimateSchemes()[i] = new STDCostEstimateSchemeInfo();
                    _filterParam.getEstimateSchemes()[i].setId(BOSUuid.read((String)id));
                }
            } else {
                _filterParam.setEstimateSchemes(null);
            }
            String calcuTypeString = customerParams.getCustomerParam(CALCULATE_TYPE);
            if (!StringUtils.isEmpty((String)calcuTypeString)) {
                _filterParam.setCalculateTypeEnum(CalculateTypeEnum.getEnum((int)Integer.valueOf(calcuTypeString)));
            } else {
                _filterParam.setCalculateTypeEnum(null);
            }
            String materialFromId = customerParams.getCustomerParam(MATERIAL_NUMBERS_FROM);
            if (materialFromId != null) {
                MaterialInfo matFrom = new MaterialInfo();
                matFrom.setId(BOSUuid.read((String)materialFromId));
                _filterParam.setMaterialInfoFrom(matFrom);
            } else {
                _filterParam.setMaterialInfoFrom(null);
            }
            String materialToId = customerParams.getCustomerParam(MATERIAL_NUMBERS_TO);
            if (materialToId != null) {
                MaterialInfo matTo = new MaterialInfo();
                matTo.setId(BOSUuid.read((String)materialToId));
                _filterParam.setMaterialInfoTo(matTo);
            } else {
                _filterParam.setMaterialInfoTo(null);
            }
            String dataType = customerParams.getCustomerParam(DATA_TYPE);
            if (!StringUtils.isEmpty((String)dataType)) {
                _filterParam.setDataType(STDCostDataSourceTypeEnum.getEnum(Integer.valueOf(dataType)));
            } else {
                _filterParam.setDataType(null);
            }
            String isOnlyNotStdPrice = customerParams.getCustomerParam(IS_ONLY_NO_STD_PRICE);
            if (!StringUtils.isEmpty((String)isOnlyNotStdPrice)) {
                _filterParam.setIsOnlyNoStdPrice(Boolean.valueOf(isOnlyNotStdPrice));
            } else {
                _filterParam.setIsOnlyNoStdPrice(Boolean.FALSE);
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    protected void loadFilterParam(NCMIFilterParam filterParam) {
        if (filterParam != null && filterParam instanceof STDCostDataFilterParam) {
            STDCostDataFilterParam _filterParam = (STDCostDataFilterParam)filterParam;
            if (_filterParam.getStorageOrgUnitInfo() != null) {
                this.storageBizPromptBox.setValue((Object)_filterParam.getStorageOrgUnitInfo());
            } else {
                this.storageBizPromptBox.setValue(null);
            }
            if (_filterParam.getEstimateSchemes() != null) {
                this.numberBizPromptBox.setValue((Object)_filterParam.getEstimateSchemes());
            } else {
                this.numberBizPromptBox.setValue(null);
            }
            if (_filterParam.getCalculateTypeEnum() != null) {
                this.calTypeComboBox.setSelectedItem((Object)_filterParam.getCalculateTypeEnum());
            } else {
                this.calTypeComboBox.setSelectedItem(null);
            }
            if (_filterParam.getMaterialInfoFrom() != null) {
                this.materialBizPromptBox.setValue((Object)_filterParam.getMaterialInfoFrom());
            } else {
                this.materialBizPromptBox.setValue(null);
            }
            if (_filterParam.getMaterialInfoTo() != null) {
                this.materialBizPromptBoxTo.setValue((Object)_filterParam.getMaterialInfoTo());
            } else {
                this.materialBizPromptBoxTo.setValue(null);
            }
            this.dataTypeComboBox.setSelectedItem((Object)_filterParam.getDataType());
            this.onlyNoStdPriceCheckBox.setSelected(_filterParam.getIsOnlyNoStdPrice().booleanValue());
        }
    }

    public boolean verify() {
        if (UIRuleUtil.isNull((Object)this.storageBizPromptBox.getValue())) {
            this.storageBizPromptBox.requestFocus();
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"27_STDCostDataFilterUI"));
            SysUtil.abort();
        }
        return true;
    }

    public FilterInfo getFilterInfo() {
        return super.getFilterInfo();
    }
}

