/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.std.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectSingleKey;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.IMaterialCompanyInfo;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMCommonQueryProcessor;
import com.kingdee.eas.ncm.std.basedata.STCostBOMQueueFactory;
import com.kingdee.eas.ncm.std.basedata.STCostBOMQueueInfo;
import com.kingdee.eas.ncm.std.basedata.STDCostEstimateSchemeInfo;
import com.kingdee.eas.ncm.std.bill.STDCostMaterialBOMFactory;
import com.kingdee.eas.ncm.std.bill.STDCostMaterialBOMInfo;
import com.kingdee.eas.ncm.std.bill.client.AbstractSTDCostMaterialBOMListUI;
import com.kingdee.eas.ncm.std.bill.client.GenerateSTDCostMaterialBOMUI;
import com.kingdee.eas.ncm.std.bill.client.STDCostMaterialBOMFilterUI;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class STDCostMaterialBOMListUI
extends AbstractSTDCostMaterialBOMListUI {
    private static Logger logger = Logger.getLogger((String)STDCostMaterialBOMListUI.class.getName());
    private static final long serialVersionUID = -6919457993238775165L;
    private static final String COL_ID = "id";
    private static final String COL_BOMQueue_ID = "bomQueue.id";
    private static final String COL_BOMQueue_Name = "bomQueue.name";
    private static final String COL_BOM_ID = "bom.id";
    private static final String COL_BOM_Number = "bom.number";
    private static final String COL_BOM_Name = "bom.name";
    private static final String COL_ValidateDate = "validateDate";
    private static final String COL_DESC = "desc";
    private static final String Col_EstimateSchemeNumber = "scheme.number";
    private static final String Col_EstimateSchemeName = "scheme.name";
    private static final String Col_EstimateSchemeStorageName = "storageOrg.name";
    private static final String COL_Material_ID = "mat.id";
    private static final String COL_Material_Number = "mat.number";
    private static final String COL_Material_Name = "mat.name";
    private static final String COL_Material_Model = "model";
    private static final String Col_CompanyName = "company.name";
    private static final String COL_CalcuType = "calcuType";
    private static final String COL_IsDirty = "isDirty";
    private final ArrayList addObjList = new ArrayList();
    private static final int FirstRowIndex = 0;
    private final ArrayList deletePks = new ArrayList();
    private KDBizPromptBox prmtEstimateScheme = null;
    private KDBizPromptBox prmtMaterial = null;
    protected STDCostMaterialBOMFilterUI filterUI = null;
    private KDBizPromptBox bomQueuePromptBox = null;
    private KDBizPromptBox bomPromptBox = null;
    private CommonQueryDialog dialog = null;
    CompanyOrgUnitInfo currCompany = null;
    PeriodInfo currPeriod = null;

    public STDCostMaterialBOMListUI() throws Exception {
        this.tblMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                int colIndex = e.getColIndex();
                int rowIndex = e.getRowIndex();
                if (colIndex == STDCostMaterialBOMListUI.this.tblMain.getColumnIndex(STDCostMaterialBOMListUI.COL_Material_Number) && STDCostMaterialBOMListUI.this.tblMain.getRow(rowIndex).getCell(STDCostMaterialBOMListUI.Col_EstimateSchemeStorageName).getValue() == null) {
                    MsgBox.showWarning((String)"\u8bf7\u5148\u9009\u62e9\u4f30\u7b97\u65b9\u6848");
                    SysUtil.abort();
                }
                try {
                    STDCostMaterialBOMListUI.this.filtExsitMaterial(null);
                }
                catch (Exception e1) {
                    logger.error((Object)e1);
                }
                super.editStarting(e);
            }
        });
    }

    public void onLoad() throws Exception {
        this.currCompany = SysContext.getSysContext().getCurrentFIUnit();
        this.currPeriod = NCMUtils.GetCurrentPeriod(null, (String)this.currCompany.getId().toString());
        super.onLoad();
        this.init();
        STCostBOMQueueFactory.getRemoteInstance().generate(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAddline.setVisible(true);
        this.actionAddline.setEnabled(true);
        this.actionInsertLine.setVisible(true);
        this.actionInsertLine.setEnabled(true);
        this.actionAddline.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_addline"));
        this.actionInsertLine.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_insert"));
    }

    protected void init() throws Exception {
        this.bomQueuePromptBox = new KDBizPromptBox();
        this.bomQueuePromptBox.setQueryInfo("com.kingdee.eas.ncm.std.basedata.app.STCostBOMQueueQuery");
        this.bomQueuePromptBox.setDisplayFormat("$number$");
        this.bomQueuePromptBox.setEditFormat("$number$");
        this.bomQueuePromptBox.setCommitFormat("$number$");
        this.bomQueuePromptBox.setEditable(false);
        this.bomQueuePromptBox.setRequired(true);
        this.bomQueuePromptBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent event) {
                int rowIndex = STDCostMaterialBOMListUI.this.tblMain.getSelectManager().getActiveRowIndex();
                IRow curRow = STDCostMaterialBOMListUI.this.tblMain.getRow(rowIndex);
                if (event.getNewValue() instanceof STCostBOMQueueInfo) {
                    STCostBOMQueueInfo bomQueue = (STCostBOMQueueInfo)event.getNewValue();
                    curRow.getCell(STDCostMaterialBOMListUI.COL_BOMQueue_ID).setValue((Object)bomQueue.getId().toString());
                    curRow.getCell(STDCostMaterialBOMListUI.COL_BOM_ID).setValue(null);
                    curRow.getCell(STDCostMaterialBOMListUI.COL_BOM_Number).setValue(null);
                    curRow.getCell(STDCostMaterialBOMListUI.COL_BOM_Name).setValue(null);
                } else if (event.getOldValue() != null) {
                    curRow.getCell(STDCostMaterialBOMListUI.COL_IsDirty).setValue((Object)String.valueOf(true));
                    STDCostMaterialBOMListUI.this.actionSave.setEnabled(true);
                }
            }
        });
        ObjectValueRender bomQueueRender = new ObjectValueRender();
        bomQueueRender.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.tblMain.getColumn(COL_BOMQueue_Name).setRenderer((IBasicRender)bomQueueRender);
        this.tblMain.getColumn(COL_BOMQueue_Name).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.bomQueuePromptBox));
        this.bomPromptBox = new KDBizPromptBox();
        this.bomPromptBox.setQueryInfo("com.kingdee.eas.basedata.ncm.app.F7BomQuery");
        this.bomPromptBox.setDisplayFormat("$name$");
        this.bomPromptBox.setEditFormat("$number$");
        this.bomPromptBox.setCommitFormat("$number$");
        this.bomPromptBox.setEditable(false);
        this.bomPromptBox.setRequired(true);
        this.bomPromptBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent event) {
                int rowIndex = STDCostMaterialBOMListUI.this.tblMain.getSelectManager().getActiveRowIndex();
                IRow curRow = STDCostMaterialBOMListUI.this.tblMain.getRow(rowIndex);
                if (event.getNewValue() instanceof BomInfo) {
                    BomInfo bomInfo = (BomInfo)event.getNewValue();
                    curRow.getCell(STDCostMaterialBOMListUI.COL_BOM_ID).setValue((Object)bomInfo.getId().toString());
                    curRow.getCell(STDCostMaterialBOMListUI.COL_BOMQueue_Name).setValue(null);
                    curRow.getCell(STDCostMaterialBOMListUI.COL_BOMQueue_ID).setValue(null);
                    curRow.getCell(STDCostMaterialBOMListUI.COL_BOM_Name).setValue((Object)((BomInfo)event.getNewValue()).getName());
                } else if (event.getOldValue() != null) {
                    curRow.getCell(STDCostMaterialBOMListUI.COL_IsDirty).setValue((Object)String.valueOf(true));
                    STDCostMaterialBOMListUI.this.actionSave.setEnabled(true);
                }
            }
        });
        this.filterBOM();
        this.bomPromptBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                try {
                    STDCostMaterialBOMListUI.this.filterBOM();
                }
                catch (Exception exc) {
                    ExceptionHandler.handle((Throwable)exc);
                }
            }
        });
        this.tblMain.getColumn(COL_BOM_Number).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.bomPromptBox));
        ObjectValueRender bomRender = new ObjectValueRender();
        bomRender.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.tblMain.getColumn(COL_BOM_Number).setRenderer((IBasicRender)bomRender);
        KDDatePicker picker = new KDDatePicker();
        picker.getEditor().setDateTimePattern("yyyy-MM-dd");
        picker.setEditable(true);
        this.tblMain.getColumn(COL_ValidateDate).setEditor((ICellEditor)new KDTDefaultCellEditor(picker));
        this.tblMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                try {
                    int colIndex = STDCostMaterialBOMListUI.this.tblMain.getSelectManager().getActiveColumnIndex();
                    if (colIndex == STDCostMaterialBOMListUI.this.tblMain.getColumn(STDCostMaterialBOMListUI.COL_BOMQueue_Name).getColumnIndex() || colIndex == STDCostMaterialBOMListUI.this.tblMain.getColumn(STDCostMaterialBOMListUI.COL_ValidateDate).getColumnIndex()) {
                        STDCostMaterialBOMListUI.this.actionCopyToDown.setEnabled(true);
                    } else {
                        STDCostMaterialBOMListUI.this.actionCopyToDown.setEnabled(false);
                    }
                }
                catch (Exception exc) {
                    ExceptionHandler.handle((Throwable)exc);
                }
            }
        });
        this.tblMain.getColumn(COL_BOMQueue_Name).setRequired(true);
        this.tblMain.getColumn(COL_BOM_Number).setRequired(true);
        this.tblMain.getColumn(COL_ValidateDate).setRequired(true);
        this.tblMain.getColumn(COL_DESC).setRequired(true);
    }

    private void filterBOM() throws Exception {
        EntityViewInfo view = null;
        view = this.bomPromptBox.getEntityViewInfo() == null ? new EntityViewInfo() : this.bomPromptBox.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (this.filterUI != null && this.filterUI.storageOrgBizPromptBox.getValue() instanceof StorageOrgUnitInfo) {
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)((StorageOrgUnitInfo)this.filterUI.storageOrgBizPromptBox.getValue()).getId().toString(), CompareType.EQUALS));
        } else {
            Object o = this.getValueFromMainQuery("schemeStorageOrg.id");
            if (o != null) {
                filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)o.toString(), CompareType.EQUALS));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)"####################", CompareType.EQUALS));
            }
        }
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)4, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bomType", (Object)40, CompareType.EQUALS));
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex >= 0) {
            Object colId = this.tblMain.getCell(rowIndex, COL_ID).getValue();
            if (colId != null) {
                Object matIDObject = this.tblMain.getCell(rowIndex, COL_Material_ID).getValue();
                if (matIDObject != null && matIDObject.toString().length() > 0) {
                    filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)matIDObject.toString(), CompareType.EQUALS));
                }
            } else {
                Object matObject = this.tblMain.getCell(rowIndex, COL_Material_Number).getValue();
                if (matObject != null && matObject.toString().length() > 0 && matObject instanceof MaterialInfo) {
                    MaterialInfo matInfo = (MaterialInfo)matObject;
                    filter.getFilterItems().add(new FilterItemInfo("material.number", (Object)matInfo.getNumber(), CompareType.EQUALS));
                }
            }
        }
        view.setFilter(filter);
        this.bomPromptBox.setEntityViewInfo(view);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.actionCopyToDown.setEnabled(false);
    }

    protected void initTableParams() {
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(COL_BOMQueue_Name).getStyleAttributes().setLocked(false);
        this.tblMain.getColumn(COL_BOM_Number).getStyleAttributes().setLocked(false);
        this.tblMain.getColumn(COL_ValidateDate).getStyleAttributes().setLocked(false);
        this.tblMain.getColumn(COL_DESC).getStyleAttributes().setLocked(false);
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
        this.tblMain.getSelectManager().setSelectMode(10);
        KDTableHelper.releaseTab((JComponent)this.tblMain);
        KDTableHelper.releaseEnter((JComponent)this.tblMain);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return STDCostMaterialBOMFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return "";
    }

    protected String getKeyFieldName() {
        return COL_ID;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("BOMQueue.*"));
        return sic;
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                STDCostMaterialBOMListUI.this.tblMain.checkParsed();
                for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                    ICell cell = STDCostMaterialBOMListUI.this.tblMain.getRow(i).getCell(STDCostMaterialBOMListUI.COL_IsDirty);
                    if (cell == null) continue;
                    cell.setValue((Object)String.valueOf(false));
                }
                STDCostMaterialBOMListUI.this.actionSave.setEnabled(false);
                STDCostMaterialBOMListUI.this.deletePks.clear();
                if (STDCostMaterialBOMListUI.this.tblMain.getRowCount() == 0) {
                    STDCostMaterialBOMListUI.this.actionRemove.setEnabled(false);
                } else {
                    STDCostMaterialBOMListUI.this.actionRemove.setEnabled(true);
                }
            }
        });
        this.tblMain.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 127) {
                    keyEvent.setKeyChar('\u0000');
                    keyEvent.setKeyCode(0);
                    try {
                        STDCostMaterialBOMListUI.this.innerDoRemoveLine();
                    }
                    catch (Exception e) {
                        STDCostMaterialBOMListUI.this.handUIException(e);
                    }
                }
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 127) {
                    keyEvent.setKeyChar('\u0000');
                    keyEvent.setKeyCode(0);
                }
            }
        });
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "STDCostMaterialBOM";
        param.alias = EASResource.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"49_STDCostMaterialBOMListUI");
        param.datataskMode = 1;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
        this.refresh(e);
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "STDCostMaterialBOM";
        param.alias = EASResource.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"49_STDCostMaterialBOMListUI");
        param.datataskMode = 0;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    @Override
    public void actionGenerate_actionPerformed(ActionEvent e) throws Exception {
        Object o;
        Object STORAGE_ORG = null;
        if ((this.filterUI == null || this.filterUI.storageOrgBizPromptBox.getValue() == null) && (o = this.getValueFromMainQuery("schemeStorageOrg.id")) != null) {
            STORAGE_ORG = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(o.toString()));
        }
        if (STORAGE_ORG == null) {
            STORAGE_ORG = this.filterUI.storageOrgBizPromptBox.getValue();
        }
        if (STORAGE_ORG == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"21_GenerateSTDCostDataUI"));
            SysUtil.abort();
        }
        this.checkIsModify();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"STORAGE_ORG", STORAGE_ORG);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(GenerateSTDCostMaterialBOMUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        this.refreshList();
    }

    private Object getValueFromMainQuery(String propertyName) {
        if (this.mainQuery != null && this.mainQuery.getFilter() != null) {
            FilterInfo filter = this.mainQuery.getFilter();
            for (FilterItemInfo item : filter.getFilterItems()) {
                if (!item.getPropertyName().equals(propertyName)) continue;
                return item.getCompareValue();
            }
        }
        return null;
    }

    private String getStorageId() {
        StorageOrgUnitInfo storInfo = (StorageOrgUnitInfo)this.filterUI.storageOrgBizPromptBox.getValue();
        if (storInfo != null) {
            return storInfo.getId().toString();
        }
        Object o = this.getValueFromMainQuery("schemeStorageOrg.id");
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.checkValidData();
        this.runUpdate();
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"28_STDCostDataListUI"));
    }

    protected void checkValidData() throws Exception {
        int rowCount = this.tblMain.getRowCount();
        int colMaterialIndex = 0;
        int colSchemeIndex = 0;
        if (rowCount > 0) {
            colMaterialIndex = this.tblMain.getCell(0, COL_Material_Number).getColumnIndex();
            colSchemeIndex = this.tblMain.getCell(0, Col_EstimateSchemeNumber).getColumnIndex();
        }
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblMain.getRow2(i);
            if (row == null) continue;
            Object Material = row.getCell(COL_Material_Number).getValue();
            Object Scheme = row.getCell(Col_EstimateSchemeNumber).getValue();
            if (Material == null) {
                this.tblMain.getEditManager().editCellAt(i, colMaterialIndex);
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"29_STDCostDataListUI"));
                SysUtil.abort();
            }
            if (Scheme != null) continue;
            this.tblMain.getEditManager().editCellAt(i, colSchemeIndex);
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"30_STDCostDataListUI"));
            SysUtil.abort();
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.innerDoRemoveLine();
    }

    private void innerDoRemoveLine() throws Exception {
        if (this.containsCheckData()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"31_STDCostDataListUI"));
            SysUtil.abort();
        }
        this.removeLine(this.tblMain);
        this.tblMain.reLayoutAndPaint();
    }

    protected void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (this.confirmRemove()) {
            KDTSelectManager selectManager = table.getSelectManager();
            int size = selectManager.size();
            KDTSelectBlock selectBlock = null;
            HashSet<Integer> indexSet = new HashSet<Integer>();
            for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
                int i;
                selectBlock = selectManager.get(blockIndex);
                int top = selectBlock.getBeginRow();
                int bottom = selectBlock.getEndRow();
                if (table.getRow(top) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                if (8 == selectBlock.getMode()) {
                    for (i = 0; i < table.getRowCount(); ++i) {
                        indexSet.add(i);
                    }
                    continue;
                }
                for (i = top; i <= bottom; ++i) {
                    indexSet.add(i);
                }
            }
            Object[] indexArr = new Integer[indexSet.size()];
            Object[] indexObj = indexSet.toArray();
            System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
            Arrays.sort(indexArr);
            table.setRefresh(false);
            for (int i = indexArr.length - 1; i >= 0; --i) {
                int index;
                int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
                IObjectValue detailData = (IObjectValue)table.getRow(rowIndex).getUserObject();
                ObjectSingleKey opk = new ObjectSingleKey(COL_ID, table.getRow(rowIndex).getCell(COL_ID).getValue());
                if (opk.getKeyValue(opk.getKeyFields()[0]) != null) {
                    this.deletePks.add(opk);
                }
                this.actionSave.setEnabled(true);
                table.removeRow(rowIndex);
                IObjectCollection collection = (IObjectCollection)table.getUserObject();
                if (collection == null) {
                    logger.error((Object)"collection not be binded to table");
                    continue;
                }
                if (detailData == null || (index = this.getCollectionIndex(collection, detailData)) < 0 || collection.size() <= index) continue;
                collection.removeObject(index);
            }
            table.setRefresh(true);
            if (table.getRow(0) != null) {
                table.getSelectManager().select(0, 0, 0, 0);
            } else {
                this.actionRemove.setEnabled(false);
            }
        }
    }

    private int getCollectionIndex(IObjectCollection collection, IObjectValue obj) {
        int index = -1;
        if (collection == null) {
            return index;
        }
        for (int i = collection.size() - 1; i >= 0; --i) {
            if (obj != collection.getObject(i)) continue;
            index = i;
            return index;
        }
        return index;
    }

    @Override
    public void actionCopyToDown_actionPerformed(ActionEvent e) throws Exception {
        block9: {
            int endRowIndex;
            int rowIndex;
            int colIndex;
            block8: {
                colIndex = this.tblMain.getSelectManager().getActiveColumnIndex();
                if (colIndex != this.tblMain.getColumn(COL_BOMQueue_Name).getColumnIndex() && colIndex != this.tblMain.getColumn(COL_ValidateDate).getColumnIndex()) {
                    return;
                }
                rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
                endRowIndex = this.tblMain.getRowCount() - 1;
                if (rowIndex < 0 || rowIndex >= endRowIndex) {
                    return;
                }
                if (colIndex != this.tblMain.getColumn(COL_BOMQueue_Name).getColumnIndex()) break block8;
                Object value = this.tblMain.getCell(rowIndex, COL_BOMQueue_Name).getValue();
                if (value == null) {
                    return;
                }
                STCostBOMQueueInfo bomQueueInfo = null;
                if (value instanceof STCostBOMQueueInfo) {
                    bomQueueInfo = (STCostBOMQueueInfo)value;
                } else if (value instanceof String) {
                    ICell bomQueueIDCell = this.tblMain.getCell(rowIndex, COL_BOMQueue_ID);
                    ICell bomQueueNameCell = this.tblMain.getCell(rowIndex, COL_BOMQueue_Name);
                    bomQueueInfo = new STCostBOMQueueInfo();
                    bomQueueInfo.setId(BOSUuid.read((String)bomQueueIDCell.getValue().toString()));
                    bomQueueInfo.setNumber(bomQueueNameCell.getValue().toString());
                }
                IRow row = null;
                for (int i = rowIndex + 1; i <= endRowIndex; ++i) {
                    row = this.tblMain.getRow(i);
                    if (row.getCell(COL_BOM_Number).getValue() != null) continue;
                    row.getCell(COL_BOMQueue_ID).setValue((Object)(bomQueueInfo == null ? "bomQueueInfo null" : String.valueOf(bomQueueInfo.getId())));
                    row.getCell(COL_BOMQueue_Name).setValue((Object)bomQueueInfo);
                    row.getCell(COL_IsDirty).setValue((Object)String.valueOf(true));
                    this.actionSave.setEnabled(true);
                }
                break block9;
            }
            if (colIndex != this.tblMain.getColumn(COL_ValidateDate).getColumnIndex()) break block9;
            Object value = this.tblMain.getCell(rowIndex, COL_ValidateDate).getValue();
            IRow row = null;
            for (int i = rowIndex + 1; i <= endRowIndex; ++i) {
                row = this.tblMain.getRow(i);
                row.getCell(COL_ValidateDate).setValue(value);
                row.getCell(COL_IsDirty).setValue((Object)String.valueOf(true));
                this.actionSave.setEnabled(true);
            }
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.checkIsModify();
        super.actionQuery_actionPerformed(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runUpdate() throws Exception {
        IRow row;
        int i;
        this.checkValidData();
        int rowCount = this.tblMain.getRowCount();
        if (rowCount <= 0 && this.deletePks.size() == 0) {
            return;
        }
        HashMap data = new HashMap();
        for (i = 0; i < rowCount; ++i) {
            row = this.tblMain.getRow2(i);
            if (row == null) continue;
            ICell idCell = row.getCell(COL_ID);
            ICell bomQueueIdCell = row.getCell(COL_BOMQueue_ID);
            ICell bomQueueNameCell = row.getCell(COL_BOMQueue_Name);
            ICell bomIDCell = row.getCell(COL_BOM_ID);
            ICell bomNumberCell = row.getCell(COL_BOM_Number);
            ICell validateDateCell = row.getCell(COL_ValidateDate);
            ICell descCell = row.getCell(COL_DESC);
            ICell isDirtyCell = row.getCell(COL_IsDirty);
            if (idCell.getValue() == null) {
                STDCostMaterialBOMInfo info = new STDCostMaterialBOMInfo();
                info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
                MaterialInfo material = (MaterialInfo)row.getCell(COL_Material_Number).getValue();
                info.setParentMaterial(material);
                STDCostEstimateSchemeInfo scheme = (STDCostEstimateSchemeInfo)row.getCell(Col_EstimateSchemeNumber).getValue();
                info.setEstimateScheme(scheme);
                STCostBOMQueueInfo bomQueue = null;
                if (bomQueueNameCell.getValue() == null) {
                    bomQueue = null;
                } else if (bomQueueNameCell.getValue() instanceof STCostBOMQueueInfo) {
                    bomQueue = (STCostBOMQueueInfo)bomQueueNameCell.getValue();
                } else {
                    bomQueue = new STCostBOMQueueInfo();
                    bomQueue.setId(BOSUuid.read((String)bomQueueIdCell.getValue().toString()));
                }
                info.setBOMQueue(bomQueue);
                BomInfo bom = null;
                if (bomNumberCell.getValue() == null) {
                    bom = null;
                } else if (bomNumberCell.getValue() instanceof BomInfo) {
                    bom = (BomInfo)bomNumberCell.getValue();
                } else {
                    bom = new BomInfo();
                    bom.setId(BOSUuid.read((String)bomIDCell.getValue().toString()));
                }
                info.setBOM(bom);
                info.setValidateDate((Date)validateDateCell.getValue());
                info.setDescription((String)descCell.getValue());
                this.addObjList.add(info);
            }
            if (!String.valueOf(true).equals(isDirtyCell.getValue()) || idCell.getValue() == null) continue;
            ArrayList<Object> dataList = new ArrayList<Object>();
            STCostBOMQueueInfo bomQueue = null;
            if (bomQueueNameCell.getValue() == null) {
                bomQueue = null;
            } else if (bomQueueNameCell.getValue() instanceof STCostBOMQueueInfo) {
                bomQueue = (STCostBOMQueueInfo)bomQueueNameCell.getValue();
            } else {
                bomQueue = new STCostBOMQueueInfo();
                bomQueue.setId(BOSUuid.read((String)bomQueueIdCell.getValue().toString()));
            }
            dataList.add(bomQueue);
            BomInfo bom = null;
            if (bomNumberCell.getValue() == null) {
                bom = null;
            } else if (bomNumberCell.getValue() instanceof BomInfo) {
                bom = (BomInfo)bomNumberCell.getValue();
            } else {
                bom = new BomInfo();
                bom.setId(BOSUuid.read((String)bomIDCell.getValue().toString()));
            }
            dataList.add(bom);
            dataList.add(validateDateCell.getValue());
            dataList.add(descCell.getValue());
            data.put(idCell.getValue(), dataList);
        }
        try {
            STDCostMaterialBOMFactory.getRemoteInstance().updateData(data, this.deletePks, this.addObjList);
        }
        finally {
            this.addObjList.clear();
        }
        for (i = 0; i < rowCount; ++i) {
            row = this.tblMain.getRow2(i);
            if (row == null) continue;
            ICell isDirtyCell = row.getCell(COL_IsDirty);
            if (!String.valueOf(true).equals(isDirtyCell.getValue())) continue;
            isDirtyCell.setValue((Object)String.valueOf(false));
        }
        data.clear();
        this.deletePks.clear();
        this.refreshList();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if ((e.getColIndex() == this.tblMain.getColumnIndex(COL_BOMQueue_Name) || e.getColIndex() == this.tblMain.getColumnIndex(COL_BOM_Number) || e.getColIndex() == this.tblMain.getColumnIndex(COL_ValidateDate) || e.getColIndex() == this.tblMain.getColumnIndex(COL_DESC)) && this.containsCheckData()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"34_STDCostDataListUI"));
            this.tblMain.getEditManager().editingStopped();
            SysUtil.abort();
        }
    }

    @Override
    protected void tblMain_editStarting(KDTEditEvent e) throws Exception {
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        int colIndex = this.tblMain.getSelectManager().getActiveColumnIndex();
        if (rowIndex < 0) {
            return;
        }
        if (colIndex == this.tblMain.getColumnIndex(COL_BOM_Number)) {
            Object materialNumber = this.tblMain.getRow(rowIndex).getCell(COL_Material_Number).getValue();
            if (materialNumber == null) {
                MsgBox.showWarning((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599");
                SysUtil.abort();
            }
            this.filterBOM();
        }
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        int length;
        Object descObj;
        Serializable _oldVal;
        Serializable _newVal;
        if (e.getRowIndex() < 0) {
            return;
        }
        int colMaterialIndex = this.tblMain.getCell(e.getRowIndex(), COL_Material_Number).getColumnIndex();
        if (e.getValue() instanceof MaterialInfo) {
            MaterialInfo materialInfo = (MaterialInfo)e.getValue();
            this.tblMain.getCell(e.getRowIndex(), COL_Material_Name).setValue((Object)materialInfo.getName());
            this.tblMain.getCell(e.getRowIndex(), COL_Material_Model).setValue((Object)materialInfo.getModel());
            IMaterialCompanyInfo i = MaterialCompanyInfoFactory.getRemoteInstance();
            FilterInfo filter = new FilterInfo();
            FilterInfo filter2 = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("mateial.id", (Object)materialInfo.getId().toString(), CompareType.EQUALS));
            filter2.getFilterItems().add(new FilterItemInfo("company.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString(), CompareType.EQUALS));
            filter.mergeFilter(filter2, "AND");
            EntityViewInfo newEvi = new EntityViewInfo();
            newEvi.setFilter(filter);
            MaterialCompanyInfoCollection collection = i.getMaterialCompanyInfoCollection(newEvi);
            this.tblMain.getCell(e.getRowIndex(), COL_CalcuType).setValue((Object)collection.get(0).getCalculateType());
            this.actionSave.setEnabled(true);
        } else if (e.getValue() == null && e.getColIndex() == colMaterialIndex) {
            this.tblMain.getCell(e.getRowIndex(), COL_Material_Name).setValue((Object)"");
        }
        if (e.getValue() instanceof STDCostEstimateSchemeInfo) {
            STDCostEstimateSchemeInfo schemeInfo = (STDCostEstimateSchemeInfo)e.getValue();
            this.tblMain.getCell(e.getRowIndex(), Col_EstimateSchemeName).setValue((Object)schemeInfo.getName());
            IStorageOrgUnit storageOrgUnit = StorageOrgUnitFactory.getRemoteInstance();
            FilterInfo filterStorage = new FilterInfo();
            filterStorage.getFilterItems().add(new FilterItemInfo(COL_ID, (Object)schemeInfo.getStorageOrgUnit().getId().toString(), CompareType.EQUALS));
            EntityViewInfo eviStorage = new EntityViewInfo();
            eviStorage.setFilter(filterStorage);
            StorageOrgUnitCollection collectionStorage = storageOrgUnit.getStorageOrgUnitCollection(eviStorage);
            this.tblMain.getCell(e.getRowIndex(), Col_EstimateSchemeStorageName).setValue((Object)collectionStorage.get(0).getName());
            this.actionSave.setEnabled(true);
        }
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        Object newVal = e.getValue();
        Object oldVal = e.getOldValue();
        boolean isDirty = false;
        if (colIndex == this.tblMain.getColumnIndex(COL_BOMQueue_Name)) {
            if (newVal instanceof STCostBOMQueueInfo) {
                _newVal = (STCostBOMQueueInfo)newVal;
                if (oldVal instanceof STCostBOMQueueInfo) {
                    _oldVal = (STCostBOMQueueInfo)oldVal;
                    if (!_newVal.getId().toString().equals(_oldVal.getId().toString())) {
                        isDirty = true;
                    }
                } else {
                    isDirty = true;
                }
            } else if (oldVal instanceof STCostBOMQueueInfo) {
                isDirty = true;
            }
        } else if (colIndex == this.tblMain.getColumnIndex(COL_BOM_Number)) {
            if (newVal instanceof BomInfo) {
                _newVal = (BomInfo)newVal;
                if (oldVal instanceof BomInfo) {
                    _oldVal = (BomInfo)oldVal;
                    if (!_newVal.getId().toString().equals(_oldVal.getId().toString())) {
                        isDirty = true;
                    }
                } else {
                    isDirty = true;
                }
            } else if (oldVal instanceof BomInfo) {
                isDirty = true;
            }
        } else if (colIndex == this.tblMain.getColumnIndex(COL_ValidateDate)) {
            if (newVal instanceof Date) {
                _newVal = (Date)newVal;
                if (oldVal instanceof Date) {
                    _oldVal = (Date)oldVal;
                    GregorianCalendar newCalendar = new GregorianCalendar();
                    newCalendar.setTime((Date)_newVal);
                    GregorianCalendar oldCalendar = new GregorianCalendar();
                    oldCalendar.setTime((Date)_oldVal);
                    if (newCalendar.get(1) != oldCalendar.get(1) || newCalendar.get(2) != oldCalendar.get(2) || newCalendar.get(5) != oldCalendar.get(5)) {
                        isDirty = true;
                    }
                } else {
                    isDirty = true;
                }
            } else if (oldVal instanceof Date) {
                isDirty = true;
            }
        } else if (colIndex == this.tblMain.getColumnIndex(COL_DESC)) {
            if (newVal == null) {
                if (oldVal != null) {
                    isDirty = true;
                }
            } else if (!newVal.equals(oldVal)) {
                isDirty = true;
            }
        }
        if (isDirty) {
            this.tblMain.getRow(rowIndex).getCell(COL_IsDirty).setValue((Object)String.valueOf(true));
            this.actionSave.setEnabled(true);
        }
        if ((descObj = this.tblMain.getRow(rowIndex).getCell(COL_DESC).getValue()) != null && (length = descObj.toString().length()) > 200) {
            MsgBox.showWarning((String)"\u5907\u6ce8\u5185\u5bb9\u957f\u5ea6\u8fc7\u957f\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
            this.tblMain.getRow(rowIndex).getCell(COL_DESC).setValue(null);
            SysUtil.abort();
        }
        super.tblMain_editStopped(e);
    }

    protected boolean checkBeforeWindowClosing() {
        try {
            this.checkIsModify();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            SysUtil.abort();
        }
        return true;
    }

    private void checkIsModify() throws Exception {
        if (this.checkIsDirty()) {
            int ret = MsgBox.showConfirm3((String)NCMClientUtils.getNcmBillResource((String)"CHECK_DIRTY"));
            if (ret == 0) {
                try {
                    this.checkPermission("");
                    this.runUpdate();
                }
                catch (BOSException e) {
                    logger.error((Object)"", (Throwable)e);
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)NCMClientUtils.getNcmBillResource((String)"SAVE_FAIL"), (String)e.getMessage(), (int)8188);
                    SysUtil.abort();
                }
                catch (EASBizException e2) {
                    logger.error((Object)"", (Throwable)e2);
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)NCMClientUtils.getNcmBillResource((String)"SAVE_FAIL"), (String)e2.getMessage(), (int)8188);
                    SysUtil.abort();
                }
            } else if (ret == 2) {
                SysUtil.abort();
            }
        }
    }

    private boolean checkIsDirty() {
        int rowCount = this.tblMain.getRowCount();
        if (rowCount <= 0 && this.deletePks.size() == 0) {
            return false;
        }
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblMain.getRow2(i);
            if (row == null) continue;
            ICell isDirty = row.getCell(COL_IsDirty);
            if (!String.valueOf(true).equals(isDirty.getValue())) continue;
            return true;
        }
        return this.deletePks.size() > 0;
    }

    private boolean checkPermission(String ermissionKey) throws Exception {
        if (!StringUtils.isEmpty((String)ermissionKey)) {
            PermissionHelper.checkFunctionPermission(null, null, (String)ermissionKey);
        }
        return true;
    }

    protected CustomerQueryPanel getFilterUI() {
        if (this.filterUI == null) {
            try {
                this.filterUI = new STDCostMaterialBOMFilterUI();
            }
            catch (Exception ex) {
                ExceptionHandler.handle((Throwable)ex);
            }
        }
        return this.filterUI;
    }

    protected int getCommonQueryDialogWidth() {
        return 450;
    }

    protected int getCommonQueryDialogHeight() {
        return 230;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog == null) {
            this.dialog = super.initCommonQueryDialog();
        }
        NCMCommonQueryProcessor cmcq = new NCMCommonQueryProcessor();
        cmcq.set("companyOrg", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        cmcq.set("query", (Object)"STDCostMaterialBOMQuery");
        this.dialog.setProcessor((IProcessor)cmcq);
        return this.dialog;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        String companyID = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyOrg.id", (Object)companyID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("materialCompany.company.id", (Object)companyID, CompareType.EQUALS));
        if (this.filterUI != null && this.filterUI.storageOrgBizPromptBox.getValue() instanceof StorageOrgUnitInfo) {
            String storageOrgUnitID = ((StorageOrgUnitInfo)this.filterUI.storageOrgBizPromptBox.getValue()).getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("materialInventory.orgUnit.id", (Object)storageOrgUnitID, CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("materialCompany.status", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("materialInventory.status", (Object)1, CompareType.EQUALS));
        return filter;
    }

    private boolean containsCheckData() {
        this.checkSelected();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows == null || selectRows.length == 0) {
            return false;
        }
        for (int i = 0; i < selectRows.length; ++i) {
            Object state = this.tblMain.getRow(selectRows[i]).getCell("state").getValue();
            if (!(state instanceof BizEnumValueDTO) || !String.valueOf(2).equals(((BizEnumValueDTO)state).getValue())) continue;
            return true;
        }
        return false;
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    @Override
    public void actionAddline_actionPerformed(ActionEvent e) throws Exception {
        if (this.getDetailTable() != null) {
            this.addLine(this.getDetailTable(), 0);
        }
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectManager selectManager = this.tblMain.getSelectManager();
        KDTSelectBlock selectBlock = selectManager.get(0);
        if (selectManager.size() == 0) {
            this.addLine(this.getDetailTable(), 0);
        } else if (selectManager.size() > 0) {
            int inserRowIndex = selectBlock.getBeginRow();
            if (inserRowIndex < 0) {
                inserRowIndex = 0;
            }
            this.addLine(this.getDetailTable(), inserRowIndex);
        }
    }

    protected void addLine(KDTable table, int rowIndex) throws Exception {
        if (table == null) {
            return;
        }
        if (this.tblMain.getRowCount() == 0) {
            this.actionRemove.setEnabled(true);
        }
        IRow row = table.addRow(rowIndex);
        this.tblMain.setRowCount(this.tblMain.getRowCount() + 1);
        this.formatAddline(row);
    }

    private void formatAddline(IRow row) throws Exception {
        row.getCell(COL_IsDirty).setValue((Object)String.valueOf(true));
        CompanyOrgUnitInfo companyInfo = SysContext.getSysContext().getCurrentFIUnit();
        row.getCell(Col_CompanyName).setValue((Object)companyInfo.getName());
        this.prmtMaterial = new KDBizPromptBox();
        this.prmtMaterial.setQueryInfo("com.kingdee.eas.basedata.ncm.app.MaterialFiStorageCostQuery");
        this.prmtMaterial.setVisible(true);
        this.prmtMaterial.setEditable(true);
        this.prmtMaterial.setDisplayFormat("$number$");
        this.prmtMaterial.setEditFormat("$number$");
        this.prmtMaterial.setCommitFormat("$number$");
        this.filterMaterialByStor(this.prmtMaterial);
        this.prmtMaterial.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                try {
                    STDCostMaterialBOMListUI.this.filtExsitMaterial(e);
                }
                catch (Exception e1) {
                    STDCostMaterialBOMListUI.this.handUIException(e1);
                }
            }
        });
        KDTDefaultCellEditor cellMaterial = new KDTDefaultCellEditor((IKDEditor)this.prmtMaterial);
        ObjectValueRender ovrMaterial = new ObjectValueRender();
        ovrMaterial.setFormat((IDataFormat)new BizDataFormat("$number$"));
        row.getCell(COL_Material_Number).getStyleAttributes().setLocked(false);
        row.getCell(COL_Material_Number).setEditor((ICellEditor)cellMaterial);
        row.getCell(COL_Material_Number).setRenderer((IBasicRender)ovrMaterial);
        this.prmtEstimateScheme = new KDBizPromptBox();
        this.prmtEstimateScheme.setQueryInfo("com.kingdee.eas.ncm.std.basedata.app.STDCostEstimateSchemeQuery");
        this.prmtEstimateScheme.setVisible(true);
        this.prmtEstimateScheme.setEditable(true);
        this.prmtEstimateScheme.setDisplayFormat("$number$");
        this.prmtEstimateScheme.setEditFormat("$number$");
        this.prmtEstimateScheme.setCommitFormat("$number$");
        this.filterEstimateScheme();
        this.prmtEstimateScheme.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                try {
                    STDCostMaterialBOMListUI.this.filtExsitEstimateScheme(e);
                }
                catch (Exception e1) {
                    STDCostMaterialBOMListUI.this.handUIException(e1);
                }
            }
        });
        KDTDefaultCellEditor cellScheme = new KDTDefaultCellEditor((IKDEditor)this.prmtEstimateScheme);
        ObjectValueRender ovrScheme = new ObjectValueRender();
        ovrScheme.setFormat((IDataFormat)new BizDataFormat("$number$"));
        row.getCell(Col_EstimateSchemeNumber).getStyleAttributes().setLocked(false);
        row.getCell(Col_EstimateSchemeNumber).setEditor((ICellEditor)cellScheme);
        row.getCell(Col_EstimateSchemeNumber).setRenderer((IBasicRender)ovrScheme);
    }

    private void filterMaterialByStor(KDBizPromptBox prmt) {
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(OrgType.Company);
        FilterInfo filter = new FilterInfo();
        String storageOrgUnitId = this.getStorageId();
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CompanyOrgUnit.id", (Object)companyInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("MaterialCompanyInfo.status", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("MaterialCompanyInfo.calculateType", (Object)2, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("MaterialInventory.status", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("MaterialCost.status", (Object)1, CompareType.EQUALS));
        EntityViewInfo newEvi = new EntityViewInfo();
        newEvi.setFilter(filter);
        prmt.getQueryAgent().resetRuntimeEntityView();
        prmt.setEntityViewInfo(newEvi);
    }

    private void filtExsitMaterial(SelectorEvent e) throws Exception {
        int selectRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        STDCostEstimateSchemeInfo info = (STDCostEstimateSchemeInfo)this.tblMain.getCell(selectRowIndex, Col_EstimateSchemeNumber).getValue();
        this.filterMaterialByStor(this.prmtMaterial);
        if (info == null) {
            return;
        }
        FilterInfo filterMaterial = new FilterInfo();
        String storageId = this.getStorageId();
        filterMaterial.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageId, CompareType.EQUALS));
        filterMaterial.getFilterItems().add(new FilterItemInfo("CompanyOrgUnit.id", (Object)this.currCompany.getId().toString(), CompareType.EQUALS));
        filterMaterial.getFilterItems().add(new FilterItemInfo("MaterialCompanyInfo.status", (Object)1, CompareType.EQUALS));
        filterMaterial.getFilterItems().add(new FilterItemInfo("MaterialInventory.status", (Object)1, CompareType.EQUALS));
        filterMaterial.getFilterItems().add(new FilterItemInfo("MaterialCost.status", (Object)1, CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterMaterial);
        this.prmtMaterial.getQueryAgent().resetRuntimeEntityView();
        this.prmtMaterial.setEntityViewInfo(view);
    }

    private void filterEstimateScheme() {
        FilterInfo filterScheme = new FilterInfo();
        String storageId = this.getStorageId();
        filterScheme.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageId, CompareType.EQUALS));
        filterScheme.getFilterItems().add(new FilterItemInfo("state", (Object)2, CompareType.NOTEQUALS));
        filterScheme.getFilterItems().add(new FilterItemInfo("schemeType", (Object)1, CompareType.EQUALS));
        EntityViewInfo newEvi = new EntityViewInfo();
        newEvi.setFilter(filterScheme);
        this.prmtEstimateScheme.getQueryAgent().resetRuntimeEntityView();
        this.prmtEstimateScheme.setEntityViewInfo(newEvi);
    }

    private void filtExsitEstimateScheme(SelectorEvent e) throws Exception {
        int selectRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        MaterialInfo info = (MaterialInfo)this.tblMain.getCell(selectRowIndex, COL_Material_Number).getValue();
        this.filterEstimateScheme();
        if (info == null) {
            return;
        }
        FilterInfo filterScheme = new FilterInfo();
        String storageId = this.getStorageId();
        filterScheme.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageId, CompareType.EQUALS));
        EntityViewInfo newEvi = new EntityViewInfo();
        newEvi.setFilter(filterScheme);
        this.prmtEstimateScheme.getQueryAgent().resetRuntimeEntityView();
        this.prmtEstimateScheme.setEntityViewInfo(newEvi);
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor test = super.getQueryExecutor(queryPK, viewInfo);
        return test;
    }
}

