/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.std.bill.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.CalculateTypeEnum;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ncm.common.NCMIFilterParam;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.std.basedata.STDCostEstimateSchemeInfo;
import com.kingdee.eas.ncm.std.bill.STDCostResourceTypeQtyFilterParam;
import com.kingdee.eas.ncm.std.bill.client.AbstractSTDCostResourceTypeQtyFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.util.List;

public class STDCostResourceTypeQtyFilterUI
extends AbstractSTDCostResourceTypeQtyFilterUI {
    private static final long serialVersionUID = 1444130799785233363L;
    private static final String STORAGE_ORG_UNIT_ID = "StorageOrgUnitId";
    private static final String ESTIMATE_SCHEME_NUMBERS = "EstimateSchemeNumbers";
    private static final String CALCULATE_TYPE = "CalculateType";
    private static final String MATERIAL_NUMBERS = "MaterialNumbers";
    CompanyOrgUnitInfo currCompany = null;
    PeriodInfo currPeriod = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    private void init() throws Exception {
        this.currCompany = SysContext.getSysContext().getCurrentFIUnit();
        this.currPeriod = NCMUtils.GetCurrentPeriod(null, (String)this.currCompany.getId().toString());
        this.companyBizPromptBox.setValue((Object)this.currCompany);
        this.companyBizPromptBox.setEnabled(false);
        this.filterStorageOrgBox();
        this.storageOrgBizPromptBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                boolean clear = false;
                if (!(eventObj.getNewValue() instanceof StorageOrgUnitInfo) || !(eventObj.getOldValue() instanceof StorageOrgUnitInfo)) {
                    clear = true;
                } else {
                    StorageOrgUnitInfo newOrg = (StorageOrgUnitInfo)eventObj.getNewValue();
                    StorageOrgUnitInfo oldOrg = (StorageOrgUnitInfo)eventObj.getOldValue();
                    if (!newOrg.getId().toString().equals(oldOrg.getId().toString())) {
                        clear = true;
                    }
                }
                if (clear) {
                    STDCostResourceTypeQtyFilterUI.this.schemeBizPromptBox.setValue(null);
                    STDCostResourceTypeQtyFilterUI.this.materialBizPromptBox.setValue(null);
                    try {
                        STDCostResourceTypeQtyFilterUI.this.filterSchemeNumberBox();
                        STDCostResourceTypeQtyFilterUI.this.filterMaterialBox();
                    }
                    catch (Exception exc) {
                        ExceptionHandler.handle((Throwable)exc);
                    }
                }
            }
        });
        this.filterSchemeNumberBox();
        this.schemeBizPromptBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                if (STDCostResourceTypeQtyFilterUI.this.storageOrgBizPromptBox.getValue() == null) {
                    MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"26_STDCostDataFilterUI"));
                    SysUtil.abort();
                }
                try {
                    STDCostResourceTypeQtyFilterUI.this.filterSchemeNumberBox();
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Throwable)ex);
                }
            }
        });
        this.filterMaterialBox();
        this.materialBizPromptBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                if (STDCostResourceTypeQtyFilterUI.this.storageOrgBizPromptBox.getValue() == null) {
                    MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"26_STDCostDataFilterUI"));
                    SysUtil.abort();
                }
                try {
                    STDCostResourceTypeQtyFilterUI.this.filterMaterialBox();
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Throwable)ex);
                }
            }
        });
    }

    public void clear() {
        super.clear();
        this.storageOrgBizPromptBox.setData(null);
        this.schemeBizPromptBox.setData(null);
        this.calcuTypeComboBox.setSelectedIndex(0);
        this.materialBizPromptBox.setData(null);
    }

    private void filterStorageOrgBox() throws Exception {
        BDCMClientUtils.filterStorageFromCompanyF7((KDBizPromptBox)this.storageOrgBizPromptBox, (String)"isBizUnit", (Object)1, (String)this.currCompany.getId().toString(), (String)"id");
    }

    private void filterSchemeNumberBox() throws Exception {
        EntityViewInfo view = null;
        view = this.schemeBizPromptBox.getEntityViewInfo() == null ? new EntityViewInfo() : this.schemeBizPromptBox.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (this.storageOrgBizPromptBox.getValue() != null) {
            String storageOrgUnitId = ((StorageOrgUnitInfo)this.storageOrgBizPromptBox.getValue()).getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitId, CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)this.currPeriod.getEndDate(), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("schemeType", (Object)1, CompareType.EQUALS));
        view.setFilter(filter);
        this.schemeBizPromptBox.getQueryAgent().resetRuntimeEntityView();
        this.schemeBizPromptBox.setEntityViewInfo(view);
    }

    private void filterMaterialBox() throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String companyOrgUnitID = this.currCompany.getId().toString();
        String storageOrgUnitID = null;
        storageOrgUnitID = this.storageOrgBizPromptBox.getValue() instanceof StorageOrgUnitInfo ? ((StorageOrgUnitInfo)this.storageOrgBizPromptBox.getValue()).getId().toString() : "####################";
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CompanyOrgUnit.id", (Object)companyOrgUnitID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("MaterialCompanyInfo.status", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("MaterialInventory.status", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("stdEstimateType.estimateType", (Object)2, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("MaterialCost.status", (Object)1));
        view.setFilter(filter);
        this.materialBizPromptBox.getQueryAgent().resetRuntimeEntityView();
        this.materialBizPromptBox.setEntityViewInfo(view);
    }

    protected NCMIFilterParam createNewFilterParam() {
        return new STDCostResourceTypeQtyFilterParam();
    }

    protected void storeBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof STDCostResourceTypeQtyFilterParam)) {
            return;
        }
        STDCostResourceTypeQtyFilterParam _filterParam = (STDCostResourceTypeQtyFilterParam)filterParam;
        super.putIdByKey(customerParams, (Object)_filterParam.getStorageOrgUnitInfo(), STORAGE_ORG_UNIT_ID);
        super.putIdByKey(customerParams, (Object)_filterParam.getEstimateSchemes(), ESTIMATE_SCHEME_NUMBERS);
        super.putIdByKey(customerParams, (Object)_filterParam.getMaterialInfos(), MATERIAL_NUMBERS);
        customerParams.addCustomerParam(CALCULATE_TYPE, String.valueOf(_filterParam.getCalculateTypeEnum().getValue()));
    }

    protected void storeFilterParam(NCMIFilterParam filterParam) {
        if (!(filterParam instanceof STDCostResourceTypeQtyFilterParam)) {
            return;
        }
        STDCostResourceTypeQtyFilterParam _filterParam = (STDCostResourceTypeQtyFilterParam)filterParam;
        if (this.storageOrgBizPromptBox.getData() instanceof StorageOrgUnitInfo) {
            _filterParam.setStorageOrgUnitInfo((StorageOrgUnitInfo)this.storageOrgBizPromptBox.getData());
        }
        STDCostEstimateSchemeInfo[] schemes = null;
        Object estimateSchemesObject = this.schemeBizPromptBox.getData();
        if (estimateSchemesObject instanceof STDCostEstimateSchemeInfo) {
            schemes = new STDCostEstimateSchemeInfo[]{(STDCostEstimateSchemeInfo)estimateSchemesObject};
        } else if (estimateSchemesObject instanceof Object[]) {
            schemes = new STDCostEstimateSchemeInfo[((Object[])estimateSchemesObject).length];
            System.arraycopy(estimateSchemesObject, 0, schemes, 0, ((Object[])estimateSchemesObject).length);
        }
        _filterParam.setEstimateSchemes(schemes);
        if (this.calcuTypeComboBox.getSelectedItem() instanceof CalculateTypeEnum) {
            _filterParam.setCalculateTypeEnum((CalculateTypeEnum)this.calcuTypeComboBox.getSelectedItem());
        }
        MaterialInfo[] materials = null;
        Object materialsObject = this.materialBizPromptBox.getData();
        if (materialsObject instanceof MaterialInfo) {
            materials = new MaterialInfo[]{(MaterialInfo)materialsObject};
        } else if (materialsObject instanceof Object[]) {
            materials = new MaterialInfo[((Object[])materialsObject).length];
            System.arraycopy(materialsObject, 0, materials, 0, ((Object[])materialsObject).length);
        }
        _filterParam.setMaterialInfos(materials);
    }

    protected void loadBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof STDCostResourceTypeQtyFilterParam)) {
            return;
        }
        STDCostResourceTypeQtyFilterParam _filterParam = (STDCostResourceTypeQtyFilterParam)filterParam;
        try {
            String storageOrgUnitId = customerParams.getCustomerParam(STORAGE_ORG_UNIT_ID);
            if (!StringUtils.isEmpty((String)storageOrgUnitId)) {
                StorageOrgUnitInfo storageOrgUnitInfo = new StorageOrgUnitInfo();
                storageOrgUnitInfo.setId(BOSUuid.read((String)storageOrgUnitId));
                _filterParam.setStorageOrgUnitInfo(storageOrgUnitInfo);
            } else {
                _filterParam.setStorageOrgUnitInfo(null);
            }
            List estimateSchemeNumbers = (List)this.getObject(this.decode(customerParams.getCustomerParam(ESTIMATE_SCHEME_NUMBERS)));
            if (estimateSchemeNumbers != null) {
                _filterParam.setEstimateSchemes(new STDCostEstimateSchemeInfo[estimateSchemeNumbers.size()]);
                String id = null;
                int in = estimateSchemeNumbers.size();
                for (int i = 0; i < in; ++i) {
                    id = (String)estimateSchemeNumbers.get(i);
                    if (StringUtils.isEmpty((String)id)) continue;
                    _filterParam.getEstimateSchemes()[i] = new STDCostEstimateSchemeInfo();
                    _filterParam.getEstimateSchemes()[i].setId(BOSUuid.read((String)id));
                }
            } else {
                _filterParam.setEstimateSchemes(null);
            }
            String calcuTypeString = customerParams.getCustomerParam(CALCULATE_TYPE);
            if (!StringUtils.isEmpty((String)calcuTypeString)) {
                _filterParam.setCalculateTypeEnum(CalculateTypeEnum.getEnum((int)Integer.valueOf(calcuTypeString)));
            } else {
                _filterParam.setCalculateTypeEnum(null);
            }
            List materialIds = (List)this.getObject(this.decode(customerParams.getCustomerParam(MATERIAL_NUMBERS)));
            if (materialIds != null) {
                _filterParam.setMaterialInfos(new MaterialInfo[materialIds.size()]);
                String id = null;
                int in = materialIds.size();
                for (int i = 0; i < in; ++i) {
                    id = (String)materialIds.get(i);
                    if (StringUtils.isEmpty((String)id)) continue;
                    _filterParam.getMaterialInfos()[i] = new MaterialInfo();
                    _filterParam.getMaterialInfos()[i].setId(BOSUuid.read((String)id));
                }
            } else {
                _filterParam.setMaterialInfos(null);
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    protected void loadFilterParam(NCMIFilterParam filterParam) {
        if (filterParam != null && filterParam instanceof STDCostResourceTypeQtyFilterParam) {
            STDCostResourceTypeQtyFilterParam _filterParam = (STDCostResourceTypeQtyFilterParam)filterParam;
            if (_filterParam.getStorageOrgUnitInfo() != null) {
                this.storageOrgBizPromptBox.setValue((Object)_filterParam.getStorageOrgUnitInfo());
            } else {
                this.storageOrgBizPromptBox.setValue(null);
            }
            if (_filterParam.getEstimateSchemes() != null) {
                this.schemeBizPromptBox.setValue((Object)_filterParam.getEstimateSchemes());
            } else {
                this.schemeBizPromptBox.setValue(null);
            }
            if (_filterParam.getCalculateTypeEnum() != null) {
                this.calcuTypeComboBox.setSelectedItem((Object)_filterParam.getCalculateTypeEnum());
            } else {
                this.calcuTypeComboBox.setSelectedItem(null);
            }
            if (_filterParam.getMaterialInfos() != null) {
                this.materialBizPromptBox.setValue((Object)_filterParam.getMaterialInfos());
            } else {
                this.materialBizPromptBox.setValue(null);
            }
        }
    }

    public boolean verify() {
        if (UIRuleUtil.isNull((Object)this.storageOrgBizPromptBox.getValue())) {
            this.storageOrgBizPromptBox.requestFocus();
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"27_STDCostDataFilterUI"));
            return false;
        }
        return true;
    }

    public FilterInfo getFilterInfo() {
        return super.getFilterInfo();
    }
}

