/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.perflog;

import com.kingdee.eas.perflog.IMonitorEvent;
import com.kingdee.eas.perflog.IMonitorListener;
import com.kingdee.eas.perflog.IPerfLogConfig;
import com.kingdee.eas.perflog.IPerfLogMBean;
import com.kingdee.eas.perflog.PerfBean;
import com.kingdee.eas.perflog.PerfExceptionLogger;
import com.kingdee.eas.perflog.PerfMonitorFactory;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractPerfLog
implements IMonitorListener,
IPerfLogMBean {
    private boolean isValid = false;
    private boolean islog = false;
    protected ThreadLocal<PerfBean> transaction = new ThreadLocal();
    private Set<String> monitorClassSet = new HashSet<String>();
    private boolean isFilterName = false;
    private Set<String> filterNameSet = new HashSet<String>();
    private boolean isSample = false;
    private double sampleThreshold = 0.1;
    private int sampleNum = 10;
    private ConcurrentHashMap<String, Integer> sampleMap;
    private long filterTimeThreshold = 1000L;
    private boolean isFilterEvent = false;
    private Set<String> filterEventSet = new HashSet<String>();
    private IPerfLogConfig config;

    @Override
    public void monitorEventEnd(IMonitorEvent event) {
    }

    @Override
    public void monitorEventPerformed(IMonitorEvent event) {
    }

    @Override
    public void monitorEventStart(IMonitorEvent event) {
    }

    @Override
    public void setValid(boolean valid) {
        if (this.isValid == valid) {
            return;
        }
        this.isValid = valid;
        if (valid) {
            try {
                Iterator<String> iter = this.monitorClassSet.iterator();
                while (iter.hasNext()) {
                    PerfMonitorFactory.addListener(iter.next(), this);
                }
            }
            catch (Exception ex) {
                PerfExceptionLogger.error(ex);
            }
        } else {
            Iterator<String> iter = this.monitorClassSet.iterator();
            while (iter.hasNext()) {
                PerfMonitorFactory.removeListener(iter.next(), this);
            }
            this.clearSampleMap();
        }
    }

    private void clearSampleMap() {
        if (this.sampleMap != null) {
            this.sampleMap.clear();
        }
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    protected String getStackTrace() {
        StringBuffer sb = new StringBuffer();
        StackTraceElement[] stackTraceVec = Thread.currentThread().getStackTrace();
        for (int i = 0; i < stackTraceVec.length; ++i) {
            sb.append("\n ");
            sb.append(stackTraceVec[i]);
        }
        sb.append("\n ");
        return sb.toString();
    }

    protected void startTransaction(PerfBean transact) {
        PerfBean apt = transact;
        if (this.isFilterName && this.filterNameSet.contains(apt.name)) {
            return;
        }
        if (!this.isOutputBySample(apt.name)) {
            return;
        }
        apt.startTime = new Timestamp(System.currentTimeMillis());
        apt.thread = Thread.currentThread().getName();
        this.transaction.set(apt);
    }

    protected void endTransaction() {
        PerfBean apt = this.transaction.get();
        if (apt == null) {
            return;
        }
        this.transaction.remove();
        apt.timespan = System.currentTimeMillis() - apt.startTime.getTime();
        apt.isFilter = this.filterTimeThreshold > 0L && apt.timespan < this.filterTimeThreshold;
    }

    private boolean isOutputBySample(String name) {
        boolean isOutput = true;
        if (this.isSample) {
            Integer counter = this.sampleMap.get(name);
            if (counter == null) {
                counter = this.sampleNum;
                this.sampleMap.put(name, counter);
                return true;
            }
            Integer n = counter;
            Integer n2 = counter = Integer.valueOf(counter - 1);
            if (counter > 0) {
                isOutput = false;
            } else {
                isOutput = true;
                counter = this.sampleNum;
            }
            this.sampleMap.put(name, counter);
        }
        return isOutput;
    }

    @Override
    public boolean isFilterName() {
        return this.isFilterName;
    }

    @Override
    public void setFilterName(boolean filterName) {
        this.isFilterName = filterName;
    }

    @Override
    public String getFilterNameSet() {
        StringBuffer sb = new StringBuffer();
        Iterator<String> iter = this.filterNameSet.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            sb.append(";");
        }
        return sb.toString();
    }

    @Override
    public void setFilterNameSet(String nameSet) {
        this.filterNameSet.clear();
        StringTokenizer token = new StringTokenizer(nameSet, ";");
        while (token.hasMoreTokens()) {
            this.filterNameSet.add(token.nextToken());
        }
    }

    public boolean isSample() {
        return this.isSample;
    }

    public void setSample(boolean isSample) {
        this.clearSampleMap();
        this.isSample = isSample;
    }

    @Override
    public double getSampleThreshold() {
        return this.sampleThreshold;
    }

    @Override
    public void setSampleThreshold(double sampleThreshold) {
        this.clearSampleMap();
        this.sampleThreshold = sampleThreshold;
        this.sampleNum = (int)(1.0 / sampleThreshold);
    }

    @Override
    public long getFilterTimeThreshold() {
        return this.filterTimeThreshold;
    }

    @Override
    public void setFilterTimeThreshold(long filterTimeThreshold) {
        this.filterTimeThreshold = filterTimeThreshold;
    }

    @Override
    public boolean isFilterEvent() {
        return this.isFilterEvent;
    }

    @Override
    public void setFilterEvent(boolean filterEvent) {
        this.isFilterEvent = filterEvent;
    }

    @Override
    public String getFilterEventSet() {
        StringBuffer sb = new StringBuffer();
        Iterator<String> iter = this.filterEventSet.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            sb.append(";");
        }
        return sb.toString();
    }

    @Override
    public void setFilterEventSet(String eventSet) {
        this.filterEventSet.clear();
        StringTokenizer token = new StringTokenizer(eventSet, ";");
        while (token.hasMoreTokens()) {
            this.filterEventSet.add(token.nextToken());
        }
    }

    @Override
    public String getMonitorSet() {
        StringBuffer sb = new StringBuffer();
        for (String monitorClass : this.monitorClassSet) {
            String monitorName = this.config.getNameByClass(monitorClass);
            if (monitorName == null || monitorName.trim().length() <= 0) continue;
            sb.append(monitorName);
            sb.append(";");
        }
        return sb.toString();
    }

    @Override
    public void setMonitorSet(String nameSet) {
        HashSet<String> tmpSet = new HashSet<String>();
        StringTokenizer token = new StringTokenizer(nameSet, ";");
        while (token.hasMoreTokens()) {
            String monitorName = token.nextToken();
            String monitorClass = this.config.getClassByName(monitorName);
            if (monitorClass == null || monitorClass.trim().length() <= 0) continue;
            tmpSet.add(monitorClass);
        }
        this.monitorClassSet = tmpSet;
        if (!this.isValid) {
            return;
        }
        for (String monitorClass : this.monitorClassSet) {
            if (tmpSet.contains(monitorClass)) continue;
            PerfMonitorFactory.removeListener(monitorClass, this);
        }
        for (String monitorClass : tmpSet) {
            if (this.monitorClassSet.contains(monitorClass)) continue;
            PerfMonitorFactory.addListener(monitorClass, this);
        }
    }

    public IPerfLogConfig getConfig() {
        return this.config;
    }

    public void setConfig(IPerfLogConfig config) {
        this.config = config;
    }

    @Override
    public boolean isLog() {
        return this.islog;
    }

    @Override
    public void setLog(boolean log) {
        this.islog = log;
    }
}

