/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.perflog.client;

import com.kingdee.eas.perflog.IPerfLogMBean;
import com.kingdee.eas.perflog.PerfExceptionLogger;
import com.kingdee.eas.perflog.client.PerfLogConfig;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class PerfLogFactory {
    private static boolean isInit = false;
    private static Map<String, IPerfLogMBean> logMap = new HashMap<String, IPerfLogMBean>();
    private static List<ObjectName> beanList = new ArrayList<ObjectName>();

    public static synchronized void init() {
        if (PerfLogFactory.getJavaVersion() < 1.5) {
            PerfExceptionLogger.error(new Exception("java version < 1.5!"));
            return;
        }
        if (isInit) {
            return;
        }
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        Iterator<String> iter = PerfLogConfig.getInstance().LogMap.keySet().iterator();
        while (iter.hasNext()) {
            try {
                String logName = iter.next();
                String className = PerfLogConfig.getInstance().LogMap.get(logName);
                if (className == null) continue;
                Class<?> logClass = Class.forName(className);
                IPerfLogMBean logInstance = (IPerfLogMBean)logClass.newInstance();
                logMap.put(logName, logInstance);
                logInstance.setValid(false);
                Class<?> mbeanClass = null;
                try {
                    mbeanClass = Class.forName(className + "MBean");
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (mbeanClass == null || !mbeanClass.isAssignableFrom(logClass)) continue;
                ObjectName mbeanName = new ObjectName("perflog:type=log,name=" + logName);
                if (!server.isRegistered(mbeanName)) {
                    server.registerMBean(logInstance, mbeanName);
                }
                beanList.add(mbeanName);
            }
            catch (Exception ex) {
                PerfExceptionLogger.error(ex);
            }
        }
        isInit = true;
    }

    public static synchronized void destroy() {
        if (PerfLogFactory.getJavaVersion() < 1.5) {
            PerfExceptionLogger.error(new Exception("java version < 1.5!"));
            return;
        }
        if (!isInit) {
            return;
        }
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        for (ObjectName mbeanName : beanList) {
            if (mbeanName == null) continue;
            try {
                if (!server.isRegistered(mbeanName)) continue;
                server.unregisterMBean(mbeanName);
            }
            catch (Exception ex) {
                PerfExceptionLogger.error(ex);
            }
        }
        isInit = false;
    }

    private static double getJavaVersion() {
        double re = 0.0;
        String tmpStr = System.getProperty("java.version");
        if (tmpStr != null && tmpStr.length() >= 3) {
            tmpStr = tmpStr.substring(0, 3);
            re = Double.parseDouble(tmpStr);
        }
        return re;
    }
}

