/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.cache;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.framework.cache.MultiParamKey;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QMBatchExecuteParam
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final Class[] paramTypes;
    private final List paramValues;
    private final String methodName;
    private final BOSObjectType bosType;
    private final String className;
    private final Class model;
    private transient Object result;
    private boolean isEnable = true;

    public Class getModel() {
        return this.model;
    }

    public QMBatchExecuteParam(BOSObjectType bosType, Class model, String methodName, Class[] paramTypes) {
        this.className = null;
        this.bosType = bosType;
        this.model = model;
        this.methodName = methodName;
        this.paramTypes = paramTypes;
        this.paramValues = new ArrayList(paramTypes.length);
    }

    public QMBatchExecuteParam(BOSObjectType bosType, Class model, String methodName, Class[] parameterTypes, Object[] arrParamValue) {
        this(bosType, model, methodName, parameterTypes);
        for (int i = 0; i < arrParamValue.length; ++i) {
            this.add(arrParamValue[i]);
        }
    }

    public QMBatchExecuteParam(String className, Class model, String methodName, Class[] paramTypes, Object[] arrParamValue) {
        this(className, model, methodName, paramTypes);
        for (int i = 0; i < arrParamValue.length; ++i) {
            this.add(arrParamValue[i]);
        }
    }

    public QMBatchExecuteParam(String className, Class model, String methodName, Class[] paramTypes) {
        this.className = className;
        this.bosType = null;
        this.model = model;
        this.methodName = methodName;
        this.paramTypes = paramTypes;
        this.paramValues = new ArrayList(paramTypes.length);
    }

    public String getMethodName() {
        return this.methodName;
    }

    private void sizeCheck() {
        if (this.paramValues.size() == this.paramTypes.length) {
            throw new IndexOutOfBoundsException("index:" + this.paramValues.size());
        }
    }

    private void typeCheck(int index, Object paramValue) {
        if (this.paramTypes[index].isPrimitive()) {
            if (paramValue == null) {
                return;
            }
            return;
        }
        if (paramValue == null) {
            if (this.paramTypes[index].isPrimitive()) {
                throw new IllegalArgumentException("error primitive parameter type: index:<" + index + ">, expected:<" + this.paramTypes[index].getName() + "> but was:<null>");
            }
            return;
        }
        if (!this.paramTypes[index].isInstance(paramValue)) {
            throw new IllegalArgumentException("error parameter type: index:<" + index + ">, expected:<" + this.paramTypes[index].getName() + "> but was:<" + paramValue.getClass().getName() + ">");
        }
    }

    public QMBatchExecuteParam add(Object paramValue) {
        this.sizeCheck();
        this.typeCheck(this.paramValues.size(), paramValue);
        this.paramValues.add(paramValue);
        return this;
    }

    public QMBatchExecuteParam add(int index, Object paramValue) {
        this.sizeCheck();
        this.typeCheck(index, paramValue);
        this.paramValues.add(index, paramValue);
        return this;
    }

    public Object get(int index) {
        return this.paramValues.get(index);
    }

    public Object set(int index, Object paramValue) {
        this.typeCheck(index, paramValue);
        return this.paramValues.set(index, paramValue);
    }

    public Object[] toArray() {
        return this.paramValues.toArray();
    }

    public Class[] getParamTypes() {
        return this.paramTypes;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("bosType:" + this.bosType);
        sb.append(" model:" + this.model);
        sb.append(" methodName:" + this.methodName);
        sb.append(" paramTypes:[");
        for (int i = 0; i < this.paramTypes.length; ++i) {
            sb.append(this.paramTypes[i] + ",");
        }
        sb.append("]");
        sb.append(" paramValues:");
        sb.append(this.paramValues);
        return sb.toString();
    }

    public Object getResult() {
        return this.result;
    }

    public void invokeLocale(Context ctx) throws IllegalArgumentException, IllegalAccessException, SecurityException, NoSuchMethodException, BOSException, EASBizException {
        block7: {
            IBOSObject boso = this.getLocalFactory(ctx);
            Method method = boso.getClass().getMethod(this.methodName, this.paramTypes);
            Object[] args = this.paramValues.toArray();
            try {
                if (args != null && args.length > 0) {
                    for (int i = 0; i < args.length; ++i) {
                        QMBatchExecuteParam a1;
                        Object a = args[i];
                        if (!(a instanceof QMBatchExecuteParam) || (a1 = (QMBatchExecuteParam)a).getResult() != null) continue;
                        a1.invokeLocale(ctx);
                        args[i] = a1.getResult();
                    }
                }
                this.result = method.invoke((Object)boso, args);
            }
            catch (InvocationTargetException ex) {
                if (ex.getTargetException() == null) break block7;
                if (ex.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)ex.getTargetException();
                }
                if (ex.getTargetException() instanceof BOSException) {
                    throw (BOSException)ex.getTargetException();
                }
                if (ex.getTargetException() instanceof EASBizException) {
                    throw (EASBizException)ex.getTargetException();
                }
                throw new BOSException(ex.getTargetException());
            }
        }
    }

    public void invokeRemote(Context ctx) throws BOSException, EASBizException, IllegalArgumentException, IllegalAccessException, SecurityException, NoSuchMethodException {
        block7: {
            IBOSObject boso = this.getRemoteFactory(ctx);
            Method method = boso.getClass().getMethod(this.methodName, this.paramTypes);
            Object[] args = this.paramValues.toArray();
            try {
                if (args != null && args.length > 0) {
                    for (int i = 0; i < args.length; ++i) {
                        QMBatchExecuteParam a1;
                        Object a = args[i];
                        if (!(a instanceof QMBatchExecuteParam) || (a1 = (QMBatchExecuteParam)a).getResult() != null) continue;
                        a1.invokeRemote(ctx);
                        args[i] = a1.getResult();
                    }
                }
                this.result = method.invoke((Object)boso, args);
            }
            catch (InvocationTargetException ex) {
                if (ex.getTargetException() == null) break block7;
                if (ex.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)ex.getTargetException();
                }
                if (ex.getTargetException() instanceof BOSException) {
                    throw (BOSException)ex.getTargetException();
                }
                if (ex.getTargetException() instanceof EASBizException) {
                    throw (EASBizException)ex.getTargetException();
                }
                throw new BOSException(ex.getTargetException());
            }
        }
    }

    private IBOSObject getLocalFactory(Context ctx) throws BOSException {
        IBOSObject boso = null;
        boso = this.bosType == null ? BOSObjectFactory.createBOSObject((Context)ctx, (String)this.className) : BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)this.bosType);
        return boso;
    }

    private IBOSObject getRemoteFactory(Context ctx) throws BOSException {
        IBOSObject boso = null;
        boso = this.bosType == null ? BOSObjectFactory.createRemoteBOSObjectWithObjectContext((String)this.className, (Class)this.model, (Context)ctx) : BOSObjectFactory.createRemoteBOSObjectWithObjectContext((BOSObjectType)this.bosType, (Class)this.model, (Context)ctx);
        return boso;
    }

    public BOSObjectType getBosType() {
        return this.bosType;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public Map getResponse() {
        HashMap<String, Object> response = new HashMap<String, Object>();
        String key = this.getActionCacheKey();
        response.put(key, this.getResult());
        return response;
    }

    public String getActionCacheKey() {
        String key = MultiParamKey.create((String)(this.getModel().getName() + "#" + this.getMethodName()), (Object[])this.paramValues.toArray()).toString();
        return key;
    }

    public void setEnable(boolean b) {
        this.isEnable = b;
    }

    public boolean isEnable() {
        return this.isEnable;
    }
}

