/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.CustomerParams;
import com.kingdee.eas.base.permission.MutiOrgPermParam;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.qm.common.QMCommonFacadeFactory;
import com.kingdee.eas.qm.common.client.AbstractQMCoreBaseFilterUI;
import com.kingdee.eas.qm.common.client.action.IUIContextManager;
import com.kingdee.eas.qm.common.client.action.UIContextManager;
import com.kingdee.eas.qm.common.client.botp.IBOTPCreateFromParameter;
import com.kingdee.eas.qm.common.client.util.IQMUIComponentCreator;
import com.kingdee.eas.qm.common.client.util.QMClientUtils;
import com.kingdee.eas.qm.common.client.util.QMUICompentCreatorFactory;
import com.kingdee.eas.qm.common.client.verify.UIControlEmptyVerifyItem;
import com.kingdee.eas.qm.common.filter.IQueryFilterManager;
import com.kingdee.eas.qm.common.filter.QueryFilterManager;
import com.kingdee.eas.qm.common.filter.SingleFilterElement;
import com.kingdee.eas.qm.common.util.QMEqualsUtils;
import com.kingdee.eas.qm.common.util.backup.QMSortUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public abstract class QMCoreBaseFilterUI
extends AbstractQMCoreBaseFilterUI {
    private static final String resourceDir = "com.kingdee.eas.qm.common.COMMONAutoGenerateResource";
    private static final Logger logger = CoreUIObject.getLogger(QMCoreBaseFilterUI.class);
    private IQueryFilterManager manager = null;
    private OrgUnitInfo[] mainOrgs = null;
    private int idxDefaultMainOrg = -1;
    private IUIContextManager uiManager = null;
    private OrgUnitCollection authorizedMainOrgs = null;
    private Map uiContextManagers = new HashMap();
    private String viewPermItemName;
    private boolean isLoading = false;
    private boolean isSupportMultiOrgs = true;
    private Context mainOrgContext = null;
    private IQMUIComponentCreator creator = null;

    protected IUIContextManager initUIContextManager(String key) {
        IUIContextManager uiContextManager = (IUIContextManager)this.uiContextManagers.get(key);
        if (uiContextManager == null) {
            uiContextManager = new UIContextManager((CoreUIObject)this);
            uiContextManager.setType(key);
            this.uiContextManagers.put(key, uiContextManager);
            this.registerUIManager(uiContextManager);
        }
        return uiContextManager;
    }

    public IUIContextManager getUIContextManager(String key) {
        IUIContextManager uiContextManager = (IUIContextManager)this.uiContextManagers.get(key);
        if (uiContextManager == null) {
            uiContextManager = this.initUIContextManager(key);
        }
        return uiContextManager;
    }

    private void initQueryFilterManager() {
        if (this.manager == null) {
            this.manager = new QueryFilterManager();
            this.registerQueryFilterManager(this.manager);
        }
    }

    public void registerQueryFilterManager(IQueryFilterManager manager) {
        String MainBizOrgField = this.getMainBizOrgField();
        SingleFilterElement mainOrgElement = new SingleFilterElement(MainBizOrgField, (Component)this.getMainBizOrg());
        OrgUnitInfo defaultMainBizOrg = this.getDefaultMainBizOrg();
        if (defaultMainBizOrg != null) {
            mainOrgElement.setDefaultValue(defaultMainBizOrg.getId().toString());
        }
        this.getFilterManager().getRootElement().getVerifyManager().addVerifyItem(new UIControlEmptyVerifyItem((CoreUIObject)this));
        this.getFilterManager().getRootElement().add(mainOrgElement);
        this.getFilterManager().setMainOrgElement(mainOrgElement);
    }

    public abstract String getMainBizOrgField();

    public void registerUIManager(IUIContextManager manager) {
        if (manager.getType().equals("MainOrgUnit")) {
            KDBizPromptBox bizOrgUnitBox = this.getMainBizOrgF7();
            OrgType orgType = this.getMainBizOrgType();
            manager.registerMainBizOrgF7(bizOrgUnitBox, orgType, this.getViewPermItemName(), this.isSupportMultiOrgs);
            PreChangeListener prmtBizOrgPreChangeListener = this.getMainBizOrgPreChangeListener();
            bizOrgUnitBox.addPreChangeListener(prmtBizOrgPreChangeListener);
        }
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.getMainBizOrg();
    }

    public String getViewPermItemName() {
        return this.viewPermItemName;
    }

    public void setViewPermItemName(String name) {
        this.viewPermItemName = name;
    }

    public void initUIContextManager() {
        this.initUIContextManager("MainOrgUnit");
    }

    public void initUIContextManager(JComponent comp, String uictxReqOrgUnit) {
        IUIContextManager managers = this.initUIContextManager(uictxReqOrgUnit);
        managers.addChangeListener(comp);
    }

    public void onLoad() throws Exception {
        if (this.uiContextManagers.size() == 0) {
            this.initUIContextManager();
            this.initQueryFilterManager();
        }
        super.onLoad();
        this.clear();
    }

    public OrgType getMainBizOrgType() {
        return OrgType.Quality;
    }

    public IQueryFilterManager getFilterManager() {
        return this.manager;
    }

    public FilterInfo getFilterInfo() {
        return this.manager.getFilterInfo();
    }

    public boolean isLoading() {
        return this.isLoading;
    }

    public void setLoading(boolean isLoading) {
        this.isLoading = isLoading;
    }

    public void clear() {
        this.setLoading(true);
        try {
            this.manager.clearAll();
            this.setDefaultValue();
        }
        finally {
            this.setLoading(false);
        }
    }

    public OrgUnitInfo getMainOrgInfo() {
        if (this.getMainOrgContext() == null) {
            return (OrgUnitInfo)super.getUIContext().get(this.getMainBizOrgType());
        }
        return (OrgUnitInfo)this.getMainOrgContext().get((Object)this.getMainBizOrgType());
    }

    public void setIsSupportMultiOrgs(boolean value) {
        this.isSupportMultiOrgs = value;
    }

    public PreChangeListener getMainBizOrgPreChangeListener() {
        PreChangeListener prmtBizOrgPreChangeListener = new PreChangeListener(){

            public void preChange(PreChangeEvent arg0) {
                if (QMCoreBaseFilterUI.this.isLoading()) {
                    return;
                }
                if (arg0.getData() != null && QMEqualsUtils.equals(arg0.getData(), arg0.getOldData())) {
                    return;
                }
                if (arg0.getData() == null && arg0.getOldData() != null) {
                    OrgType mainOrgType = QMCoreBaseFilterUI.this.getMainBizOrgType();
                    String msg = EASResource.getString((String)QMCoreBaseFilterUI.resourceDir, (String)"15_QMCoreBaseFilterUI");
                    MessageFormat mf = new MessageFormat(msg);
                    MsgBox.showWarning((String)mf.format(new String[]{mainOrgType.toString()}));
                    arg0.setResult(0);
                    return;
                }
            }
        };
        return prmtBizOrgPreChangeListener;
    }

    public abstract KDBizPromptBox getMainBizOrg();

    public void initMainBizOrg() {
        if (this.getMainBizOrgF7() != null) {
            this.getMainBizOrgF7().addDataChangeListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    Object value = QMCoreBaseFilterUI.this.getMainBizOrg().getValue();
                    if (value == null) {
                        return;
                    }
                    if (QMCoreBaseFilterUI.this.isSupportMultiOrgs) {
                        Object[] data = value instanceof Object[] ? (Object[])value : new Object[]{value};
                        OrgUnitInfo[] orgs = new OrgUnitInfo[data.length];
                        System.arraycopy(data, 0, orgs, 0, orgs.length);
                        OrgUnitInfo oldOrg = QMCoreBaseFilterUI.this.getMainOrgInfo();
                        if (orgs != null && orgs.length > 0 && orgs[0].getId() != null) {
                            String oldOrgId = "";
                            if (oldOrg != null && oldOrg.getId() != null) {
                                oldOrgId = oldOrg.getId().toString();
                            }
                            if (!orgs[0].getId().toString().equals(oldOrgId)) {
                                QMCoreBaseFilterUI.this.initUIMainOrgContext(orgs[0].getId().toString());
                            }
                        }
                        QMCoreBaseFilterUI.this.afterMainOrgChanged(oldOrg, orgs);
                    } else {
                        OrgUnitInfo org = (OrgUnitInfo)value;
                        OrgUnitInfo oldOrg = QMCoreBaseFilterUI.this.getMainOrgInfo();
                        if (org != null && org.getId() != null) {
                            String oldOrgId = "";
                            if (oldOrg != null && oldOrg.getId() != null) {
                                oldOrgId = oldOrg.getId().toString();
                            }
                            if (!org.getId().toString().equals(oldOrgId)) {
                                QMCoreBaseFilterUI.this.initUIMainOrgContext(org.getId().toString());
                            }
                        }
                        QMCoreBaseFilterUI.this.afterMainOrgChanged(oldOrg, org);
                    }
                }
            });
        }
    }

    protected void afterMainOrgChanged(OrgUnitInfo oldOrg, OrgUnitInfo[] orgs) {
        if (orgs.length > 0 && orgs[0].getId() != null) {
            ArrayList<String> coll = new ArrayList<String>();
            for (int i = 0; i < orgs.length; ++i) {
                coll.add(orgs[i].getId().toString());
            }
            MutiOrgPermParam mutiOrgParam = new MutiOrgPermParam();
            mutiOrgParam.setOrgType(this.getMainBizOrgType());
            mutiOrgParam.setOrgIdList(coll);
            this.getMainOrgContext().put((Object)"MUTI_ORG_INFO", (Object)mutiOrgParam);
            Context mainOrgContext2 = this.getMainOrgContext();
            this.getUIContextManager("MainOrgUnit").changeUIContext(mainOrgContext2);
        }
    }

    protected void afterMainOrgChanged(OrgUnitInfo oldOrg, OrgUnitInfo org) {
        if (org != null && org.getId() != null) {
            Context mainOrgContext2 = this.getMainOrgContext();
            this.getUIContextManager("MainOrgUnit").changeUIContext(mainOrgContext2);
        }
    }

    protected final void initUIMainOrgContext(String orgID) {
        if (orgID == null) {
            return;
        }
        try {
            if (this.mainOrgContext == null) {
                this.mainOrgContext = new Context();
            }
            FrameWorkUtils.switchOrg((Context)this.mainOrgContext, (String)orgID);
            if (FrameWorkUtils.getCurrentOrgUnit((Context)this.mainOrgContext, (OrgType)this.getMainBizOrgType()) != null) {
                this.getUIContext().put(this.getMainBizOrgType(), FrameWorkUtils.getCurrentOrgUnit((Context)this.mainOrgContext, (OrgType)this.getMainBizOrgType()));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public void setBOTPParameter(IBOTPCreateFromParameter botpParameter) {
        if (botpParameter != null) {
            this.setAuthorizedMainOrgs(botpParameter.getOrgUnitCollection());
        }
    }

    public com.kingdee.eas.base.commonquery.client.CustomerParams getCustomerParams() {
        return com.kingdee.eas.base.commonquery.client.CustomerParams.castToClientCustomerParams((CustomerParams)this.getCustomerParams2());
    }

    public CustomerParams getCustomerParams2() {
        CustomerParams customerParams = this.manager.getCustomerParams();
        return customerParams;
    }

    public void setCustomerParams(com.kingdee.eas.base.commonquery.client.CustomerParams cp) {
        if (cp == null) {
            return;
        }
        this.setCustomerParams2(cp.castToCommonCustomerParams());
    }

    public void setCustomerParams2(CustomerParams cp) {
        this.manager.clearAll();
        this.manager.setCustomerParams(cp);
    }

    public boolean verify() {
        boolean flag = false;
        try {
            flag = this.manager.verify();
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return flag;
    }

    protected void setDefaultValue() {
    }

    public final OrgUnitInfo getDefaultMainBizOrg() {
        OrgUnitInfo currentMainOrg;
        if (this.idxDefaultMainOrg > -1) {
            return this.mainOrgs[this.idxDefaultMainOrg];
        }
        if (this.mainOrgs == null) {
            this.gainAuthMainBizOrgs();
        }
        if ((currentMainOrg = SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType())) != null && this.mainOrgs.length > 0) {
            for (int i = 0; i < this.mainOrgs.length; ++i) {
                if (!currentMainOrg.getId().toString().equals(this.mainOrgs[i].getId().toString())) continue;
                this.idxDefaultMainOrg = i;
                return currentMainOrg;
            }
        }
        if (this.mainOrgs.length > 0) {
            this.idxDefaultMainOrg = 0;
            return this.mainOrgs[0];
        }
        return null;
    }

    private void gainAuthMainBizOrgs() {
        if (this.mainOrgs == null) {
            try {
                if (this.authorizedMainOrgs == null) {
                    OrgType mainBizOrgType = this.getMainBizOrgType();
                    String viewPermission = this.getViewPermItemName();
                    this.mainOrgs = this.isBaseDataFilterUI() ? QMCommonFacadeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext()).getAuthorizedOrgUnits(mainBizOrgType, viewPermission) : QMCommonFacadeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext()).getAuthorizedBizOrgUnits(mainBizOrgType, viewPermission);
                } else {
                    int size = this.authorizedMainOrgs.size();
                    this.mainOrgs = new OrgUnitInfo[size];
                    if (size > 0) {
                        Object[] objects = this.authorizedMainOrgs.toArray();
                        System.arraycopy(objects, 0, this.mainOrgs, 0, size);
                    }
                }
                if (this.mainOrgs == null) {
                    this.mainOrgs = new OrgUnitInfo[0];
                }
                if (this.mainOrgs.length > 0) {
                    this.mainOrgs = (OrgUnitInfo[])QMSortUtils.sortDataByNumber((DataBaseInfo[])this.mainOrgs, true);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    public Context getMainOrgContext() {
        return this.mainOrgContext;
    }

    public void setAuthorizedMainOrgs(OrgUnitCollection authorizedMainOrgs) {
        this.authorizedMainOrgs = authorizedMainOrgs;
    }

    public Component getComponentByName(String name) {
        return QMClientUtils.getComponentByName((CoreUIObject)this, name);
    }

    public IQMUIComponentCreator getUICompentCreatorFacotry() {
        if (this.creator == null) {
            this.creator = QMUICompentCreatorFactory.getInstance();
        }
        return this.creator;
    }

    protected boolean isBaseDataFilterUI() {
        return false;
    }
}

