/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.UIFocusTraversalPolicy;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.framework.CUIDGetterFacadeFactory;
import com.kingdee.eas.basedata.framework.ICUIDGetterFacade;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.config.IConfigController;
import com.kingdee.eas.qm.common.DBCheckedStatusEnum;
import com.kingdee.eas.qm.common.IQMCodingRuleManageFacade;
import com.kingdee.eas.qm.common.IQMCommonFacade;
import com.kingdee.eas.qm.common.IQMCoreDataBase;
import com.kingdee.eas.qm.common.QMCoreDataBaseInfo;
import com.kingdee.eas.qm.common.QMDataBaseDInfo;
import com.kingdee.eas.qm.common.cache.IQMCacheManager;
import com.kingdee.eas.qm.common.cache.QMBatchExecuteParam;
import com.kingdee.eas.qm.common.cache.QMCacheManager;
import com.kingdee.eas.qm.common.client.AbstractQMCoreEditUI;
import com.kingdee.eas.qm.common.client.action.IUIContextManager;
import com.kingdee.eas.qm.common.client.action.UIContextManager;
import com.kingdee.eas.qm.common.client.ccstrategy.IQMClientControlStrategy;
import com.kingdee.eas.qm.common.client.ccstrategy.IQMControlModeUIProxy;
import com.kingdee.eas.qm.common.client.ccstrategy.QMClientControlStrategy;
import com.kingdee.eas.qm.common.client.ccstrategy.QMClientControlStrategyFactory;
import com.kingdee.eas.qm.common.client.util.IQMUIComponentCreator;
import com.kingdee.eas.qm.common.client.util.QMClientUtils;
import com.kingdee.eas.qm.common.client.util.QMUICompentCreatorFactory;
import com.kingdee.eas.qm.common.client.verify.DataBaseAuditVerifyItem;
import com.kingdee.eas.qm.common.client.verify.UIControlEmptyVerifyItem;
import com.kingdee.eas.qm.common.codingrule.ClientCodingRuleStrategy;
import com.kingdee.eas.qm.common.util.backup.FMClientHelper;
import com.kingdee.eas.qm.common.util.backup.QMPermissionUtils;
import com.kingdee.eas.qm.common.verify.IVerifyManager;
import com.kingdee.eas.qm.common.verify.VerifyManager;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FocusTraversalPolicy;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class QMCoreEditUI
extends AbstractQMCoreEditUI
implements IQMControlModeUIProxy {
    private static final long serialVersionUID = 9037145471623942524L;
    private static final Logger logger = CoreUIObject.getLogger(QMCoreEditUI.class);
    protected IVerifyManager verifyManager = null;
    private String controlType = null;
    private IQMClientControlStrategy ccStrategy = null;
    private ClientCodingRuleStrategy codingRuleStrategy = null;
    private IUIContextManager uiContextManager = null;
    private IQMUIComponentCreator creator = null;
    private IQMCacheManager cacheManager;

    public QMCoreEditUI() throws Exception {
        List list = this.getInitCache();
        this.getCacheManager().batchInvoke(null, list.toArray(new QMBatchExecuteParam[list.size()]));
    }

    @Override
    public BOSObjectType getBizObjectType() {
        try {
            BOSObjectType currentBOSObjectType = this.getBizType();
            return currentBOSObjectType;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public ICoreBase getBizInterface1() throws Exception {
        return this.getBizInterface();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_auditing"));
        this.actionUnAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.actionBlocked.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_freeze"));
        this.actionUnBlocked.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_ffreeze"));
        this.actionAddLine.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_addline"));
        this.actionInsertLine.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_insert"));
        this.actionCopyLine.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_copyline"));
        this.actionRemoveLine.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    @Override
    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
        QMClientUtils.updateUITitle((CoreUIObject)this, this.resHelper.getString("this.title"));
    }

    public IVerifyManager getVerifyManager() {
        if (this.verifyManager == null) {
            this.verifyManager = new VerifyManager();
        }
        return this.verifyManager;
    }

    protected IObjectValue createNewData() {
        IObjectValue data = this.doCreateNewData(null);
        return data;
    }

    public void onLoad() throws Exception {
        List list = this.getOnloadCache();
        this.getCacheManager().batchInvoke(null, list.toArray(new QMBatchExecuteParam[list.size()]));
        this.initStrategy();
        this.initUIContextManager();
        this.dataBinder.addPropertyChangeListener("loadLine", this.getDataBinderPropertyChangeListener());
        super.onLoad();
        UIControlEmptyVerifyItem verifyItem = new UIControlEmptyVerifyItem((CoreUIObject)this);
        this.getVerifyManager().addVerifyItem(verifyItem);
        DataBaseAuditVerifyItem verifyItem2 = new DataBaseAuditVerifyItem(this);
        this.getVerifyManager().addVerifyItem(verifyItem2);
    }

    private PropertyChangeListener getDataBinderPropertyChangeListener() {
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                KDTable tbl = (KDTable)evt.getSource();
                Integer rowidx = (Integer)evt.getNewValue();
                IRow row = tbl.getRow(rowidx.intValue());
                QMCoreEditUI.this.tblDetail_propertyChange(tbl, row);
            }
        };
        return listener;
    }

    public void tblDetail_propertyChange(KDTable tbl, IRow row) {
    }

    protected Class getEntityModel() {
        return null;
    }

    public String getControlType() {
        if (this.controlType == null) {
            this.controlType = "";
            try {
                if (this.getBizInterface() == null) {
                    return this.controlType;
                }
                EntityObjectInfo eoi = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(this.getBizType());
                if (eoi.containsExtendedPropertyKey("controlType")) {
                    this.controlType = eoi.getExtendedProperty("controlType");
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
                SysUtil.abort();
            }
        }
        return this.controlType;
    }

    protected IQMClientControlStrategy getClientControlStrategy() {
        if (this.ccStrategy != null) {
            return this.ccStrategy;
        }
        String controlType = this.getControlType();
        this.ccStrategy = QMClientControlStrategyFactory.create(controlType, this);
        return this.ccStrategy;
    }

    private void initStrategy() {
        if (this.ccStrategy == null) {
            this.ccStrategy = this.getClientControlStrategy();
        }
    }

    private void checkPermission(String action, String cuID) throws Exception {
        IQMClientControlStrategy stategy = this.getClientControlStrategy();
        if (stategy instanceof QMClientControlStrategy) {
            ((QMClientControlStrategy)stategy).checkPermission(action, cuID);
        }
    }

    public QMCoreDataBaseInfo getEditData() {
        return this.editData;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("ACTION_ADDNEW", null);
        super.actionAddNew_actionPerformed(e);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        IObjectValue objectValue;
        this.checkPermission("ACTION_ADDNEW", null);
        this.checkModified();
        if (this.editData != null && !OprtState.VIEW.equals(this.getOprtState()) && (objectValue = (IObjectValue)this.getUIContext().get("CURRENT.VO")) != null) {
            try {
                String id = this.idList.getID(this.idList.getCurrentIndex());
                this.setOprtState("RELEASEALL");
                this.pubFireVOChangeListener(id);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.unLockUI();
        this.setOprtState("ADDNEW");
        this.editData = (QMCoreDataBaseInfo)this.doCreateNewData(this.editData);
        this.setDataObject(this.editData);
        this.loadFields();
        this.showCopyAddNew();
        this.actionCopy.setEnabled(false);
        this.chkMenuItemSubmitAndAddNew.setVisible(true);
        this.setDefaultFocused();
        this.initOldData(this.editData);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
        this.unLockUI();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        QMCoreDataBaseInfo info = (QMCoreDataBaseInfo)this.getDataObject();
        boolean isShowBizMenu = false;
        if (this.isSuportAudit()) {
            boolean canAudit = info.getCheckedStatus() != DBCheckedStatusEnum.AUDITED && info.getEffectedStatus() == EffectedStatusEnum.EFFECTED;
            boolean canUnAudit = info.getCheckedStatus() == DBCheckedStatusEnum.AUDITED && info.getEffectedStatus() == EffectedStatusEnum.EFFECTED;
            this.actionAudit.setEnabled(canAudit);
            this.actionAudit.setVisible(canAudit);
            this.actionUnAudit.setEnabled(canUnAudit);
            this.actionUnAudit.setVisible(canUnAudit);
            boolean bl = isShowBizMenu = isShowBizMenu || canAudit || canUnAudit;
        }
        if (this.isSuportCancel()) {
            boolean canCancel = info.getDeletedStatus() != DeletedStatusEnum.DELETED && info.getEffectedStatus() == EffectedStatusEnum.EFFECTED;
            boolean canCancelCancel = info.getDeletedStatus() == DeletedStatusEnum.DELETED && info.getEffectedStatus() == EffectedStatusEnum.EFFECTED;
            this.actionCancel.setEnabled(canCancel);
            this.actionCancel.setVisible(canCancel);
            this.actionCancelCancel.setEnabled(canCancelCancel);
            this.actionCancelCancel.setVisible(canCancelCancel);
            boolean bl = isShowBizMenu = isShowBizMenu || canCancel || canCancelCancel;
        }
        if (this.isSuportBlocked()) {
            boolean canBlock = info.getBlockedStatus() != BlockedStatusEnum.BLOCKED && info.getEffectedStatus() == EffectedStatusEnum.EFFECTED;
            boolean canUnBlock = info.getBlockedStatus() == BlockedStatusEnum.BLOCKED && info.getEffectedStatus() == EffectedStatusEnum.EFFECTED;
            this.actionBlocked.setEnabled(canBlock);
            this.actionBlocked.setVisible(canBlock);
            this.actionUnBlocked.setEnabled(canUnBlock);
            this.actionUnBlocked.setVisible(canUnBlock);
            isShowBizMenu = isShowBizMenu || canBlock || canUnBlock;
        }
        this.menuBiz.setVisible(isShowBizMenu);
        this.menuBiz.setEnabled(isShowBizMenu);
        String opr = this.getOprtState();
        if ("EDIT".equals(opr)) {
            try {
                String orgID = "";
                orgID = this.getMainOrgInfo() != null ? this.getMainOrgInfo().getId().toString() : SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
                this.getCodingRuleStrategy().processEditCodingRuleNumber(this.getMainOrgContext(), this.getNumTextField(), (AbstractObjectValue)info, orgID);
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        boolean canModifyEntry = "EDIT".equals(opr) || "ADDNEW".equals(opr);
        this.actionAddLine.setEnabled(canModifyEntry);
        this.actionInsertLine.setEnabled(canModifyEntry);
        this.actionRemoveLine.setEnabled(canModifyEntry);
        this.actionCopyLine.setEnabled(canModifyEntry);
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        QMCoreDataBaseInfo info = (QMCoreDataBaseInfo)dataObject;
        String actionCopy = (String)this.getUIContext().get("COPY");
        if (actionCopy != null && actionCopy.equals("COPY") && this.getOprtState().equals(OprtState.ADDNEW) && EmptyUtil.isEmpty((String)info.getNumber())) {
            try {
                this.getCodingRuleStrategy().processCodingRuleNumber(this.getMainOrgContext(), this.getNumTextField(), info, this.getMainOrgInfo().getId().toString());
                this.getUIContext().put("COPY", null);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        super.setDataObject(dataObject);
    }

    protected boolean isSuportBlocked() {
        return false;
    }

    protected boolean isSuportCancel() {
        return false;
    }

    protected boolean isSuportAudit() {
        return false;
    }

    protected IObjectValue doCreateNewData(QMCoreDataBaseInfo info) {
        Map map = this.getUIContext();
        String actionCopy = (String)map.get("COPY");
        String id = null;
        if (map.get("ID") != null) {
            id = map.get("ID").toString();
        }
        QMCoreDataBaseInfo data = null;
        try {
            QMCoreDataBaseInfo oldInfo;
            if (info != null) {
                oldInfo = info;
                data = (QMCoreDataBaseInfo)oldInfo.copy();
            } else if (actionCopy != null && id != null && actionCopy.equals("COPY")) {
                oldInfo = (QMCoreDataBaseInfo)this.getValue((IObjectPK)new ObjectUuidPK(id));
                data = (QMCoreDataBaseInfo)oldInfo.copy();
                map.remove("COPY");
            } else {
                data = (QMCoreDataBaseInfo)this.newInstanceData();
            }
            this.setFieldsNull((AbstractObjectValue)data);
            if (data.getCU() == null && this.getMainOrgInfo() != null) {
                data.setCU(this.getMainOrgInfo().getCU());
            }
            KDTextField txtNumber = this.getNumTextField();
            OrgUnitInfo mainOrgInfo = this.getMainOrgInfo();
            if (mainOrgInfo == null) {
                logger.error((Object)"mainOrgInfo is null, pls check u main org");
            } else {
                String orgId = mainOrgInfo.getId().toString();
                this.getCodingRuleStrategy().processCodingRuleNumber(this.getMainOrgContext(), txtNumber, data, orgId);
            }
        }
        catch (EASBizException e) {
            this.handleException((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.applyBillDefaultValue(data);
        return data;
    }

    protected void applyBillDefaultValue(QMCoreDataBaseInfo vo) {
        QMCoreDataBaseInfo billInfo = vo;
        billInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        Date today = new Date();
        billInfo.setCreateTime(new Timestamp(today.getTime()));
        billInfo.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
        billInfo.setLastUpdateTime(null);
    }

    public abstract KDTextField getNumTextField();

    public ClientCodingRuleStrategy getCodingRuleStrategy() {
        if (this.codingRuleStrategy == null) {
            this.codingRuleStrategy = new ClientCodingRuleStrategy();
        }
        return this.codingRuleStrategy;
    }

    protected abstract IObjectValue newInstanceData();

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        this.getVerifyManager().verify();
    }

    @Override
    public abstract SelectorItemCollection getSelectors();

    protected void afterMainOrgChanged(String oldOrgId, String newOrgId) {
        if (newOrgId != null && !newOrgId.equals(oldOrgId)) {
            this.getUIContextManager().changeUIContext(this.getMainOrgContext());
        }
    }

    private void initUIContextManager() {
        if (this.uiContextManager == null) {
            this.uiContextManager = new UIContextManager((CoreUIObject)this);
            this.registerUIManager(this.uiContextManager);
        }
    }

    public IUIContextManager getUIContextManager() {
        if (this.uiContextManager == null) {
            this.initUIContextManager();
        }
        return this.uiContextManager;
    }

    public void registerUIManager(IUIContextManager manager) {
        KDBizPromptBox bizOrgUnitBox = this.getMainBizOrg();
        if (bizOrgUnitBox == null) {
            logger.error((Object)"mainBizOrg KDBizPromptBox is null, pls override getMainBizOrg()");
            return;
        }
        OrgType orgType = this.getMainBizOrgType();
        this.getUIContextManager().registerMainBizOrgF7(bizOrgUnitBox, orgType, this.getAddNewPermItemName(), false);
    }

    protected void initContextOrg() {
        OrgUnitInfo orgUnitInfo = this.getMainOrgInfo();
        if (orgUnitInfo == null) {
            orgUnitInfo = SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType());
        }
        if (orgUnitInfo != null) {
            this.initUIMainOrgContext(orgUnitInfo.getId().toString());
        }
    }

    protected String getAddNewPermItemName() {
        try {
            return QMPermissionUtils.getAddNewPermItemName(this.getMainOrgContext(), this.getBizType());
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return null;
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAudit_actionPerformed(e);
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        IQMCoreDataBase biz = (IQMCoreDataBase)this.getBizInterface();
        biz.audit((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        this.setOprtState("VIEW");
        this.afterDoAction(e, (IObjectPK)pk);
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnAudit_actionPerformed(e);
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        IQMCoreDataBase biz = (IQMCoreDataBase)this.getBizInterface();
        biz.unAudit((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        this.afterDoAction(e, (IObjectPK)pk);
    }

    @Override
    public void actionBlocked_actionPerformed(ActionEvent e) throws Exception {
        super.actionBlocked_actionPerformed(e);
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        IQMCoreDataBase biz = (IQMCoreDataBase)this.getBizInterface();
        biz.blocked((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        this.afterDoAction(e, (IObjectPK)pk);
    }

    @Override
    public void actionUnBlocked_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnBlocked_actionPerformed(e);
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        IQMCoreDataBase biz = (IQMCoreDataBase)this.getBizInterface();
        biz.unBlocked((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        this.afterDoAction(e, (IObjectPK)pk);
    }

    private void afterDoAction(ActionEvent e, IObjectPK pk) throws Exception {
        FMClientHelper.showSuccessMessage((CoreUI)this, e);
        this.setDataObject(this.getValue(pk));
        this.loadFields();
        this.initOldData(this.editData);
        this.setSave(true);
        this.setSaved(true);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        IQMCoreDataBase biz = (IQMCoreDataBase)this.getBizInterface();
        biz.cancel((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        this.afterDoAction(e, (IObjectPK)pk);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        IQMCoreDataBase biz = (IQMCoreDataBase)this.getBizInterface();
        biz.cancelCancel((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        this.afterDoAction(e, (IObjectPK)pk);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        DBCheckedStatusEnum v;
        this.checkPermission("ACTION_MODIFY", this.getCUIDFromBizobject());
        if (this.editData != null && !(this.editData instanceof QMDataBaseDInfo) && (v = this.editData.getCheckedStatus()) != null && v == DBCheckedStatusEnum.AUDITED) {
            String info = EASResource.getString((String)"com.kingdee.eas.qm.basedata.client.BasedataResource", (String)"Msg_AuditedCannotEdit");
            MsgBox.showInfo((Component)((Object)this), (String)info);
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    private String getCUIDFromBizobject() throws Exception {
        return this.getICGF().getCUID(this.editData.getId().toString());
    }

    private ICUIDGetterFacade getICGF() throws Exception {
        return CUIDGetterFacadeFactory.getRemoteInstance();
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.getDetailTable() != null) {
            this.addLine(this.getDetailTable());
            this.appendFootRow(this.getDetailTable());
        }
    }

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        this.dataBinder.loadLineFields(table, row, obj);
    }

    protected void afterAddLine(KDTable table, IObjectValue lineData) {
    }

    protected void afterInsertLine(KDTable table, IObjectValue lineData) {
    }

    protected void afterRemoveLine(KDTable table, IObjectValue lineData) {
    }

    protected void storeLineFields(KDTable table, IRow row, IObjectValue obj) {
        this.dataBinder.storeLineFields(table, row, obj);
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }

    protected void addLine(KDTable table) {
        if (table == null) {
            return;
        }
        IObjectValue detailData = this.createNewDetailData(table);
        IRow row = table.addRow();
        this.getUILifeCycleHandler().fireOnAddNewLine((Object)table, detailData);
        this.loadLineFields(table, row, detailData);
        this.afterAddLine(table, detailData);
    }

    protected abstract KDTable getDetailTable();

    @Override
    public void actionCopyLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopyLine_actionPerformed(e);
        KDTable table = this.getDetailTable();
        if (table == null) {
            return;
        }
        KDTSelectManager manager = table.getSelectManager();
        if (manager.getBlocks().size() > 0) {
            this.addLine(this.getDetailTable());
            this.appendFootRow(this.getDetailTable());
            IRow copyFromRowObj = null;
            IRow copyToRowObj = null;
            int copyFromRowIndex = 0;
            int copyToRowIndex = 0;
            KDTSelectBlock selectedBlock = (KDTSelectBlock)manager.getBlocks().get(0);
            int beginBlockRow = selectedBlock.getBeginRow();
            int endBlockRow = selectedBlock.getEndRow();
            if (manager.getBlocks().size() > 1 || beginBlockRow != endBlockRow) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MultiRows"));
                return;
            }
            copyFromRowIndex = selectedBlock.getEndRow();
            copyToRowIndex = KDTableUtil.getLastVisibleRowIndex((KDTable)table);
            copyFromRowObj = table.getRow(copyFromRowIndex);
            copyToRowObj = table.getRow(copyToRowIndex);
            for (int cellIndex = 0; cellIndex < table.getColumnCount(); ++cellIndex) {
                ICell copyFromCell = copyFromRowObj.getCell(cellIndex);
                ICell copyToCell = copyToRowObj.getCell(cellIndex);
                if (copyFromCell == null || copyToCell == null) continue;
                Object orgValue = copyFromCell.getValue();
                copyToCell.setValue(orgValue);
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneRow"));
            return;
        }
    }

    protected void copyLine(KDTable table, IRow srcrow) {
        if (table == null) {
            return;
        }
        IObjectValue detailData = this.createNewDetailData(table, srcrow);
        if (null == detailData) {
            return;
        }
        IRow row = table.addRow();
        this.getUILifeCycleHandler().fireOnAddNewLine((Object)table, detailData);
        this.loadLineFields(table, row, detailData);
        this.afterAddLine(table, detailData);
    }

    protected IObjectValue createNewDetailData(KDTable table, IRow srcrow) {
        return null;
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.getDetailTable() != null) {
            this.removeLine(this.getDetailTable());
            this.appendFootRow(this.getDetailTable());
            if (this.getDetailTable().getRowCount() == 0) {
                FocusTraversalPolicy policy = null;
                Object container = null;
                Component initComponent = null;
                if (this.getFocusTraversalPolicy() != null && this.getFocusTraversalPolicy() instanceof UIFocusTraversalPolicy) {
                    policy = this.getFocusTraversalPolicy();
                    container = this;
                    Component[] traverComponent = ((UIFocusTraversalPolicy)policy).getComponents();
                    for (int i = 0; i < traverComponent.length; ++i) {
                        if (traverComponent[i] != this.getDetailTable()) continue;
                        initComponent = traverComponent[i];
                        break;
                    }
                    if (initComponent == null) {
                        initComponent = policy.getLastComponent((Container)container);
                        initComponent.requestFocusInWindow();
                    } else if (initComponent != null) {
                        Component component = policy.getComponentBefore((Container)container, initComponent);
                        while (!(component instanceof IKDTextComponent) || !component.isEnabled()) {
                            component = policy.getComponentBefore((Container)container, component);
                        }
                        component.requestFocusInWindow();
                    }
                } else if (policy == null) {
                    if (this.getUIWindow() instanceof Dialog) {
                        policy = ((Dialog)this.uiWindow).getFocusTraversalPolicy();
                        container = (Dialog)this.uiWindow;
                    } else if (this.getUIWindow() instanceof Window) {
                        policy = ((Window)this.uiWindow).getFocusTraversalPolicy();
                        container = (Window)this.uiWindow;
                    }
                    if (policy != null) {
                        try {
                            Component component = policy.getComponentBefore((Container)container, (Component)this.getDetailTable());
                            while (!(component instanceof IKDTextComponent) || !component.isEnabled()) {
                                component = policy.getComponentBefore((Container)container, component);
                            }
                            component.requestFocusInWindow();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.getDetailTable() != null) {
            this.insertLine(this.getDetailTable());
            this.appendFootRow(this.getDetailTable());
        }
    }

    protected void insertLine(KDTable table) {
        if (table == null) {
            return;
        }
        IObjectValue detailData = this.createNewDetailData(table);
        IRow row = null;
        if (table.getSelectManager().size() > 0) {
            int top = table.getSelectManager().get().getTop();
            row = this.isTableColumnSelected(table) ? table.addRow() : table.addRow(top);
        } else {
            row = table.addRow();
        }
        this.getUILifeCycleHandler().fireOnAddNewLine((Object)table, detailData);
        this.loadLineFields(table, row, detailData);
        this.afterInsertLine(table, detailData);
    }

    protected final boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    protected void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (this.confirmRemove()) {
            KDTSelectManager selectManager = table.getSelectManager();
            int size = selectManager.size();
            KDTSelectBlock selectBlock = null;
            HashSet<Integer> indexSet = new HashSet<Integer>();
            for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
                selectBlock = selectManager.get(blockIndex);
                int top = selectBlock.getBeginRow();
                int bottom = selectBlock.getEndRow();
                if (table.getRow(top) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                for (int i = top; i <= bottom; ++i) {
                    indexSet.add(new Integer(i));
                }
            }
            Object[] indexArr = new Integer[indexSet.size()];
            Object[] indexObj = indexSet.toArray();
            System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
            Arrays.sort(indexArr);
            if (indexArr == null) {
                return;
            }
            for (int i = indexArr.length - 1; i >= 0; --i) {
                int index;
                int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
                IObjectValue detailData = (IObjectValue)table.getRow(rowIndex).getUserObject();
                table.removeRow(rowIndex);
                IObjectCollection collection = (IObjectCollection)table.getUserObject();
                if (collection == null) {
                    logger.error((Object)"collection not be binded to table");
                } else if (detailData != null && (index = this.getCollectionIndex(collection, detailData)) >= 0 && collection.size() > index) {
                    collection.removeObject(index);
                }
                this.afterRemoveLine(table, detailData);
            }
            if (table.getRow(0) != null) {
                table.getSelectManager().select(0, 0);
            }
        }
    }

    private int getCollectionIndex(IObjectCollection collection, IObjectValue obj) {
        int index = -1;
        if (collection == null) {
            return index;
        }
        for (int i = collection.size() - 1; i >= 0; --i) {
            if (obj != collection.getObject(i)) continue;
            index = i;
            return index;
        }
        return index;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected void applyDefaultValue(IObjectValue vo) {
        super.applyDefaultValue(vo);
        QMCoreDataBaseInfo info = (QMCoreDataBaseInfo)vo;
        if (info.getCheckedStatus() == DBCheckedStatusEnum.AUDITED) {
            info.setCheckedStatus(DBCheckedStatusEnum.UNAUDITED);
        }
        if (info.getDeletedStatus() == DeletedStatusEnum.DELETED) {
            info.setDeletedStatus(DeletedStatusEnum.NORMAL);
        }
        if (info.getBlockedStatus() == BlockedStatusEnum.BLOCKED) {
            info.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        }
    }

    protected void initListener() {
        super.initListener();
        if (this.getDetailTable() != null) {
            this.getDetailTable().addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

                public void editStopped(KDTEditEvent e) {
                    QMCoreEditUI.this.tblDetail_editStopped(e);
                }
            });
        }
    }

    protected void tblDetail_editStopped(KDTEditEvent e) {
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.setScrollButtons();
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.setScrollButtons();
    }

    protected void setScrollButtons() {
        int currentIndex = this.idList.getCurrentIndex();
        int nextIndex = currentIndex + 1;
        String nextId = this.idList.getID(nextIndex);
        if (nextId == null) {
            this.actionNext.setEnabled(false);
            this.actionLast.setEnabled(false);
        }
    }

    public Component getComponentByName(String name) {
        return QMClientUtils.getComponentByName((CoreUIObject)this, name);
    }

    public IQMUIComponentCreator getUICompentCreatorFacotry() {
        if (this.creator == null) {
            this.creator = QMUICompentCreatorFactory.getInstance();
        }
        return this.creator;
    }

    public List getOnloadCache() {
        ArrayList params = new ArrayList();
        return params;
    }

    public List getInitCache() {
        QMBatchExecuteParam p1 = new QMBatchExecuteParam("com.kingdee.eas.framework.config.app.ConfigController", IConfigController.class, "getUserConfigData", new Class[]{String.class, String.class}, new Object[]{"SubmitAndAdd", this.getMetaDataPK().getFullName()});
        QMBatchExecuteParam p2 = new QMBatchExecuteParam("com.kingdee.eas.framework.config.app.ConfigController", IConfigController.class, "getUserConfigData", new Class[]{String.class, String.class}, new Object[]{"SubmitAndPrint", this.getMetaDataPK().getFullName()});
        QMBatchExecuteParam p4 = new QMBatchExecuteParam(BOSObjectType.create((String)"E6020364"), IQMCommonFacade.class, "getAuthorizedBizOrgUnits", new Class[]{OrgType.class, String.class}, new Object[]{this.getMainBizOrgType(), this.getAddNewPermItemName()});
        ArrayList<QMBatchExecuteParam> params = new ArrayList<QMBatchExecuteParam>();
        params.add(p1);
        params.add(p2);
        params.add(p4);
        return params;
    }

    public IQMCacheManager getCacheManager() {
        if (this.cacheManager == null) {
            this.cacheManager = QMCacheManager.getInstance();
        }
        return this.cacheManager;
    }

    @Override
    public boolean isPrepareInit() {
        List list = this.getOnloadCache();
        try {
            this.getCacheManager().batchInvoke(null, list.toArray(new QMBatchExecuteParam[list.size()]));
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return super.isPrepareInit();
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        IObjectValue value = super.getValue(pk);
        List list = this.getValueFecthCache(value);
        this.getCacheManager().batchInvoke(this.getMainOrgContext(), list.toArray(new QMBatchExecuteParam[list.size()]));
        return value;
    }

    public List getValueFecthCache(IObjectValue value) throws Exception {
        ArrayList<QMBatchExecuteParam> params = new ArrayList<QMBatchExecuteParam>();
        if (this.getMainOrgInfo() != null) {
            String orgID = this.getMainOrgInfo().getId().toString();
            QMBatchExecuteParam p1 = new QMBatchExecuteParam(BOSObjectType.create((String)"D98D0544"), IQMCodingRuleManageFacade.class, "getCodingRuleData", new Class[]{IObjectValue.class, String.class}, new Object[]{value, orgID});
            params.add(p1);
        }
        return params;
    }

    public ICoreBase getBizCaller() throws Exception {
        return this.getCoreBaseInterface();
    }
}

