/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.qm.common.DBCheckedStatusEnum;
import com.kingdee.eas.qm.common.IQMCoreTreeBase;
import com.kingdee.eas.qm.common.QMCoreTreeBaseInfo;
import com.kingdee.eas.qm.common.client.AbstractQMCoreTreeEditUI;
import com.kingdee.eas.qm.common.client.ccstrategy.IQMClientControlStrategy;
import com.kingdee.eas.qm.common.client.ccstrategy.IQMControlModeUIProxy;
import com.kingdee.eas.qm.common.client.ccstrategy.QMClientControlStrategy;
import com.kingdee.eas.qm.common.client.ccstrategy.QMClientControlStrategyFactory;
import com.kingdee.eas.qm.common.client.util.IQMUIComponentCreator;
import com.kingdee.eas.qm.common.client.util.QMClientUtils;
import com.kingdee.eas.qm.common.client.util.QMUICompentCreatorFactory;
import com.kingdee.eas.qm.common.client.verify.UIControlEmptyVerifyItem;
import com.kingdee.eas.qm.common.codingrule.ClientCodingRuleStrategy;
import com.kingdee.eas.qm.common.util.backup.FMClientHelper;
import com.kingdee.eas.qm.common.verify.IVerifyManager;
import com.kingdee.eas.qm.common.verify.VerifyManager;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class QMCoreTreeEditUI
extends AbstractQMCoreTreeEditUI
implements IQMControlModeUIProxy {
    private static final long serialVersionUID = 7337099825449497766L;
    private static final Logger logger = CoreUIObject.getLogger(QMCoreTreeEditUI.class);
    protected IVerifyManager verifyManager = null;
    public static String parent_info;
    private ClientCodingRuleStrategy codingRuleStrategy = null;
    private String controlType = null;
    private IQMClientControlStrategy ccStrategy = null;
    private IQMUIComponentCreator creator = null;

    public QMCoreTreeEditUI() throws Exception {
        logger.debug((Object)"QMCoreTreeEditUI");
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_auditing"));
        this.actionUnAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.actionBlocked.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_freeze"));
        this.actionUnBlocked.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_ffreeze"));
    }

    @Override
    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
        UIUtil.updateUITitle((CoreUIObject)this, (String)this.resHelper.getString("this.title"));
    }

    public IVerifyManager getVerifyManager() {
        if (this.verifyManager == null) {
            this.verifyManager = new VerifyManager();
        }
        return this.verifyManager;
    }

    protected IObjectValue createNewData() {
        IObjectValue data = this.doCreateNewData();
        return data;
    }

    public void onLoad() throws Exception {
        this.initStrategy();
        super.onLoad();
        UIControlEmptyVerifyItem verifyItem = new UIControlEmptyVerifyItem((CoreUIObject)this);
        this.getVerifyManager().addVerifyItem(verifyItem);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        QMCoreTreeBaseInfo info = (QMCoreTreeBaseInfo)this.getDataObject();
        boolean canAudit = info.getCheckedStatus() != DBCheckedStatusEnum.AUDITED && info.getEffectedStatus() == EffectedStatusEnum.EFFECTED;
        boolean canUnAudit = info.getCheckedStatus() == DBCheckedStatusEnum.AUDITED && info.getEffectedStatus() == EffectedStatusEnum.EFFECTED;
        this.actionAudit.setEnabled(canAudit);
        this.actionAudit.setVisible(canAudit);
        this.actionUnAudit.setEnabled(canUnAudit);
        this.actionUnAudit.setVisible(canUnAudit);
        boolean canCancel = info.getDeletedStatus() != DeletedStatusEnum.DELETED && info.getEffectedStatus() == EffectedStatusEnum.EFFECTED;
        boolean canCancelCancel = info.getDeletedStatus() == DeletedStatusEnum.DELETED && info.getEffectedStatus() == EffectedStatusEnum.EFFECTED;
        this.actionCancel.setEnabled(canCancel);
        this.actionCancel.setVisible(canCancel);
        this.actionCancelCancel.setEnabled(canCancelCancel);
        this.actionCancelCancel.setVisible(canCancelCancel);
        boolean canBlock = info.getBlockedStatus() != BlockedStatusEnum.BLOCKED && info.getEffectedStatus() == EffectedStatusEnum.EFFECTED;
        boolean canUnBlock = info.getBlockedStatus() == BlockedStatusEnum.BLOCKED && info.getEffectedStatus() == EffectedStatusEnum.EFFECTED;
        this.actionBlocked.setEnabled(canBlock);
        this.actionBlocked.setVisible(canBlock);
        this.actionUnBlocked.setEnabled(canUnBlock);
        this.actionUnBlocked.setVisible(canUnBlock);
        this.initActionStatus();
    }

    protected void initActionStatus() {
        this.actionBlocked.setEnabled(false);
        this.actionBlocked.setVisible(false);
        this.actionUnBlocked.setEnabled(false);
        this.actionUnBlocked.setVisible(false);
        this.actionSave.setEnabled(false);
        this.actionSave.setVisible(false);
    }

    protected void initContextOrg() {
        OrgUnitInfo orgUnitInfo = this.getMainOrgInfo();
        if (orgUnitInfo == null) {
            orgUnitInfo = SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType());
        }
        this.initUIMainOrgContext(orgUnitInfo.getId().toString());
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        if ("ADDNEW".equals(this.getOprtState())) {
            dataObject.put("parent", this.getUIContext().get("ParentNode"));
        }
        super.setDataObject(dataObject);
        QMCoreTreeBaseInfo info = (QMCoreTreeBaseInfo)dataObject;
        if (info != null && info.innerGetParent() != null) {
            this.getUIContext().put("ParentNode", info.innerGetParent());
        }
        if (info != null && info.getLevel() == 1) {
            this.getUIContext().put("ParentNode", null);
        }
    }

    protected IObjectValue doCreateNewData() {
        Map map = this.getUIContext();
        String actionCopy = (String)map.get("COPY");
        String id = null;
        if (map.get("ID") != null) {
            id = map.get("ID").toString();
        }
        QMCoreTreeBaseInfo data = null;
        try {
            if (actionCopy != null && id != null && actionCopy.equals("COPY")) {
                QMCoreTreeBaseInfo oldInfo = (QMCoreTreeBaseInfo)this.getValue((IObjectPK)new ObjectUuidPK(id));
                data = (QMCoreTreeBaseInfo)oldInfo.copy();
                map.remove("COPY");
            } else {
                data = (QMCoreTreeBaseInfo)this.newInstanceData();
            }
            KDTextField txtNumber = this.getNumTextField();
            String orgId = this.getMainOrgInfo().getId().toString();
            if (data.getCU() == null) {
                data.setCU(this.getMainOrgInfo().getCU());
            }
            this.getCodingRuleStrategy().processCodingRuleNumber(this.getMainOrgContext(), txtNumber, data, orgId);
        }
        catch (EASBizException e) {
            this.handleException((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.applyBillDefaultValue(data);
        return data;
    }

    protected void applyBillDefaultValue(QMCoreTreeBaseInfo vo) {
        QMCoreTreeBaseInfo billInfo = vo;
        billInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        Date today = new Date();
        billInfo.setCreateTime(new Timestamp(today.getTime()));
        billInfo.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
        billInfo.setLastUpdateTime(null);
    }

    public abstract KDTextField getNumTextField();

    public ClientCodingRuleStrategy getCodingRuleStrategy() {
        if (this.codingRuleStrategy == null) {
            this.codingRuleStrategy = new ClientCodingRuleStrategy();
        }
        return this.codingRuleStrategy;
    }

    protected abstract IObjectValue newInstanceData();

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        this.getVerifyManager().verify();
        this.checkCanAddAtParentGroup();
    }

    protected void checkCanAddAtParentGroup() throws Exception {
        Object group = this.editData.get(this.getGroupField());
        if (group instanceof TreeBaseInfo) {
            ICoreBase ibiz;
            TreeBaseInfo treeInfo = (TreeBaseInfo)group;
            FilterInfo filter = new FilterInfo();
            filter.appendFilterItem(this.getTreeDataBaseGroupFiled() + ".id", (Object)treeInfo.getId().toString());
            BOSObjectType dbType = this.getTreeDataBaseType();
            Class interfaceClass = this.getTreeDataBaseInterfaceClass();
            if (dbType != null && interfaceClass != null && (ibiz = (ICoreBase)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)dbType, (Class)interfaceClass)).exists(filter)) {
                String msg = EASResource.getString((String)"com.kingdee.eas.qm.basedata.client.BasedataResource", (String)"cannotAddGroup");
                MsgBox.showInfo((Component)((Object)this), (String)msg);
                SysUtil.abort();
            }
        }
    }

    protected String getGroupField() {
        return "parent";
    }

    protected String getTreeDataBaseGroupFiled() {
        return "group";
    }

    protected BOSObjectType getTreeDataBaseType() throws Exception {
        return null;
    }

    protected Class getTreeDataBaseInterfaceClass() {
        return null;
    }

    @Override
    public abstract SelectorItemCollection getSelectors();

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAudit_actionPerformed(e);
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        IQMCoreTreeBase biz = (IQMCoreTreeBase)this.getBizInterface();
        biz.audit((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        this.setOprtState("VIEW");
        this.afterDoAction(e, (IObjectPK)pk);
    }

    private void afterDoAction(ActionEvent e, IObjectPK pk) throws Exception {
        FMClientHelper.showSuccessMessage((CoreUI)this, e);
        this.setDataObject(this.getValue(pk));
        this.loadFields();
        this.initOldData((IObjectValue)this.editData);
        this.setSave(true);
        this.setSaved(true);
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnAudit_actionPerformed(e);
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        IQMCoreTreeBase biz = (IQMCoreTreeBase)this.getBizInterface();
        biz.unAudit((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        this.afterDoAction(e, (IObjectPK)pk);
    }

    @Override
    public void actionBlocked_actionPerformed(ActionEvent e) throws Exception {
        super.actionBlocked_actionPerformed(e);
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        IQMCoreTreeBase biz = (IQMCoreTreeBase)this.getBizInterface();
        biz.blocked((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        this.afterDoAction(e, (IObjectPK)pk);
    }

    @Override
    public void actionUnBlocked_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnBlocked_actionPerformed(e);
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        IQMCoreTreeBase biz = (IQMCoreTreeBase)this.getBizInterface();
        biz.unBlocked((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        this.afterDoAction(e, (IObjectPK)pk);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        IQMCoreTreeBase biz = (IQMCoreTreeBase)this.getBizInterface();
        biz.cancel((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        this.afterDoAction(e, (IObjectPK)pk);
    }

    @Override
    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        IQMCoreTreeBase biz = (IQMCoreTreeBase)this.getBizInterface();
        biz.cancelCancel((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        this.afterDoAction(e, (IObjectPK)pk);
    }

    @Override
    public BOSObjectType getBizObjectType() {
        try {
            BOSObjectType currentBOSObjectType = this.getBizType();
            return currentBOSObjectType;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public ICoreBase getBizInterface1() throws Exception {
        return this.getBizInterface();
    }

    public String getControlType() {
        if (this.controlType == null) {
            this.controlType = "";
            try {
                if (this.getBizInterface() == null) {
                    return this.controlType;
                }
                EntityObjectInfo eoi = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(this.getBizType());
                if (eoi.containsExtendedPropertyKey("controlType")) {
                    this.controlType = eoi.getExtendedProperty("controlType");
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
                SysUtil.abort();
            }
        }
        return this.controlType;
    }

    protected IQMClientControlStrategy getClientControlStrategy() {
        if (this.ccStrategy != null) {
            return this.ccStrategy;
        }
        String controlType = this.getControlType();
        this.ccStrategy = QMClientControlStrategyFactory.create(controlType, this);
        return this.ccStrategy;
    }

    private void initStrategy() {
        if (this.ccStrategy == null) {
            this.ccStrategy = this.getClientControlStrategy();
        }
    }

    private void checkPermission(String action, String cuID) throws Exception {
        IQMClientControlStrategy stategy = this.getClientControlStrategy();
        if (stategy instanceof QMClientControlStrategy) {
            ((QMClientControlStrategy)stategy).checkPermission(action, cuID);
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("ACTION_ADDNEW", null);
        super.actionAddNew_actionPerformed(e);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("ACTION_ADDNEW", null);
        QMCoreTreeBaseInfo info = (QMCoreTreeBaseInfo)this.editData;
        if (info.getLevel() == 1) {
            this.getUIContext().put("ParentNode", null);
        }
        super.actionCopy_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("ACTION_DELETE", null);
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        if (this.confirmRemove()) {
            boolean bool = UtilRequest.isPrepare((String)"ActionRemove", (CoreUIObject)this);
            if (bool) {
                this.prepareRomove(null).callHandler();
            }
            this.removeByPK((IObjectPK)pk);
            this.unLockUI();
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        String tempOprState = this.getOprtState();
        this.setSave(false);
        this.checkPermission("ACTION_MODIFY", null);
        this.setOprtState("EDIT");
        IObjectValue val = (IObjectValue)this.getUIContext().get("CURRENT.VO");
        this.getUIContext().put("CURRENT.VO", null);
        try {
            this.setDataObject(val);
        }
        catch (Exception ex) {
            this.setOprtState(tempOprState);
            this.getUIContext().put("CURRENT.VO", val);
            throw ex;
        }
        this.unLockUI();
        this.showMessageForStatus();
        this.initDataStatus();
        this.setDefaultFocused();
    }

    public void setParentGroupFilter(KDBizPromptBox prmt) {
        if (prmt == null) {
            return;
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        QMCoreTreeBaseInfo treeBaseInfo = (QMCoreTreeBaseInfo)this.editData;
        if (treeBaseInfo != null) {
            String longNumber = treeBaseInfo.getLongNumber();
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)longNumber, CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longNumber + "!%"), CompareType.NOTLIKE));
            filter.setMaskString("#0 and #1");
        }
        ev.setFilter(filter);
        prmt.setEntityViewInfo(ev);
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        super.setFieldsNull(newData);
        newData.setString("number", null);
    }

    public Component getComponentByName(CoreUIObject ui, String name) {
        return QMClientUtils.getComponentByName((CoreUIObject)this, name);
    }

    public IQMUIComponentCreator getBoxCreatorFacotry() {
        if (this.creator == null) {
            this.creator = QMUICompentCreatorFactory.getInstance();
        }
        return this.creator;
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.setScrollButtons();
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.setScrollButtons();
    }

    protected void setScrollButtons() {
        int currentIndex = this.idList.getCurrentIndex();
        int nextIndex = currentIndex + 1;
        String nextId = this.idList.getID(nextIndex);
        if (nextId == null) {
            this.actionNext.setEnabled(false);
            this.actionLast.setEnabled(false);
        }
    }
}

