/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.framework.DataTableNameGetterFacadeFactory;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.qm.common.IQMCoreDataBaseD;
import com.kingdee.eas.qm.common.client.QMDataBaseDUpgradeUI;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Hashtable;

public class QMDataBaseDUpgradeUI2
extends QMDataBaseDUpgradeUI {
    private static final long serialVersionUID = -8255067844500056574L;
    private String sqlForAllUpgradableSubordinateCUIDs = "";
    private FilterInfo fiAll;
    private FilterInfo fiImported;
    private FilterInfo fiUnimported;

    @Override
    protected void initCtrls() {
        super.initCtrls();
        this.prmptQualityOrgUnit.setVisible(false);
        this.kDLabelContainer1.setBoundLabelUnderline(false);
        this.kDLabelContainer1.setBoundLabelLength(this.kDLabelContainer1.getBoundLabelLength() * 3);
        this.kDLabelContainer1.setBoundLabelText(this.getMultiLangString("UpgradeHeadLabel"));
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.rebuildUIBecauseAComponentHasBeenHiden();
    }

    private void rebuildUIBecauseAComponentHasBeenHiden() {
        this.kDLabelContainer1.setVisible(false);
        int x = 0;
        int y = 0;
        Component[] comps = this.getComponents();
        int n = comps.length;
        for (int i = 0; i < n; ++i) {
            x = (int)comps[i].getLocation().getX();
            y = (int)comps[i].getLocation().getY();
            comps[i].setLocation(x, y - 20);
        }
        int width = this.getWidth();
        int height = this.getHeight();
        this.setSize(width, height - 20);
    }

    @Override
    protected IRowSet getRSAll(int start, int length) throws Exception {
        this.fiRadioButtonsRelated = this.getFiAll();
        return this.getRowSet(start, length);
    }

    @Override
    protected IRowSet getRSImported(int start, int length) throws Exception {
        this.fiRadioButtonsRelated = this.getFiImported();
        return this.getRowSet(start, length);
    }

    @Override
    protected IRowSet getRSUnimported(int start, int length) throws Exception {
        this.fiRadioButtonsRelated = this.getFiUnimported();
        return this.getRowSet(start, length);
    }

    @Override
    protected void doImport() throws Exception {
        this.setCursorOfWair();
        ArrayList al = this.getIDsOfRowsToImport();
        Hashtable cuIDs = this.getCUIDsByDataIDs(al);
        this.checkSelected(al);
        IQMCoreDataBaseD idbd = this.getBizInterfaceFromUIContext();
        String dataID = null;
        int size = al.size();
        for (int i = 0; i < size; ++i) {
            dataID = al.get(i).toString();
            idbd.upgrade((IObjectPK)new ObjectUuidPK(dataID), (IObjectPK)new ObjectUuidPK(cuIDs.get(dataID).toString()), (IObjectPK)new ObjectUuidPK(this.getCurrentCUID()));
        }
        this.setCursorOfDefault();
        MsgBox.showInfo((Component)((Object)this), (String)this.getMultiLangString("UpgradingFinished"));
        this.setStatus();
    }

    @Override
    protected ArrayList getIDsOfRowsToImport() throws Exception {
        return null;
    }

    private Hashtable getCUIDsByDataIDs(ArrayList dataIDs) throws Exception {
        return null;
    }

    private String getOQLForDataIDsAndCUIDs(ArrayList dataIDs) {
        StringBuffer oql = new StringBuffer("select id,CU.id where ");
        int groupCount = 50;
        ArrayList idGroup = new ArrayList();
        boolean handledAGroup = false;
        boolean firstGroup = true;
        int n = dataIDs.size();
        for (int i = 0; i < n; ++i) {
            handledAGroup = false;
            idGroup.add(dataIDs.get(i));
            if (i == 0 || i % 50 != 0) continue;
            if (!firstGroup) {
                oql.append(" or ");
            }
            oql.append(this.getGroupOQL(idGroup));
            handledAGroup = true;
            firstGroup = false;
            idGroup.clear();
        }
        if (!handledAGroup) {
            if (!firstGroup) {
                oql.append(" or ");
            }
            oql.append(this.getGroupOQL(idGroup));
        }
        return oql.toString();
    }

    private String getGroupOQL(ArrayList idGroup) {
        StringBuffer oql = new StringBuffer();
        oql.append("id in ('").append(idGroup.get(0).toString()).append("'");
        int n = idGroup.size();
        for (int i = 1; i < n; ++i) {
            oql.append(",'").append(idGroup.get(i).toString()).append("'");
        }
        oql.append(")");
        return oql.toString();
    }

    private FilterInfo getFiAll() {
        if (this.fiAll != null) {
            return this.fiAll;
        }
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        fic.add(new FilterItemInfo("CU.id", (Object)this.getSQLForAllUpgradableSubordinateCUIDs(), CompareType.INNER));
        this.fiAll = fi;
        return this.fiAll;
    }

    private FilterInfo getFiImported() {
        if (this.fiImported != null) {
            return this.fiImported;
        }
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        fic.add(new FilterItemInfo("adminCU.id", (Object)this.getCurrentCUID()));
        fic.add(new FilterItemInfo("CU.id", (Object)this.getSQLForAllUpgradableSubordinateCUIDs(), CompareType.INNER));
        this.fiImported = fi;
        return this.fiImported;
    }

    private FilterInfo getFiUnimported() throws Exception {
        if (this.fiUnimported != null) {
            return this.fiUnimported;
        }
        StringBuffer oql = new StringBuffer();
        oql.append("where id in (").append(this.getSQLForAllIDsWhoseAdminCUEqualsToCU()).append(") and adminCU.id in (").append(this.getSQLForAllUpgradableSubordinateCUIDs()).append(")");
        EntityViewInfo evi = new EntityViewInfo(oql.toString());
        this.fiUnimported = evi.getFilter();
        return this.fiUnimported;
    }

    private String getSQLForAllIDsWhoseAdminCUEqualsToCU() throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("select FID from ").append(DataTableNameGetterFacadeFactory.getRemoteInstance().getTableName(this.getBizInterfaceFromUIContext().getType().toString())).append(" where FAdminCUID=FControlUnitID");
        return sql.toString();
    }

    private String getSQLForAllUpgradableSubordinateCUIDs() {
        if (this.sqlForAllUpgradableSubordinateCUIDs.length() != 0) {
            return this.sqlForAllUpgradableSubordinateCUIDs;
        }
        String longNumber = SysContext.getSysContext().getCurrentCtrlUnit().getLongNumber();
        String bosType = this.getBizInterfaceFromUIContext().getType().toString();
        StringBuffer sql = new StringBuffer(100);
        sql.append("select a.FID from T_ORG_CtrlUnit a inner join T_ORG_CUBDControl b ").append("on a.FID=b.FControlUnitID where a.FLongNumber like '").append(longNumber).append("!%' ").append("and b.FBDBOSType='").append(bosType).append("' and b.FIsSubordinateUpgradable=1");
        this.sqlForAllUpgradableSubordinateCUIDs = sql.toString();
        return this.sqlForAllUpgradableSubordinateCUIDs;
    }
}

