/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.UIFocusTraversalPolicy;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.qm.common.client.AbstractQMEntryEditUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FocusTraversalPolicy;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.log4j.Logger;

public abstract class QMEntryEditUI
extends AbstractQMEntryEditUI {
    private static final long serialVersionUID = 4287766895451581801L;
    private static final Logger logger = CoreUIObject.getLogger(QMEntryEditUI.class);
    protected IObjectCollection infoList = null;
    protected int infoListSize = 0;
    protected IObjectValue currInfo = null;
    protected int currIndex = 0;
    private EditUI ownerUI = null;

    public void onLoad() throws Exception {
        this.beforeOnLoad();
        super.onLoad();
        this.afterOnLoad();
    }

    protected void beforeOnLoad() {
        this.infoList = (IObjectCollection)this.getUIContext().get("Context_RowInfoCollection");
        if (this.infoList != null) {
            this.infoListSize = this.infoList.size();
            this.currInfo = (IObjectValue)this.getUIContext().get("InitDataObject");
            this.currIndex = this.getIndex(this.infoList, this.currInfo);
        }
    }

    protected void afterOnLoad() {
        this.doAfterLoadAndSwitch();
    }

    public boolean checkBeforeWindowClosing() {
        this.storeFields();
        EditUI ownerUI = (EditUI)this.getUIContext().get("Owner");
        if (!ownerUI.getOprtState().equals(OprtState.VIEW)) {
            ownerUI.getUIContext().put("Context_RowInfoCollection", this.infoList);
        }
        return true;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        this.beforeSwitchAction();
        --this.currIndex;
        this.afterSwitchAction();
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        this.beforeSwitchAction();
        ++this.currIndex;
        this.afterSwitchAction();
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        this.beforeSwitchAction();
        this.currIndex = 0;
        this.afterSwitchAction();
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        this.beforeSwitchAction();
        this.currIndex = this.infoListSize - 1;
        this.afterSwitchAction();
    }

    protected void beforeSwitchAction() {
        this.storeFields();
        this.infoList.removeObject(this.currInfo);
        this.infoList.addObject(this.currIndex, this.currInfo);
    }

    protected void afterSwitchAction() {
        this.currInfo = this.infoList.getObject(this.currIndex);
        this.setDataObject(this.currInfo);
        this.beforeLoadFields();
        this.loadFields();
        this.afterLoadFields();
        this.initOldData((IObjectValue)this.editData);
        this.initScrollButtons();
        this.doAfterLoadAndSwitch();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    protected void beforeLoadFields() {
    }

    protected void afterLoadFields() {
    }

    protected void doAfterLoadAndSwitch() {
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.setActionDisabled(new ItemAction[]{this.actionAddLine, this.actionInsertLine, this.actionRemoveLine});
            return;
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setUIOprtState();
    }

    protected void setUIOprtState() {
        if (this.getOwnerUI() != null) {
            Object state = this.getOwnerUI().getUIContext().get("Context_DetailUIOprtState");
            if (state != null) {
                this.setOprtState(state.toString());
                return;
            }
            this.setOprtState(this.getOwnerUI().getOprtState());
        }
    }

    protected EditUI getOwnerUI() {
        if (this.ownerUI == null) {
            this.ownerUI = (EditUI)this.getUIContext().get("Owner");
        }
        return this.ownerUI;
    }

    protected void initScrollButtons() {
        ItemAction[] actionAll = new ItemAction[]{this.actionFirst, this.actionPre, this.actionNext, this.actionLast};
        ItemAction[] actionP = new ItemAction[]{this.actionFirst, this.actionPre};
        ItemAction[] actionN = new ItemAction[]{this.actionNext, this.actionLast};
        if (this.infoListSize == 0 || this.infoListSize == 1) {
            this.setActionDisabled(actionAll);
            return;
        }
        if (this.currIndex == 0) {
            this.setActionDisabled(actionP);
            if (this.currIndex == this.infoListSize - 1) {
                this.setActionDisabled(actionN);
            } else {
                this.setActionEnabled(actionN);
            }
        } else {
            this.setActionEnabled(actionP);
            if (this.currIndex == this.infoListSize - 1) {
                this.setActionDisabled(actionN);
            } else {
                this.setActionEnabled(actionN);
            }
        }
    }

    protected void setActionEnabled(ItemAction[] actions) {
        for (int i = 0; i < actions.length; ++i) {
            actions[i].setEnabled(true);
        }
    }

    protected void setActionDisabled(ItemAction[] actions) {
        for (int i = 0; i < actions.length; ++i) {
            actions[i].setEnabled(false);
        }
    }

    protected void checkTableParsed() {
        super.checkTableParsed();
        if (this.getDetailTable() != null) {
            this.getDetailTable().checkParsed();
        }
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Quality;
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.addLine(this.getDetailTable());
    }

    protected void addLine(KDTable table) {
        if (table == null) {
            return;
        }
        IObjectValue detailData = this.createNewDetailData(table);
        IRow row = table.addRow();
        this.getUILifeCycleHandler().fireOnAddNewLine((Object)table, detailData);
        this.loadLineFields(table, row, detailData);
        this.afterAddLine(table, detailData);
    }

    protected abstract IObjectValue createNewDetailData(KDTable var1);

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        this.dataBinder.loadLineFields(table, row, obj);
    }

    protected void afterAddLine(KDTable table, IObjectValue lineData) {
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        this.insertLine(this.getDetailTable());
    }

    protected void insertLine(KDTable table) {
        if (table == null) {
            return;
        }
        IObjectValue detailData = this.createNewDetailData(table);
        IRow row = null;
        if (table.getSelectManager().size() > 0) {
            int top = table.getSelectManager().get().getTop();
            row = this.isTableColumnSelected(table) ? table.addRow() : table.addRow(top);
        } else {
            row = table.addRow();
        }
        this.getUILifeCycleHandler().fireOnAddNewLine((Object)table, detailData);
        this.loadLineFields(table, row, detailData);
        this.afterInsertLine(table, detailData);
    }

    protected boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    protected void afterInsertLine(KDTable table, IObjectValue lineData) {
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.getDetailTable() != null) {
            this.removeLine(this.getDetailTable());
            this.appendFootRow(this.getDetailTable());
            if (this.getDetailTable().getRowCount() == 0) {
                FocusTraversalPolicy policy = null;
                Object container = null;
                Component initComponent = null;
                if (this.getFocusTraversalPolicy() != null && this.getFocusTraversalPolicy() instanceof UIFocusTraversalPolicy) {
                    policy = this.getFocusTraversalPolicy();
                    container = this;
                    Component[] traverComponent = ((UIFocusTraversalPolicy)policy).getComponents();
                    for (int i = 0; i < traverComponent.length; ++i) {
                        if (traverComponent[i] != this.getDetailTable()) continue;
                        initComponent = traverComponent[i];
                        break;
                    }
                    if (initComponent == null) {
                        initComponent = policy.getLastComponent((Container)container);
                        initComponent.requestFocusInWindow();
                    } else if (initComponent != null) {
                        Component component = policy.getComponentBefore((Container)container, initComponent);
                        while (!(component instanceof IKDTextComponent) || !component.isEnabled()) {
                            component = policy.getComponentBefore((Container)container, component);
                        }
                        component.requestFocusInWindow();
                    }
                } else if (policy == null) {
                    if (this.getUIWindow() instanceof Dialog) {
                        policy = ((Dialog)this.uiWindow).getFocusTraversalPolicy();
                        container = (Dialog)this.uiWindow;
                    } else if (this.getUIWindow() instanceof Window) {
                        policy = ((Window)this.uiWindow).getFocusTraversalPolicy();
                        container = (Window)this.uiWindow;
                    }
                    if (policy != null) {
                        try {
                            Component component = policy.getComponentBefore((Container)container, (Component)this.getDetailTable());
                            while (!(component instanceof IKDTextComponent) || !component.isEnabled()) {
                                component = policy.getComponentBefore((Container)container, component);
                            }
                            component.requestFocusInWindow();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    protected void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (this.confirmRemove()) {
            KDTSelectManager selectManager = table.getSelectManager();
            int size = selectManager.size();
            KDTSelectBlock selectBlock = null;
            HashSet<Integer> indexSet = new HashSet<Integer>();
            for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
                selectBlock = selectManager.get(blockIndex);
                int top = selectBlock.getBeginRow();
                int bottom = selectBlock.getEndRow();
                if (table.getRow(top) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                for (int i = top; i <= bottom; ++i) {
                    indexSet.add(new Integer(i));
                }
            }
            Object[] indexArr = new Integer[indexSet.size()];
            Object[] indexObj = indexSet.toArray();
            System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
            Arrays.sort(indexArr);
            if (indexArr == null) {
                return;
            }
            for (int i = indexArr.length - 1; i >= 0; --i) {
                int index;
                int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
                IObjectValue detailData = (IObjectValue)table.getRow(rowIndex).getUserObject();
                table.removeRow(rowIndex);
                IObjectCollection collection = (IObjectCollection)table.getUserObject();
                if (collection == null) {
                    logger.error((Object)"collection not be binded to table");
                } else if (detailData != null && (index = this.getIndex(collection, detailData)) >= 0 && collection.size() > index) {
                    collection.removeObject(index);
                }
                this.afterRemoveLine(table, detailData);
            }
            if (table.getRow(0) != null) {
                table.getSelectManager().select(0, 0);
            }
        }
    }

    protected void afterRemoveLine(KDTable table, IObjectValue lineData) {
    }

    protected abstract KDTable getDetailTable();

    public int getIndex(IObjectCollection colls, Object obj) {
        if (colls == null || obj == null) {
            return -1;
        }
        for (int i = 0; i < colls.size(); ++i) {
            if (!colls.getObject(i).equals(obj)) continue;
            return i;
        }
        return -1;
    }
}

