/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.client.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.common.client.action.AbstractUIContextAction;
import com.kingdee.eas.qm.common.client.action.IUIContextAction;
import com.kingdee.eas.qm.common.client.util.QMClientUtils;
import com.kingdee.eas.qm.qc.client.QCBillEditUI;
import com.kingdee.eas.scm.common.client.GeneralKDPromptSelectorAdaptor;
import java.awt.Component;
import org.apache.log4j.Logger;

public class MaterialAction
extends AbstractUIContextAction
implements IUIContextAction {
    private static final Logger logger = CoreUIObject.getLogger(MaterialAction.class);
    private static final String QUERY = "com.kingdee.eas.basedata.master.material.app.F7MaterialSimpleQuery";
    private KDBizPromptBox prmtBox;
    private OrgType mainOrgType;

    public MaterialAction(Component owner, KDBizPromptBox prmtMaterial, OrgType mainOrgType) {
        this.prmtBox = prmtMaterial;
        this.mainOrgType = mainOrgType;
        this.prmtBox.setQueryInfo(QUERY);
        this.prmtBox.setDisplayFormat("$name$");
        this.prmtBox.setEditFormat("$number$");
        this.prmtBox.setCommitFormat("$number$;$name$;$helpCode$");
        GeneralKDPromptSelectorAdaptor select = QMClientUtils.setBizMaterialF7(this.prmtBox, owner, mainOrgType, QUERY);
        select.setIsMultiSelect(prmtMaterial.isEnabledMultiSelection());
        this.prmtBox.setSelector((KDPromptSelector)select);
        EntityViewInfo ev = this.getMaterialFilter(null, mainOrgType);
        this.prmtBox.setEntityViewInfo(ev);
    }

    private EntityViewInfo getMaterialFilter(OrgUnitInfo mainOrg, OrgType mainOrgType) {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (mainOrg == null) {
            filter.getFilterItems().add(new FilterItemInfo("id", null));
            ev.setFilter(filter);
            return ev;
        }
        if (mainOrgType == OrgType.Quality) {
            try {
                filter = MaterialFactory.getRemoteInstance().getDatabaseDFilter((IObjectPK)new ObjectUuidPK(mainOrg.getCU().getId()), "id", "cu.id");
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        } else if (mainOrgType == OrgType.Storage) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)("select fmaterialid from t_bd_MaterialInventory where FOrgUnit='" + mainOrg.getId().toString() + "'"), CompareType.INNER));
        } else if (mainOrgType == OrgType.Company) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)("select fmaterialid from t_bd_materialcompany where FCompanyID='" + mainOrg.getId().toString() + "'"), CompareType.INNER));
        }
        ev.setFilter(filter);
        return ev;
    }

    @Override
    public void changeUIContext(CoreUIObject owner, Context context) {
        if (owner instanceof QCBillEditUI && this.isloading(owner)) {
            return;
        }
        OrgUnitInfo mainOrg = (OrgUnitInfo)context.get((Object)this.mainOrgType);
        if (mainOrg == null) {
            EntityViewInfo ev = this.getMaterialFilter(mainOrg, this.mainOrgType);
            this.prmtBox.setEntityViewInfo(ev);
            this.prmtBox.setData(null);
            return;
        }
        EntityViewInfo ev = this.getMaterialFilter(mainOrg, this.mainOrgType);
        this.prmtBox.setEntityViewInfo(ev);
        this.prmtBox.setF7Context(context);
        this.prmtBox.setData(null);
        CtrlUnitInfo cu = (CtrlUnitInfo)context.get((Object)OrgType.ControlUnit);
        this.prmtBox.setCurrentCtrlUnit(cu);
        if (cu != null) {
            GeneralKDPromptSelectorAdaptor select = (GeneralKDPromptSelectorAdaptor)this.prmtBox.getSelector();
            select.setCUId(cu.getId().toString());
        }
        this.prmtBox.setEntityViewInfo(ev);
    }
}

