/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.client.ccstrategy;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.qm.common.QMDatabaseDException;
import com.kingdee.eas.qm.common.client.ccstrategy.IQMClientControlStrategy;
import com.kingdee.eas.qm.common.client.ccstrategy.IQMControlModeUIProxy;

public abstract class QMClientControlStrategy
implements IQMClientControlStrategy {
    protected IQMControlModeUIProxy _ui = null;

    public QMClientControlStrategy(IQMControlModeUIProxy ui) {
        this._ui = ui;
    }

    public void addUIComponent() {
    }

    public void initUIComponent() {
    }

    public void checkCanAdd() throws Exception {
    }

    public void checkCanUpdate(String sltedKeyValue) throws Exception {
    }

    public void checkCanDelete(String sltedKeyValue) throws Exception {
    }

    @Override
    public void checkPermission(String action, String bizObjCUID) throws Exception {
        if (this.getControlType().equalsIgnoreCase("S1")) {
            if (!this.getCurrentCUID().equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
                this.throwsExceptionForNoPermission(action);
            }
        } else if (this.getControlType().equalsIgnoreCase("S3") || this.getControlType().equalsIgnoreCase("S4")) {
            if (!action.equals("ACTION_ADDNEW") && !this.getCurrentCUID().equals(bizObjCUID)) {
                this.throwsExceptionForNoPermission(action);
            }
        } else if (this.getControlType().equalsIgnoreCase("I") && !action.equals("ACTION_ADDNEW") && !this.getCurrentCUID().equals(bizObjCUID)) {
            this.throwsExceptionForNoPermission(action);
        }
    }

    protected String getCurrentCUID() {
        OrgUnitInfo org = this._ui.getMainOrgInfo();
        if (org != null) {
            return org.getCU().getId().toString();
        }
        String currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        return currentCUID;
    }

    protected OrgUnitInfo getCurrentOrgUnitInto() {
        OrgUnitInfo currentOrgUnitInfo = SysContext.getSysContext().getCurrentOrgUnit();
        return currentOrgUnitInfo;
    }

    protected boolean isControlType_I() {
        return this.getCurrentOrgUnitInto().isIsStorageOrgUnit();
    }

    private void throwsExceptionForNoPermission(String action) throws Exception {
        if (action.equals("ACTION_ADDNEW")) {
            throw new QMDatabaseDException(QMDatabaseDException.CAN_NOT_ADD);
        }
        if (action.equals("ACTION_DELETE")) {
            throw new QMDatabaseDException(QMDatabaseDException.CAN_NOT_DELETE);
        }
        if (action.equals("ACTION_MODIFY")) {
            throw new QMDatabaseDException(QMDatabaseDException.CAN_NOT_UPDATE);
        }
        if (action.equals("ACTION_AUDIT")) {
            throw new QMDatabaseDException(QMDatabaseDException.CAN_NOT_AUDIT);
        }
        if (action.equals("ACTION_UNAUDIT")) {
            throw new QMDatabaseDException(QMDatabaseDException.CAN_NOT_UNAUDIT);
        }
        if (action.equals("ACTION_CANCEL")) {
            throw new QMDatabaseDException(QMDatabaseDException.CAN_NOT_CANCEL);
        }
        if (action.equals("ACTION_CANCELCANCEL")) {
            throw new QMDatabaseDException(QMDatabaseDException.CAN_NOT_CANCLECANCLE);
        }
        if (action.equals("ACTION_MOVEDATA")) {
            throw new QMDatabaseDException(QMDatabaseDException.CAN_NOT_MOVE);
        }
        if (action.equals("ACTION_ADDNEW_TREE")) {
            throw new QMDatabaseDException(QMDatabaseDException.CAN_NOT_ADDTREE);
        }
        if (action.equals("ACTION_DELETE_TREE")) {
            throw new QMDatabaseDException(QMDatabaseDException.CAN_NOT_REMOVETREE);
        }
        if (action.equals("ACTION_MODIFY_TREE")) {
            throw new QMDatabaseDException(QMDatabaseDException.CAN_NOT_MODIFYTREE);
        }
        if (action.equals("ACTION_MOVE_TREE")) {
            throw new QMDatabaseDException(QMDatabaseDException.CAN_NOT_MOVETREE);
        }
    }

    @Override
    public abstract FilterInfo getDefaultFilterForControlType();

    public FilterInfo getCommonPromptBoxDefaultFilterForControlType(String uiOprState) {
        return this.getDefaultFilterForControlType();
    }

    public FilterInfo getGeneralBoxDefaultFilterForControlType(String uiOprState) {
        return this.getDefaultFilterForControlType();
    }
}

