/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.client.ccstrategy;

import com.kingdee.eas.qm.common.client.ccstrategy.IQMClientControlStrategy;
import com.kingdee.eas.qm.common.client.ccstrategy.IQMControlModeEditUIProxy;
import com.kingdee.eas.qm.common.client.ccstrategy.IQMControlModeListUIProxy;
import com.kingdee.eas.qm.common.client.ccstrategy.IQMControlModeUIProxy;
import com.kingdee.eas.qm.common.client.ccstrategy.QMClientControlStrategy;
import com.kingdee.eas.qm.common.client.ccstrategy.QMDEditClientControlStrategy;
import com.kingdee.eas.qm.common.client.ccstrategy.QMDListClientControlStrategy;
import com.kingdee.eas.qm.common.client.ccstrategy.QMDataBaseIClientControlStrategy;
import com.kingdee.eas.qm.common.client.ccstrategy.QMS1ClientControlStrategy;
import com.kingdee.eas.qm.common.client.ccstrategy.QMS2ClientControlStrategy;
import com.kingdee.eas.qm.common.client.ccstrategy.QMS3ClientControlStrategy;
import com.kingdee.eas.qm.common.client.ccstrategy.QMS4ClientControlStrategy;
import org.apache.log4j.Logger;

public class QMClientControlStrategyFactory {
    private static Logger logger = Logger.getLogger(QMClientControlStrategyFactory.class);

    public static IQMClientControlStrategy create(String controlType, IQMControlModeUIProxy ui) {
        QMClientControlStrategy ccStrategy = null;
        if (controlType.equals("I")) {
            ccStrategy = new QMDataBaseIClientControlStrategy(ui);
        } else if (controlType.equals("S1")) {
            ccStrategy = new QMS1ClientControlStrategy(ui);
        } else if (controlType.equals("S2")) {
            ccStrategy = new QMS2ClientControlStrategy(ui);
        } else if (controlType.equals("S3")) {
            ccStrategy = new QMS3ClientControlStrategy(ui);
        } else if (controlType.equals("S4")) {
            ccStrategy = new QMS4ClientControlStrategy(ui);
        } else if (controlType.equals("D")) {
            if (ui instanceof IQMControlModeListUIProxy) {
                ccStrategy = new QMDListClientControlStrategy((IQMControlModeListUIProxy)ui);
            } else if (ui instanceof IQMControlModeEditUIProxy) {
                ccStrategy = new QMDEditClientControlStrategy((IQMControlModeEditUIProxy)ui);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ui" + ui + " controlType: " + controlType + " ccStrategy:" + ccStrategy));
        }
        return ccStrategy;
    }
}

