/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.client.ccstrategy;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.framework.DataBaseDException;
import com.kingdee.eas.basedata.org.CUBDControlFactory;
import com.kingdee.eas.basedata.org.CUBDControlInfo;
import com.kingdee.eas.basedata.org.ICUBDControl;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.common.QMDataBaseDInfo;
import com.kingdee.eas.qm.common.client.ccstrategy.IQMControlModeUIProxy;
import com.kingdee.eas.qm.common.client.ccstrategy.QMClientControlStrategy;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;

public class QMDClientControlStrategy
extends QMClientControlStrategy {
    private String controlType = null;

    public QMDClientControlStrategy(IQMControlModeUIProxy ui) {
        super(ui);
    }

    @Override
    public String getControlType() {
        if (this.controlType == null) {
            this.controlType = "D";
            try {
                if (this._ui.getBizInterface1() == null) {
                    return this.controlType;
                }
                EntityObjectInfo eoi = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(this._ui.getBizObjectType());
                if (eoi.containsExtendedPropertyKey("controlType")) {
                    this.controlType = eoi.getExtendedProperty("controlType");
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
                SysUtil.abort();
            }
        }
        return this.controlType;
    }

    @Override
    public FilterInfo getDefaultFilterForControlType() {
        return null;
    }

    @Override
    public void checkCanAdd() throws Exception {
        String controlType = this.getControlType();
        if (!"I".equals(controlType)) {
            this.checkAddPolicy(this.getCurrentCUID(), this._ui.getBizObjectType());
        }
    }

    @Override
    public void checkCanUpdate(String sltedKeyValue) throws Exception {
        ObjectUuidPK objectPK = new ObjectUuidPK(sltedKeyValue);
        QMDataBaseDInfo dataBaseDInfo = (QMDataBaseDInfo)this._ui.getBizInterface1().getValue((IObjectPK)objectPK);
        if (!dataBaseDInfo.getCU().getId().toString().equals(this.getCurrentCUID())) {
            this.checkUpdatePolicy(this.getCurrentCUID(), this._ui.getBizObjectType());
        }
    }

    @Override
    public void checkCanDelete(String sltedKeyValue) throws Exception {
        ObjectUuidPK objectPK = new ObjectUuidPK(sltedKeyValue);
        QMDataBaseDInfo dataBaseDInfo = (QMDataBaseDInfo)this._ui.getBizInterface1().getValue((IObjectPK)objectPK);
        if (!dataBaseDInfo.getCU().getId().toString().equals(this.getCurrentCUID())) {
            this.checkDelPolicy(this.getCurrentCUID(), this._ui.getBizObjectType());
        }
    }

    protected void checkAddPolicy(String ctrlUnitPK, BOSObjectType objectType) throws BOSException, EASBizException {
        boolean flag;
        ICUBDControl iCUBDControl = CUBDControlFactory.getRemoteInstance();
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(objectType.toString(), ctrlUnitPK);
        boolean bl = flag = controlInfo == null ? false : controlInfo.isIsSubordinateAddnewable();
        if (!flag) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_ADD);
        }
    }

    protected void checkUpdatePolicy(String ctrlUnitPK, BOSObjectType objectType) throws BOSException, EASBizException {
        boolean flag;
        ICUBDControl iCUBDControl = CUBDControlFactory.getRemoteInstance();
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(objectType.toString(), ctrlUnitPK);
        boolean bl = flag = controlInfo == null ? false : controlInfo.isIsSubordinateEditable();
        if (!flag) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_UPDATE);
        }
    }

    protected void checkDelPolicy(String ctrlUnitPK, BOSObjectType objectType) throws BOSException, EASBizException {
        boolean flag;
        ICUBDControl iCUBDControl = CUBDControlFactory.getRemoteInstance();
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(objectType.toString(), ctrlUnitPK);
        boolean bl = flag = controlInfo == null ? false : controlInfo.isIsSubordinateDeletable();
        if (!flag) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE);
        }
    }
}

