/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.client.ccstrategy;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.framework.CUIDGetterFacadeFactory;
import com.kingdee.eas.basedata.framework.ICUIDGetterFacade;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.qm.common.client.ccstrategy.IQMControlModeUIProxy;
import com.kingdee.eas.qm.common.client.ccstrategy.QMClientControlStrategy;
import java.util.HashSet;

public class QMS4ClientControlStrategy
extends QMClientControlStrategy {
    public QMS4ClientControlStrategy(IQMControlModeUIProxy ui) {
        super(ui);
    }

    @Override
    public String getControlType() {
        return "S4";
    }

    @Override
    public FilterInfo getDefaultFilterForControlType() {
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        fic.add(new FilterItemInfo("CU.id", (Object)this.getCurrentCUID()));
        CtrlUnitInfo cui = SysContext.getSysContext().getCurrentCtrlUnit();
        String ln = cui.getLongNumber();
        String[] lnSecs = ln.split("!");
        int size = lnSecs.length;
        HashSet<String> lnUps = new HashSet<String>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < size - 1; ++i) {
            if (i != 0) {
                sb.append("!");
            }
            sb.append(lnSecs[i]);
            lnUps.add(sb.toString());
        }
        if (lnUps.size() != 0) {
            fic.add(new FilterItemInfo("CU.longNumber", lnUps, CompareType.INCLUDE));
            fi.setMaskString("#0 or #1");
        }
        return fi;
    }

    @Override
    public void checkCanAdd() throws Exception {
        this.checkPermission("ACTION_ADDNEW", null);
    }

    @Override
    public void checkCanUpdate(String sltedKeyValue) throws Exception {
        this.checkSIPermission("ACTION_MODIFY", sltedKeyValue);
    }

    @Override
    public void checkCanDelete(String sltedKeyValue) throws Exception {
        this.checkSIPermission("ACTION_DELETE", sltedKeyValue);
    }

    private void checkSIPermission(String action, String sltedKeyValue) throws Exception {
        this.checkPermission(action, this.getCUIDFromBizobject(sltedKeyValue));
    }

    private ICUIDGetterFacade getICGF() throws Exception {
        return CUIDGetterFacadeFactory.getRemoteInstance();
    }

    private String getCUIDFromBizobject(String sltedKeyValue) throws Exception {
        return this.getICGF().getCUID(sltedKeyValue);
    }
}

