/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.BOTPUtil;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.Container;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;

public final class QMClientVerifyUtils {
    private static String path = "com.kingdee.eas.fm.common.FMResource";
    private static String qmPath = "com.kingdee.eas.qm.common.COMMONAutoGenerateResource";
    private static final BigDecimal MAX_VALUE = new BigDecimal("9999999999999.99");

    public static void verifyInput(CoreUIObject ui, String resourcePath, KDTable kdtEntries, IRow row, int i, String msg) {
        if (EmptyUtil.isEmpty((Object)row.getCell(i).getValue())) {
            kdtEntries.getEditManager().editCellAt(row.getRowIndex(), i);
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)msg));
            SysUtil.abort();
        }
    }

    public static void verifyInput(CoreUIObject ui, KDTable kdtEntries, String key) {
        IRow row = null;
        for (int j = 0; j < kdtEntries.getRowCount(); ++j) {
            row = kdtEntries.getRow(j);
            QMClientVerifyUtils.verifyInput(ui, kdtEntries, row, key);
        }
    }

    public static void verifyInput(CoreUIObject ui, KDTable kdtEntries, String key, boolean ifEntries) {
        IRow row = null;
        for (int j = 0; j < kdtEntries.getRowCount(); ++j) {
            row = kdtEntries.getRow(j);
            if (ifEntries) {
                QMClientVerifyUtils.verifyInput(ui, kdtEntries, row, key, true);
                continue;
            }
            QMClientVerifyUtils.verifyInput(ui, kdtEntries, row, key);
        }
    }

    public static void verifyInput(CoreUIObject ui, KDTable kdtEntries, IRow row, String key) {
        int colIndex = kdtEntries.getColumnIndex(key);
        if (EmptyUtil.isEmpty((Object)row.getCell(key).getValue())) {
            kdtEntries.getEditManager().editCellAt(row.getRowIndex(), colIndex);
            String headValue = (String)kdtEntries.getHeadRow(0).getCell(key).getValue();
            String msg = EASResource.getString((String)qmPath, (String)"52_CanNotBeNull");
            MessageFormat mf = new MessageFormat(msg);
            String result = mf.format(new String[]{headValue});
            result = result.replaceAll("#", " " + headValue + " ");
            MsgBox.showWarning((Component)ui, (String)result);
            SysUtil.abort();
        }
    }

    public static void verifyInput(CoreUIObject ui, KDTable kdtEntries, IRow row, String key, boolean ifEntries) {
        int colIndex = kdtEntries.getColumnIndex(key);
        if (EmptyUtil.isEmpty((Object)row.getCell(key).getValue())) {
            kdtEntries.getEditManager().editCellAt(row.getRowIndex(), colIndex);
            String headValue = (String)kdtEntries.getHeadRow(0).getCell(key).getValue();
            String msg = EASResource.getString((String)qmPath, (String)"55_EntryCanNotBeNull");
            MessageFormat mf = new MessageFormat(msg);
            String result = mf.format(new String[]{headValue});
            result = result.replaceAll("#", " " + headValue + " ");
            MsgBox.showWarning((Component)ui, (String)result);
            SysUtil.abort();
        }
    }

    public static void verifyInputIsZero(CoreUIObject ui, KDTable kdtEntries, IRow row, String key) {
        int colIndex = kdtEntries.getColumnIndex(key);
        Object obj = row.getCell(key).getValue();
        if (!EmptyUtil.isEmpty((Object)obj) && obj instanceof BigDecimal && BOTPUtil.isZERO((BigDecimal)((BigDecimal)obj))) {
            kdtEntries.getEditManager().editCellAt(row.getRowIndex(), colIndex);
            String headValue = (String)kdtEntries.getHeadRow(0).getCell(key).getValue();
            String msg = EASResource.getString((String)qmPath, (String)"53_CanNotBeZero");
            MessageFormat mf = new MessageFormat(msg);
            String result = mf.format(new String[]{headValue});
            result = result.replaceAll("#", " " + headValue + " ");
            MsgBox.showWarning((Component)ui, (String)result);
            SysUtil.abort();
        }
    }

    public static void verifyInputIsMaxValue(CoreUIObject ui, KDTable kdtEntries, IRow row, String key) {
        int colIndex = kdtEntries.getColumnIndex(key);
        Object obj = row.getCell(key).getValue();
        if (!EmptyUtil.isEmpty((Object)obj) && obj instanceof BigDecimal && ((BigDecimal)obj).compareTo(MAX_VALUE) == 1) {
            kdtEntries.getEditManager().editCellAt(row.getRowIndex(), colIndex);
            String headValue = (String)kdtEntries.getHeadRow(0).getCell(key).getValue();
            String msg = EASResource.getString((String)qmPath, (String)"53_CanNotBeZero");
            MessageFormat mf = new MessageFormat(msg);
            String result = mf.format(new String[]{headValue});
            result = result.replaceAll("#", " " + headValue + " ");
            MsgBox.showWarning((Component)ui, (String)result);
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, KDTable kdtEntries) {
        if (kdtEntries == null || kdtEntries.getRowCount() < 1) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)path, (String)"EntryCanNotBeNull"));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDTextField txtNumber, String msg) {
        String txt = txtNumber.getText();
        if (txt == null || txt.trim().equals("")) {
            txtNumber.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)(resourcePath == null || msg == null ? QMClientVerifyUtils.getMessage((Component)txtNumber) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, KDTextField txtNumber) {
        QMClientVerifyUtils.verifyEmpty(ui, null, txtNumber, null);
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, JFormattedTextField txtField, String msg) {
        String txt = txtField.getText();
        if (txt == null || txt.trim().equals("")) {
            txtField.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)(resourcePath == null || msg == null ? QMClientVerifyUtils.getMessage(txtField) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, JFormattedTextField txtNumber) {
        QMClientVerifyUtils.verifyEmpty(ui, null, txtNumber, null);
    }

    public static String getMessage(Component component) {
        String text = QMClientVerifyUtils.getCompLabelText(component);
        String msg = EASResource.getString((String)qmPath, (String)"52_CanNotBeNull");
        MessageFormat mf = new MessageFormat(msg);
        return mf.format(new String[]{text});
    }

    private static String getCompLabelText(Component component) {
        Container cont2;
        Container cont;
        String text = "";
        if (component.getParent() instanceof KDLabelContainer) {
            text = ((KDLabelContainer)component.getParent()).getBoundLabelText();
        } else if (component instanceof KDTextArea && (cont = component.getParent()) != null && (cont2 = cont.getParent()) instanceof KDScrollPane && cont2.getParent() instanceof KDLabelContainer) {
            text = ((KDLabelContainer)cont2.getParent()).getBoundLabelText();
        }
        return text;
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDBizPromptBox bizBox, String msg) {
        Object content = bizBox.getData();
        if (content == null) {
            bizBox.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)(resourcePath == null || msg == null ? QMClientVerifyUtils.getMessage((Component)bizBox) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, KDBizPromptBox bizBox) {
        QMClientVerifyUtils.verifyEmpty(ui, null, bizBox, null);
    }

    public static void verifyEmpty(CoreUIObject ui, KDComboBox comboBox) {
        QMClientVerifyUtils.verifyEmpty(ui, null, comboBox, null);
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDMultiLangBox multLangBox, String msg) {
        Object content = multLangBox.getSelectedItem();
        if (content == null || content.toString().trim().length() <= 0) {
            multLangBox.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)(resourcePath == null || msg == null ? QMClientVerifyUtils.getMessage((Component)multLangBox) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, KDMultiLangBox multLangBox) {
        QMClientVerifyUtils.verifyEmpty(ui, null, multLangBox, null);
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDComboBox comboBox, String msg) {
        Object content = comboBox.getSelectedItem();
        if (content == null) {
            comboBox.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)(resourcePath == null || msg == null ? QMClientVerifyUtils.getMessage((Component)comboBox) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDDatePicker datePicker, String msg) {
        String content = datePicker.getText();
        if (content == null || content.equals("")) {
            datePicker.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)(resourcePath == null || msg == null ? QMClientVerifyUtils.getMessage((Component)datePicker) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, KDDatePicker datePicker) {
        QMClientVerifyUtils.verifyEmpty(ui, null, datePicker, null);
    }

    public static void verifyDateFromTo(CoreUIObject ui, String resourcePath, Date dateFrom, Date dateTo, String msg) {
        if ((dateFrom = DateTimeUtils.truncateDate((Date)dateFrom)).compareTo(dateTo = DateTimeUtils.truncateDate((Date)dateTo)) == 0) {
            dateTo = DateUtil.getNextDay((Date)dateTo);
        }
        if (dateFrom.compareTo(dateTo) > 0) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)msg));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDFormattedTextField txtNumber, String msg) {
        Number txt = txtNumber.getNumberValue();
        if (txt == null) {
            txtNumber.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)(resourcePath == null || msg == null ? QMClientVerifyUtils.getMessage((Component)txtNumber) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDTextArea txtArea, String msg) {
        String txt = txtArea.getText();
        if (txt == null || txt.trim().length() <= 0) {
            txtArea.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)(resourcePath == null || msg == null ? QMClientVerifyUtils.getMessage((Component)txtArea) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, KDTextArea txtArea, String name) {
        String txt = txtArea.getText();
        if (txt == null || txt.trim().length() <= 0) {
            txtArea.requestFocus(true);
            String msg = EASResource.getString((String)qmPath, (String)"52_CanNotBeNull");
            MessageFormat mf = new MessageFormat(msg);
            String result = mf.format(new String[]{name});
            MsgBox.showWarning((String)result);
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, KDTextArea txtArea) {
        QMClientVerifyUtils.verifyEmpty(ui, null, txtArea, null);
    }

    public static void verifyEmpty(CoreUIObject ui, KDFormattedTextField txtNumber) {
        QMClientVerifyUtils.verifyEmpty(ui, null, txtNumber, null);
    }

    public static void checkStringLength(Component ui, String resourcePath, IRow row, String colName, int length) {
        String name = (String)row.getCell(colName).getValue();
        if (name != null && name.length() > length) {
            String msg = EASResource.getString((String)qmPath, (String)"54_StringLengthGreaterthan");
            MessageFormat mf = new MessageFormat(msg);
            MsgBox.showWarning((Component)ui, (String)mf.format(new String[]{name, "" + length}));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, Object value, String msg) {
        if (EmptyUtil.isEmpty((Object)value)) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)msg));
            SysUtil.abort();
        }
    }

    public static void verifyNotNegtive(CoreUIObject ui, String resourcePath, BigDecimal value, String msg) {
        if (EmptyUtil.isEmpty((Object)value) || value.signum() < 0) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)msg));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, Object value, String msg, String ctrlName) {
        if (EmptyUtil.isEmpty((Object)value)) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)msg));
            QMClientVerifyUtils.setComponentFocus((JComponent)ui, ctrlName);
            SysUtil.abort();
        }
    }

    public static void setComponentFocus(JComponent ui, String componentName) {
        Component[] comps = ui.getComponents();
        if (comps != null && comps.length > 0) {
            for (int i = 0; i < comps.length; ++i) {
                if (comps[i] instanceof KDPanel || comps[i] instanceof KDScrollPane || comps[i] instanceof KDSplitPane || comps[i] instanceof KDTabbedPane || comps[i] instanceof KDLabelContainer || comps[i] instanceof KDContainer || comps[i] instanceof KDPanel || comps[i] instanceof JPanel) {
                    QMClientVerifyUtils.setComponentFocus((JComponent)comps[i], componentName);
                    continue;
                }
                if (comps[i] == null || comps[i].getName() == null || !comps[i].getName().equals(componentName)) continue;
                comps[i].requestFocus();
            }
        }
    }

    public static void verifyEmptyAndNoZero(CoreUIObject ui, String resourcePath, Object value, String msg) {
        if (value == null) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)msg));
            SysUtil.abort();
        }
        if (value instanceof BigDecimal && ((BigDecimal)value).compareTo(Constants.ZERO) == 0) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)msg));
            SysUtil.abort();
        }
    }

    public static void verifyEmptyAndNoZero(CoreUIObject ui, KDFormattedTextField txt) {
        QMClientVerifyUtils.verifyEmpty(ui, txt);
        BigDecimal value = txt.getBigDecimalValue();
        if (value.compareTo(Constants.ZERO) == 0) {
            txt.requestFocus(true);
            String msg = EASResource.getString((String)qmPath, (String)"53_CanNotBeZero");
            MessageFormat mf = new MessageFormat(msg);
            MsgBox.showWarning((Component)ui, (String)mf.format(new String[]{QMClientVerifyUtils.getCompLabelText((Component)txt)}));
            SysUtil.abort();
        }
    }

    public static void verifyBeginEndDateRel(CoreUIObject ui, Date beginDate, Date endDate) {
        if (beginDate != null && endDate != null && beginDate.after(endDate)) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)path, (String)"beginDateNotGreaterEndDate"));
            SysUtil.abort();
        }
    }

    public static void verifyBeginEndDateRel(CoreUIObject ui, KDDatePicker pkBeginDate, KDDatePicker pkEndDate) {
        if (pkBeginDate == null || pkEndDate == null) {
            return;
        }
        if (pkBeginDate.getValue() == null || pkEndDate.getValue() == null) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)path, (String)"pkDateIsNull"));
            SysUtil.abort();
        }
        Date beginDate = DateTimeUtils.truncateDate((Date)((Date)pkBeginDate.getValue()));
        Date endDate = DateTimeUtils.truncateDate((Date)((Date)pkEndDate.getValue()));
        QMClientVerifyUtils.verifyBeginEndDateRel(ui, beginDate, endDate);
    }

    public static void verifyAGreaterThanB(CoreUIObject ui, KDFormattedTextField txtA, KDFormattedTextField txtB) {
        QMClientVerifyUtils.verifyEmpty(ui, txtA);
        QMClientVerifyUtils.verifyEmpty(ui, txtB);
        BigDecimal a = txtA.getBigDecimalValue();
        BigDecimal b = txtB.getBigDecimalValue();
        if (a.compareTo(b) < 1) {
            txtA.requestFocus(true);
            String aText = QMClientVerifyUtils.getCompLabelText((Component)txtA);
            String bText = QMClientVerifyUtils.getCompLabelText((Component)txtB);
            String msg = MessageFormat.format(EASResource.getString((String)path, (String)"greaterThan"), aText, bText);
            MsgBox.showWarning((Component)ui, (String)msg);
            SysUtil.abort();
        }
    }

    public static void verifyAGreaterThanEqualsB(CoreUIObject ui, KDFormattedTextField txtA, KDFormattedTextField txtB) {
        QMClientVerifyUtils.verifyEmpty(ui, txtA);
        QMClientVerifyUtils.verifyEmpty(ui, txtB);
        BigDecimal a = txtA.getBigDecimalValue();
        BigDecimal b = txtB.getBigDecimalValue();
        if (a.compareTo(b) == -1) {
            txtA.requestFocus(true);
            String aText = QMClientVerifyUtils.getCompLabelText((Component)txtA);
            String bText = QMClientVerifyUtils.getCompLabelText((Component)txtB);
            String msg = MessageFormat.format(EASResource.getString((String)path, (String)"greaterThanEquals"), aText, bText);
            MsgBox.showWarning((Component)ui, (String)msg);
            SysUtil.abort();
        }
    }

    public static void verifyALesserThanEqualsB(CoreUIObject ui, KDFormattedTextField txtA, KDFormattedTextField txtB) {
        QMClientVerifyUtils.verifyEmpty(ui, txtA);
        QMClientVerifyUtils.verifyEmpty(ui, txtB);
        BigDecimal a = txtA.getBigDecimalValue();
        BigDecimal b = txtB.getBigDecimalValue();
        if (b.compareTo(a) == -1) {
            txtA.requestFocus(true);
            String aText = QMClientVerifyUtils.getCompLabelText((Component)txtA);
            String bText = QMClientVerifyUtils.getCompLabelText((Component)txtB);
            QMClientVerifyUtils.showMsg(ui, "lesserThanEquals", new Object[]{aText, bText});
        }
    }

    public static void verifyAEqualsB(CoreUIObject ui, KDBizPromptBox box1, KDBizPromptBox box2) {
        Object value1 = box1.getValue();
        Object value2 = box2.getValue();
        boolean isEquals = false;
        if (!EmptyUtil.isEmpty((Object)value1) && !EmptyUtil.isEmpty((Object)value2)) {
            if (value1 instanceof CoreBaseInfo && value2 instanceof CoreBaseInfo) {
                CoreBaseInfo info1 = (CoreBaseInfo)value1;
                CoreBaseInfo info2 = (CoreBaseInfo)value2;
                if (info1.getId().equals((Object)info2.getId())) {
                    isEquals = true;
                }
            }
            if (value1 instanceof String && value2 instanceof String && value1.equals(value2)) {
                isEquals = true;
            }
        }
        if (isEquals) {
            String txt1 = QMClientVerifyUtils.getCompLabelText((Component)box1);
            String txt2 = QMClientVerifyUtils.getCompLabelText((Component)box2);
            String msg = MessageFormat.format(EASResource.getString((String)path, (String)"cannotsame"), txt1, txt2);
            if (box1.isEnabled()) {
                box1.requestFocus();
            } else {
                box2.requestFocus();
            }
            MsgBox.showWarning((Component)ui, (String)msg);
            SysUtil.abort();
        }
    }

    private static void showMsg(CoreUIObject ui, String resName, Object[] text) {
        String msg = MessageFormat.format(EASResource.getString((String)path, (String)resName), text);
        MsgBox.showWarning((Component)ui, (String)msg);
        SysUtil.abort();
    }

    public static void verifyGreaterThan(CoreUIObject ui, KDFormattedTextField txt, BigDecimal num) {
        QMClientVerifyUtils.verifyEmpty(ui, txt);
        BigDecimal value = txt.getBigDecimalValue();
        if (value.compareTo(num) < 1) {
            txt.requestFocus(true);
            String Text = QMClientVerifyUtils.getCompLabelText((Component)txt);
            String msg = MessageFormat.format(EASResource.getString((String)path, (String)"greaterThan"), Text, num.toString());
            MsgBox.showWarning((Component)ui, (String)msg);
            SysUtil.abort();
        }
    }

    public static void verifyGreaterThanEqual(CoreUIObject ui, KDFormattedTextField txt, BigDecimal num) {
        QMClientVerifyUtils.verifyEmpty(ui, txt);
        BigDecimal value = txt.getBigDecimalValue();
        if (value.compareTo(num) == -1) {
            txt.requestFocus(true);
            String Text = QMClientVerifyUtils.getCompLabelText((Component)txt);
            String msg = MessageFormat.format(EASResource.getString((String)path, (String)"greaterThanEquals"), Text, num.toString());
            MsgBox.showWarning((Component)ui, (String)msg);
            SysUtil.abort();
        }
    }

    public static void verifyRequire(CoreUIObject ui) {
        Component[] comps = ui.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            Component comp = comps[i];
            if (comp instanceof KDLabelContainer) {
                KDTextField txtEditor;
                KDLabelContainer ct = (KDLabelContainer)comp;
                JComponent editor = ct.getBoundEditor();
                if (editor instanceof KDTextField) {
                    txtEditor = (KDTextField)editor;
                    if (!txtEditor.isRequired()) continue;
                    QMClientVerifyUtils.verifyEmpty(ui, txtEditor);
                    continue;
                }
                if (editor instanceof KDBizMultiLangBox) {
                    txtEditor = (KDBizMultiLangBox)editor;
                    if (!txtEditor.isRequired()) continue;
                    QMClientVerifyUtils.verifyEmpty(ui, (KDMultiLangBox)txtEditor);
                    continue;
                }
                if (editor instanceof KDComboBox) {
                    txtEditor = (KDComboBox)editor;
                    if (!txtEditor.isRequired()) continue;
                    QMClientVerifyUtils.verifyEmpty(ui, (KDComboBox)txtEditor);
                    continue;
                }
                if (editor instanceof KDDatePicker) {
                    txtEditor = (KDDatePicker)editor;
                    if (!txtEditor.isRequired()) continue;
                    QMClientVerifyUtils.verifyEmpty(ui, (KDDatePicker)txtEditor);
                    continue;
                }
                if (editor instanceof KDBizPromptBox) {
                    txtEditor = (KDBizPromptBox)editor;
                    if (!txtEditor.isRequired()) continue;
                    QMClientVerifyUtils.verifyEmpty(ui, (KDBizPromptBox)txtEditor);
                    continue;
                }
                if (!(editor instanceof KDFormattedTextField) || !(txtEditor = (KDFormattedTextField)editor).isRequired()) continue;
                QMClientVerifyUtils.verifyEmpty(ui, (KDFormattedTextField)txtEditor);
                continue;
            }
            if (!(comp instanceof KDPanel)) continue;
            QMClientVerifyUtils.verifyRequire(ui, (KDPanel)comp);
        }
    }

    public static void verifyRequire(CoreUIObject ui, KDPanel panel) {
        Component[] comps = panel.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            Component comp = comps[i];
            if (comp instanceof KDLabelContainer) {
                KDTextField txtEditor;
                KDLabelContainer ct = (KDLabelContainer)comp;
                JComponent editor = ct.getBoundEditor();
                if (editor instanceof KDTextField) {
                    txtEditor = (KDTextField)editor;
                    if (!txtEditor.isRequired()) continue;
                    QMClientVerifyUtils.verifyEmpty(ui, txtEditor);
                    continue;
                }
                if (editor instanceof KDBizMultiLangBox) {
                    txtEditor = (KDBizMultiLangBox)editor;
                    if (!txtEditor.isRequired()) continue;
                    QMClientVerifyUtils.verifyEmpty(ui, (KDMultiLangBox)txtEditor);
                    continue;
                }
                if (editor instanceof KDComboBox) {
                    txtEditor = (KDComboBox)editor;
                    if (!txtEditor.isRequired()) continue;
                    QMClientVerifyUtils.verifyEmpty(ui, (KDComboBox)txtEditor);
                    continue;
                }
                if (editor instanceof KDDatePicker) {
                    txtEditor = (KDDatePicker)editor;
                    if (!txtEditor.isRequired()) continue;
                    QMClientVerifyUtils.verifyEmpty(ui, (KDDatePicker)txtEditor);
                    continue;
                }
                if (editor instanceof KDBizPromptBox) {
                    txtEditor = (KDBizPromptBox)editor;
                    if (!txtEditor.isRequired()) continue;
                    QMClientVerifyUtils.verifyEmpty(ui, (KDBizPromptBox)txtEditor);
                    continue;
                }
                if (!(editor instanceof KDFormattedTextField) || !(txtEditor = (KDFormattedTextField)editor).isRequired()) continue;
                QMClientVerifyUtils.verifyEmpty(ui, (KDFormattedTextField)txtEditor);
                continue;
            }
            if (!(comp instanceof KDPanel)) continue;
            QMClientVerifyUtils.verifyRequire(ui, (KDPanel)comp);
        }
    }

    public static Set getAllComponents(Container container) {
        Component[] components = container.getComponents();
        HashSet<Component> compSet = new HashSet<Component>();
        for (Component comp : components) {
            compSet.add(comp);
            if (!(comp instanceof KDPanel) && !(comp instanceof KDScrollPane) && !(comp instanceof KDSplitPane) && !(comp instanceof KDTabbedPane) && !(comp instanceof KDLabelContainer) && !(comp instanceof KDContainer) && !(comp instanceof JPanel)) continue;
            compSet.addAll(QMClientVerifyUtils.getAllComponents((Container)comp));
        }
        return compSet;
    }

    public static void verifyUIControlEmpty(CoreUI ui) {
        Set allLeafComponents = QMClientVerifyUtils.getAllComponents((Container)ui);
        for (Component comp : allLeafComponents) {
            IKDTextComponent txtComp;
            if (!(comp instanceof IKDTextComponent) || !(txtComp = (IKDTextComponent)comp).isRequired()) continue;
            if (comp instanceof KDTextField) {
                QMClientVerifyUtils.verifyEmpty((CoreUIObject)ui, (KDTextField)comp);
                continue;
            }
            if (comp instanceof KDBizPromptBox) {
                QMClientVerifyUtils.verifyEmpty((CoreUIObject)ui, (KDBizPromptBox)comp);
                continue;
            }
            if (comp instanceof KDMultiLangBox) {
                QMClientVerifyUtils.verifyEmpty((CoreUIObject)ui, (KDMultiLangBox)comp);
                continue;
            }
            if (comp instanceof KDComboBox) {
                QMClientVerifyUtils.verifyEmpty((CoreUIObject)ui, (KDComboBox)comp);
                continue;
            }
            if (comp instanceof KDDatePicker) {
                QMClientVerifyUtils.verifyEmpty((CoreUIObject)ui, (KDDatePicker)comp);
                continue;
            }
            if (comp instanceof KDFormattedTextField) {
                QMClientVerifyUtils.verifyEmpty((CoreUIObject)ui, (KDFormattedTextField)comp);
                continue;
            }
            if (!(comp instanceof KDTextArea)) continue;
            QMClientVerifyUtils.verifyEmpty((CoreUIObject)ui, (KDTextArea)comp);
        }
    }

    public static boolean verifyEmptyXOR(Object a, Object b) {
        return !QMClientVerifyUtils.verifyEmptyOR(a, b);
    }

    public static boolean verifyEmptyXOR(Object a, Object b, Object c) {
        return !QMClientVerifyUtils.verifyEmptyOR(a, b, c);
    }

    public static boolean verifyEmptyOR(Object a, Object b) {
        return a == null && b == null || a != null && b != null;
    }

    public static boolean verifyEmptyOR(Object a, Object b, Object c) {
        return a == null && b == null && c == null || a != null && b != null && c != null;
    }

    public static void verifyRelateAccountBankAsCurrency(CoreUIObject ui, AccountBankInfo acctInfo, CurrencyInfo currency) throws EASBizException, BOSException {
        CurrencyInfo acctCurrency;
        MessageFormat mf;
        String msg;
        if (acctInfo == null) {
            msg = EASResource.getString((String)qmPath, (String)"52_CanNotBeNull");
            mf = new MessageFormat(msg);
            MsgBox.showWarning((Component)ui, (String)mf.format(new String[]{EASResource.getString((String)path, (String)"bankAccount")}));
            SysUtil.abort();
        }
        if (currency == null) {
            msg = EASResource.getString((String)qmPath, (String)"52_CanNotBeNull");
            mf = new MessageFormat(msg);
            MsgBox.showWarning((Component)ui, (String)mf.format(new String[]{EASResource.getString((String)path, (String)"currency")}));
            SysUtil.abort();
        }
        if ((acctCurrency = acctInfo.getCurrency()) == null || acctCurrency.getId() == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("currency.id"));
            sic.add(new SelectorItemInfo("currency.name"));
            sic.add(new SelectorItemInfo("currency.number"));
            acctInfo = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(acctInfo.getId()), sic);
            acctCurrency = acctInfo.getCurrency();
        }
        if (acctCurrency == null) {
            return;
        }
        if (!acctCurrency.getId().toString().equals(currency.getId().toString())) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)path, (String)"acctCurrencyNotBillCurrency"));
            SysUtil.abort();
        }
    }

    public static void verifyInputMax(CoreUIObject ui, KDFormattedTextField txtFiled) {
        BigDecimal val = txtFiled.getBigDecimalValue();
        if (val != null || MAX_VALUE.compareTo(val) < 0) {
            txtFiled.requestFocus(true);
            String msg = MessageFormat.format(EASResource.getString((String)path, (String)"lesserThanEquals"), txtFiled.getLabelContainer().getBoundLabelText(), MAX_VALUE);
            MsgBox.showWarning((Component)ui, (String)msg);
            SysUtil.abort();
        }
    }

    public static void verifyComboCurrency(CoreUIObject ui, KDComboBox comboCurrency) {
        if (comboCurrency == null || comboCurrency.getSelectedItem() == null || !(comboCurrency.getSelectedItem() instanceof CurrencyInfo)) {
            return;
        }
        CurrencyInfo currency = (CurrencyInfo)comboCurrency.getSelectedItem();
        if (DeletedStatusEnum.DELETED.equals((Object)currency.getDeletedStatus())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.qm.common.COMMONAutoGenerateResource", (String)"19_QMClientVerifyUtils"));
            SysUtil.abort();
        }
    }
}

