/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.client.verify;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.common.verify.AbstractVerifyItem;
import com.kingdee.eas.qm.common.verify.IVerifyItem;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JPanel;

public class UIControlEmptyVerifyItem
extends AbstractVerifyItem
implements IVerifyItem {
    private CoreUIObject ui = null;
    private static String path = "com.kingdee.eas.qm.common.COMMONAutoGenerateResource";

    public UIControlEmptyVerifyItem(CoreUIObject editUI) {
        this.ui = editUI;
    }

    public static void verifyInput(CoreUIObject ui, KDTable kdtEntries, String key) {
        IRow row = null;
        for (int j = 0; j < kdtEntries.getRowCount(); ++j) {
            row = kdtEntries.getRow(j);
            UIControlEmptyVerifyItem.verifyInput(ui, kdtEntries, row, key);
        }
    }

    public static void verifyInput(CoreUIObject ui, KDTable kdtEntries, IRow row, String key) {
        int colIndex = kdtEntries.getColumnIndex(key);
        if (EmptyUtil.isEmpty((Object)row.getCell(key).getValue()) && !row.getCell(key).getStyleAttributes().isLocked()) {
            kdtEntries.getEditManager().editCellAt(row.getRowIndex(), colIndex);
            String headValue = (String)kdtEntries.getHeadRow(0).getCell(key).getValue();
            String msg = EASResource.getString((String)path, (String)"52_CanNotBeNull");
            MessageFormat mf = new MessageFormat(msg);
            String result = mf.format(new String[]{headValue});
            result = result.replaceAll("#", " " + headValue + " ");
            MsgBox.showWarning((Component)ui, (String)result);
            SysUtil.abort();
        }
    }

    private void verifyUIControlEmpty(CoreUIObject ui) {
        Set allLeafComponents = this.getAllComponents((Container)ui);
        for (Component comp : allLeafComponents) {
            IKDTextComponent txtComp;
            if (comp instanceof KDTable) {
                KDTable tbl = (KDTable)comp;
                for (int i = 0; i < tbl.getColumnCount(); ++i) {
                    IColumn c = tbl.getColumn(i);
                    if (c.getStyleAttributes().isHided() || c.getStyleAttributes().isLocked() || !c.isRequired()) continue;
                    UIControlEmptyVerifyItem.verifyInput(ui, tbl, tbl.getColumnKey(i));
                }
            }
            if (!(comp instanceof IKDTextComponent) || !(txtComp = (IKDTextComponent)comp).isRequired() || !txtComp.isEnabled()) continue;
            if (comp instanceof KDTextField) {
                this.verifyEmpty(ui, (KDTextField)comp);
                continue;
            }
            if (comp instanceof KDBizPromptBox) {
                this.verifyEmpty(ui, (KDBizPromptBox)comp);
                continue;
            }
            if (comp instanceof KDMultiLangBox) {
                this.verifyEmpty(ui, (KDMultiLangBox)comp);
                continue;
            }
            if (comp instanceof KDComboBox) {
                this.verifyEmpty(ui, (KDComboBox)comp);
                continue;
            }
            if (comp instanceof KDDatePicker) {
                this.verifyEmpty(ui, (KDDatePicker)comp);
                continue;
            }
            if (comp instanceof KDFormattedTextField) {
                this.verifyEmpty(ui, (KDFormattedTextField)comp);
                continue;
            }
            if (!(comp instanceof KDTextArea)) continue;
            this.verifyEmpty(ui, (KDTextArea)comp);
        }
    }

    private void verifyEmpty(CoreUIObject ui, KDTextField txtNumber) {
        this.verifyEmpty(ui, null, txtNumber, null);
    }

    private Set getAllComponents(Container container) {
        Component[] components = container.getComponents();
        HashSet<Component> compSet = new HashSet<Component>();
        for (Component comp : components) {
            compSet.add(comp);
            if (!(comp instanceof KDPanel) && !(comp instanceof KDScrollPane) && !(comp instanceof KDSplitPane) && !(comp instanceof KDTabbedPane) && !(comp instanceof KDLabelContainer) && !(comp instanceof KDContainer) && !(comp instanceof JPanel)) continue;
            compSet.addAll(this.getAllComponents((Container)comp));
        }
        return compSet;
    }

    private void verifyEmpty(CoreUIObject ui, String resourcePath, KDBizPromptBox bizBox, String msg) {
        Object content = bizBox.getData();
        if (content == null) {
            bizBox.requestFocus();
            MsgBox.showWarning((Component)ui, (String)(resourcePath == null || msg == null ? this.getMessage((Component)bizBox) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    private void verifyEmpty(CoreUIObject ui, KDBizPromptBox bizBox) {
        this.verifyEmpty(ui, null, bizBox, null);
    }

    private void verifyEmpty(CoreUIObject ui, KDComboBox comboBox) {
        this.verifyEmpty(ui, null, comboBox, null);
    }

    private void verifyEmpty(CoreUIObject ui, String resourcePath, KDMultiLangBox multLangBox, String msg) {
        Object content = multLangBox.getSelectedItem();
        if (content == null || content.toString().trim().length() <= 0) {
            multLangBox.requestFocus();
            MsgBox.showWarning((Component)ui, (String)(resourcePath == null || msg == null ? this.getMessage((Component)multLangBox) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    private void verifyEmpty(CoreUIObject ui, KDMultiLangBox multLangBox) {
        this.verifyEmpty(ui, null, multLangBox, null);
    }

    private void verifyEmpty(CoreUIObject ui, String resourcePath, KDComboBox comboBox, String msg) {
        Object content = comboBox.getSelectedItem();
        if (content == null) {
            comboBox.requestFocus();
            MsgBox.showWarning((Component)ui, (String)(resourcePath == null || msg == null ? this.getMessage((Component)comboBox) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    private void verifyEmpty(CoreUIObject ui, String resourcePath, KDDatePicker datePicker, String msg) {
        String content = datePicker.getText();
        if (content == null || content.equals("")) {
            datePicker.requestFocus();
            MsgBox.showWarning((Component)ui, (String)(resourcePath == null || msg == null ? this.getMessage((Component)datePicker) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    private void verifyEmpty(CoreUIObject ui, KDDatePicker datePicker) {
        this.verifyEmpty(ui, null, datePicker, null);
    }

    private String getMessage(Component component) {
        String text = this.getCompLabelText(component);
        String msg = EASResource.getString((String)path, (String)"52_CanNotBeNull");
        MessageFormat mf = new MessageFormat(msg);
        return mf.format(new String[]{text});
    }

    private String getCompLabelText(Component component) {
        Container cont2;
        Container cont;
        String text = "";
        Container parent = component.getParent();
        if (parent instanceof KDLabelContainer) {
            text = ((KDLabelContainer)parent).getBoundLabelText();
        } else if (component instanceof KDTextArea && (cont = parent) != null && (cont2 = cont.getParent()) instanceof KDScrollPane && cont2.getParent() instanceof KDLabelContainer) {
            text = ((KDLabelContainer)cont2.getParent()).getBoundLabelText();
        }
        return text;
    }

    private void verifyEmpty(CoreUIObject ui, String resourcePath, KDFormattedTextField txtNumber, String msg) {
        Number txt = txtNumber.getNumberValue();
        if (txt == null) {
            txtNumber.requestFocus();
            MsgBox.showWarning((Component)ui, (String)(resourcePath == null || msg == null ? this.getMessage((Component)txtNumber) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    private void verifyEmpty(CoreUIObject ui, String resourcePath, KDTextArea txtArea, String msg) {
        String txt = txtArea.getText();
        if (txt == null || txt.trim().length() <= 0) {
            txtArea.requestFocus();
            MsgBox.showWarning((Component)ui, (String)(resourcePath == null || msg == null ? this.getMessage((Component)txtArea) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    private void verifyEmpty(CoreUIObject ui, KDTextArea txtArea) {
        this.verifyEmpty(ui, null, txtArea, null);
    }

    private void verifyEmpty(CoreUIObject ui, KDFormattedTextField txtNumber) {
        this.verifyEmpty(ui, null, txtNumber, null);
    }

    private void verifyEmpty(CoreUIObject ui, String resourcePath, KDTextField txtNumber, String msg) {
        String txt = txtNumber.getText();
        if (txt == null || txt.trim().equals("")) {
            txtNumber.requestFocus();
            MsgBox.showWarning((Component)ui, (String)(resourcePath == null || msg == null ? this.getMessage((Component)txtNumber) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    @Override
    public boolean verify() throws EASBizException, BOSException {
        this.verifyUIControlEmpty(this.ui);
        return true;
    }
}

