/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.codingrule;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.common.QMCodingRuleManageFacadeFactory;
import com.kingdee.eas.qm.common.codingrule.QMCodingRuleData;
import java.util.Hashtable;
import java.util.Map;

public class ClientCodingRuleStrategy {
    private Map codingRuleDataCache = new Hashtable();

    public void processCodingRuleNumber(Context context, KDTextField txtNumber, IObjectValue bizObject, String orgId) throws EASBizException, BOSException {
        if (txtNumber == null) {
            return;
        }
        QMCodingRuleData codingRuleData = this.getCodingRuleData(context, bizObject, orgId);
        bizObject.put("codingRuleData", (Object)codingRuleData);
        if (codingRuleData.isExistRule()) {
            txtNumber.putClientProperty((Object)"checkAuthority", (Object)new Boolean(false));
            if (codingRuleData.isUseIntermitNumber()) {
                txtNumber.setEnabled(false);
                txtNumber.setText("");
                bizObject.setString("number", "");
            } else if (codingRuleData.isAddView() && !codingRuleData.isModifable()) {
                txtNumber.setEnabled(false);
                ICodingRuleManager iCrm = CodingRuleManagerFactory.getRemoteInstanceWithObjectContext((Context)context);
                String number = iCrm.getNumber(bizObject, orgId);
                bizObject.setString("number", number);
                txtNumber.setText(number);
            } else if (codingRuleData.isAddView() && codingRuleData.isModifable()) {
                txtNumber.setEnabled(true);
                ICodingRuleManager iCrm = CodingRuleManagerFactory.getRemoteInstanceWithObjectContext((Context)context);
                String number = iCrm.readNumber(bizObject, orgId);
                bizObject.setString("number", number);
                bizObject.setString("oldNumber", number);
                txtNumber.setText(number);
            } else if (codingRuleData.isAddView() && !codingRuleData.isUseIntermitNumber()) {
                txtNumber.setEnabled(false);
                ICodingRuleManager iCrm = CodingRuleManagerFactory.getRemoteInstanceWithObjectContext((Context)context);
                String number = iCrm.readNumber(bizObject, orgId);
                bizObject.setString("number", number);
                txtNumber.setText(number);
            } else if (!codingRuleData.isAddView()) {
                txtNumber.setEnabled(false);
                txtNumber.setText("");
                bizObject.setString("number", "");
            }
        } else {
            txtNumber.setEnabled(true);
            txtNumber.setText("");
            bizObject.setString("number", "");
        }
    }

    public void processEditCodingRuleNumber(Context context, KDTextField txtNumber, AbstractObjectValue bizObject, String orgId) throws EASBizException, BOSException {
        QMCodingRuleData codingRuleData = this.getCodingRuleData(context, (IObjectValue)bizObject, orgId);
        boolean old = bizObject.isSyncOldValue();
        bizObject.setSyncOldValue(true);
        bizObject.put("codingRuleData", (Object)codingRuleData);
        bizObject.setSyncOldValue(old);
        if (codingRuleData.isExistRule()) {
            if (codingRuleData.isModifable()) {
                txtNumber.setEnabled(true);
                String number = bizObject.getString("number");
                bizObject.setString("oldNumber", number);
            } else {
                txtNumber.setEnabled(false);
            }
        }
    }

    public QMCodingRuleData getCodingRuleData(Context context, IObjectValue bizObject, String orgId) throws EASBizException, BOSException {
        if (bizObject == null) {
            return null;
        }
        String key = bizObject.getBOSType() + orgId;
        QMCodingRuleData data = (QMCodingRuleData)this.codingRuleDataCache.get(key);
        if (data != null) {
            return data;
        }
        data = QMCodingRuleManageFacadeFactory.getRemoteInstanceWithObjectContext(context).getCodingRuleData(bizObject, orgId);
        this.codingRuleDataCache.put(key, data);
        return data;
    }

    public void setNumberFieldEnableStatus(Context context, KDTextField txtNumber, IObjectValue bizObject, String orgId) throws EASBizException, BOSException {
        QMCodingRuleData codingRuleData = this.getCodingRuleData(context, bizObject, orgId);
        if (codingRuleData == null || !codingRuleData.isExistRule()) {
            return;
        }
        if (codingRuleData.isModifable()) {
            txtNumber.setEnabled(true);
        } else {
            txtNumber.setEnabled(false);
        }
    }
}

