/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.datatask;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.qm.common.util.QMConstant;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class QMBaseDataTransmission
extends AbstractDataTransmission {
    private Boolean importDataByRule = null;
    private static final String resourceDir = "com.kingdee.eas.qm.common.COMMONAutoGenerateResource";
    private Map cache_info = new HashMap();

    protected abstract CoreBaseInfo createNewInfo(Hashtable var1, Context var2);

    protected abstract ICoreBase getBizController(Context var1) throws EASBizException, BOSException;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return this.getBizController(ctx);
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    protected abstract CoreBaseInfo getInfoByNumber(Hashtable var1, Context var2, String var3) throws BOSException, EASBizException;

    protected CoreBaseInfo innerTransmit(Hashtable hsData, Context ctx) throws EASBizException, BOSException {
        String number = this.getDataString(hsData, "FNumber");
        CoreBaseInfo info = null;
        if (number != null && number.trim().length() > 0 && this.isSltImportUpdate() && (info = this.getInfoByNumber(hsData, ctx, number)) != null) {
            this.setUpdateValue(hsData, ctx, info);
        }
        if (info == null) {
            info = this.createNewInfo(hsData, ctx);
            this.setAllValue(hsData, ctx, info);
            if (this.isImportDataByRule(ctx)) {
                info.setString("number", null);
            }
        }
        return info;
    }

    protected boolean isImportDataByRule(Context ctx) throws EASBizException, BOSException {
        if (this.importDataByRule == null) {
            this.importDataByRule = DataImportUtils.getImportParamBooleanObject((Context)ctx);
        }
        return this.importDataByRule;
    }

    public abstract void setAllValue(Hashtable var1, Context var2, CoreBaseInfo var3) throws BOSException, EASBizException;

    public abstract void setUpdateValue(Hashtable var1, Context var2, CoreBaseInfo var3) throws BOSException, EASBizException;

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        try {
            return this.innerTransmit(hsData, ctx);
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    protected String getDataString(Hashtable hsData, String key) {
        DataToken dataToken = (DataToken)hsData.get(key);
        if (dataToken == null) {
            return null;
        }
        String number = (String)dataToken.data;
        return number;
    }

    public static int getDataInt(Hashtable hsData, String fieldName) {
        Object o = ((DataToken)hsData.get((Object)fieldName)).data;
        if (o == null) {
            return 0;
        }
        String str = o.toString();
        if (str == null || "".equals(str)) {
            return 0;
        }
        return new Integer(str);
    }

    protected void setString(Hashtable hsData, CoreBaseInfo info, String string, String key) {
        String str = this.getDataString(hsData, key);
        info.setString(string, str);
    }

    protected void setIntEnum(Hashtable hsData, CoreBaseInfo info, List enums, String string, String key) {
        String str = this.getDataString(hsData, key);
        if (StringUtil.isEmptyString((String)str)) {
            return;
        }
        boolean isNumber = this.isIntFormat(str);
        int b = 0;
        if (isNumber) {
            b = Integer.parseInt(str);
        }
        int value = 0;
        for (int i = 0; i < enums.size(); ++i) {
            IntEnum o = (IntEnum)enums.get(i);
            if (!isNumber) {
                if (!o.getAlias().equals(str)) continue;
                value = o.getValue();
                info.setInt(string, value);
                return;
            }
            if (o.getValue() != b) continue;
            value = o.getValue();
            info.setInt(string, value);
            return;
        }
    }

    private boolean isIntFormat(String str) {
        boolean isNumber = true;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '0' && c <= '9') continue;
            isNumber = false;
            break;
        }
        return isNumber;
    }

    protected void setStringEnum(Hashtable hsData, CoreBaseInfo info, List enums, String string, String key) {
        String str = this.getDataString(hsData, key);
        if (StringUtil.isEmptyString((String)str)) {
            return;
        }
        String value = null;
        for (int i = 0; i < enums.size(); ++i) {
            StringEnum o = (StringEnum)enums.get(i);
            if (!o.getAlias().equals(str) && !o.getValue().equals(str)) continue;
            value = o.getValue();
            info.setString(string, value);
            return;
        }
    }

    protected void setInt(Hashtable hsData, CoreBaseInfo info, String string, String key) {
        int str = QMBaseDataTransmission.getDataInt(hsData, key);
        info.setInt(string, str);
    }

    protected void setBoolean(Hashtable hsData, CoreBaseInfo info, String string, String key) {
        boolean str = this.getDataboolean(hsData, key);
        info.setBoolean(string, str);
    }

    protected void setInfo(Hashtable hsData, CoreBaseInfo info, ICoreBase biz, Context ctx, String string, String key) throws BOSException {
        String number = this.getDataString(hsData, key);
        if (number == null || number.trim().length() == 0) {
            return;
        }
        CoreBaseInfo voInfo = this.getInfoByNumber(hsData, biz, ctx, number);
        info.put(string, (Object)voInfo);
    }

    public Map getCache() {
        return this.cache_info;
    }

    public CoreBaseInfo getInfoByNumber(Hashtable hsData, ICoreBase biz, Context ctx, String number) throws BOSException {
        if (biz == null) {
            return null;
        }
        if (number == null || number.trim().length() == 0) {
            return null;
        }
        String ckey = biz.getType() + number;
        if (this.cache_info.get(ckey) != null) {
            return (CoreBaseInfo)this.cache_info.get(ckey);
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        ev.setFilter(filter);
        CoreBaseCollection coll = biz.getCollection(ev);
        CoreBaseInfo voInfo = null;
        if (coll == null || coll.size() == 0) {
            BOSObjectType type = biz.getType();
            EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(type);
            String msg = ResourceBase.getString((String)resourceDir, (String)"22_QMBaseDataTransmission", (Locale)ContextUtils.getLocaleFromEnv());
            MessageFormat mf = new MessageFormat(msg);
            throw new BOSException(mf.format(new String[]{number + entity.getAlias()}));
        }
        if (coll.size() == 1) {
            voInfo = coll.get(0);
        }
        if (coll.size() > 1) {
            BOSObjectType type = biz.getType();
            EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(type);
            String msg = ResourceBase.getString((String)resourceDir, (String)"24_QMBaseDataTransmission", (Locale)ContextUtils.getLocaleFromEnv());
            MessageFormat mf = new MessageFormat(msg);
            throw new BOSException(mf.format(new String[]{entity.getAlias(), number, entity.getAlias()}));
        }
        this.cache_info.put(ckey, voInfo);
        return voInfo;
    }

    public Date getDataDate(Hashtable hsData, String fieldName) throws Exception {
        Object o = ((DataToken)hsData.get((Object)fieldName)).data;
        if (o == null) {
            return null;
        }
        String str = o.toString();
        if (str == null || "".equals(str)) {
            return null;
        }
        return TypeConversionUtils.objToDate((Object)str);
    }

    public static BigDecimal getDataBigDecimal(Hashtable hsData, String fieldName) {
        Object o = ((DataToken)hsData.get((Object)fieldName)).data;
        if (o == null) {
            return null;
        }
        String str = o.toString();
        if (str == null || "".equals(str)) {
            return null;
        }
        return new BigDecimal(str);
    }

    public boolean getDataboolean(Hashtable hsData, String fieldName) {
        Object o = ((DataToken)hsData.get((Object)fieldName)).data;
        if (o == null) {
            return false;
        }
        String str = o.toString();
        if (str == null || "".equals(str)) {
            return false;
        }
        return str.equalsIgnoreCase("Y") || str.equals("1") || str.equalsIgnoreCase("true") || str.equals(ResourceBase.getString((String)resourceDir, (String)"27_QMBaseDataTransmission", (Locale)ContextUtils.getLocaleFromEnv()));
    }

    protected void setMultiLanProperty(Hashtable hsData, CoreBaseInfo info, String propertyName, String tableColumnName) {
        String str = this.getDataString(hsData, tableColumnName + "l2".toLowerCase());
        info.put(propertyName, (Object)str, new Locale("l2"));
        str = this.getDataString(hsData, tableColumnName + "l3".toLowerCase());
        info.put(propertyName, (Object)str, new Locale("l3"));
        str = this.getDataString(hsData, tableColumnName + "l1".toLowerCase());
        info.put(propertyName, (Object)str, new Locale("l1"));
    }

    protected void putTable(Hashtable htable, Object key, Object value) {
        if (value != null) {
            htable.put(key, value);
        }
    }

    protected void putMultiLanString(IRowSet rs, Context ctx, Hashtable result, String rsColumnName, String tableColumnName) throws SQLException {
        String multiName = tableColumnName + LocaleUtils.getLocaleString((Locale)ctx.getLocale()).toLowerCase();
        this.putTable(result, multiName, rs.getString(rsColumnName));
    }

    protected void putString(IRowSet rs, Hashtable result, String rsColumnName, String tableColumnName) throws SQLException {
        this.putTable(result, tableColumnName, rs.getString(rsColumnName));
    }

    protected void putBoolean(IRowSet rs, Hashtable result, String rsColumnName, String tableColumnName) throws SQLException {
        int i = rs.getInt(rsColumnName);
        String value = null;
        value = i != 0 ? "true" : "false";
        this.putTable(result, tableColumnName, value);
    }

    protected void putInt(IRowSet rs, Hashtable result, String rsColumnName, String tableColumnName) throws SQLException {
        this.putTable(result, tableColumnName, String.valueOf(rs.getInt(rsColumnName)));
    }

    protected void putBigDecimal(IRowSet rs, Hashtable result, String rsColumnName, String tableColumnName) throws SQLException {
        this.putTable(result, tableColumnName, QMConstant.FORMAT_DECIMAL.format(rs.getBigDecimal(rsColumnName)));
    }

    protected void putIntEnum(IRowSet rs, Hashtable result, List list, String rsColumnName, String tableColumnName) throws SQLException {
        int int1 = rs.getInt(rsColumnName);
        String value = null;
        for (int i = 0; i < list.size(); ++i) {
            IntEnum o = (IntEnum)list.get(i);
            if (o.getValue() != int1) continue;
            value = o.getAlias();
        }
        this.putTable(result, tableColumnName, value);
    }

    protected void putStringEnum(IRowSet rs, Hashtable result, List list, String rsColumnName, String tableColumnName) throws SQLException {
        String int1 = rs.getString(rsColumnName);
        String value = null;
        for (int i = 0; i < list.size(); ++i) {
            StringEnum o = (StringEnum)list.get(i);
            if (!o.getValue().equals(int1)) continue;
            value = o.getAlias();
        }
        this.putTable(result, tableColumnName, value);
    }

    protected void putDate(IRowSet rs, Hashtable result, String rsColumnName, String tableColumnName) throws SQLException {
        Date date = rs.getDate(rsColumnName);
        if (date != null) {
            this.putTable(result, tableColumnName, QMConstant.getFormatDay().format(date));
        }
    }

    protected void putTimestamp(IRowSet rs, Hashtable result, String rsColumnName, String tableColumnName) throws SQLException {
        Timestamp date = rs.getTimestamp(rsColumnName);
        if (date != null) {
            this.putTable(result, tableColumnName, QMConstant.getFormatTime().format(date));
        }
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return super.getExportFilterForQuery(ctx);
    }

    public String getExportQueryInfo(Context ctx) {
        return null;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            this.innerSubmit(coreBaseInfo, ctx);
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public void innerSubmit(CoreBaseInfo coreBaseInfo, Context ctx) throws BOSException, EASBizException, TaskExternalException {
        coreBaseInfo.put("isImport", (Object)"true");
        this.getController(ctx).submit(coreBaseInfo);
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        try {
            return this.innerExportTransmit(rs, ctx);
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public Map innerExportTransmit(IRowSet rs, Context ctx) throws BOSException, EASBizException, TaskExternalException, SQLException {
        return super.exportTransmit(rs, ctx);
    }
}

