/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.filter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.qm.common.filter.SingleFilterRptElement;
import com.kingdee.eas.util.SysUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class F7FilterRptElement
extends SingleFilterRptElement {
    private static Logger logger = Logger.getLogger((String)F7FilterRptElement.class.getName());
    private KDBizPromptBox component = null;
    boolean isMutilSelect = false;
    private Set keySet = new HashSet(){
        private static final long serialVersionUID = -1135408193304454076L;
        {
            this.add("id");
            this.add("number");
            this.add("name");
        }
    };

    public F7FilterRptElement(String id, KDBizPromptBox component) {
        super(id, (Component)component);
        this.component = component;
        this.checkVOClassType();
        this.isMutilSelect = this.component.isEnabledMultiSelection();
    }

    public void putVOKey(String key) {
        this.keySet.add(key);
    }

    private void checkVOClassType() {
        if (this.component == null) {
            throw new IllegalArgumentException("Error f7 component!");
        }
    }

    public String getValue() {
        String value = "";
        try {
            value = this.packageVOInfo();
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return value;
    }

    @Override
    public void addCustomerParam(CustomerParams cp, String key, Object obj) {
        super.addCustomerParam(cp, key, obj);
        String str = this.getValue();
        cp.addCustomerParam(key + "@", str);
    }

    public void setElementValue(CustomerParams cp) {
        super.setElementValue(cp);
        if (cp.getCustomerParam(this.getId()) != null) {
            String o = cp.getCustomerParam(this.getId() + "@");
            try {
                this.setValue(o);
            }
            catch (Exception e) {
                logger.error((Object)e);
                SysUtil.abort();
            }
        }
    }

    public void setValue(String o) throws Exception {
        this.checkVOClassType();
        Object dataObj = this.parserVOInfo(o);
        if (dataObj instanceof Object[] && !this.isMutilSelect) {
            dataObj = ((Object[])dataObj)[0];
        }
        this.component.setData(dataObj);
    }

    private String packageVOInfo() throws BOSException {
        int endIndex;
        int beginIndex;
        Object objData = this.component.getData();
        if (objData == null) {
            return null;
        }
        if (this.component.getDisplayFormatter() != null && !this.component.getDisplayFormatter().toString().equalsIgnoreCase("$name$")) {
            String displayFormatterStr = this.component.getDisplayFormatter().toString();
            beginIndex = displayFormatterStr.indexOf("$");
            endIndex = displayFormatterStr.indexOf(".");
            if (endIndex > beginIndex) {
                displayFormatterStr = displayFormatterStr.substring(beginIndex + 1, endIndex);
                this.keySet.add(displayFormatterStr);
            }
        }
        if (this.component.getEditFormatter() != null && !this.component.getEditFormatter().toString().equalsIgnoreCase("$number$")) {
            String editFormatterStr = this.component.getEditFormatter().toString();
            beginIndex = editFormatterStr.indexOf("$");
            endIndex = editFormatterStr.indexOf(".");
            if (endIndex > beginIndex) {
                editFormatterStr = editFormatterStr.substring(beginIndex + 1, endIndex);
                this.keySet.add(editFormatterStr);
            }
        }
        Object[] rsObjs = null;
        if (objData instanceof Object[]) {
            rsObjs = (Object[])objData;
            for (int i = 0; i < rsObjs.length; ++i) {
                if (rsObjs[i] instanceof IObjectValue) continue;
                throw new IllegalArgumentException("Error vo class type,must IObjectValue or the sub class!");
            }
        } else if (objData instanceof IObjectValue) {
            rsObjs = new Object[]{objData};
        } else {
            throw new IllegalArgumentException("Error vo class type,must IObjectValue or the sub class!");
        }
        StringBuffer rs = new StringBuffer();
        for (int i = 0; i < rsObjs.length; ++i) {
            IObjectValue tempObj = (IObjectValue)rsObjs[i];
            String dataType = tempObj.getClass().getName();
            for (String key : this.keySet) {
                Object tempData = tempObj.get(key);
                String value = "";
                if (tempData != null) {
                    String subInfo;
                    value = tempData instanceof IObjectValue ? (subInfo = this.convertSubIObjctValueToString((IObjectValue)tempData)) : tempData.toString();
                }
                rs.append("" + key + "//=" + value + "//;");
            }
            rs.append("dataType//=" + dataType + "//;");
            rs.append("//|");
        }
        return rs.toString();
    }

    private String convertSubIObjctValueToString(IObjectValue tempObj) {
        StringBuffer rs = new StringBuffer();
        String dataType = tempObj.getClass().getName();
        HashSet<String> subKeySet = new HashSet<String>();
        subKeySet.add("id");
        subKeySet.add("number");
        subKeySet.add("name");
        for (String key : subKeySet) {
            Object tempData = tempObj.get(key);
            String value = "";
            if (tempData != null) {
                value = tempData.toString();
            }
            rs.append("" + key + "//@=" + value + "//@;");
        }
        rs.append("dataType//@=" + dataType + "//@;");
        return rs.toString();
    }

    private Object parserVOInfo(String obj) throws BOSException {
        if (StringUtil.isEmptyString((String)obj)) {
            return null;
        }
        Map[] maps = this.convertToMap(obj);
        ArrayList<IObjectValue> objectList = new ArrayList<IObjectValue>();
        for (int i = 0; i < maps.length; ++i) {
            Map tempMap = maps[i];
            String dataType = (String)tempMap.get("dataType");
            IObjectValue objValue = null;
            try {
                objValue = (IObjectValue)Class.forName(dataType).newInstance();
            }
            catch (Throwable e) {
                throw new BOSException(e);
            }
            for (Map.Entry entry : tempMap.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if ("dataType".equals(key)) continue;
                objValue.put(key, value);
            }
            objectList.add(objValue);
        }
        Object[] objs = objectList.toArray(new Object[objectList.size()]);
        return objs;
    }

    private Map[] convertToMap(String obj) throws BOSException {
        ArrayList mapList = new ArrayList();
        String[] strs = obj.split("//\\|");
        for (int i = 0; i < strs.length; ++i) {
            HashMap<String, String> map = new HashMap<String, String>();
            String str = strs[i];
            String[] kvs = str.split("//\\;");
            for (int k = 0; k < kvs.length; ++k) {
                String kv = kvs[k];
                String[] infos = kv.split("//\\=");
                if (infos.length != 2) continue;
                String key = infos[0];
                Object value = infos[1];
                if (((String)value).indexOf("dataType") != -1) {
                    value = this.convertSubStringToInfo((String)value);
                }
                map.put(key, (String)value);
            }
            mapList.add(map);
        }
        Map[] maps = mapList.toArray(new Map[mapList.size()]);
        return maps;
    }

    private Object convertSubStringToInfo(String subobj) throws BOSException {
        Map[] maps = this.convertSubStringToMap(subobj);
        IObjectValue objValue = null;
        for (int i = 0; i < maps.length; ++i) {
            Map tempMap = maps[i];
            String dataType = (String)tempMap.get("dataType");
            try {
                objValue = (IObjectValue)Class.forName(dataType).newInstance();
            }
            catch (Throwable e) {
                throw new BOSException(e);
            }
            for (Map.Entry entry : tempMap.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if ("dataType".equals(key)) continue;
                objValue.put(key, value);
            }
        }
        return objValue;
    }

    private Map[] convertSubStringToMap(String subobj) {
        ArrayList mapList = new ArrayList();
        HashMap<String, String> map = new HashMap<String, String>();
        String str = subobj;
        String[] kvs = str.split("//\\@\\;");
        for (int k = 0; k < kvs.length; ++k) {
            String kv = kvs[k];
            String[] infos = kv.split("//\\@\\=");
            if (infos.length != 2) continue;
            String key = infos[0];
            String value = infos[1];
            if (!(value instanceof String) || value.indexOf("dataType") != -1) {
                // empty if block
            }
            map.put(key, value);
        }
        mapList.add(map);
        Map[] maps = mapList.toArray(new Map[mapList.size()]);
        return maps;
    }
}

