/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.print;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class QMTDHelper {
    public static final String resPath = "com.kingdee.eas.qm.common.QMResource";
    public static final String print_resPath = "com.kingdee.eas.basedata.assistant.PrintIntegrationResource";
    public static final String LogItem_QMTDPrint = "QMTDPrint";
    public static final String MethodName_QMTDPrint = "actionTDPrint";

    public static String getMsg(String key, Object[] objs) {
        return QMTDHelper.getMsg(key, resPath, objs);
    }

    public static String getMsg(String key, String path, Object[] objs) {
        String msg = EASResource.getString((String)path, (String)key);
        if (objs != null && objs.length > 0) {
            msg = MessageFormat.format(msg, objs);
        }
        return msg;
    }

    public static void processTDResultInfoForEditUI(CoreUI ui, String billNumber, Map printedErrorMap, Map willPrintedErrorMap) {
        int errorPrintCount = printedErrorMap.size() + willPrintedErrorMap.size();
        if (errorPrintCount > 0) {
            StringBuffer detailMsg = new StringBuffer();
            detailMsg.append(QMTDHelper.buildDetailPrintInfoForEditUI(billNumber, printedErrorMap.entrySet().iterator(), 1));
            detailMsg.append(QMTDHelper.buildDetailPrintInfoForEditUI(billNumber, willPrintedErrorMap.entrySet().iterator(), 2));
            MsgBox.showWarning((Component)ui, (String)detailMsg.toString());
        }
    }

    public static String buildDetailPrintInfoForEditUI(String billNumber, Iterator it, int type) {
        StringBuffer detailMsg = new StringBuffer();
        while (it.hasNext()) {
            if (type != 1 && type != 2) continue;
            Map.Entry entry = (Map.Entry)it.next();
            String errorInfo = (String)entry.getValue();
            String[] errMsgs = errorInfo.split("#");
            if (type == 1) {
                detailMsg.append(QMTDHelper.getMsg("pi.controlinfo1", print_resPath, new Object[]{billNumber, errMsgs[2], errMsgs[0], errMsgs[1]}) + "\n");
                continue;
            }
            detailMsg.append(QMTDHelper.getMsg("pi.controlinfo2", print_resPath, new Object[]{billNumber, errMsgs[2], errMsgs[0], errMsgs[1]}) + "\n");
        }
        return detailMsg.toString();
    }

    public static void processTDResultInfoForListUI(CoreUI ui, KDTable tblMain, String keyField, String billNumberField, int totalPrintCount, int beforePrintCount, List checkErrorList, Map printedErrorMap, Map willPrintedErrorMap) {
        int afterPrintCount = beforePrintCount - printedErrorMap.size() - willPrintedErrorMap.size();
        int errorPrintCount = printedErrorMap.size() + willPrintedErrorMap.size() + checkErrorList.size();
        if (errorPrintCount > 0) {
            String titleMsg = QMTDHelper.getMsg("List_PrintResultInfoTitle", new Integer[]{new Integer(totalPrintCount), new Integer(afterPrintCount), new Integer(errorPrintCount)});
            StringBuffer detailMsg = new StringBuffer();
            detailMsg.append(QMTDHelper.buildDetailPrintInfo(tblMain, keyField, billNumberField, checkErrorList.iterator(), 1));
            detailMsg.append(QMTDHelper.buildDetailPrintInfo(tblMain, keyField, billNumberField, printedErrorMap.entrySet().iterator(), 2));
            detailMsg.append(QMTDHelper.buildDetailPrintInfo(tblMain, keyField, billNumberField, willPrintedErrorMap.entrySet().iterator(), 3));
            if (totalPrintCount > 1) {
                MsgBox.showDetailAndOK((Component)ui, (String)titleMsg, (String)detailMsg.toString(), (int)1);
            } else if (totalPrintCount == 1) {
                MsgBox.showWarning((Component)ui, (String)detailMsg.toString());
            }
        }
    }

    public static String buildDetailPrintInfo(KDTable tblMain, String keyField, String billNumberField, Iterator it, int type) {
        StringBuffer detailMsg = new StringBuffer();
        while (it.hasNext()) {
            if (type == 1) {
                String billID = (String)it.next();
                String billNumber = QMTDHelper.findBillNumberAtListUI(tblMain, billID, keyField, billNumberField);
                detailMsg.append(billNumber + " " + QMTDHelper.getMsg("TD_CannotPrint", null) + "\n");
                continue;
            }
            if (type != 2 && type != 3) continue;
            Map.Entry entry = (Map.Entry)it.next();
            String billID = (String)entry.getKey();
            String billNumber = QMTDHelper.findBillNumberAtListUI(tblMain, billID, keyField, billNumberField);
            String errorInfo = (String)entry.getValue();
            String[] errMsgs = errorInfo.split("#");
            if (type == 2) {
                detailMsg.append(QMTDHelper.getMsg("pi.controlinfo1", print_resPath, new Object[]{billNumber, errMsgs[2], errMsgs[0], errMsgs[1]}) + "\n");
                continue;
            }
            detailMsg.append(QMTDHelper.getMsg("pi.controlinfo2", print_resPath, new Object[]{billNumber, errMsgs[2], errMsgs[0], errMsgs[1]}) + "\n");
        }
        return detailMsg.toString();
    }

    public static String findBillNumberAtListUI(KDTable tblMain, String billID, String keyField, String billNumberField) {
        for (int i = 0; i < tblMain.getRowCount(); ++i) {
            IRow row = tblMain.getRow(i);
            String innerBillID = (String)row.getCell(keyField).getValue();
            if (!billID.equals(innerBillID)) continue;
            Object obj = row.getCell(billNumberField).getValue();
            return obj == null ? null : obj.toString();
        }
        return null;
    }
}

