/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.common.util.QMConstant;
import com.kingdee.eas.qm.common.util.QMEqualsUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;

public class QMUnitAndExchangeUtils {
    public static MeasureUnitInfo getBaseUnitForServer(Context ctx, String materialID) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)materialID)) {
            return null;
        }
        MeasureUnitInfo baseUnit = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("baseUnit.*"));
        MaterialInfo material = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(materialID), sic);
        if (null != material && null != material.getBaseUnit()) {
            baseUnit = material.getBaseUnit();
        }
        return baseUnit;
    }

    public static BigDecimal getExchangeQtyForServer(Context ctx, MeasureUnitInfo srcUnit, MeasureUnitInfo desUnit, BigDecimal qty, String materialID) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)materialID) || null == srcUnit || null == desUnit || qty == null) {
            return QMConstant.ZERO;
        }
        BigDecimal targetQty = QMConstant.ZERO;
        if (srcUnit.getId().toString().equals(desUnit.getId().toString())) {
            return qty;
        }
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitInfo srcMultiUnitInfo = multiUnit.getMultiUnit(materialID, srcUnit.getId().toString());
        MultiMeasureUnitInfo desMultiUnitInfo = multiUnit.getMultiUnit(materialID, desUnit.getId().toString());
        targetQty = QMUnitAndExchangeUtils.getQtyAfterCovert(qty, targetQty, srcMultiUnitInfo, desMultiUnitInfo);
        return targetQty;
    }

    public static BigDecimal getQtyAfterCovert(BigDecimal qty, BigDecimal targetQty, MultiMeasureUnitInfo srcMultiUnitInfo, MultiMeasureUnitInfo desMultiUnitInfo) {
        if (srcMultiUnitInfo != null && desMultiUnitInfo != null) {
            BigDecimal baseExchangeRate1 = srcMultiUnitInfo.getBaseConvsRate();
            BigDecimal baseExchangeRate2 = desMultiUnitInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = new BigDecimal("1.00");
            }
            if (baseExchangeRate2 == null) {
                baseExchangeRate2 = new BigDecimal("1.00");
            }
            BigDecimal baseQty = qty.multiply(baseExchangeRate1);
            targetQty = baseQty.divide(baseExchangeRate2, desMultiUnitInfo.getQtyPrecision(), 4);
        }
        return targetQty;
    }

    public static BigDecimal getExchangeQty(Context ctx, MeasureUnitInfo srcUnit, MeasureUnitInfo desUnit, BigDecimal qty, String materialID) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)materialID) || null == srcUnit || null == desUnit || qty == null) {
            return QMConstant.ZERO;
        }
        BigDecimal targetQty = QMConstant.ZERO;
        if (srcUnit.getId().toString().equals(desUnit.getId().toString())) {
            return qty;
        }
        IMultiMeasureUnit multiUnit = QMEqualsUtils.equals(ctx, null) ? MultiMeasureUnitFactory.getRemoteInstance() : MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitInfo srcMultiUnitInfo = multiUnit.getMultiUnit(materialID, srcUnit.getId().toString());
        MultiMeasureUnitInfo desMultiUnitInfo = multiUnit.getMultiUnit(materialID, desUnit.getId().toString());
        targetQty = QMUnitAndExchangeUtils.getQtyAfterCovert(qty, targetQty, srcMultiUnitInfo, desMultiUnitInfo);
        return targetQty;
    }

    public static BigDecimal getExchangeBaseQty(Context ctx, MeasureUnitInfo srcUnit, BigDecimal qty, String materialID) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)materialID) || null == srcUnit || qty == null) {
            return QMConstant.ZERO;
        }
        BigDecimal targetQty = QMConstant.ZERO;
        MeasureUnitInfo baseUnit = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("baseUnit.*"));
        IMaterial iMaterial = ctx == null ? MaterialFactory.getRemoteInstance() : MaterialFactory.getLocalInstance((Context)ctx);
        MaterialInfo material = iMaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialID), sic);
        if (null != material && null != material.getBaseUnit()) {
            baseUnit = material.getBaseUnit();
        }
        IMultiMeasureUnit multiUnit = QMEqualsUtils.equals(ctx, null) ? MultiMeasureUnitFactory.getRemoteInstance() : MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitInfo srcMultiUnitInfo = multiUnit.getMultiUnit(materialID, srcUnit.getId().toString());
        MultiMeasureUnitInfo desMultiUnitInfo = multiUnit.getMultiUnit(materialID, baseUnit.getId().toString());
        targetQty = QMUnitAndExchangeUtils.getQtyAfterCovert(qty, targetQty, srcMultiUnitInfo, desMultiUnitInfo);
        return targetQty;
    }

    public static BigDecimal getExchangeDestQty(Context ctx, MeasureUnitInfo destUnit, BigDecimal baseQty, String materialID) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)materialID) || null == destUnit || baseQty == null) {
            return QMConstant.ZERO;
        }
        BigDecimal targetQty = QMConstant.ZERO;
        MeasureUnitInfo baseUnit = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("baseUnit.*"));
        IMaterial iMaterial = ctx == null ? MaterialFactory.getRemoteInstance() : MaterialFactory.getLocalInstance((Context)ctx);
        MaterialInfo material = iMaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialID), sic);
        if (null != material && null != material.getBaseUnit()) {
            baseUnit = material.getBaseUnit();
        }
        IMultiMeasureUnit multiUnit = QMEqualsUtils.equals(ctx, null) ? MultiMeasureUnitFactory.getRemoteInstance() : MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitInfo srcMultiUnitInfo = multiUnit.getMultiUnit(materialID, baseUnit.getId().toString());
        MultiMeasureUnitInfo desMultiUnitInfo = multiUnit.getMultiUnit(materialID, destUnit.getId().toString());
        targetQty = QMUnitAndExchangeUtils.getQtyAfterCovert(baseQty, targetQty, srcMultiUnitInfo, desMultiUnitInfo);
        return targetQty;
    }

    public static boolean isSameMultiUnitGroup(Context ctx, MaterialInfo material, MeasureUnitInfo unit) throws BOSException, EASBizException {
        if (QMEqualsUtils.equals(material, null) || QMEqualsUtils.equals(unit, null)) {
            return false;
        }
        IMultiMeasureUnit multiUnit = QMEqualsUtils.equals(ctx, null) ? MultiMeasureUnitFactory.getRemoteInstance() : MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitInfo desMultiUnitInfo = multiUnit.getMultiUnit(material.getId().toString(), unit.getId().toString());
        return !QMEqualsUtils.equals(desMultiUnitInfo, null);
    }
}

